#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 brick
version:              1.7
visibility:           public
id:                   brick-1.7-BLrdrm8Arom3u2UZpkVSaJ
key:                  brick-1.7-BLrdrm8Arom3u2UZpkVSaJ
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  ff33c7e087dfefbcdd2cb305365ed9a3
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/brick-1.7
library-dirs:         /usr/lib/ghc-9.2.8/site-local/brick-1.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-1.7-BLrdrm8Arom3u2UZpkVSaJ
depends:
    base-4.16.4.0 bimap-0.5.0-Ezm3Pul1aocGiOTrQDC32r
    bytestring-0.11.4.0 config-ini-0.2.6.0-4l3GSYAqsYGIXTvWAyhmMh
    containers-0.6.5.1 data-clist-0.2-1Q3dBPxEFZlFPtiPwL3SPc
    deepseq-1.4.6.1 directory-1.3.6.2 exceptions-0.10.4
    filepath-1.4.2.2 microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-mtl-0.2.0.3-K2j2D46quth4CyQpetHsMp
    microlens-th-0.4.3.14-N8oH2Lt1wGBzxrEjsZjaw mtl-2.2.2 stm-2.5.0.2
    template-haskell-2.18.0.0 text-1.2.5.0
    text-zipper-0.13-GJDn6QcuXJh4pMJ1gT12Be unix-2.7.2.2
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe
    vty-5.38-3w6UVq6p4ArDNpX9EUY74t
    word-wrap-0.5-Ae6yE3CVJ7FAvLNQJtG41y

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

