<!-- Source: https://github.com/arduino/tooling-project-assets/blob/main/documentation-templates/contributor-guide/general/contributor-guide/issues.md -->

# Issue Report Guide

---

❗ Do you need help or have a question about using this project? Support requests should be made to the [Arduino Forum](https://forum.arduino.cc).

---

High quality bug reports and feature requests are valuable contributions to this project. These can be made by submitting an issue report to the project's GitHub repository:

https://github.com/arduino/arduino-ide/issues/new/choose

## Before Reporting an Issue

- Give the latest development version a test drive to see if your issue was already resolved:<br />
  https://www.arduino.cc/en/software#nightly-builds
- Search [existing pull requests and issues](https://github.com/arduino/arduino-ide/issues?q=) to see if it was already reported.<br />
  If you have additional information to provide about an existing issue, please comment there instead of creating a duplicate. You can use [GitHub's "Reactions" feature](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) if you only want to express support 👍.

## Qualities of an Excellent Report

- Concise and descriptive issue title.<br />
  Vague titles make it difficult to decipher the purpose of the issue when looking through the list of reports, which might result in your issue not being given proper attention.
- Describe the issue and what behavior you were expecting.<br />
  Include the full and exact text of any relevant error or warning messages you might have encountered.
- Provide a full set of steps necessary to reproduce the issue.<br />
  Demonstration code or commands should be complete and simplified to the minimum necessary to reproduce the issue.
- Be responsive.<br />
  We may need you to provide additional information in order to investigate and resolve the issue.<br />
  Make sure your GitHub account is configured so that you will receive notifications of responses to your issue report.
- If you find a solution to your problem, please comment on your issue report with an explanation of how you were able to fix it, then close the issue.
