//! DO NOT EDIT
//! If you want to specify the zig version, use `zig build -Ddata_version=0.12.0`
//! GENERATED BY src/config_gen/config_gen.zig

const Builtin = struct {
    name: []const u8,
    signature: []const u8,
    snippet: []const u8,
    documentation: []const u8,
    arguments: []const []const u8,
};

pub const builtins = [_]Builtin{
    .{
        .name = "@addrSpaceCast",
        .signature = "@addrSpaceCast(ptr: anytype) anytype",
        .snippet = "@addrSpaceCast(${1:ptr: anytype})",
        .documentation =
        \\Converts a pointer from one address space to another. The new address space is inferred based on the result type. Depending on the current target and address spaces, this cast may be a no-op, a complex operation, or illegal. If the cast is legal, then the resulting pointer points to the same memory location as the pointer operand. It is always valid to cast a pointer between the same address spaces.
        ,
        .arguments = &.{
            "ptr: anytype",
        },
    },
    .{
        .name = "@addWithOverflow",
        .signature = "@addWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
        .snippet = "@addWithOverflow(${1:a: anytype}, ${2:b: anytype})",
        .documentation =
        \\Performs `a + b` and returns a tuple with the result and a possible overflow bit.
        ,
        .arguments = &.{
            "a: anytype",
            "b: anytype",
        },
    },
    .{
        .name = "@alignCast",
        .signature = "@alignCast(ptr: anytype) anytype",
        .snippet = "@alignCast(${1:ptr: anytype})",
        .documentation =
        \\`ptr` can be `*T`, `?*T`, or `[]T`. Changes the alignment of a pointer. The alignment to use is inferred based on the result type.
        \\
        \\A [pointer alignment safety check](https://ziglang.org/documentation/0.12.0/#Incorrect-Pointer-Alignment) is added to the generated code to make sure the pointer is aligned as promised.
        ,
        .arguments = &.{
            "ptr: anytype",
        },
    },
    .{
        .name = "@alignOf",
        .signature = "@alignOf(comptime T: type) comptime_int",
        .snippet = "@alignOf(${1:comptime T: type})",
        .documentation =
        \\This function returns the number of bytes that this type should be aligned to for the current target to match the C ABI. When the child type of a pointer has this alignment, the alignment can be omitted from the type.
        \\
        \\```zig
        \\const assert = @import("std").debug.assert;
        \\comptime {
        \\    assert(*u32 == *align(@alignOf(u32)) u32);
        \\}
        \\```
        \\The result is a target-specific compile time constant. It is guaranteed to be less than or equal to [@sizeOf(T)](https://ziglang.org/documentation/0.12.0/#sizeOf).
        ,
        .arguments = &.{
            "comptime T: type",
        },
    },
    .{
        .name = "@as",
        .signature = "@as(comptime T: type, expression) T",
        .snippet = "@as(${1:comptime T: type}, ${2:expression})",
        .documentation =
        \\Performs [Type Coercion](https://ziglang.org/documentation/0.12.0/#Type-Coercion). This cast is allowed when the conversion is unambiguous and safe, and is the preferred way to convert between types, whenever possible.
        ,
        .arguments = &.{
            "comptime T: type",
            "expression",
        },
    },
    .{
        .name = "@atomicLoad",
        .signature = "@atomicLoad(comptime T: type, ptr: *const T, comptime ordering: AtomicOrder) T",
        .snippet = "@atomicLoad(${1:comptime T: type}, ${2:ptr: *const T}, ${3:comptime ordering: AtomicOrder})",
        .documentation =
        \\This builtin function atomically dereferences a pointer to a `T` and returns the value.
        \\
        \\`T` must be a pointer, a `bool`, a float, an integer or an enum.
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        ,
        .arguments = &.{
            "comptime T: type",
            "ptr: *const T",
            "comptime ordering: AtomicOrder",
        },
    },
    .{
        .name = "@atomicRmw",
        .signature = "@atomicRmw(comptime T: type, ptr: *T, comptime op: AtomicRmwOp, operand: T, comptime ordering: AtomicOrder) T",
        .snippet = "@atomicRmw(${1:comptime T: type}, ${2:ptr: *T}, ${3:comptime op: AtomicRmwOp}, ${4:operand: T}, ${5:comptime ordering: AtomicOrder})",
        .documentation =
        \\This builtin function dereferences a pointer to a `T` and atomically modifies the value and returns the previous value.
        \\
        \\`T` must be a pointer, a `bool`, a float, an integer or an enum.
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        \\
        \\`AtomicRmwOp` can be found with `@import("std").builtin.AtomicRmwOp`.
        ,
        .arguments = &.{
            "comptime T: type",
            "ptr: *T",
            "comptime op: AtomicRmwOp",
            "operand: T",
            "comptime ordering: AtomicOrder",
        },
    },
    .{
        .name = "@atomicStore",
        .signature = "@atomicStore(comptime T: type, ptr: *T, value: T, comptime ordering: AtomicOrder) void",
        .snippet = "@atomicStore(${1:comptime T: type}, ${2:ptr: *T}, ${3:value: T}, ${4:comptime ordering: AtomicOrder})",
        .documentation =
        \\This builtin function dereferences a pointer to a `T` and atomically stores the given value.
        \\
        \\`T` must be a pointer, a `bool`, a float, an integer or an enum.
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        ,
        .arguments = &.{
            "comptime T: type",
            "ptr: *T",
            "value: T",
            "comptime ordering: AtomicOrder",
        },
    },
    .{
        .name = "@bitCast",
        .signature = "@bitCast(value: anytype) anytype",
        .snippet = "@bitCast(${1:value: anytype})",
        .documentation =
        \\Converts a value of one type to another type. The return type is the inferred result type.
        \\
        \\Asserts that `@sizeOf(@TypeOf(value)) == @sizeOf(DestType)`.
        \\
        \\Asserts that `@typeInfo(DestType) != .Pointer`. Use `@ptrCast` or `@ptrFromInt` if you need this.
        \\
        \\Can be used for these things for example:
        \\
        \\ - Convert `f32` to `u32` bits
        \\ - Convert `i32` to `u32` preserving twos complement
        \\Works at compile-time if `value` is known at compile time. It's a compile error to bitcast a value of undefined layout; this means that, besides the restriction from types which possess dedicated casting builtins (enums, pointers, error sets), bare structs, error unions, slices, optionals, and any other type without a well-defined memory layout, also cannot be used in this operation.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@bitOffsetOf",
        .signature = "@bitOffsetOf(comptime T: type, comptime field_name: []const u8) comptime_int",
        .snippet = "@bitOffsetOf(${1:comptime T: type}, ${2:comptime field_name: []const u8})",
        .documentation =
        \\Returns the bit offset of a field relative to its containing struct.
        \\
        \\For non [packed structs](https://ziglang.org/documentation/0.12.0/#packed-struct), this will always be divisible by `8`. For packed structs, non-byte-aligned fields will share a byte offset, but they will have different bit offsets.
        ,
        .arguments = &.{
            "comptime T: type",
            "comptime field_name: []const u8",
        },
    },
    .{
        .name = "@bitSizeOf",
        .signature = "@bitSizeOf(comptime T: type) comptime_int",
        .snippet = "@bitSizeOf(${1:comptime T: type})",
        .documentation =
        \\This function returns the number of bits it takes to store `T` in memory if the type were a field in a packed struct/union. The result is a target-specific compile time constant.
        \\
        \\This function measures the size at runtime. For types that are disallowed at runtime, such as `comptime_int` and `type`, the result is `0`.
        ,
        .arguments = &.{
            "comptime T: type",
        },
    },
    .{
        .name = "@breakpoint",
        .signature = "@breakpoint() void",
        .snippet = "@breakpoint()",
        .documentation =
        \\This function inserts a platform-specific debug trap instruction which causes debuggers to break there. Unlike for `@trap()`, execution may continue after this point if the program is resumed.
        \\
        \\This function is only valid within function scope.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@mulAdd",
        .signature = "@mulAdd(comptime T: type, a: T, b: T, c: T) T",
        .snippet = "@mulAdd(${1:comptime T: type}, ${2:a: T}, ${3:b: T}, ${4:c: T})",
        .documentation =
        \\Fused multiply-add, similar to `(a * b) + c`, except only rounds once, and is thus more accurate.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "comptime T: type",
            "a: T",
            "b: T",
            "c: T",
        },
    },
    .{
        .name = "@byteSwap",
        .signature = "@byteSwap(operand: anytype) T",
        .snippet = "@byteSwap(${1:operand: anytype})",
        .documentation =
        \\`@TypeOf(operand)` must be an integer type or an integer vector type with bit count evenly divisible by 8.
        \\
        \\`operand` may be an [integer](https://ziglang.org/documentation/0.12.0/#Integers) or [vector](https://ziglang.org/documentation/0.12.0/#Vectors).
        \\
        \\Swaps the byte order of the integer. This converts a big endian integer to a little endian integer, and converts a little endian integer to a big endian integer.
        \\
        \\Note that for the purposes of memory layout with respect to endianness, the integer type should be related to the number of bytes reported by [@sizeOf](https://ziglang.org/documentation/0.12.0/#sizeOf) bytes. This is demonstrated with `u24`. `@sizeOf(u24) == 4`, which means that a `u24` stored in memory takes 4 bytes, and those 4 bytes are what are swapped on a little vs big endian system. On the other hand, if `T` is specified to be `u24`, then only 3 bytes are reversed.
        ,
        .arguments = &.{
            "operand: anytype",
        },
    },
    .{
        .name = "@bitReverse",
        .signature = "@bitReverse(integer: anytype) T",
        .snippet = "@bitReverse(${1:integer: anytype})",
        .documentation =
        \\`@TypeOf(anytype)` accepts any integer type or integer vector type.
        \\
        \\Reverses the bitpattern of an integer value, including the sign bit if applicable.
        \\
        \\For example 0b10110110 (`u8 = 182`, `i8 = -74`) becomes 0b01101101 (`u8 = 109`, `i8 = 109`).
        ,
        .arguments = &.{
            "integer: anytype",
        },
    },
    .{
        .name = "@offsetOf",
        .signature = "@offsetOf(comptime T: type, comptime field_name: []const u8) comptime_int",
        .snippet = "@offsetOf(${1:comptime T: type}, ${2:comptime field_name: []const u8})",
        .documentation =
        \\Returns the byte offset of a field relative to its containing struct.
        ,
        .arguments = &.{
            "comptime T: type",
            "comptime field_name: []const u8",
        },
    },
    .{
        .name = "@call",
        .signature = "@call(modifier: std.builtin.CallModifier, function: anytype, args: anytype) anytype",
        .snippet = "@call(${1:modifier: std.builtin.CallModifier}, ${2:function: anytype}, ${3:args: anytype})",
        .documentation =
        \\Calls a function, in the same way that invoking an expression with parentheses does:
        \\
        \\```zig
        \\const expect = @import("std").testing.expect;
        \\test "noinline function call" {
        \\    try expect(@call(.auto, add, .{3, 9}) == 12);
        \\}
        \\fn add(a: i32, b: i32) i32 {
        \\    return a + b;
        \\}
        \\```
        \\`@call` allows more flexibility than normal function call syntax does. The `CallModifier` enum is reproduced here:
        \\
        \\```zig
        \\pub const CallModifier = enum {
        \\    /// Equivalent to function call syntax.
        \\    auto,
        \\    /// Equivalent to async keyword used with function call syntax.
        \\    async_kw,
        \\    /// Prevents tail call optimization. This guarantees that the return
        \\    /// address will point to the callsite, as opposed to the callsite's
        \\    /// callsite. If the call is otherwise required to be tail-called
        \\    /// or inlined, a compile error is emitted instead.
        \\    never_tail,
        \\    /// Guarantees that the call will not be inlined. If the call is
        \\    /// otherwise required to be inlined, a compile error is emitted instead.
        \\    never_inline,
        \\    /// Asserts that the function call will not suspend. This allows a
        \\    /// non-async function to call an async function.
        \\    no_async,
        \\    /// Guarantees that the call will be generated with tail call optimization.
        \\    /// If this is not possible, a compile error is emitted instead.
        \\    always_tail,
        \\    /// Guarantees that the call will inlined at the callsite.
        \\    /// If this is not possible, a compile error is emitted instead.
        \\    always_inline,
        \\    /// Evaluates the call at compile-time. If the call cannot be completed at
        \\    /// compile-time, a compile error is emitted instead.
        \\    compile_time,
        \\};
        \\```
        ,
        .arguments = &.{
            "modifier: std.builtin.CallModifier",
            "function: anytype",
            "args: anytype",
        },
    },
    .{
        .name = "@cDefine",
        .signature = "@cDefine(comptime name: []const u8, value) void",
        .snippet = "@cDefine(${1:comptime name: []const u8}, ${2:value})",
        .documentation =
        \\This function can only occur inside `@cImport`.
        \\
        \\This appends
        \\`#define $name $value`to the `@cImport` temporary buffer.
        \\
        \\To define without a value, like this:
        \\
        \\`#define _GNU_SOURCE`Use the void value, like this:
        \\
        \\`@cDefine("_GNU_SOURCE", {})`
        ,
        .arguments = &.{
            "comptime name: []const u8",
            "value",
        },
    },
    .{
        .name = "@cImport",
        .signature = "@cImport(expression) type",
        .snippet = "@cImport(${1:expression})",
        .documentation =
        \\This function parses C code and imports the functions, types, variables, and compatible macro definitions into a new empty struct type, and then returns that type.
        \\
        \\`expression` is interpreted at compile time. The builtin functions `@cInclude`, `@cDefine`, and `@cUndef` work within this expression, appending to a temporary buffer which is then parsed as C code.
        \\
        \\Usually you should only have one `@cImport` in your entire application, because it saves the compiler from invoking clang multiple times, and prevents inline functions from being duplicated.
        \\
        \\Reasons for having multiple `@cImport` expressions would be:
        \\
        \\ - To avoid a symbol collision, for example if foo.h and bar.h both
        \\`#define CONNECTION_COUNT` - To analyze the C code with different preprocessor defines
        ,
        .arguments = &.{
            "expression",
        },
    },
    .{
        .name = "@cInclude",
        .signature = "@cInclude(comptime path: []const u8) void",
        .snippet = "@cInclude(${1:comptime path: []const u8})",
        .documentation =
        \\This function can only occur inside `@cImport`.
        \\
        \\This appends
        \\`#include &lt;$path&gt;\n`to the `c_import` temporary buffer.
        ,
        .arguments = &.{
            "comptime path: []const u8",
        },
    },
    .{
        .name = "@clz",
        .signature = "@clz(operand: anytype) anytype",
        .snippet = "@clz(${1:operand: anytype})",
        .documentation =
        \\`@TypeOf(operand)` must be an integer type or an integer vector type.
        \\
        \\`operand` may be an [integer](https://ziglang.org/documentation/0.12.0/#Integers) or [vector](https://ziglang.org/documentation/0.12.0/#Vectors).
        \\
        \\Counts the number of most-significant (leading in a big-endian sense) zeroes in an integer - "count leading zeroes".
        \\
        \\If `operand` is a [comptime](https://ziglang.org/documentation/0.12.0/#comptime)-known integer, the return type is `comptime_int`. Otherwise, the return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
        \\
        \\If `operand` is zero, `@clz` returns the bit width of integer type `T`.
        ,
        .arguments = &.{
            "operand: anytype",
        },
    },
    .{
        .name = "@cmpxchgStrong",
        .signature = "@cmpxchgStrong(comptime T: type, ptr: *T, expected_value: T, new_value: T, success_order: AtomicOrder, fail_order: AtomicOrder) ?T",
        .snippet = "@cmpxchgStrong(${1:comptime T: type}, ${2:ptr: *T}, ${3:expected_value: T}, ${4:new_value: T}, ${5:success_order: AtomicOrder}, ${6:fail_order: AtomicOrder})",
        .documentation =
        \\This function performs a strong atomic compare-and-exchange operation, returning `null` if the current value is not the given expected value. It's the equivalent of this code, except atomic:
        \\
        \\```zig
        \\fn cmpxchgStrongButNotAtomic(comptime T: type, ptr: *T, expected_value: T, new_value: T) ?T {
        \\    const old_value = ptr.*;
        \\    if (old_value == expected_value) {
        \\        ptr.* = new_value;
        \\        return null;
        \\    } else {
        \\        return old_value;
        \\    }
        \\}
        \\```
        \\If you are using cmpxchg in a retry loop, [@cmpxchgWeak](https://ziglang.org/documentation/0.12.0/#cmpxchgWeak) is the better choice, because it can be implemented more efficiently in machine instructions.
        \\
        \\`T` must be a pointer, a `bool`, a float, an integer or an enum.
        \\
        \\`@typeInfo(@TypeOf(ptr)).Pointer.alignment` must be `>= @sizeOf(T).`
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        ,
        .arguments = &.{
            "comptime T: type",
            "ptr: *T",
            "expected_value: T",
            "new_value: T",
            "success_order: AtomicOrder",
            "fail_order: AtomicOrder",
        },
    },
    .{
        .name = "@cmpxchgWeak",
        .signature = "@cmpxchgWeak(comptime T: type, ptr: *T, expected_value: T, new_value: T, success_order: AtomicOrder, fail_order: AtomicOrder) ?T",
        .snippet = "@cmpxchgWeak(${1:comptime T: type}, ${2:ptr: *T}, ${3:expected_value: T}, ${4:new_value: T}, ${5:success_order: AtomicOrder}, ${6:fail_order: AtomicOrder})",
        .documentation =
        \\This function performs a weak atomic compare-and-exchange operation, returning `null` if the current value is not the given expected value. It's the equivalent of this code, except atomic:
        \\
        \\```zig
        \\fn cmpxchgWeakButNotAtomic(comptime T: type, ptr: *T, expected_value: T, new_value: T) ?T {
        \\    const old_value = ptr.*;
        \\    if (old_value == expected_value and usuallyTrueButSometimesFalse()) {
        \\        ptr.* = new_value;
        \\        return null;
        \\    } else {
        \\        return old_value;
        \\    }
        \\}
        \\```
        \\If you are using cmpxchg in a retry loop, the sporadic failure will be no problem, and `cmpxchgWeak` is the better choice, because it can be implemented more efficiently in machine instructions. However if you need a stronger guarantee, use [@cmpxchgStrong](https://ziglang.org/documentation/0.12.0/#cmpxchgStrong).
        \\
        \\`T` must be a pointer, a `bool`, a float, an integer or an enum.
        \\
        \\`@typeInfo(@TypeOf(ptr)).Pointer.alignment` must be `>= @sizeOf(T).`
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        ,
        .arguments = &.{
            "comptime T: type",
            "ptr: *T",
            "expected_value: T",
            "new_value: T",
            "success_order: AtomicOrder",
            "fail_order: AtomicOrder",
        },
    },
    .{
        .name = "@compileError",
        .signature = "@compileError(comptime msg: []const u8) noreturn",
        .snippet = "@compileError(${1:comptime msg: []const u8})",
        .documentation =
        \\This function, when semantically analyzed, causes a compile error with the message `msg`.
        \\
        \\There are several ways that code avoids being semantically checked, such as using `if` or `switch` with compile time constants, and `comptime` functions.
        ,
        .arguments = &.{
            "comptime msg: []const u8",
        },
    },
    .{
        .name = "@compileLog",
        .signature = "@compileLog(args: ...) void",
        .snippet = "@compileLog(${1:args: ...})",
        .documentation =
        \\This function prints the arguments passed to it at compile-time.
        \\
        \\To prevent accidentally leaving compile log statements in a codebase, a compilation error is added to the build, pointing to the compile log statement. This error prevents code from being generated, but does not otherwise interfere with analysis.
        \\
        \\This function can be used to do "printf debugging" on compile-time executing code.
        \\
        \\```zig
        \\const print = @import("std").debug.print;
        \\const num1 = blk: {
        \\    var val1: i32 = 99;
        \\    @compileLog("comptime val1 = ", val1);
        \\    val1 = val1 + 1;
        \\    break :blk val1;
        \\};
        \\test "main" {
        \\    @compileLog("comptime in main");
        \\    print("Runtime in main, num1 = {}.\n", .{num1});
        \\}
        \\```
        ,
        .arguments = &.{
            "args: ...",
        },
    },
    .{
        .name = "@constCast",
        .signature = "@constCast(value: anytype) DestType",
        .snippet = "@constCast(${1:value: anytype})",
        .documentation =
        \\Remove `const` qualifier from a pointer.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@ctz",
        .signature = "@ctz(operand: anytype) anytype",
        .snippet = "@ctz(${1:operand: anytype})",
        .documentation =
        \\`@TypeOf(operand)` must be an integer type or an integer vector type.
        \\
        \\`operand` may be an [integer](https://ziglang.org/documentation/0.12.0/#Integers) or [vector](https://ziglang.org/documentation/0.12.0/#Vectors).
        \\
        \\Counts the number of least-significant (trailing in a big-endian sense) zeroes in an integer - "count trailing zeroes".
        \\
        \\If `operand` is a [comptime](https://ziglang.org/documentation/0.12.0/#comptime)-known integer, the return type is `comptime_int`. Otherwise, the return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
        \\
        \\If `operand` is zero, `@ctz` returns the bit width of integer type `T`.
        ,
        .arguments = &.{
            "operand: anytype",
        },
    },
    .{
        .name = "@cUndef",
        .signature = "@cUndef(comptime name: []const u8) void",
        .snippet = "@cUndef(${1:comptime name: []const u8})",
        .documentation =
        \\This function can only occur inside `@cImport`.
        \\
        \\This appends
        \\`#undef $name`to the `@cImport` temporary buffer.
        ,
        .arguments = &.{
            "comptime name: []const u8",
        },
    },
    .{
        .name = "@cVaArg",
        .signature = "@cVaArg(operand: *std.builtin.VaList, comptime T: type) T",
        .snippet = "@cVaArg(${1:operand: *std.builtin.VaList}, ${2:comptime T: type})",
        .documentation =
        \\Implements the C macro `va_arg`.
        ,
        .arguments = &.{
            "operand: *std.builtin.VaList",
            "comptime T: type",
        },
    },
    .{
        .name = "@cVaCopy",
        .signature = "@cVaCopy(src: *std.builtin.VaList) std.builtin.VaList",
        .snippet = "@cVaCopy(${1:src: *std.builtin.VaList})",
        .documentation =
        \\Implements the C macro `va_copy`.
        ,
        .arguments = &.{
            "src: *std.builtin.VaList",
        },
    },
    .{
        .name = "@cVaEnd",
        .signature = "@cVaEnd(src: *std.builtin.VaList) void",
        .snippet = "@cVaEnd(${1:src: *std.builtin.VaList})",
        .documentation =
        \\Implements the C macro `va_end`.
        ,
        .arguments = &.{
            "src: *std.builtin.VaList",
        },
    },
    .{
        .name = "@cVaStart",
        .signature = "@cVaStart() std.builtin.VaList",
        .snippet = "@cVaStart()",
        .documentation =
        \\Implements the C macro `va_start`. Only valid inside a variadic function.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@divExact",
        .signature = "@divExact(numerator: T, denominator: T) T",
        .snippet = "@divExact(${1:numerator: T}, ${2:denominator: T})",
        .documentation =
        \\Exact division. Caller guarantees `denominator != 0` and `@divTrunc(numerator, denominator) * denominator == numerator`.
        \\
        \\ - `@divExact(6, 3) == 2`
        \\ - `@divExact(a, b) * b == a`
        \\For a function that returns a possible error code, use `@import("std").math.divExact`.
        ,
        .arguments = &.{
            "numerator: T",
            "denominator: T",
        },
    },
    .{
        .name = "@divFloor",
        .signature = "@divFloor(numerator: T, denominator: T) T",
        .snippet = "@divFloor(${1:numerator: T}, ${2:denominator: T})",
        .documentation =
        \\Floored division. Rounds toward negative infinity. For unsigned integers it is the same as `numerator / denominator`. Caller guarantees `denominator != 0` and `!(@typeInfo(T) == .Int and T.is_signed and numerator == std.math.minInt(T) and denominator == -1)`.
        \\
        \\ - `@divFloor(-5, 3) == -2`
        \\ - `(@divFloor(a, b) * b) + @mod(a, b) == a`
        \\For a function that returns a possible error code, use `@import("std").math.divFloor`.
        ,
        .arguments = &.{
            "numerator: T",
            "denominator: T",
        },
    },
    .{
        .name = "@divTrunc",
        .signature = "@divTrunc(numerator: T, denominator: T) T",
        .snippet = "@divTrunc(${1:numerator: T}, ${2:denominator: T})",
        .documentation =
        \\Truncated division. Rounds toward zero. For unsigned integers it is the same as `numerator / denominator`. Caller guarantees `denominator != 0` and `!(@typeInfo(T) == .Int and T.is_signed and numerator == std.math.minInt(T) and denominator == -1)`.
        \\
        \\ - `@divTrunc(-5, 3) == -1`
        \\ - `(@divTrunc(a, b) * b) + @rem(a, b) == a`
        \\For a function that returns a possible error code, use `@import("std").math.divTrunc`.
        ,
        .arguments = &.{
            "numerator: T",
            "denominator: T",
        },
    },
    .{
        .name = "@embedFile",
        .signature = "@embedFile(comptime path: []const u8) *const [N:0]u8",
        .snippet = "@embedFile(${1:comptime path: []const u8})",
        .documentation =
        \\This function returns a compile time constant pointer to null-terminated, fixed-size array with length equal to the byte count of the file given by `path`. The contents of the array are the contents of the file. This is equivalent to a [string literal](https://ziglang.org/documentation/0.12.0/#String-Literals-and-Unicode-Code-Point-Literals) with the file contents.
        \\
        \\`path` is absolute or relative to the current file, just like `@import`.
        ,
        .arguments = &.{
            "comptime path: []const u8",
        },
    },
    .{
        .name = "@enumFromInt",
        .signature = "@enumFromInt(integer: anytype) anytype",
        .snippet = "@enumFromInt(${1:integer: anytype})",
        .documentation =
        \\Converts an integer into an [enum](https://ziglang.org/documentation/0.12.0/#enum) value. The return type is the inferred result type.
        \\
        \\Attempting to convert an integer which represents no value in the chosen enum type invokes safety-checked [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "integer: anytype",
        },
    },
    .{
        .name = "@errorFromInt",
        .signature = "@errorFromInt(value: std.meta.Int(.unsigned, @bitSizeOf(anyerror))) anyerror",
        .snippet = "@errorFromInt(${1:value: std.meta.Int(.unsigned, @bitSizeOf(anyerror)})",
        .documentation =
        \\Converts from the integer representation of an error into [The Global Error Set](https://ziglang.org/documentation/0.12.0/#The-Global-Error-Set) type.
        \\
        \\It is generally recommended to avoid this cast, as the integer representation of an error is not stable across source code changes.
        \\
        \\Attempting to convert an integer that does not correspond to any error results in safety-protected [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "value: std.meta.Int(.unsigned, @bitSizeOf(anyerror)",
        },
    },
    .{
        .name = "@errorName",
        .signature = "@errorName(err: anyerror) [:0]const u8",
        .snippet = "@errorName(${1:err: anyerror})",
        .documentation =
        \\This function returns the string representation of an error. The string representation of `error.OutOfMem` is `"OutOfMem"`.
        \\
        \\If there are no calls to `@errorName` in an entire application, or all calls have a compile-time known value for `err`, then no error name table will be generated.
        ,
        .arguments = &.{
            "err: anyerror",
        },
    },
    .{
        .name = "@errorReturnTrace",
        .signature = "@errorReturnTrace() ?*builtin.StackTrace",
        .snippet = "@errorReturnTrace()",
        .documentation =
        \\If the binary is built with error return tracing, and this function is invoked in a function that calls a function with an error or error union return type, returns a stack trace object. Otherwise returns [null](https://ziglang.org/documentation/0.12.0/#null).
        ,
        .arguments = &.{},
    },
    .{
        .name = "@errorCast",
        .signature = "@errorCast(value: anytype) anytype",
        .snippet = "@errorCast(${1:value: anytype})",
        .documentation =
        \\Converts an error set or error union value from one error set to another error set. The return type is the inferred result type. Attempting to convert an error which is not in the destination error set results in safety-protected [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@export",
        .signature = "@export(declaration, comptime options: std.builtin.ExportOptions) void",
        .snippet = "@export(${1:declaration}, ${2:comptime options: std.builtin.ExportOptions})",
        .documentation =
        \\Creates a symbol in the output object file.
        \\
        \\`declaration`must be one of two things:
        \\
        \\ - An identifier (`x`) identifying a [function](https://ziglang.org/documentation/0.12.0/#Functions) or a [variable](https://ziglang.org/documentation/0.12.0/#Container-Level-Variables).
        \\ - Field access (`x.y`) looking up a [function](https://ziglang.org/documentation/0.12.0/#Functions) or a [variable](https://ziglang.org/documentation/0.12.0/#Container-Level-Variables).
        \\This builtin can be called from a [comptime](https://ziglang.org/documentation/0.12.0/#comptime) block to conditionally export symbols. When
        \\`declaration`is a function with the C calling convention and `options.linkage` is `Strong`, this is equivalent to the `export` keyword used on a function:
        \\
        \\```zig
        \\comptime {
        \\    @export(internalName, .{ .name = "foo", .linkage = .strong });
        \\}
        \\fn internalName() callconv(.C) void {}
        \\```
        \\This is equivalent to:
        \\
        \\`export fn foo() void {}`
        \\Note that even when using `export`, the `@"foo"` syntax for [identifiers](https://ziglang.org/documentation/0.12.0/#Identifiers) can be used to choose any string for the symbol name:
        \\
        \\`export fn @"A function name that is a complete sentence."() void {}`
        \\When looking at the resulting object, you can see the symbol is used verbatim:
        \\
        \\`00000000000001f0 T A function name that is a complete sentence.`
        ,
        .arguments = &.{
            "declaration",
            "comptime options: std.builtin.ExportOptions",
        },
    },
    .{
        .name = "@extern",
        .signature = "@extern(T: type, comptime options: std.builtin.ExternOptions) T",
        .snippet = "@extern(${1:T: type}, ${2:comptime options: std.builtin.ExternOptions})",
        .documentation =
        \\Creates a reference to an external symbol in the output object file. T must be a pointer type.
        ,
        .arguments = &.{
            "T: type",
            "comptime options: std.builtin.ExternOptions",
        },
    },
    .{
        .name = "@fence",
        .signature = "@fence(order: AtomicOrder) void",
        .snippet = "@fence(${1:order: AtomicOrder})",
        .documentation =
        \\The `fence` function is used to introduce happens-before edges between operations.
        \\
        \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
        ,
        .arguments = &.{
            "order: AtomicOrder",
        },
    },
    .{
        .name = "@field",
        .signature = "@field(lhs: anytype, comptime field_name: []const u8) (field)",
        .snippet = "@field(${1:lhs: anytype}, ${2:comptime field_name: []const u8})",
        .documentation =
        \\Performs field access by a compile-time string. Works on both fields and declarations.
        \\
        \\```zig
        \\const std = @import("std");
        \\const Point = struct {
        \\    x: u32,
        \\    y: u32,
        \\    pub var z: u32 = 1;
        \\};
        \\test "field access by string" {
        \\    const expect = std.testing.expect;
        \\    var p = Point{ .x = 0, .y = 0 };
        \\    @field(p, "x") = 4;
        \\    @field(p, "y") = @field(p, "x") + 1;
        \\    try expect(@field(p, "x") == 4);
        \\    try expect(@field(p, "y") == 5);
        \\}
        \\test "decl access by string" {
        \\    const expect = std.testing.expect;
        \\    try expect(@field(Point, "z") == 1);
        \\    @field(Point, "z") = 2;
        \\    try expect(@field(Point, "z") == 2);
        \\}
        \\```
        ,
        .arguments = &.{
            "lhs: anytype",
            "comptime field_name: []const u8",
        },
    },
    .{
        .name = "@fieldParentPtr",
        .signature = "@fieldParentPtr(comptime field_name: []const u8, field_ptr: *T) anytype",
        .snippet = "@fieldParentPtr(${1:comptime field_name: []const u8}, ${2:field_ptr: *T})",
        .documentation =
        \\Given a pointer to a field, returns the base pointer of a struct.
        ,
        .arguments = &.{
            "comptime field_name: []const u8",
            "field_ptr: *T",
        },
    },
    .{
        .name = "@floatCast",
        .signature = "@floatCast(value: anytype) anytype",
        .snippet = "@floatCast(${1:value: anytype})",
        .documentation =
        \\Convert from one float type to another. This cast is safe, but may cause the numeric value to lose precision. The return type is the inferred result type.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@floatFromInt",
        .signature = "@floatFromInt(int: anytype) anytype",
        .snippet = "@floatFromInt(${1:int: anytype})",
        .documentation =
        \\Converts an integer to the closest floating point representation. The return type is the inferred result type. To convert the other way, use [@intFromFloat](https://ziglang.org/documentation/0.12.0/#intFromFloat). This operation is legal for all values of all integer types.
        ,
        .arguments = &.{
            "int: anytype",
        },
    },
    .{
        .name = "@frameAddress",
        .signature = "@frameAddress() usize",
        .snippet = "@frameAddress()",
        .documentation =
        \\This function returns the base pointer of the current stack frame.
        \\
        \\The implications of this are target-specific and not consistent across all platforms. The frame address may not be available in release mode due to aggressive optimizations.
        \\
        \\This function is only valid within function scope.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@hasDecl",
        .signature = "@hasDecl(comptime Container: type, comptime name: []const u8) bool",
        .snippet = "@hasDecl(${1:comptime Container: type}, ${2:comptime name: []const u8})",
        .documentation =
        \\Returns whether or not a [container](https://ziglang.org/documentation/0.12.0/#Containers) has a declaration matching `name`.
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\const Foo = struct {
        \\    nope: i32,
        \\    pub var blah = "xxx";
        \\    const hi = 1;
        \\};
        \\test "@hasDecl" {
        \\    try expect(@hasDecl(Foo, "blah"));
        \\    // Even though `hi` is private, @hasDecl returns true because this test is
        \\    // in the same file scope as Foo. It would return false if Foo was declared
        \\    // in a different file.
        \\    try expect(@hasDecl(Foo, "hi"));
        \\    // @hasDecl is for declarations; not fields.
        \\    try expect(!@hasDecl(Foo, "nope"));
        \\    try expect(!@hasDecl(Foo, "nope1234"));
        \\}
        \\```
        ,
        .arguments = &.{
            "comptime Container: type",
            "comptime name: []const u8",
        },
    },
    .{
        .name = "@hasField",
        .signature = "@hasField(comptime Container: type, comptime name: []const u8) bool",
        .snippet = "@hasField(${1:comptime Container: type}, ${2:comptime name: []const u8})",
        .documentation =
        \\Returns whether the field name of a struct, union, or enum exists.
        \\
        \\The result is a compile time constant.
        \\
        \\It does not include functions, variables, or constants.
        ,
        .arguments = &.{
            "comptime Container: type",
            "comptime name: []const u8",
        },
    },
    .{
        .name = "@import",
        .signature = "@import(comptime path: []const u8) type",
        .snippet = "@import(${1:comptime path: []const u8})",
        .documentation =
        \\This function finds a zig file corresponding to `path` and adds it to the build, if it is not already added.
        \\
        \\Zig source files are implicitly structs, with a name equal to the file's basename with the extension truncated. `@import` returns the struct type corresponding to the file.
        \\
        \\Declarations which have the `pub` keyword may be referenced from a different source file than the one they are declared in.
        \\
        \\`path` can be a relative path or it can be the name of a package. If it is a relative path, it is relative to the file that contains the `@import` function call.
        \\
        \\The following packages are always available:
        \\
        \\ - `@import("std")` - Zig Standard Library
        \\ - `@import("builtin")` - Target-specific information The command
        \\`zig build-exe --show-builtin`outputs the source to stdout for reference.
        \\ - `@import("root")` - Root source file This is usually
        \\`src/main.zig`but depends on what file is built.
        ,
        .arguments = &.{
            "comptime path: []const u8",
        },
    },
    .{
        .name = "@inComptime",
        .signature = "@inComptime() bool",
        .snippet = "@inComptime()",
        .documentation =
        \\Returns whether the builtin was run in a `comptime` context. The result is a compile-time constant.
        \\
        \\This can be used to provide alternative, comptime-friendly implementations of functions. It should not be used, for instance, to exclude certain functions from being evaluated at comptime.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@intCast",
        .signature = "@intCast(int: anytype) anytype",
        .snippet = "@intCast(${1:int: anytype})",
        .documentation =
        \\Converts an integer to another integer while keeping the same numerical value. The return type is the inferred result type. Attempting to convert a number which is out of range of the destination type results in safety-protected [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        \\
        \\```zig
        \\test "integer cast panic" {
        \\    var a: u16 = 0xabcd; // runtime-known
        \\    _ = &a;
        \\    const b: u8 = @intCast(a);
        \\    _ = b;
        \\}
        \\```
        \\To truncate the significant bits of a number out of range of the destination type, use [@truncate](https://ziglang.org/documentation/0.12.0/#truncate).
        \\
        \\If `T` is `comptime_int`, then this is semantically equivalent to [Type Coercion](https://ziglang.org/documentation/0.12.0/#Type-Coercion).
        ,
        .arguments = &.{
            "int: anytype",
        },
    },
    .{
        .name = "@intFromBool",
        .signature = "@intFromBool(value: bool) u1",
        .snippet = "@intFromBool(${1:value: bool})",
        .documentation =
        \\Converts `true` to `@as(u1, 1)` and `false` to `@as(u1, 0)`.
        ,
        .arguments = &.{
            "value: bool",
        },
    },
    .{
        .name = "@intFromEnum",
        .signature = "@intFromEnum(enum_or_tagged_union: anytype) anytype",
        .snippet = "@intFromEnum(${1:enum_or_tagged_union: anytype})",
        .documentation =
        \\Converts an enumeration value into its integer tag type. When a tagged union is passed, the tag value is used as the enumeration value.
        \\
        \\If there is only one possible enum value, the result is a `comptime_int` known at [comptime](https://ziglang.org/documentation/0.12.0/#comptime).
        ,
        .arguments = &.{
            "enum_or_tagged_union: anytype",
        },
    },
    .{
        .name = "@intFromError",
        .signature = "@intFromError(err: anytype) std.meta.Int(.unsigned, @bitSizeOf(anyerror))",
        .snippet = "@intFromError(${1:err: anytype})",
        .documentation =
        \\Supports the following types:
        \\
        \\ - [The Global Error Set](https://ziglang.org/documentation/0.12.0/#The-Global-Error-Set)
        \\ - [Error Set Type](https://ziglang.org/documentation/0.12.0/#Error-Set-Type)
        \\ - [Error Union Type](https://ziglang.org/documentation/0.12.0/#Error-Union-Type)
        \\Converts an error to the integer representation of an error.
        \\
        \\It is generally recommended to avoid this cast, as the integer representation of an error is not stable across source code changes.
        ,
        .arguments = &.{
            "err: anytype",
        },
    },
    .{
        .name = "@intFromFloat",
        .signature = "@intFromFloat(float: anytype) anytype",
        .snippet = "@intFromFloat(${1:float: anytype})",
        .documentation =
        \\Converts the integer part of a floating point number to the inferred result type.
        \\
        \\If the integer part of the floating point number cannot fit in the destination type, it invokes safety-checked [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "float: anytype",
        },
    },
    .{
        .name = "@intFromPtr",
        .signature = "@intFromPtr(value: anytype) usize",
        .snippet = "@intFromPtr(${1:value: anytype})",
        .documentation =
        \\Converts `value` to a `usize` which is the address of the pointer. `value` can be `*T` or `?*T`.
        \\
        \\To convert the other way, use [@ptrFromInt](https://ziglang.org/documentation/0.12.0/#ptrFromInt)
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@max",
        .signature = "@max(a: T, b: T) T",
        .snippet = "@max(${1:a: T}, ${2:b: T})",
        .documentation =
        \\Returns the maximum value of `a` and `b`. This builtin accepts integers, floats, and vectors of either. In the latter case, the operation is performed element wise.
        \\
        \\NaNs are handled as follows: if one of the operands of a (pairwise) operation is NaN, the other operand is returned. If both operands are NaN, NaN is returned.
        ,
        .arguments = &.{
            "a: T",
            "b: T",
        },
    },
    .{
        .name = "@memcpy",
        .signature = "@memcpy(noalias dest, noalias source) void",
        .snippet = "@memcpy(${1:noalias dest}, ${2:noalias source})",
        .documentation =
        \\This function copies bytes from one region of memory to another.
        \\
        \\`dest` must be a mutable slice, a mutable pointer to an array, or a mutable many-item [pointer](https://ziglang.org/documentation/0.12.0/#Pointers). It may have any alignment, and it may have any element type.
        \\
        \\`source` must be a slice, a pointer to an array, or a many-item [pointer](https://ziglang.org/documentation/0.12.0/#Pointers). It may have any alignment, and it may have any element type.
        \\
        \\The `source` element type must support [Type Coercion](https://ziglang.org/documentation/0.12.0/#Type-Coercion) into the `dest` element type. The element types may have different ABI size, however, that may incur a performance penalty.
        \\
        \\Similar to [for](https://ziglang.org/documentation/0.12.0/#for) loops, at least one of `source` and `dest` must provide a length, and if two lengths are provided, they must be equal.
        \\
        \\Finally, the two memory regions must not overlap.
        ,
        .arguments = &.{
            "noalias dest",
            "noalias source",
        },
    },
    .{
        .name = "@memset",
        .signature = "@memset(dest, elem) void",
        .snippet = "@memset(${1:dest}, ${2:elem})",
        .documentation =
        \\This function sets all the elements of a memory region to `elem`.
        \\
        \\`dest` must be a mutable slice or a mutable pointer to an array. It may have any alignment, and it may have any element type.
        \\
        \\`elem` is coerced to the element type of `dest`.
        \\
        \\For securely zeroing out sensitive contents from memory, you should use `std.crypto.utils.secureZero`
        ,
        .arguments = &.{
            "dest",
            "elem",
        },
    },
    .{
        .name = "@min",
        .signature = "@min(a: T, b: T) T",
        .snippet = "@min(${1:a: T}, ${2:b: T})",
        .documentation =
        \\Returns the minimum value of `a` and `b`. This builtin accepts integers, floats, and vectors of either. In the latter case, the operation is performed element wise.
        \\
        \\NaNs are handled as follows: if one of the operands of a (pairwise) operation is NaN, the other operand is returned. If both operands are NaN, NaN is returned.
        ,
        .arguments = &.{
            "a: T",
            "b: T",
        },
    },
    .{
        .name = "@wasmMemorySize",
        .signature = "@wasmMemorySize(index: u32) u32",
        .snippet = "@wasmMemorySize(${1:index: u32})",
        .documentation =
        \\This function returns the size of the Wasm memory identified by `index` as an unsigned value in units of Wasm pages. Note that each Wasm page is 64KB in size.
        \\
        \\This function is a low level intrinsic with no safety mechanisms usually useful for allocator designers targeting Wasm. So unless you are writing a new allocator from scratch, you should use something like `@import("std").heap.WasmPageAllocator`.
        ,
        .arguments = &.{
            "index: u32",
        },
    },
    .{
        .name = "@wasmMemoryGrow",
        .signature = "@wasmMemoryGrow(index: u32, delta: u32) i32",
        .snippet = "@wasmMemoryGrow(${1:index: u32}, ${2:delta: u32})",
        .documentation =
        \\This function increases the size of the Wasm memory identified by `index` by `delta` in units of unsigned number of Wasm pages. Note that each Wasm page is 64KB in size. On success, returns previous memory size; on failure, if the allocation fails, returns -1.
        \\
        \\This function is a low level intrinsic with no safety mechanisms usually useful for allocator designers targeting Wasm. So unless you are writing a new allocator from scratch, you should use something like `@import("std").heap.WasmPageAllocator`.
        \\
        \\```zig
        \\const std = @import("std");
        \\const native_arch = @import("builtin").target.cpu.arch;
        \\const expect = std.testing.expect;
        \\test "@wasmMemoryGrow" {
        \\    if (native_arch != .wasm32) return error.SkipZigTest;
        \\    const prev = @wasmMemorySize(0);
        \\    try expect(prev == @wasmMemoryGrow(0, 1));
        \\    try expect(prev + 1 == @wasmMemorySize(0));
        \\}
        \\```
        ,
        .arguments = &.{
            "index: u32",
            "delta: u32",
        },
    },
    .{
        .name = "@mod",
        .signature = "@mod(numerator: T, denominator: T) T",
        .snippet = "@mod(${1:numerator: T}, ${2:denominator: T})",
        .documentation =
        \\Modulus division. For unsigned integers this is the same as `numerator % denominator`. Caller guarantees `denominator > 0`, otherwise the operation will result in a [Remainder Division by Zero](https://ziglang.org/documentation/0.12.0/#Remainder-Division-by-Zero) when runtime safety checks are enabled.
        \\
        \\ - `@mod(-5, 3) == 1`
        \\ - `(@divFloor(a, b) * b) + @mod(a, b) == a`
        \\For a function that returns an error code, see `@import("std").math.mod`.
        ,
        .arguments = &.{
            "numerator: T",
            "denominator: T",
        },
    },
    .{
        .name = "@mulWithOverflow",
        .signature = "@mulWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
        .snippet = "@mulWithOverflow(${1:a: anytype}, ${2:b: anytype})",
        .documentation =
        \\Performs `a * b` and returns a tuple with the result and a possible overflow bit.
        ,
        .arguments = &.{
            "a: anytype",
            "b: anytype",
        },
    },
    .{
        .name = "@panic",
        .signature = "@panic(message: []const u8) noreturn",
        .snippet = "@panic(${1:message: []const u8})",
        .documentation =
        \\Invokes the panic handler function. By default the panic handler function calls the public `panic` function exposed in the root source file, or if there is not one specified, the `std.builtin.default_panic` function from `std/builtin.zig`.
        \\
        \\Generally it is better to use `@import("std").debug.panic`. However, `@panic` can be useful for 2 scenarios:
        \\
        \\ - From library code, calling the programmer's panic function if they exposed one in the root source file.
        \\ - When mixing C and Zig code, calling the canonical panic implementation across multiple .o files.
        ,
        .arguments = &.{
            "message: []const u8",
        },
    },
    .{
        .name = "@popCount",
        .signature = "@popCount(operand: anytype) anytype",
        .snippet = "@popCount(${1:operand: anytype})",
        .documentation =
        \\`@TypeOf(operand)` must be an integer type.
        \\
        \\`operand` may be an [integer](https://ziglang.org/documentation/0.12.0/#Integers) or [vector](https://ziglang.org/documentation/0.12.0/#Vectors).
        \\
        \\Counts the number of bits set in an integer - "population count".
        \\
        \\If `operand` is a [comptime](https://ziglang.org/documentation/0.12.0/#comptime)-known integer, the return type is `comptime_int`. Otherwise, the return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
        ,
        .arguments = &.{
            "operand: anytype",
        },
    },
    .{
        .name = "@prefetch",
        .signature = "@prefetch(ptr: anytype, comptime options: PrefetchOptions) void",
        .snippet = "@prefetch(${1:ptr: anytype}, ${2:comptime options: PrefetchOptions})",
        .documentation =
        \\This builtin tells the compiler to emit a prefetch instruction if supported by the target CPU. If the target CPU does not support the requested prefetch instruction, this builtin is a no-op. This function has no effect on the behavior of the program, only on the performance characteristics.
        \\
        \\The `ptr` argument may be any pointer type and determines the memory address to prefetch. This function does not dereference the pointer, it is perfectly legal to pass a pointer to invalid memory to this function and no illegal behavior will result.
        \\
        \\`PrefetchOptions` can be found with `@import("std").builtin.PrefetchOptions`.
        ,
        .arguments = &.{
            "ptr: anytype",
            "comptime options: PrefetchOptions",
        },
    },
    .{
        .name = "@ptrCast",
        .signature = "@ptrCast(value: anytype) anytype",
        .snippet = "@ptrCast(${1:value: anytype})",
        .documentation =
        \\Converts a pointer of one type to a pointer of another type. The return type is the inferred result type.
        \\
        \\[Optional Pointers](https://ziglang.org/documentation/0.12.0/#Optional-Pointers) are allowed. Casting an optional pointer which is [null](https://ziglang.org/documentation/0.12.0/#null) to a non-optional pointer invokes safety-checked [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        \\
        \\`@ptrCast` cannot be used for:
        \\
        \\ - Removing `const` qualifier, use [@constCast](https://ziglang.org/documentation/0.12.0/#constCast).
        \\ - Removing `volatile` qualifier, use [@volatileCast](https://ziglang.org/documentation/0.12.0/#volatileCast).
        \\ - Changing pointer address space, use [@addrSpaceCast](https://ziglang.org/documentation/0.12.0/#addrSpaceCast).
        \\ - Increasing pointer alignment, use [@alignCast](https://ziglang.org/documentation/0.12.0/#alignCast).
        \\ - Casting a non-slice pointer to a slice, use slicing syntax `ptr[start..end]`.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@ptrFromInt",
        .signature = "@ptrFromInt(address: usize) anytype",
        .snippet = "@ptrFromInt(${1:address: usize})",
        .documentation =
        \\Converts an integer to a [pointer](https://ziglang.org/documentation/0.12.0/#Pointers). The return type is the inferred result type. To convert the other way, use [@intFromPtr](https://ziglang.org/documentation/0.12.0/#intFromPtr). Casting an address of 0 to a destination type which in not [optional](https://ziglang.org/documentation/0.12.0/#Optional-Pointers) and does not have the `allowzero` attribute will result in a [Pointer Cast Invalid Null](https://ziglang.org/documentation/0.12.0/#Pointer-Cast-Invalid-Null) panic when runtime safety checks are enabled.
        \\
        \\If the destination pointer type does not allow address zero and `address` is zero, this invokes safety-checked [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "address: usize",
        },
    },
    .{
        .name = "@rem",
        .signature = "@rem(numerator: T, denominator: T) T",
        .snippet = "@rem(${1:numerator: T}, ${2:denominator: T})",
        .documentation =
        \\Remainder division. For unsigned integers this is the same as `numerator % denominator`. Caller guarantees `denominator > 0`, otherwise the operation will result in a [Remainder Division by Zero](https://ziglang.org/documentation/0.12.0/#Remainder-Division-by-Zero) when runtime safety checks are enabled.
        \\
        \\ - `@rem(-5, 3) == -2`
        \\ - `(@divTrunc(a, b) * b) + @rem(a, b) == a`
        \\For a function that returns an error code, see `@import("std").math.rem`.
        ,
        .arguments = &.{
            "numerator: T",
            "denominator: T",
        },
    },
    .{
        .name = "@returnAddress",
        .signature = "@returnAddress() usize",
        .snippet = "@returnAddress()",
        .documentation =
        \\This function returns the address of the next machine code instruction that will be executed when the current function returns.
        \\
        \\The implications of this are target-specific and not consistent across all platforms.
        \\
        \\This function is only valid within function scope. If the function gets inlined into a calling function, the returned address will apply to the calling function.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@select",
        .signature = "@select(comptime T: type, pred: @Vector(len, bool), a: @Vector(len, T), b: @Vector(len, T)) @Vector(len, T)",
        .snippet = "@select(${1:comptime T: type}, ${2:pred: @Vector(len, bool)}, ${3:a: @Vector(len, T)}, ${4:b: @Vector(len, T)})",
        .documentation =
        \\Selects values element-wise from `a` or `b` based on `pred`. If `pred[i]` is `true`, the corresponding element in the result will be `a[i]` and otherwise `b[i]`.
        ,
        .arguments = &.{
            "comptime T: type",
            "pred: @Vector(len, bool)",
            "a: @Vector(len, T)",
            "b: @Vector(len, T)",
        },
    },
    .{
        .name = "@setAlignStack",
        .signature = "@setAlignStack(comptime alignment: u29) void",
        .snippet = "@setAlignStack(${1:comptime alignment: u29})",
        .documentation =
        \\Ensures that a function will have a stack alignment of at least `alignment` bytes.
        ,
        .arguments = &.{
            "comptime alignment: u29",
        },
    },
    .{
        .name = "@setCold",
        .signature = "@setCold(comptime is_cold: bool) void",
        .snippet = "@setCold(${1:comptime is_cold: bool})",
        .documentation =
        \\Tells the optimizer that the current function is (or is not) rarely called.  This function is only valid within function scope.
        ,
        .arguments = &.{
            "comptime is_cold: bool",
        },
    },
    .{
        .name = "@setEvalBranchQuota",
        .signature = "@setEvalBranchQuota(comptime new_quota: u32) void",
        .snippet = "@setEvalBranchQuota(${1:comptime new_quota: u32})",
        .documentation =
        \\Increase the maximum number of backwards branches that compile-time code execution can use before giving up and making a compile error.
        \\
        \\If the `new_quota` is smaller than the default quota (`1000`) or a previously explicitly set quota, it is ignored.
        \\
        \\Example:
        \\
        \\1001) : (i += 1) {}
        \\    }
        \\}
        \\```
        \\Now we use `@setEvalBranchQuota`:
        \\
        \\1001) : (i += 1) {}
        \\    }
        \\}
        \\```
        ,
        .arguments = &.{
            "comptime new_quota: u32",
        },
    },
    .{
        .name = "@setFloatMode",
        .signature = "@setFloatMode(comptime mode: FloatMode) void",
        .snippet = "@setFloatMode(${1:comptime mode: FloatMode})",
        .documentation =
        \\Changes the current scope's rules about how floating point operations are defined.
        \\
        \\ - `Strict` (default) - Floating point operations follow strict IEEE compliance.
        \\ - `Optimized` - Floating point operations may do all of the following:
        \\   - Assume the arguments and result are not NaN. Optimizations are required to retain defined behavior over NaNs, but the value of the result is undefined.
        \\   - Assume the arguments and result are not +/-Inf. Optimizations are required to retain defined behavior over +/-Inf, but the value of the result is undefined.
        \\   - Treat the sign of a zero argument or result as insignificant.
        \\   - Use the reciprocal of an argument rather than perform division.
        \\   - Perform floating-point contraction (e.g. fusing a multiply followed by an addition into a fused multiply-add).
        \\   - Perform algebraically equivalent transformations that may change results in floating point (e.g. reassociate).
        \\This is equivalent to
        \\`-ffast-math`in GCC.
        \\The floating point mode is inherited by child scopes, and can be overridden in any scope. You can set the floating point mode in a struct or module scope by using a comptime block.
        \\
        \\`FloatMode` can be found with `@import("std").builtin.FloatMode`.
        ,
        .arguments = &.{
            "comptime mode: FloatMode",
        },
    },
    .{
        .name = "@setRuntimeSafety",
        .signature = "@setRuntimeSafety(comptime safety_on: bool) void",
        .snippet = "@setRuntimeSafety(${1:comptime safety_on: bool})",
        .documentation =
        \\Sets whether runtime safety checks are enabled for the scope that contains the function call.
        \\
        \\```zig
        \\test "@setRuntimeSafety" {
        \\    // The builtin applies to the scope that it is called in. So here, integer overflow
        \\    // will not be caught in ReleaseFast and ReleaseSmall modes:
        \\    // var x: u8 = 255;
        \\    // x += 1; // undefined behavior in ReleaseFast/ReleaseSmall modes.
        \\    {
        \\        // However this block has safety enabled, so safety checks happen here,
        \\        // even in ReleaseFast and ReleaseSmall modes.
        \\        @setRuntimeSafety(true);
        \\        var x: u8 = 255;
        \\        x += 1;
        \\        {
        \\            // The value can be overridden at any scope. So here integer overflow
        \\            // would not be caught in any build mode.
        \\            @setRuntimeSafety(false);
        \\            // var x: u8 = 255;
        \\            // x += 1; // undefined behavior in all build modes.
        \\        }
        \\    }
        \\}
        \\```
        \\Note: it is
        \\[planned](https://github.com/ziglang/zig/issues/978)to replace `@setRuntimeSafety` with
        \\`@optimizeFor`
        ,
        .arguments = &.{
            "comptime safety_on: bool",
        },
    },
    .{
        .name = "@shlExact",
        .signature = "@shlExact(value: T, shift_amt: Log2T) T",
        .snippet = "@shlExact(${1:value: T}, ${2:shift_amt: Log2T})",
        .documentation =
        \\`). For unsigned integers, the result is [undefined](https://ziglang.org/documentation/0.12.0/#undefined) if any 1 bits are shifted out. For signed integers, the result is [undefined](https://ziglang.org/documentation/0.12.0/#undefined) if any bits that disagree with the resultant sign bit are shifted out.
        \\
        \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(T).Int.bits)` bits. This is because `shift_amt >= @typeInfo(T).Int.bits` is undefined behavior.
        \\
        \\`comptime_int` is modeled as an integer with an infinite number of bits, meaning that in such case, `@shlExact` always produces a result and cannot produce a compile error.
        ,
        .arguments = &.{
            "value: T",
            "shift_amt: Log2T",
        },
    },
    .{
        .name = "@shlWithOverflow",
        .signature = "@shlWithOverflow(a: anytype, shift_amt: Log2T) struct { @TypeOf(a), u1 }",
        .snippet = "@shlWithOverflow(${1:a: anytype}, ${2:shift_amt: Log2T})",
        .documentation =
        \\b` and returns a tuple with the result and a possible overflow bit.
        \\
        \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(@TypeOf(a)).Int.bits)` bits. This is because `shift_amt >= @typeInfo(@TypeOf(a)).Int.bits` is undefined behavior.
        ,
        .arguments = &.{
            "a: anytype",
            "shift_amt: Log2T",
        },
    },
    .{
        .name = "@shrExact",
        .signature = "@shrExact(value: T, shift_amt: Log2T) T",
        .snippet = "@shrExact(${1:value: T}, ${2:shift_amt: Log2T})",
        .documentation =
        \\Performs the right shift operation (`>>`). Caller guarantees that the shift will not shift any 1 bits out.
        \\
        \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(T).Int.bits)` bits. This is because `shift_amt >= @typeInfo(T).Int.bits` is undefined behavior.
        ,
        .arguments = &.{
            "value: T",
            "shift_amt: Log2T",
        },
    },
    .{
        .name = "@shuffle",
        .signature = "@shuffle(comptime E: type, a: @Vector(a_len, E), b: @Vector(b_len, E), comptime mask: @Vector(mask_len, i32)) @Vector(mask_len, E)",
        .snippet = "@shuffle(${1:comptime E: type}, ${2:a: @Vector(a_len, E)}, ${3:b: @Vector(b_len, E)}, ${4:comptime mask: @Vector(mask_len, i32)})",
        .documentation =
        \\Constructs a new [vector](https://ziglang.org/documentation/0.12.0/#Vectors) by selecting elements from `a` and `b` based on `mask`.
        \\
        \\Each element in `mask` selects an element from either `a` or `b`. Positive numbers select from `a` starting at 0. Negative values select from `b`, starting at `-1` and going down. It is recommended to use the `~` operator for indexes from `b` so that both indexes can start from `0` (i.e. `~@as(i32, 0)` is `-1`).
        \\
        \\For each element of `mask`, if it or the selected value from `a` or `b` is `undefined`, then the resulting element is `undefined`.
        \\
        \\`a_len` and `b_len` may differ in length. Out-of-bounds element indexes in `mask` result in compile errors.
        \\
        \\If `a` or `b` is `undefined`, it is equivalent to a vector of all `undefined` with the same length as the other vector. If both vectors are `undefined`, `@shuffle` returns a vector with all elements `undefined`.
        \\
        \\`E` must be an [integer](https://ziglang.org/documentation/0.12.0/#Integers), [float](https://ziglang.org/documentation/0.12.0/#Floats), [pointer](https://ziglang.org/documentation/0.12.0/#Pointers), or `bool`. The mask may be any vector length, and its length determines the result length.
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "vector @shuffle" {
        \\    const a = @Vector(7, u8){ 'o', 'l', 'h', 'e', 'r', 'z', 'w' };
        \\    const b = @Vector(4, u8){ 'w', 'd', '!', 'x' };
        \\    // To shuffle within a single vector, pass undefined as the second argument.
        \\    // Notice that we can re-order, duplicate, or omit elements of the input vector
        \\    const mask1 = @Vector(5, i32){ 2, 3, 1, 1, 0 };
        \\    const res1: @Vector(5, u8) = @shuffle(u8, a, undefined, mask1);
        \\    try expect(std.mem.eql(u8, &@as([5]u8, res1), "hello"));
        \\    // Combining two vectors
        \\    const mask2 = @Vector(6, i32){ -1, 0, 4, 1, -2, -3 };
        \\    const res2: @Vector(6, u8) = @shuffle(u8, a, b, mask2);
        \\    try expect(std.mem.eql(u8, &@as([6]u8, res2), "world!"));
        \\}
        \\```
        ,
        .arguments = &.{
            "comptime E: type",
            "a: @Vector(a_len, E)",
            "b: @Vector(b_len, E)",
            "comptime mask: @Vector(mask_len, i32)",
        },
    },
    .{
        .name = "@sizeOf",
        .signature = "@sizeOf(comptime T: type) comptime_int",
        .snippet = "@sizeOf(${1:comptime T: type})",
        .documentation =
        \\This function returns the number of bytes it takes to store `T` in memory. The result is a target-specific compile time constant.
        \\
        \\This size may contain padding bytes. If there were two consecutive T in memory, the padding would be the offset in bytes between element at index 0 and the element at index 1. For [integer](https://ziglang.org/documentation/0.12.0/#Integers), consider whether you want to use `@sizeOf(T)` or `@typeInfo(T).Int.bits`.
        \\
        \\This function measures the size at runtime. For types that are disallowed at runtime, such as `comptime_int` and `type`, the result is `0`.
        ,
        .arguments = &.{
            "comptime T: type",
        },
    },
    .{
        .name = "@splat",
        .signature = "@splat(scalar: anytype) anytype",
        .snippet = "@splat(${1:scalar: anytype})",
        .documentation =
        \\Produces a vector where each element is the value `scalar`. The return type and thus the length of the vector is inferred.
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "vector @splat" {
        \\    const scalar: u32 = 5;
        \\    const result: @Vector(4, u32) = @splat(scalar);
        \\    try expect(std.mem.eql(u32, &@as([4]u32, result), &[_]u32{ 5, 5, 5, 5 }));
        \\}
        \\```
        \\`scalar` must be an [integer](https://ziglang.org/documentation/0.12.0/#Integers), [bool](https://ziglang.org/documentation/0.12.0/#Primitive-Types), [float](https://ziglang.org/documentation/0.12.0/#Floats), or [pointer](https://ziglang.org/documentation/0.12.0/#Pointers).
        ,
        .arguments = &.{
            "scalar: anytype",
        },
    },
    .{
        .name = "@reduce",
        .signature = "@reduce(comptime op: std.builtin.ReduceOp, value: anytype) E",
        .snippet = "@reduce(${1:comptime op: std.builtin.ReduceOp}, ${2:value: anytype})",
        .documentation =
        \\Transforms a [vector](https://ziglang.org/documentation/0.12.0/#Vectors) into a scalar value (of type
        \\`E`) by performing a sequential horizontal reduction of its elements using the specified operator `op`.
        \\
        \\Not every operator is available for every vector element type:
        \\
        \\ - Every operator is available for [integer](https://ziglang.org/documentation/0.12.0/#Integers) vectors.
        \\ - `.And`, `.Or`, `.Xor` are additionally available for `bool` vectors,
        \\ - `.Min`, `.Max`, `.Add`, `.Mul` are additionally available for [floating point](https://ziglang.org/documentation/0.12.0/#Floats) vectors,
        \\Note that `.Add` and `.Mul` reductions on integral types are wrapping; when applied on floating point types the operation associativity is preserved, unless the float mode is set to `Optimized`.
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "vector @reduce" {
        \\    const V = @Vector(4, i32);
        \\    const value = V{ 1, -1, 1, -1 };
        \\    const result = value > @as(V, @splat(0));
        \\    // result is { true, false, true, false };
        \\    try comptime expect(@TypeOf(result) == @Vector(4, bool));
        \\    const is_all_true = @reduce(.And, result);
        \\    try comptime expect(@TypeOf(is_all_true) == bool);
        \\    try expect(is_all_true == false);
        \\}
        \\```
        ,
        .arguments = &.{
            "comptime op: std.builtin.ReduceOp",
            "value: anytype",
        },
    },
    .{
        .name = "@src",
        .signature = "@src() std.builtin.SourceLocation",
        .snippet = "@src()",
        .documentation =
        \\Returns a `SourceLocation` struct representing the function's name and location in the source code. This must be called in a function.
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "@src" {
        \\    try doTheTest();
        \\}
        \\fn doTheTest() !void {
        \\    const src = @src();
        \\    try expect(src.line == 9);
        \\    try expect(src.column == 17);
        \\    try expect(std.mem.endsWith(u8, src.fn_name, "doTheTest"));
        \\    try expect(std.mem.endsWith(u8, src.file, "test_src_builtin.zig"));
        \\}
        \\```
        ,
        .arguments = &.{},
    },
    .{
        .name = "@sqrt",
        .signature = "@sqrt(value: anytype) @TypeOf(value)",
        .snippet = "@sqrt(${1:value: anytype})",
        .documentation =
        \\Performs the square root of a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@sin",
        .signature = "@sin(value: anytype) @TypeOf(value)",
        .snippet = "@sin(${1:value: anytype})",
        .documentation =
        \\Sine trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@cos",
        .signature = "@cos(value: anytype) @TypeOf(value)",
        .snippet = "@cos(${1:value: anytype})",
        .documentation =
        \\Cosine trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@tan",
        .signature = "@tan(value: anytype) @TypeOf(value)",
        .snippet = "@tan(${1:value: anytype})",
        .documentation =
        \\Tangent trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@exp",
        .signature = "@exp(value: anytype) @TypeOf(value)",
        .snippet = "@exp(${1:value: anytype})",
        .documentation =
        \\Base-e exponential function on a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@exp2",
        .signature = "@exp2(value: anytype) @TypeOf(value)",
        .snippet = "@exp2(${1:value: anytype})",
        .documentation =
        \\Base-2 exponential function on a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@log",
        .signature = "@log(value: anytype) @TypeOf(value)",
        .snippet = "@log(${1:value: anytype})",
        .documentation =
        \\Returns the natural logarithm of a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@log2",
        .signature = "@log2(value: anytype) @TypeOf(value)",
        .snippet = "@log2(${1:value: anytype})",
        .documentation =
        \\Returns the logarithm to the base 2 of a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@log10",
        .signature = "@log10(value: anytype) @TypeOf(value)",
        .snippet = "@log10(${1:value: anytype})",
        .documentation =
        \\Returns the logarithm to the base 10 of a floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@abs",
        .signature = "@abs(value: anytype) anytype",
        .snippet = "@abs(${1:value: anytype})",
        .documentation =
        \\Returns the absolute value of an integer or a floating point number. Uses a dedicated hardware instruction when available.  The return type is always an unsigned integer of the same bit width as the operand if the operand is an integer. Unsigned integer operands are supported. The builtin cannot overflow for signed integer operands.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats), [Integers](https://ziglang.org/documentation/0.12.0/#Integers) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats or integers.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@floor",
        .signature = "@floor(value: anytype) @TypeOf(value)",
        .snippet = "@floor(${1:value: anytype})",
        .documentation =
        \\Returns the largest integral value not greater than the given floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@ceil",
        .signature = "@ceil(value: anytype) @TypeOf(value)",
        .snippet = "@ceil(${1:value: anytype})",
        .documentation =
        \\Returns the smallest integral value not less than the given floating point number. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@trunc",
        .signature = "@trunc(value: anytype) @TypeOf(value)",
        .snippet = "@trunc(${1:value: anytype})",
        .documentation =
        \\Rounds the given floating point number to an integer, towards zero. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@round",
        .signature = "@round(value: anytype) @TypeOf(value)",
        .snippet = "@round(${1:value: anytype})",
        .documentation =
        \\Rounds the given floating point number to an integer, away from zero. Uses a dedicated hardware instruction when available.
        \\
        \\Supports [Floats](https://ziglang.org/documentation/0.12.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors) of floats.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@subWithOverflow",
        .signature = "@subWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
        .snippet = "@subWithOverflow(${1:a: anytype}, ${2:b: anytype})",
        .documentation =
        \\Performs `a - b` and returns a tuple with the result and a possible overflow bit.
        ,
        .arguments = &.{
            "a: anytype",
            "b: anytype",
        },
    },
    .{
        .name = "@tagName",
        .signature = "@tagName(value: anytype) [:0]const u8",
        .snippet = "@tagName(${1:value: anytype})",
        .documentation =
        \\Converts an enum value or union value to a string literal representing the name.
        \\
        \\If the enum is non-exhaustive and the tag value does not map to a name, it invokes safety-checked [Undefined Behavior](https://ziglang.org/documentation/0.12.0/#Undefined-Behavior).
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@This",
        .signature = "@This() type",
        .snippet = "@This()",
        .documentation =
        \\Returns the innermost struct, enum, or union that this function call is inside. This can be useful for an anonymous struct that needs to refer to itself:
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "@This()" {
        \\    var items = [_]i32{ 1, 2, 3, 4 };
        \\    const list = List(i32){ .items = items[0..] };
        \\    try expect(list.length() == 4);
        \\}
        \\fn List(comptime T: type) type {
        \\    return struct {
        \\        const Self = @This();
        \\        items: []T,
        \\        fn length(self: Self) usize {
        \\            return self.items.len;
        \\        }
        \\    };
        \\}
        \\```
        \\When `@This()` is used at file scope, it returns a reference to the struct that corresponds to the current file.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@trap",
        .signature = "@trap() noreturn",
        .snippet = "@trap()",
        .documentation =
        \\This function inserts a platform-specific trap/jam instruction which can be used to exit the program abnormally. This may be implemented by explicitly emitting an invalid instruction which may cause an illegal instruction exception of some sort. Unlike for `@breakpoint()`, execution does not continue after this point.
        \\
        \\Outside function scope, this builtin causes a compile error.
        ,
        .arguments = &.{},
    },
    .{
        .name = "@truncate",
        .signature = "@truncate(integer: anytype) anytype",
        .snippet = "@truncate(${1:integer: anytype})",
        .documentation =
        \\This function truncates bits from an integer type, resulting in a smaller or same-sized integer type. The return type is the inferred result type.
        \\
        \\This function always truncates the significant bits of the integer, regardless of endianness on the target platform.
        \\
        \\Calling `@truncate` on a number out of range of the destination type is well defined and working code:
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "integer truncation" {
        \\    const a: u16 = 0xabcd;
        \\    const b: u8 = @truncate(a);
        \\    try expect(b == 0xcd);
        \\}
        \\```
        \\Use [@intCast](https://ziglang.org/documentation/0.12.0/#intCast) to convert numbers guaranteed to fit the destination type.
        ,
        .arguments = &.{
            "integer: anytype",
        },
    },
    .{
        .name = "@Type",
        .signature = "@Type(comptime info: std.builtin.Type) type",
        .snippet = "@Type(${1:comptime info: std.builtin.Type})",
        .documentation =
        \\This function is the inverse of [@typeInfo](https://ziglang.org/documentation/0.12.0/#typeInfo). It reifies type information into a `type`.
        \\
        \\It is available for the following types:
        \\
        \\ - `type`
        \\ - `noreturn`
        \\ - `void`
        \\ - `bool`
        \\ - [Integers](https://ziglang.org/documentation/0.12.0/#Integers) - The maximum bit count for an integer type is `65535`.
        \\ - [Floats](https://ziglang.org/documentation/0.12.0/#Floats)
        \\ - [Pointers](https://ziglang.org/documentation/0.12.0/#Pointers)
        \\ - `comptime_int`
        \\ - `comptime_float`
        \\ - `@TypeOf(undefined)`
        \\ - `@TypeOf(null)`
        \\ - [Arrays](https://ziglang.org/documentation/0.12.0/#Arrays)
        \\ - [Optionals](https://ziglang.org/documentation/0.12.0/#Optionals)
        \\ - [Error Set Type](https://ziglang.org/documentation/0.12.0/#Error-Set-Type)
        \\ - [Error Union Type](https://ziglang.org/documentation/0.12.0/#Error-Union-Type)
        \\ - [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors)
        \\ - [opaque](https://ziglang.org/documentation/0.12.0/#opaque)
        \\ - `anyframe`
        \\ - [struct](https://ziglang.org/documentation/0.12.0/#struct)
        \\ - [enum](https://ziglang.org/documentation/0.12.0/#enum)
        \\ - [Enum Literals](https://ziglang.org/documentation/0.12.0/#Enum-Literals)
        \\ - [union](https://ziglang.org/documentation/0.12.0/#union)
        \\ - [Functions](https://ziglang.org/documentation/0.12.0/#Functions)
        ,
        .arguments = &.{
            "comptime info: std.builtin.Type",
        },
    },
    .{
        .name = "@typeInfo",
        .signature = "@typeInfo(comptime T: type) std.builtin.Type",
        .snippet = "@typeInfo(${1:comptime T: type})",
        .documentation =
        \\Provides type reflection.
        \\
        \\Type information of [structs](https://ziglang.org/documentation/0.12.0/#struct), [unions](https://ziglang.org/documentation/0.12.0/#union), [enums](https://ziglang.org/documentation/0.12.0/#enum), and [error sets](https://ziglang.org/documentation/0.12.0/#Error-Set-Type) has fields which are guaranteed to be in the same order as appearance in the source file.
        \\
        \\Type information of [structs](https://ziglang.org/documentation/0.12.0/#struct), [unions](https://ziglang.org/documentation/0.12.0/#union), [enums](https://ziglang.org/documentation/0.12.0/#enum), and [opaques](https://ziglang.org/documentation/0.12.0/#opaque) has declarations, which are also guaranteed to be in the same order as appearance in the source file.
        ,
        .arguments = &.{
            "comptime T: type",
        },
    },
    .{
        .name = "@typeName",
        .signature = "@typeName(T: type) *const [N:0]u8",
        .snippet = "@typeName(${1:T: type})",
        .documentation =
        \\This function returns the string representation of a type, as an array. It is equivalent to a string literal of the type name. The returned type name is fully qualified with the parent namespace included as part of the type name with a series of dots.
        ,
        .arguments = &.{
            "T: type",
        },
    },
    .{
        .name = "@TypeOf",
        .signature = "@TypeOf(...) type",
        .snippet = "@TypeOf(${1:...})",
        .documentation =
        \\`@TypeOf` is a special builtin function that takes any (nonzero) number of expressions as parameters and returns the type of the result, using [Peer Type Resolution](https://ziglang.org/documentation/0.12.0/#Peer-Type-Resolution).
        \\
        \\The expressions are evaluated, however they are guaranteed to have no
        \\**runtime** side-effects:
        \\
        \\```zig
        \\const std = @import("std");
        \\const expect = std.testing.expect;
        \\test "no runtime side effects" {
        \\    var data: i32 = 0;
        \\    const T = @TypeOf(foo(i32, &data));
        \\    try comptime expect(T == i32);
        \\    try expect(data == 0);
        \\}
        \\fn foo(comptime T: type, ptr: *T) T {
        \\    ptr.* += 1;
        \\    return ptr.*;
        \\}
        \\```
        ,
        .arguments = &.{
            "...",
        },
    },
    .{
        .name = "@unionInit",
        .signature = "@unionInit(comptime Union: type, comptime active_field_name: []const u8, init_expr) Union",
        .snippet = "@unionInit(${1:comptime Union: type}, ${2:comptime active_field_name: []const u8}, ${3:init_expr})",
        .documentation =
        \\This is the same thing as [union](https://ziglang.org/documentation/0.12.0/#union) initialization syntax, except that the field name is a [comptime](https://ziglang.org/documentation/0.12.0/#comptime)-known value rather than an identifier token.
        \\
        \\`@unionInit` forwards its [result location](https://ziglang.org/documentation/0.12.0/#Result-Location-Semantics) to `init_expr`.
        ,
        .arguments = &.{
            "comptime Union: type",
            "comptime active_field_name: []const u8",
            "init_expr",
        },
    },
    .{
        .name = "@Vector",
        .signature = "@Vector(len: comptime_int, Element: type) type",
        .snippet = "@Vector(${1:len: comptime_int}, ${2:Element: type})",
        .documentation =
        \\Creates [Vectors](https://ziglang.org/documentation/0.12.0/#Vectors).
        ,
        .arguments = &.{
            "len: comptime_int",
            "Element: type",
        },
    },
    .{
        .name = "@volatileCast",
        .signature = "@volatileCast(value: anytype) DestType",
        .snippet = "@volatileCast(${1:value: anytype})",
        .documentation =
        \\Remove `volatile` qualifier from a pointer.
        ,
        .arguments = &.{
            "value: anytype",
        },
    },
    .{
        .name = "@workGroupId",
        .signature = "@workGroupId(comptime dimension: u32) u32",
        .snippet = "@workGroupId(${1:comptime dimension: u32})",
        .documentation =
        \\Returns the index of the work group in the current kernel invocation in dimension `dimension`.
        ,
        .arguments = &.{
            "comptime dimension: u32",
        },
    },
    .{
        .name = "@workGroupSize",
        .signature = "@workGroupSize(comptime dimension: u32) u32",
        .snippet = "@workGroupSize(${1:comptime dimension: u32})",
        .documentation =
        \\Returns the number of work items that a work group has in dimension `dimension`.
        ,
        .arguments = &.{
            "comptime dimension: u32",
        },
    },
    .{
        .name = "@workItemId",
        .signature = "@workItemId(comptime dimension: u32) u32",
        .snippet = "@workItemId(${1:comptime dimension: u32})",
        .documentation =
        \\Returns the index of the work item in the work group in dimension `dimension`. This function returns values between `0` (inclusive) and `@workGroupSize(dimension)` (exclusive).
        ,
        .arguments = &.{
            "comptime dimension: u32",
        },
    },
};

// DO NOT EDIT
