/* notify.c generated by valac 0.56.16, the Vala compiler
 * generated from notify.vala, do not modify */

/* notify.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist.h"
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR (zeitgeist_monitor_manager_monitor_get_type ())
#define ZEITGEIST_MONITOR_MANAGER_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitor))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))

typedef struct _ZeitgeistMonitorManagerMonitor ZeitgeistMonitorManagerMonitor;
typedef struct _ZeitgeistMonitorManagerMonitorClass ZeitgeistMonitorManagerMonitorClass;
enum  {
	ZEITGEIST_MONITOR_MANAGER_0_PROPERTY,
	ZEITGEIST_MONITOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_monitor_manager_properties[ZEITGEIST_MONITOR_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _zeitgeist_monitor_manager_monitor_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistMonitorManagerMonitorPrivate ZeitgeistMonitorManagerMonitorPrivate;
typedef struct _ZeitgeistMonitorManagerMonitorQueuedNotification ZeitgeistMonitorManagerMonitorQueuedNotification;
typedef enum  {
	ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION,
	ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION
} ZeitgeistMonitorManagerMonitorNotificationType;

#define ZEITGEIST_MONITOR_MANAGER_MONITOR_TYPE_NOTIFICATION_TYPE (zeitgeist_monitor_manager_monitor_notification_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ZeitgeistMonitorManagerParamSpecMonitor ZeitgeistMonitorManagerParamSpecMonitor;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistMonitorManagerPrivate {
	GHashTable* monitors;
	GHashTable* connections;
};

struct _ZeitgeistMonitorManagerMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistMonitorManagerMonitorPrivate * priv;
};

struct _ZeitgeistMonitorManagerMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistMonitorManagerMonitor *self);
};

struct _ZeitgeistMonitorManagerMonitorPrivate {
	GPtrArray* event_templates;
	ZeitgeistTimeRange* time_range;
	ZeitgeistRemoteMonitor* proxy_object;
	GSList* queued_notifications;
};

struct _ZeitgeistMonitorManagerMonitorQueuedNotification {
	ZeitgeistMonitorManagerMonitorNotificationType type;
	GVariant* time_range;
	GVariant* events;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
};

struct _ZeitgeistMonitorManagerParamSpecMonitor {
	GParamSpec parent_instance;
};

static gint ZeitgeistMonitorManager_private_offset;
static gpointer zeitgeist_monitor_manager_parent_class = NULL;
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_instance;
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_instance = NULL;
static gint ZeitgeistMonitorManagerMonitor_private_offset;
static gpointer zeitgeist_monitor_manager_monitor_parent_class = NULL;

static gpointer zeitgeist_monitor_manager_monitor_ref (gpointer instance);
static void zeitgeist_monitor_manager_monitor_unref (gpointer instance);
static GParamSpec* zeitgeist_monitor_manager_param_spec_monitor (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags) G_GNUC_UNUSED ;
static void zeitgeist_monitor_manager_value_set_monitor (GValue* value,
                                                  gpointer v_object) G_GNUC_UNUSED ;
static void zeitgeist_monitor_manager_value_take_monitor (GValue* value,
                                                   gpointer v_object) G_GNUC_UNUSED ;
static gpointer zeitgeist_monitor_manager_value_get_monitor (const GValue* value) G_GNUC_UNUSED ;
static GType zeitgeist_monitor_manager_monitor_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_new (void);
static ZeitgeistMonitorManager* zeitgeist_monitor_manager_construct (GType object_type);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_new (const char* peer,
                                                                       const gchar* object_path,
                                                                       ZeitgeistTimeRange* tr,
                                                                       GPtrArray* templates);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_construct (GType object_type,
                                                                             const char* peer,
                                                                             const gchar* object_path,
                                                                             ZeitgeistTimeRange* tr,
                                                                             GPtrArray* templates);
static void _g_free0_ (gpointer var);
static void zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self,
                                                      ZeitgeistTimeRange* time_range,
                                                      GPtrArray* events);
static void zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self,
                                                      ZeitgeistTimeRange* time_range,
                                                      guint32* event_ids,
                                                      gint event_ids_length1);
static void zeitgeist_monitor_manager_monitor_queued_notification_free (ZeitgeistMonitorManagerMonitorQueuedNotification * self);
static GType zeitgeist_monitor_manager_monitor_notification_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _zeitgeist_monitor_manager_monitor_queued_notification_free0_ (gpointer var);
static inline void _g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (GSList* self);
static void __lambda6_ (ZeitgeistMonitorManagerMonitor* self,
                 GObject* obj,
                 GAsyncResult* res);
static void zeitgeist_monitor_manager_monitor_flush_notifications (ZeitgeistMonitorManagerMonitor* self);
static void zeitgeist_monitor_manager_monitor_name_owner_changed (ZeitgeistMonitorManagerMonitor* self);
static void _zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void zeitgeist_monitor_manager_monitor_queued_notification_send (ZeitgeistMonitorManagerMonitorQueuedNotification* self,
                                                                 ZeitgeistRemoteMonitor* proxy_object);
static gboolean zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self,
                                                    ZeitgeistEvent* event);
static void _g_object_unref0_ (gpointer var);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (GVariant* time_range,
                                                                                                                       GVariant* events);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (GVariant* time_range,
                                                                                                                      guint32* event_ids,
                                                                                                                      gint event_ids_length1);
static void zeitgeist_monitor_manager_monitor_queued_notification_instance_init (ZeitgeistMonitorManagerMonitorQueuedNotification * self);
static guint32* _vala_array_dup1 (guint32* self,
                           gssize length);
static ZeitgeistMonitorManagerMonitorQueuedNotification* zeitgeist_monitor_manager_monitor_queued_notification_new (void);
static void zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor * obj);
static GType zeitgeist_monitor_manager_monitor_get_type_once (void);
static GObject * zeitgeist_monitor_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _zeitgeist_monitor_manager_monitor_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _zeitgeist_monitor_manager____lambda7_ (ZeitgeistMonitorManager* self,
                                             GDBusConnection* conn,
                                             const gchar* sender,
                                             const gchar* path,
                                             const gchar* ifc_name,
                                             const gchar* sig_name,
                                             GVariant* parameters);
static void __zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback (GDBusConnection* connection,
                                                                     const gchar* sender_name,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* signal_name,
                                                                     GVariant* parameters,
                                                                     gpointer self);
static void zeitgeist_monitor_manager_finalize (GObject * obj);
static GType zeitgeist_monitor_manager_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
zeitgeist_monitor_manager_get_instance_private (ZeitgeistMonitorManager* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistMonitorManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistMonitorManager*
zeitgeist_monitor_manager_get_default (void)
{
	ZeitgeistMonitorManager* _tmp0_ = NULL;
	ZeitgeistMonitorManager* _tmp1_;
	ZeitgeistMonitorManager* _tmp2_;
	ZeitgeistMonitorManager* _tmp4_;
	ZeitgeistMonitorManager* result;
	_tmp1_ = zeitgeist_monitor_manager_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ZeitgeistMonitorManager* _tmp3_;
		_tmp3_ = zeitgeist_monitor_manager_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static ZeitgeistMonitorManager*
zeitgeist_monitor_manager_construct (GType object_type)
{
	ZeitgeistMonitorManager * self = NULL;
	self = (ZeitgeistMonitorManager*) g_object_new (object_type, NULL);
	return self;
}

static ZeitgeistMonitorManager*
zeitgeist_monitor_manager_new (void)
{
	return zeitgeist_monitor_manager_construct (ZEITGEIST_TYPE_MONITOR_MANAGER);
}

static gpointer
_zeitgeist_monitor_manager_monitor_ref0 (gpointer self)
{
	return self ? zeitgeist_monitor_manager_monitor_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

void
zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self,
                                           const char* peer,
                                           const gchar* object_path,
                                           ZeitgeistTimeRange* time_range,
                                           GPtrArray* templates)
{
	gchar* hash = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (templates != NULL);
	_tmp0_ = g_strdup_printf ("%s#%s", (const gchar*) peer, object_path);
	hash = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = hash;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp3_) == NULL) {
		ZeitgeistMonitorManagerMonitor* monitor = NULL;
		ZeitgeistMonitorManagerMonitor* _tmp4_;
		GHashTable* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		ZeitgeistMonitorManagerMonitor* _tmp8_;
		ZeitgeistMonitorManagerMonitor* _tmp9_;
		GHashTable* _tmp10_;
		gconstpointer _tmp11_;
		GHashTable* _tmp15_;
		gconstpointer _tmp16_;
		gchar* _tmp17_;
		_tmp4_ = zeitgeist_monitor_manager_monitor_new (peer, object_path, time_range, templates);
		monitor = _tmp4_;
		_tmp5_ = self->priv->monitors;
		_tmp6_ = hash;
		_tmp7_ = g_strdup (_tmp6_);
		_tmp8_ = monitor;
		_tmp9_ = _zeitgeist_monitor_manager_monitor_ref0 (_tmp8_);
		g_hash_table_insert (_tmp5_, _tmp7_, _tmp9_);
		_tmp10_ = self->priv->connections;
		_tmp11_ = g_hash_table_lookup (_tmp10_, (const gchar*) peer);
		if (((GPtrArray*) _tmp11_) == NULL) {
			GHashTable* _tmp12_;
			gchar* _tmp13_;
			GPtrArray* _tmp14_;
			_tmp12_ = self->priv->connections;
			_tmp13_ = g_strdup ((gchar*) peer);
			_tmp14_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
		}
		_tmp15_ = self->priv->connections;
		_tmp16_ = g_hash_table_lookup (_tmp15_, (const gchar*) peer);
		_tmp17_ = g_strdup (object_path);
		g_ptr_array_add ((GPtrArray*) _tmp16_, _tmp17_);
		g_debug ("notify.vala:290: Installed new monitor for %s", (const gchar*) peer);
		_zeitgeist_monitor_manager_monitor_unref0 (monitor);
	} else {
		const gchar* _tmp18_;
		_tmp18_ = hash;
		g_warning ("notify.vala:294: There's already a monitor installed for %s", _tmp18_);
	}
	_g_free0 (hash);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self,
                                          const char* peer,
                                          const gchar* object_path)
{
	gchar* hash = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	g_debug ("notify.vala:300: Removing monitor %s%s", (const gchar*) peer, object_path);
	_tmp0_ = g_strdup_printf ("%s#%s", (const gchar*) peer, object_path);
	hash = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = hash;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp3_) != NULL) {
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->monitors;
		_tmp5_ = hash;
		g_hash_table_remove (_tmp4_, _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = hash;
		g_warning ("notify.vala:306: There's no monitor installed for %s", _tmp6_);
	}
	_tmp7_ = self->priv->connections;
	_tmp8_ = g_hash_table_lookup (_tmp7_, (const gchar*) peer);
	if (((GPtrArray*) _tmp8_) != NULL) {
		GPtrArray* paths = NULL;
		GHashTable* _tmp9_;
		gconstpointer _tmp10_;
		GPtrArray* _tmp11_;
		_tmp9_ = self->priv->connections;
		_tmp10_ = g_hash_table_lookup (_tmp9_, (const gchar*) peer);
		_tmp11_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp10_);
		paths = _tmp11_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					GPtrArray* _tmp17_;
					gconstpointer _tmp18_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = paths;
					_tmp15_ = vala_g_ptr_array_get_length (_tmp14_);
					_tmp16_ = _tmp15_;
					if (!(i < _tmp16_)) {
						break;
					}
					_tmp17_ = paths;
					_tmp18_ = g_ptr_array_index (_tmp17_, (guint) i);
					if (g_strcmp0 ((const gchar*) _tmp18_, object_path) == 0) {
						GPtrArray* _tmp19_;
						_tmp19_ = paths;
						g_ptr_array_remove_index_fast (_tmp19_, (guint) i);
						break;
					}
				}
			}
		}
		_g_ptr_array_unref0 (paths);
	}
	_g_free0 (hash);
}

void
zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self,
                                         ZeitgeistTimeRange* time_range,
                                         GPtrArray* events)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_;
				_tmp2_ = mon;
				zeitgeist_monitor_manager_monitor_notify_insert (_tmp2_, time_range, events);
			}
		}
		(mon_collection == NULL) ? NULL : (mon_collection = (g_list_free (mon_collection), NULL));
	}
}

void
zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self,
                                         ZeitgeistTimeRange* time_range,
                                         guint32* event_ids,
                                         gint event_ids_length1)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_;
				_tmp2_ = mon;
				zeitgeist_monitor_manager_monitor_notify_delete (_tmp2_, time_range, event_ids, (gint) event_ids_length1);
			}
		}
		(mon_collection == NULL) ? NULL : (mon_collection = (g_list_free (mon_collection), NULL));
	}
}

static inline gpointer
zeitgeist_monitor_manager_monitor_get_instance_private (ZeitgeistMonitorManagerMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistMonitorManagerMonitor_private_offset);
}

static GType
zeitgeist_monitor_manager_monitor_notification_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION, "ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION", "insertion"}, {ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION, "ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION", "deletion"}, {0, NULL, NULL}};
	GType zeitgeist_monitor_manager_monitor_notification_type_type_id;
	zeitgeist_monitor_manager_monitor_notification_type_type_id = g_enum_register_static ("ZeitgeistMonitorManagerMonitorNotificationType", values);
	return zeitgeist_monitor_manager_monitor_notification_type_type_id;
}

static GType
zeitgeist_monitor_manager_monitor_notification_type_get_type (void)
{
	static volatile gsize zeitgeist_monitor_manager_monitor_notification_type_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_monitor_notification_type_type_id__once)) {
		GType zeitgeist_monitor_manager_monitor_notification_type_type_id;
		zeitgeist_monitor_manager_monitor_notification_type_type_id = zeitgeist_monitor_manager_monitor_notification_type_get_type_once ();
		g_once_init_leave (&zeitgeist_monitor_manager_monitor_notification_type_type_id__once, zeitgeist_monitor_manager_monitor_notification_type_type_id);
	}
	return zeitgeist_monitor_manager_monitor_notification_type_type_id__once;
}

static void
_zeitgeist_monitor_manager_monitor_queued_notification_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_queued_notification_free (var), NULL));
}

static inline void
_g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _zeitgeist_monitor_manager_monitor_queued_notification_free0_);
}

static void
_zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	zeitgeist_monitor_manager_monitor_name_owner_changed ((ZeitgeistMonitorManagerMonitor*) self);
}

static void
__lambda6_ (ZeitgeistMonitorManagerMonitor* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteMonitor* _tmp0_ = NULL;
		ZeitgeistRemoteMonitor* _tmp1_;
		ZeitgeistRemoteMonitor* _tmp2_;
		ZeitgeistRemoteMonitor* _tmp3_;
		ZeitgeistRemoteMonitor* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (ZeitgeistRemoteMonitor*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (ZeitgeistRemoteMonitor*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy_object);
		self->priv->proxy_object = _tmp3_;
		zeitgeist_monitor_manager_monitor_flush_notifications (self);
		_tmp4_ = self->priv->proxy_object;
		g_signal_connect ((GObject*) _tmp4_, "notify::g-name-owner", (GCallback) _zeitgeist_monitor_manager_monitor_name_owner_changed_g_object_notify, self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("notify.vala:161: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((ZeitgeistMonitorManagerMonitor*) self, source_object, res);
	zeitgeist_monitor_manager_monitor_unref (self);
}

static ZeitgeistMonitorManagerMonitor*
zeitgeist_monitor_manager_monitor_construct (GType object_type,
                                             const char* peer,
                                             const gchar* object_path,
                                             ZeitgeistTimeRange* tr,
                                             GPtrArray* templates)
{
	ZeitgeistMonitorManagerMonitor* self = NULL;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (peer != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (tr != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	self = (ZeitgeistMonitorManagerMonitor*) g_type_create_instance (object_type);
	(self->priv->queued_notifications == NULL) ? NULL : (self->priv->queued_notifications = (_g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (self->priv->queued_notifications), NULL));
	self->priv->queued_notifications = NULL;
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY, 0, NULL, ___lambda6__gasync_ready_callback, zeitgeist_monitor_manager_monitor_ref (self), "g-flags", (G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS) | G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", (const gchar*) peer, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", object_path, "g-interface-name", "org.gnome.zeitgeist.Monitor", NULL);
	_tmp0_ = _g_object_ref0 (tr);
	_g_object_unref0 (self->priv->time_range);
	self->priv->time_range = _tmp0_;
	_tmp1_ = _g_ptr_array_ref0 (templates);
	_g_ptr_array_unref0 (self->priv->event_templates);
	self->priv->event_templates = _tmp1_;
	return self;
}

static ZeitgeistMonitorManagerMonitor*
zeitgeist_monitor_manager_monitor_new (const char* peer,
                                       const gchar* object_path,
                                       ZeitgeistTimeRange* tr,
                                       GPtrArray* templates)
{
	return zeitgeist_monitor_manager_monitor_construct (ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, peer, object_path, tr, templates);
}

static void
zeitgeist_monitor_manager_monitor_name_owner_changed (ZeitgeistMonitorManagerMonitor* self)
{
	ZeitgeistRemoteMonitor* _tmp0_;
	GDBusProxy* p = NULL;
	ZeitgeistRemoteMonitor* _tmp1_;
	GDBusProxy* _tmp2_;
	GDBusProxy* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy_object;
	_vala_return_if_fail (_tmp0_ != NULL, "proxy_object != null");
	_tmp1_ = self->priv->proxy_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_dbus_proxy_get_type ()) ? ((GDBusProxy*) _tmp1_) : NULL);
	p = _tmp2_;
	_tmp3_ = p;
	g_object_get (_tmp3_, "g-name-owner", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		zeitgeist_monitor_manager_monitor_flush_notifications (self);
	}
	_g_object_unref0 (p);
}

static void
zeitgeist_monitor_manager_monitor_flush_notifications (ZeitgeistMonitorManagerMonitor* self)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->queued_notifications = g_slist_reverse (self->priv->queued_notifications);
	_tmp0_ = self->priv->queued_notifications;
	{
		GSList* notification_collection = NULL;
		GSList* notification_it = NULL;
		notification_collection = _tmp0_;
		for (notification_it = notification_collection; notification_it != NULL; notification_it = notification_it->next) {
			ZeitgeistMonitorManagerMonitorQueuedNotification* notification = NULL;
			notification = (ZeitgeistMonitorManagerMonitorQueuedNotification*) notification_it->data;
			{
				ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp1_;
				ZeitgeistRemoteMonitor* _tmp2_;
				_tmp1_ = notification;
				_tmp2_ = self->priv->proxy_object;
				zeitgeist_monitor_manager_monitor_queued_notification_send (_tmp1_, _tmp2_);
			}
		}
	}
	(self->priv->queued_notifications == NULL) ? NULL : (self->priv->queued_notifications = (_g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (self->priv->queued_notifications), NULL));
	self->priv->queued_notifications = NULL;
}

static gboolean
zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self,
                                           ZeitgeistEvent* event)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->event_templates;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->event_templates;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->event_templates;
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) i);
				if (zeitgeist_event_matches_template (event, (ZeitgeistEvent*) _tmp9_)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self,
                                                 ZeitgeistTimeRange* time_range,
                                                 GPtrArray* events)
{
	ZeitgeistTimeRange* intersect_tr = NULL;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->time_range;
	_tmp1_ = zeitgeist_time_range_intersect (time_range, _tmp0_);
	intersect_tr = _tmp1_;
	_tmp2_ = intersect_tr;
	if (_tmp2_ != NULL) {
		GPtrArray* matching_events = NULL;
		GPtrArray* _tmp3_;
		GPtrArray* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		matching_events = _tmp3_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_;
					gint _tmp7_;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gconstpointer _tmp11_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = vala_g_ptr_array_get_length (events);
					_tmp7_ = _tmp6_;
					if (!(i < _tmp7_)) {
						break;
					}
					_tmp11_ = g_ptr_array_index (events, (guint) i);
					if (((ZeitgeistEvent*) _tmp11_) != NULL) {
						gconstpointer _tmp12_;
						_tmp12_ = g_ptr_array_index (events, (guint) i);
						_tmp10_ = zeitgeist_monitor_manager_monitor_matches (self, (ZeitgeistEvent*) _tmp12_);
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						gconstpointer _tmp13_;
						gint64 _tmp14_;
						gint64 _tmp15_;
						ZeitgeistTimeRange* _tmp16_;
						gint64 _tmp17_;
						gint64 _tmp18_;
						_tmp13_ = g_ptr_array_index (events, (guint) i);
						_tmp14_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = intersect_tr;
						_tmp17_ = zeitgeist_time_range_get_start (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp9_ = _tmp15_ >= _tmp18_;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gconstpointer _tmp19_;
						gint64 _tmp20_;
						gint64 _tmp21_;
						ZeitgeistTimeRange* _tmp22_;
						gint64 _tmp23_;
						gint64 _tmp24_;
						_tmp19_ = g_ptr_array_index (events, (guint) i);
						_tmp20_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = intersect_tr;
						_tmp23_ = zeitgeist_time_range_get_end (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp8_ = _tmp21_ <= _tmp24_;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						GPtrArray* _tmp25_;
						gconstpointer _tmp26_;
						ZeitgeistEvent* _tmp27_;
						_tmp25_ = matching_events;
						_tmp26_ = g_ptr_array_index (events, (guint) i);
						_tmp27_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp26_);
						g_ptr_array_add (_tmp25_, _tmp27_);
					}
				}
			}
		}
		_tmp28_ = matching_events;
		_tmp29_ = vala_g_ptr_array_get_length (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ > 0) {
			GVariant* time_v = NULL;
			ZeitgeistTimeRange* _tmp31_;
			GVariant* _tmp32_;
			GVariant* events_v = NULL;
			GPtrArray* _tmp33_;
			GVariant* _tmp34_;
			gchar* name_owner = NULL;
			ZeitgeistRemoteMonitor* _tmp35_;
			gboolean _tmp42_ = FALSE;
			ZeitgeistRemoteMonitor* _tmp43_;
			_tmp31_ = intersect_tr;
			_tmp32_ = zeitgeist_time_range_to_variant (_tmp31_);
			time_v = _tmp32_;
			_tmp33_ = matching_events;
			_tmp34_ = zeitgeist_events_to_variant (_tmp33_);
			events_v = _tmp34_;
			name_owner = NULL;
			_tmp35_ = self->priv->proxy_object;
			if (_tmp35_ != NULL) {
				GDBusProxy* p = NULL;
				ZeitgeistRemoteMonitor* _tmp36_;
				GDBusProxy* _tmp37_;
				GDBusProxy* _tmp38_;
				_tmp36_ = self->priv->proxy_object;
				_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, g_dbus_proxy_get_type ()) ? ((GDBusProxy*) _tmp36_) : NULL);
				p = _tmp37_;
				_tmp38_ = p;
				if (_tmp38_ != NULL) {
					GDBusProxy* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp39_ = p;
					g_object_get (_tmp39_, "g-name-owner", &_tmp40_, NULL);
					_tmp41_ = _tmp40_;
					_g_free0 (name_owner);
					name_owner = _tmp41_;
				}
				_g_object_unref0 (p);
			}
			_tmp43_ = self->priv->proxy_object;
			if (_tmp43_ != NULL) {
				const gchar* _tmp44_;
				_tmp44_ = name_owner;
				_tmp42_ = _tmp44_ != NULL;
			} else {
				_tmp42_ = FALSE;
			}
			if (_tmp42_) {
				GDBusProxy* p = NULL;
				ZeitgeistRemoteMonitor* _tmp45_;
				GDBusProxy* _tmp46_;
				GDBusProxy* _tmp47_;
				const gchar* _tmp48_;
				GPtrArray* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				ZeitgeistRemoteMonitor* _tmp52_;
				GVariant* _tmp53_;
				GVariant* _tmp54_;
				_tmp45_ = self->priv->proxy_object;
				_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, g_dbus_proxy_get_type (), GDBusProxy));
				p = _tmp46_;
				_tmp47_ = p;
				_tmp48_ = g_dbus_proxy_get_name (_tmp47_);
				_tmp49_ = matching_events;
				_tmp50_ = vala_g_ptr_array_get_length (_tmp49_);
				_tmp51_ = _tmp50_;
				g_debug ("notify.vala:234: Notifying %s about %d insertions", _tmp48_, _tmp51_);
				_tmp52_ = self->priv->proxy_object;
				_tmp53_ = time_v;
				_tmp54_ = events_v;
				zeitgeist_remote_monitor_notify_insert (_tmp52_, _tmp53_, _tmp54_, NULL, NULL);
				_g_object_unref0 (p);
			} else {
				GPtrArray* _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				GVariant* _tmp58_;
				GVariant* _tmp59_;
				ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp60_;
				_tmp55_ = matching_events;
				_tmp56_ = vala_g_ptr_array_get_length (_tmp55_);
				_tmp57_ = _tmp56_;
				g_debug ("notify.vala:241: Queueing notification about %d insertions", _tmp57_);
				_tmp58_ = time_v;
				_tmp59_ = events_v;
				_tmp60_ = zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (_tmp58_, _tmp59_);
				self->priv->queued_notifications = g_slist_prepend (self->priv->queued_notifications, _tmp60_);
			}
			_g_free0 (name_owner);
			_g_variant_unref0 (events_v);
			_g_variant_unref0 (time_v);
		}
		_g_ptr_array_unref0 (matching_events);
	}
	_g_object_unref0 (intersect_tr);
}

static void
zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self,
                                                 ZeitgeistTimeRange* time_range,
                                                 guint32* event_ids,
                                                 gint event_ids_length1)
{
	ZeitgeistTimeRange* intersect_tr = NULL;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = self->priv->time_range;
	_tmp1_ = zeitgeist_time_range_intersect (time_range, _tmp0_);
	intersect_tr = _tmp1_;
	_tmp2_ = intersect_tr;
	if (_tmp2_ != NULL) {
		GVariant* time_v = NULL;
		ZeitgeistTimeRange* _tmp3_;
		GVariant* _tmp4_;
		gchar* name_owner = NULL;
		ZeitgeistRemoteMonitor* _tmp5_;
		gboolean _tmp12_ = FALSE;
		ZeitgeistRemoteMonitor* _tmp13_;
		_tmp3_ = intersect_tr;
		_tmp4_ = zeitgeist_time_range_to_variant (_tmp3_);
		time_v = _tmp4_;
		name_owner = NULL;
		_tmp5_ = self->priv->proxy_object;
		if (_tmp5_ != NULL) {
			GDBusProxy* p = NULL;
			ZeitgeistRemoteMonitor* _tmp6_;
			GDBusProxy* _tmp7_;
			GDBusProxy* _tmp8_;
			_tmp6_ = self->priv->proxy_object;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_dbus_proxy_get_type ()) ? ((GDBusProxy*) _tmp6_) : NULL);
			p = _tmp7_;
			_tmp8_ = p;
			if (_tmp8_ != NULL) {
				GDBusProxy* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = p;
				g_object_get (_tmp9_, "g-name-owner", &_tmp10_, NULL);
				_tmp11_ = _tmp10_;
				_g_free0 (name_owner);
				name_owner = _tmp11_;
			}
			_g_object_unref0 (p);
		}
		_tmp13_ = self->priv->proxy_object;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			_tmp14_ = name_owner;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ZeitgeistRemoteMonitor* _tmp15_;
			GVariant* _tmp16_;
			_tmp15_ = self->priv->proxy_object;
			_tmp16_ = time_v;
			zeitgeist_remote_monitor_notify_delete (_tmp15_, _tmp16_, event_ids, (gint) event_ids_length1, NULL, NULL);
		} else {
			GVariant* _tmp17_;
			ZeitgeistMonitorManagerMonitorQueuedNotification* _tmp18_;
			_tmp17_ = time_v;
			_tmp18_ = zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (_tmp17_, event_ids, event_ids_length1);
			self->priv->queued_notifications = g_slist_prepend (self->priv->queued_notifications, _tmp18_);
		}
		_g_free0 (name_owner);
		_g_variant_unref0 (time_v);
	}
	_g_object_unref0 (intersect_tr);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static ZeitgeistMonitorManagerMonitorQueuedNotification*
zeitgeist_monitor_manager_monitor_queued_notification_new_insertion (GVariant* time_range,
                                                                     GVariant* events)
{
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	self->type = ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION;
	_tmp0_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (self->time_range);
	self->time_range = _tmp0_;
	_tmp1_ = _g_variant_ref0 (events);
	_g_variant_unref0 (self->events);
	self->events = _tmp1_;
	return self;
}

static guint32*
_vala_array_dup1 (guint32* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint32));
	}
	return NULL;
}

static ZeitgeistMonitorManagerMonitorQueuedNotification*
zeitgeist_monitor_manager_monitor_queued_notification_new_deletion (GVariant* time_range,
                                                                    guint32* event_ids,
                                                                    gint event_ids_length1)
{
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	GVariant* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (time_range != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	self->type = ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_DELETION;
	_tmp0_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (self->time_range);
	self->time_range = _tmp0_;
	_tmp1_ = (event_ids != NULL) ? _vala_array_dup1 (event_ids, event_ids_length1) : event_ids;
	_tmp1__length1 = event_ids_length1;
	self->event_ids = (g_free (self->event_ids), NULL);
	self->event_ids = _tmp1_;
	self->event_ids_length1 = _tmp1__length1;
	self->_event_ids_size_ = self->event_ids_length1;
	return self;
}

static void
zeitgeist_monitor_manager_monitor_queued_notification_send (ZeitgeistMonitorManagerMonitorQueuedNotification* self,
                                                            ZeitgeistRemoteMonitor* proxy_object)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy_object != NULL);
	if (self->type == ZEITGEIST_MONITOR_MANAGER_MONITOR_NOTIFICATION_TYPE_INSERTION) {
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = self->time_range;
		_tmp1_ = self->events;
		zeitgeist_remote_monitor_notify_insert (proxy_object, _tmp0_, _tmp1_, NULL, NULL);
	} else {
		GVariant* _tmp2_;
		guint32* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = self->time_range;
		_tmp3_ = self->event_ids;
		_tmp3__length1 = self->event_ids_length1;
		zeitgeist_remote_monitor_notify_delete (proxy_object, _tmp2_, _tmp3_, (gint) _tmp3__length1, NULL, NULL);
	}
}

static ZeitgeistMonitorManagerMonitorQueuedNotification*
zeitgeist_monitor_manager_monitor_queued_notification_new (void)
{
	ZeitgeistMonitorManagerMonitorQueuedNotification* self;
	self = g_slice_new0 (ZeitgeistMonitorManagerMonitorQueuedNotification);
	zeitgeist_monitor_manager_monitor_queued_notification_instance_init (self);
	return self;
}

static void
zeitgeist_monitor_manager_monitor_queued_notification_instance_init (ZeitgeistMonitorManagerMonitorQueuedNotification * self)
{
}

static void
zeitgeist_monitor_manager_monitor_queued_notification_free (ZeitgeistMonitorManagerMonitorQueuedNotification * self)
{
	_g_variant_unref0 (self->time_range);
	_g_variant_unref0 (self->events);
	self->event_ids = (g_free (self->event_ids), NULL);
	g_slice_free (ZeitgeistMonitorManagerMonitorQueuedNotification, self);
}

static void
zeitgeist_monitor_manager_value_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
zeitgeist_monitor_manager_value_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		zeitgeist_monitor_manager_monitor_unref (value->data[0].v_pointer);
	}
}

static void
zeitgeist_monitor_manager_value_monitor_copy_value (const GValue* src_value,
                                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
zeitgeist_monitor_manager_value_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
zeitgeist_monitor_manager_value_monitor_collect_value (GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ZeitgeistMonitorManagerMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
zeitgeist_monitor_manager_value_monitor_lcopy_value (const GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	ZeitgeistMonitorManagerMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
zeitgeist_monitor_manager_param_spec_monitor (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags)
{
	ZeitgeistMonitorManagerParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
zeitgeist_monitor_manager_value_get_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}

static void
zeitgeist_monitor_manager_value_set_monitor (GValue* value,
                                             gpointer v_object)
{
	ZeitgeistMonitorManagerMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}

static void
zeitgeist_monitor_manager_value_take_monitor (GValue* value,
                                              gpointer v_object)
{
	ZeitgeistMonitorManagerMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}

static void
zeitgeist_monitor_manager_monitor_class_init (ZeitgeistMonitorManagerMonitorClass * klass,
                                              gpointer klass_data)
{
	zeitgeist_monitor_manager_monitor_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistMonitorManagerMonitorClass *) klass)->finalize = zeitgeist_monitor_manager_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &ZeitgeistMonitorManagerMonitor_private_offset);
}

static void
zeitgeist_monitor_manager_monitor_instance_init (ZeitgeistMonitorManagerMonitor * self,
                                                 gpointer klass)
{
	self->priv = zeitgeist_monitor_manager_monitor_get_instance_private (self);
	self->priv->proxy_object = NULL;
	self->ref_count = 1;
}

static void
zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor * obj)
{
	ZeitgeistMonitorManagerMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitor);
	g_signal_handlers_destroy (self);
	_g_ptr_array_unref0 (self->priv->event_templates);
	_g_object_unref0 (self->priv->time_range);
	_g_object_unref0 (self->priv->proxy_object);
	(self->priv->queued_notifications == NULL) ? NULL : (self->priv->queued_notifications = (_g_slist_free__zeitgeist_monitor_manager_monitor_queued_notification_free0_ (self->priv->queued_notifications), NULL));
}

static GType
zeitgeist_monitor_manager_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { zeitgeist_monitor_manager_value_monitor_init, zeitgeist_monitor_manager_value_monitor_free_value, zeitgeist_monitor_manager_value_monitor_copy_value, zeitgeist_monitor_manager_value_monitor_peek_pointer, "p", zeitgeist_monitor_manager_value_monitor_collect_value, "p", zeitgeist_monitor_manager_value_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManagerMonitor), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType zeitgeist_monitor_manager_monitor_type_id;
	zeitgeist_monitor_manager_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistMonitorManagerMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ZeitgeistMonitorManagerMonitor_private_offset = g_type_add_instance_private (zeitgeist_monitor_manager_monitor_type_id, sizeof (ZeitgeistMonitorManagerMonitorPrivate));
	return zeitgeist_monitor_manager_monitor_type_id;
}

static GType
zeitgeist_monitor_manager_monitor_get_type (void)
{
	static volatile gsize zeitgeist_monitor_manager_monitor_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_monitor_type_id__once)) {
		GType zeitgeist_monitor_manager_monitor_type_id;
		zeitgeist_monitor_manager_monitor_type_id = zeitgeist_monitor_manager_monitor_get_type_once ();
		g_once_init_leave (&zeitgeist_monitor_manager_monitor_type_id__once, zeitgeist_monitor_manager_monitor_type_id);
	}
	return zeitgeist_monitor_manager_monitor_type_id__once;
}

static gpointer
zeitgeist_monitor_manager_monitor_ref (gpointer instance)
{
	ZeitgeistMonitorManagerMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
zeitgeist_monitor_manager_monitor_unref (gpointer instance)
{
	ZeitgeistMonitorManagerMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_zeitgeist_monitor_manager_monitor_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL));
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

static void
_zeitgeist_monitor_manager____lambda7_ (ZeitgeistMonitorManager* self,
                                        GDBusConnection* conn,
                                        const gchar* sender,
                                        const gchar* path,
                                        const gchar* ifc_name,
                                        const gchar* sig_name,
                                        GVariant* parameters)
{
	gchar* arg0 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* arg1 = NULL;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* arg2 = NULL;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	GHashTable* _tmp13_;
	GList* _tmp14_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (ifc_name != NULL);
	g_return_if_fail (sig_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_dup_string (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_variant_unref0 (_tmp1_);
	arg0 = _tmp3_;
	_tmp4_ = g_variant_get_child_value (parameters, (gsize) 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_dup_string (_tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	arg1 = _tmp7_;
	_tmp8_ = g_variant_get_child_value (parameters, (gsize) 2);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_dup_string (_tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_variant_unref0 (_tmp9_);
	arg2 = _tmp11_;
	_tmp12_ = arg2;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		_g_free0 (arg2);
		_g_free0 (arg1);
		_g_free0 (arg0);
		return;
	}
	_tmp13_ = self->priv->connections;
	_tmp14_ = g_hash_table_get_keys (_tmp13_);
	{
		GList* owner_collection = NULL;
		GList* owner_it = NULL;
		owner_collection = _tmp14_;
		for (owner_it = owner_collection; owner_it != NULL; owner_it = owner_it->next) {
			const gchar* owner = NULL;
			owner = (const gchar*) owner_it->data;
			{
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = arg0;
				_tmp17_ = owner;
				if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
					const gchar* _tmp18_;
					_tmp18_ = arg0;
					_tmp15_ = g_dbus_is_unique_name (_tmp18_);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					GPtrArray* paths = NULL;
					GHashTable* _tmp19_;
					const gchar* _tmp20_;
					gconstpointer _tmp21_;
					GPtrArray* _tmp22_;
					const gchar* _tmp23_;
					GHashTable* _tmp32_;
					const gchar* _tmp33_;
					_tmp19_ = self->priv->connections;
					_tmp20_ = arg0;
					_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
					_tmp22_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp21_);
					paths = _tmp22_;
					_tmp23_ = owner;
					g_debug ("notify.vala:81: Client disconnected %s", _tmp23_);
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp24_ = FALSE;
							_tmp24_ = TRUE;
							while (TRUE) {
								GPtrArray* _tmp26_;
								gint _tmp27_;
								gint _tmp28_;
								const gchar* _tmp29_;
								GPtrArray* _tmp30_;
								gconstpointer _tmp31_;
								if (!_tmp24_) {
									gint _tmp25_;
									_tmp25_ = i;
									i = _tmp25_ + 1;
								}
								_tmp24_ = FALSE;
								_tmp26_ = paths;
								_tmp27_ = vala_g_ptr_array_get_length (_tmp26_);
								_tmp28_ = _tmp27_;
								if (!(i < _tmp28_)) {
									break;
								}
								_tmp29_ = arg0;
								_tmp30_ = paths;
								_tmp31_ = g_ptr_array_index (_tmp30_, (guint) i);
								zeitgeist_monitor_manager_remove_monitor (self, (const char*) _tmp29_, (const gchar*) _tmp31_);
							}
						}
					}
					_tmp32_ = self->priv->connections;
					_tmp33_ = arg0;
					g_hash_table_remove (_tmp32_, _tmp33_);
					_g_ptr_array_unref0 (paths);
				}
			}
		}
		(owner_collection == NULL) ? NULL : (owner_collection = (g_list_free (owner_collection), NULL));
	}
	_g_free0 (arg2);
	_g_free0 (arg1);
	_g_free0 (arg0);
}

static void
__zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback (GDBusConnection* connection,
                                                                const gchar* sender_name,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* signal_name,
                                                                GVariant* parameters,
                                                                gpointer self)
{
	_zeitgeist_monitor_manager____lambda7_ ((ZeitgeistMonitorManager*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static GObject *
zeitgeist_monitor_manager_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistMonitorManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager);
	zeitgeist_monitor_manager_instance = self;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _zeitgeist_monitor_manager_monitor_unref0_);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->connections);
	self->priv->connections = _tmp5_;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp6_;
		GDBusConnection* _tmp7_;
		_tmp6_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp7_ = connection;
		g_dbus_connection_signal_subscribe (_tmp7_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, __zeitgeist_monitor_manager____lambda7__gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("notify.vala:91: Cannot subscribe to NameOwnerChanged signal! %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
zeitgeist_monitor_manager_class_init (ZeitgeistMonitorManagerClass * klass,
                                      gpointer klass_data)
{
	zeitgeist_monitor_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistMonitorManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_monitor_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_monitor_manager_finalize;
}

static void
zeitgeist_monitor_manager_instance_init (ZeitgeistMonitorManager * self,
                                         gpointer klass)
{
	self->priv = zeitgeist_monitor_manager_get_instance_private (self);
}

static void
zeitgeist_monitor_manager_finalize (GObject * obj)
{
	ZeitgeistMonitorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager);
	zeitgeist_monitor_manager_instance = NULL;
	_g_hash_table_unref0 (self->priv->monitors);
	_g_hash_table_unref0 (self->priv->connections);
	G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class)->finalize (obj);
}

static GType
zeitgeist_monitor_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManager), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_instance_init, NULL };
	GType zeitgeist_monitor_manager_type_id;
	zeitgeist_monitor_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistMonitorManager", &g_define_type_info, 0);
	ZeitgeistMonitorManager_private_offset = g_type_add_instance_private (zeitgeist_monitor_manager_type_id, sizeof (ZeitgeistMonitorManagerPrivate));
	return zeitgeist_monitor_manager_type_id;
}

GType
zeitgeist_monitor_manager_get_type (void)
{
	static volatile gsize zeitgeist_monitor_manager_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_type_id__once)) {
		GType zeitgeist_monitor_manager_type_id;
		zeitgeist_monitor_manager_type_id = zeitgeist_monitor_manager_get_type_once ();
		g_once_init_leave (&zeitgeist_monitor_manager_type_id__once, zeitgeist_monitor_manager_type_id);
	}
	return zeitgeist_monitor_manager_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

