/* ext-blacklist.c generated by valac 0.56.16, the Vala compiler
 * generated from ext-blacklist.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Manish Sinha <manishsinha@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist-engine.h"

#define ZEITGEIST_BLACKLIST_TEMPLATES_SIG_BLACKLIST "a{s(" ZEITGEIST_UTILS_SIG_EVENT ")}"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_BLACKLIST (zeitgeist_remote_blacklist_get_type ())
#define ZEITGEIST_REMOTE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_BLACKLIST, ZeitgeistRemoteBlacklist))
#define ZEITGEIST_IS_REMOTE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_BLACKLIST))
#define ZEITGEIST_REMOTE_BLACKLIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_BLACKLIST, ZeitgeistRemoteBlacklistIface))

typedef struct _ZeitgeistRemoteBlacklist ZeitgeistRemoteBlacklist;
typedef struct _ZeitgeistRemoteBlacklistIface ZeitgeistRemoteBlacklistIface;

#define ZEITGEIST_TYPE_REMOTE_BLACKLIST_PROXY (zeitgeist_remote_blacklist_proxy_get_type ())
enum  {
	ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_ADDED_SIGNAL,
	ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_REMOVED_SIGNAL,
	ZEITGEIST_REMOTE_BLACKLIST_NUM_SIGNALS
};
static guint zeitgeist_remote_blacklist_signals[ZEITGEIST_REMOTE_BLACKLIST_NUM_SIGNALS] = {0};
typedef GDBusProxy ZeitgeistRemoteBlacklistProxy;
typedef GDBusProxyClass ZeitgeistRemoteBlacklistProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define ZEITGEIST_TYPE_BLACKLIST (zeitgeist_blacklist_get_type ())
#define ZEITGEIST_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_BLACKLIST, ZeitgeistBlacklist))
#define ZEITGEIST_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_BLACKLIST, ZeitgeistBlacklistClass))
#define ZEITGEIST_IS_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_BLACKLIST))
#define ZEITGEIST_IS_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_BLACKLIST))
#define ZEITGEIST_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_BLACKLIST, ZeitgeistBlacklistClass))

typedef struct _ZeitgeistBlacklist ZeitgeistBlacklist;
typedef struct _ZeitgeistBlacklistClass ZeitgeistBlacklistClass;
typedef struct _ZeitgeistBlacklistPrivate ZeitgeistBlacklistPrivate;
enum  {
	ZEITGEIST_BLACKLIST_0_PROPERTY,
	ZEITGEIST_BLACKLIST_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_blacklist_properties[ZEITGEIST_BLACKLIST_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ZeitgeistRemoteBlacklistIface {
	GTypeInterface parent_iface;
	void (*add_template) (ZeitgeistRemoteBlacklist* self, const gchar* template_id, GVariant* event_template, GError** error);
	GVariant* (*get_templates) (ZeitgeistRemoteBlacklist* self, GError** error);
	void (*remove_template) (ZeitgeistRemoteBlacklist* self, const gchar* template_id, GError** error);
};

struct _ZeitgeistBlacklist {
	ZeitgeistExtension parent_instance;
	ZeitgeistBlacklistPrivate * priv;
};

struct _ZeitgeistBlacklistClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistBlacklistPrivate {
	GHashTable* blacklist;
	guint registration_id;
};

static GType zeitgeist_remote_blacklist_type_id = 0;
static gint ZeitgeistBlacklist_private_offset;
static gpointer zeitgeist_blacklist_parent_class = NULL;
static ZeitgeistRemoteBlacklistIface * zeitgeist_blacklist_zeitgeist_remote_blacklist_parent_iface = NULL;
static GType zeitgeist_blacklist_type_id = 0;

VALA_EXTERN GType zeitgeist_remote_blacklist_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void zeitgeist_remote_blacklist_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint zeitgeist_remote_blacklist_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
GType zeitgeist_remote_blacklist_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_remote_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteBlacklist, g_object_unref)
VALA_EXTERN void zeitgeist_remote_blacklist_add_template (ZeitgeistRemoteBlacklist* self,
                                              const gchar* template_id,
                                              GVariant* event_template,
                                              GError** error);
VALA_EXTERN GVariant* zeitgeist_remote_blacklist_get_templates (ZeitgeistRemoteBlacklist* self,
                                                    GError** error);
VALA_EXTERN void zeitgeist_remote_blacklist_remove_template (ZeitgeistRemoteBlacklist* self,
                                                 const gchar* template_id,
                                                 GError** error);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void zeitgeist_remote_blacklist_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_blacklist_template_added (ZeitgeistRemoteBlacklist* self,
                                                             GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_blacklist_template_removed (ZeitgeistRemoteBlacklist* self,
                                                               GVariant* parameters);
static void zeitgeist_remote_blacklist_proxy_add_template (ZeitgeistRemoteBlacklist* self,
                                                    const gchar* template_id,
                                                    GVariant* event_template,
                                                    GError** error);
static GVariant* zeitgeist_remote_blacklist_proxy_get_templates (ZeitgeistRemoteBlacklist* self,
                                                          GError** error);
static void zeitgeist_remote_blacklist_proxy_remove_template (ZeitgeistRemoteBlacklist* self,
                                                       const gchar* template_id,
                                                       GError** error);
static void zeitgeist_remote_blacklist_proxy_zeitgeist_remote_blacklist_interface_init (ZeitgeistRemoteBlacklistIface* iface);
static void _dbus_zeitgeist_remote_blacklist_add_template (ZeitgeistRemoteBlacklist* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_blacklist_get_templates (ZeitgeistRemoteBlacklist* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_blacklist_remove_template (ZeitgeistRemoteBlacklist* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void zeitgeist_remote_blacklist_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* zeitgeist_remote_blacklist_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean zeitgeist_remote_blacklist_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _dbus_zeitgeist_remote_blacklist_template_added (GObject* _sender,
                                                      const gchar* template_id,
                                                      GVariant* event_template,
                                                      gpointer* _data);
static void _dbus_zeitgeist_remote_blacklist_template_removed (GObject* _sender,
                                                        const gchar* template_id,
                                                        GVariant* event_template,
                                                        gpointer* _data);
static void _zeitgeist_remote_blacklist_unregister_object (gpointer user_data);
VALA_EXTERN GHashTable* zeitgeist_blacklist_templates_from_variant (GVariant* templates_variant,
                                                        GError** error);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GVariant* zeitgeist_blacklist_templates_to_variant (GHashTable* blacklist);
GType zeitgeist_blacklist_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistBlacklist, g_object_unref)
static ZeitgeistBlacklist* zeitgeist_blacklist_new (void);
static ZeitgeistBlacklist* zeitgeist_blacklist_construct (GType object_type);
static void zeitgeist_blacklist_real_unload (ZeitgeistExtension* base);
static void zeitgeist_blacklist_flush (ZeitgeistBlacklist* self);
static void zeitgeist_blacklist_real_pre_insert_events (ZeitgeistExtension* base,
                                                 GPtrArray* events,
                                                 const char* sender);
static void zeitgeist_blacklist_real_add_template (ZeitgeistRemoteBlacklist* base,
                                            const gchar* template_id,
                                            GVariant* event_template,
                                            GError** error);
static void zeitgeist_blacklist_real_remove_template (ZeitgeistRemoteBlacklist* base,
                                               const gchar* template_id,
                                               GError** error);
static GVariant* zeitgeist_blacklist_real_get_templates (ZeitgeistRemoteBlacklist* base,
                                                  GError** error);
static GObject * zeitgeist_blacklist_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void zeitgeist_blacklist_finalize (GObject * obj);
VALA_EXTERN GType zeitgeist_blacklist_init (GTypeModule* module);

static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_add_template_template_id = {-1, "template_id", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_add_template_event_template = {-1, "event_template", "(asaasay)", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_add_template_in[] = {&_zeitgeist_remote_blacklist_dbus_arg_info_add_template_template_id, &_zeitgeist_remote_blacklist_dbus_arg_info_add_template_event_template, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_add_template_out[] = {NULL};
static const GDBusMethodInfo _zeitgeist_remote_blacklist_dbus_method_info_add_template = {-1, "AddTemplate", (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_add_template_in), (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_add_template_out), NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_get_templates_result = {-1, "result", "a{s(asaasay)}", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_get_templates_in[] = {NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_get_templates_out[] = {&_zeitgeist_remote_blacklist_dbus_arg_info_get_templates_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_blacklist_dbus_method_info_get_templates = {-1, "GetTemplates", (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_get_templates_in), (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_get_templates_out), NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_remove_template_template_id = {-1, "template_id", "s", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_remove_template_in[] = {&_zeitgeist_remote_blacklist_dbus_arg_info_remove_template_template_id, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_remove_template_out[] = {NULL};
static const GDBusMethodInfo _zeitgeist_remote_blacklist_dbus_method_info_remove_template = {-1, "RemoveTemplate", (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_remove_template_in), (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_remove_template_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_blacklist_dbus_method_info[] = {&_zeitgeist_remote_blacklist_dbus_method_info_add_template, &_zeitgeist_remote_blacklist_dbus_method_info_get_templates, &_zeitgeist_remote_blacklist_dbus_method_info_remove_template, NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_template_added_template_id = {-1, "template_id", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_template_added_event_template = {-1, "event_template", "(asaasay)", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_template_added[] = {&_zeitgeist_remote_blacklist_dbus_arg_info_template_added_template_id, &_zeitgeist_remote_blacklist_dbus_arg_info_template_added_event_template, NULL};
static const GDBusSignalInfo _zeitgeist_remote_blacklist_dbus_signal_info_template_added = {-1, "TemplateAdded", (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_template_added), NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_template_removed_template_id = {-1, "template_id", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_blacklist_dbus_arg_info_template_removed_event_template = {-1, "event_template", "(asassay)", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_blacklist_dbus_arg_info_template_removed[] = {&_zeitgeist_remote_blacklist_dbus_arg_info_template_removed_template_id, &_zeitgeist_remote_blacklist_dbus_arg_info_template_removed_event_template, NULL};
static const GDBusSignalInfo _zeitgeist_remote_blacklist_dbus_signal_info_template_removed = {-1, "TemplateRemoved", (GDBusArgInfo **) (&_zeitgeist_remote_blacklist_dbus_arg_info_template_removed), NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_blacklist_dbus_signal_info[] = {&_zeitgeist_remote_blacklist_dbus_signal_info_template_added, &_zeitgeist_remote_blacklist_dbus_signal_info_template_removed, NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_blacklist_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_blacklist_dbus_interface_info = {-1, "org.gnome.zeitgeist.Blacklist", (GDBusMethodInfo **) (&_zeitgeist_remote_blacklist_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_blacklist_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_blacklist_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_blacklist_dbus_interface_vtable = {zeitgeist_remote_blacklist_dbus_interface_method_call, zeitgeist_remote_blacklist_dbus_interface_get_property, zeitgeist_remote_blacklist_dbus_interface_set_property};

void
zeitgeist_remote_blacklist_add_template (ZeitgeistRemoteBlacklist* self,
                                         const gchar* template_id,
                                         GVariant* event_template,
                                         GError** error)
{
	ZeitgeistRemoteBlacklistIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ZEITGEIST_REMOTE_BLACKLIST_GET_INTERFACE (self);
	if (_iface_->add_template) {
		_iface_->add_template (self, template_id, event_template, error);
	}
}

GVariant*
zeitgeist_remote_blacklist_get_templates (ZeitgeistRemoteBlacklist* self,
                                          GError** error)
{
	ZeitgeistRemoteBlacklistIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ZEITGEIST_REMOTE_BLACKLIST_GET_INTERFACE (self);
	if (_iface_->get_templates) {
		return _iface_->get_templates (self, error);
	}
	return NULL;
}

void
zeitgeist_remote_blacklist_remove_template (ZeitgeistRemoteBlacklist* self,
                                            const gchar* template_id,
                                            GError** error)
{
	ZeitgeistRemoteBlacklistIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ZEITGEIST_REMOTE_BLACKLIST_GET_INTERFACE (self);
	if (_iface_->remove_template) {
		_iface_->remove_template (self, template_id, error);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static void
zeitgeist_remote_blacklist_default_init (ZeitgeistRemoteBlacklistIface * iface,
                                         gpointer iface_data)
{
	zeitgeist_remote_blacklist_signals[ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_ADDED_SIGNAL] = g_signal_new ("template-added", ZEITGEIST_TYPE_REMOTE_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
	zeitgeist_remote_blacklist_signals[ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_REMOVED_SIGNAL] = g_signal_new ("template-removed", ZEITGEIST_TYPE_REMOTE_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
}

GType
zeitgeist_remote_blacklist_get_type (void)
{
	return zeitgeist_remote_blacklist_type_id;
}

GType
zeitgeist_remote_blacklist_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteBlacklistIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_blacklist_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_blacklist_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteBlacklist", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_blacklist_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_blacklist_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_blacklist_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_blacklist_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Blacklist");
	g_type_set_qdata (zeitgeist_remote_blacklist_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_blacklist_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_blacklist_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_blacklist_register_object);
	return zeitgeist_remote_blacklist_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteBlacklistProxy, zeitgeist_remote_blacklist_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_BLACKLIST, zeitgeist_remote_blacklist_proxy_zeitgeist_remote_blacklist_interface_init) )
static void
zeitgeist_remote_blacklist_proxy_class_init (ZeitgeistRemoteBlacklistProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_blacklist_proxy_g_signal;
}

static void
_dbus_handle_zeitgeist_remote_blacklist_template_added (ZeitgeistRemoteBlacklist* self,
                                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* template_id = NULL;
	GVariant* _tmp0_;
	GVariant* event_template = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	template_id = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	event_template = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "template-added", template_id, event_template);
	_g_free0 (template_id);
	_g_variant_unref0 (event_template);
}

static void
_dbus_handle_zeitgeist_remote_blacklist_template_removed (ZeitgeistRemoteBlacklist* self,
                                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* template_id = NULL;
	GVariant* _tmp1_;
	GVariant* event_template = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	template_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	event_template = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "template-removed", template_id, event_template);
	_g_free0 (template_id);
	_g_variant_unref0 (event_template);
}

static void
zeitgeist_remote_blacklist_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters)
{
	if (strcmp (signal_name, "TemplateAdded") == 0) {
		_dbus_handle_zeitgeist_remote_blacklist_template_added ((ZeitgeistRemoteBlacklist*) proxy, parameters);
	} else if (strcmp (signal_name, "TemplateRemoved") == 0) {
		_dbus_handle_zeitgeist_remote_blacklist_template_removed ((ZeitgeistRemoteBlacklist*) proxy, parameters);
	}
}

static void
zeitgeist_remote_blacklist_proxy_class_finalize (ZeitgeistRemoteBlacklistProxyClass* klass)
{
}

void
zeitgeist_remote_blacklist_proxy_register_dynamic_type (GTypeModule* module)
{
	zeitgeist_remote_blacklist_proxy_register_type (module);
}

static void
zeitgeist_remote_blacklist_proxy_init (ZeitgeistRemoteBlacklistProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_blacklist_dbus_interface_info));
}

static void
zeitgeist_remote_blacklist_proxy_add_template (ZeitgeistRemoteBlacklist* self,
                                               const gchar* template_id,
                                               GVariant* event_template,
                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "AddTemplate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (template_id));
	g_variant_builder_add_value (&_arguments_builder, event_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static GVariant*
zeitgeist_remote_blacklist_proxy_get_templates (ZeitgeistRemoteBlacklist* self,
                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "GetTemplates");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}

static void
zeitgeist_remote_blacklist_proxy_remove_template (ZeitgeistRemoteBlacklist* self,
                                                  const gchar* template_id,
                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Blacklist", "RemoveTemplate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (template_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
zeitgeist_remote_blacklist_proxy_zeitgeist_remote_blacklist_interface_init (ZeitgeistRemoteBlacklistIface* iface)
{
	iface->add_template = zeitgeist_remote_blacklist_proxy_add_template;
	iface->get_templates = zeitgeist_remote_blacklist_proxy_get_templates;
	iface->remove_template = zeitgeist_remote_blacklist_proxy_remove_template;
}

static void
_dbus_zeitgeist_remote_blacklist_add_template (ZeitgeistRemoteBlacklist* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* template_id = NULL;
	GVariant* _tmp2_;
	GVariant* event_template = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	template_id = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	event_template = g_variant_iter_next_value (&_arguments_iter);
	zeitgeist_remote_blacklist_add_template (self, template_id, event_template, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (template_id);
	_g_variant_unref0 (event_template);
	;
}

static void
_dbus_zeitgeist_remote_blacklist_get_templates (ZeitgeistRemoteBlacklist* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = zeitgeist_remote_blacklist_get_templates (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_zeitgeist_remote_blacklist_remove_template (ZeitgeistRemoteBlacklist* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* template_id = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	template_id = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	zeitgeist_remote_blacklist_remove_template (self, template_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (template_id);
	;
}

static void
zeitgeist_remote_blacklist_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddTemplate") == 0) {
		_dbus_zeitgeist_remote_blacklist_add_template (object, parameters, invocation);
	} else if (strcmp (method_name, "GetTemplates") == 0) {
		_dbus_zeitgeist_remote_blacklist_get_templates (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveTemplate") == 0) {
		_dbus_zeitgeist_remote_blacklist_remove_template (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_blacklist_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_blacklist_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_zeitgeist_remote_blacklist_template_added (GObject* _sender,
                                                 const gchar* template_id,
                                                 GVariant* event_template,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (template_id));
	g_variant_builder_add_value (&_arguments_builder, event_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.Blacklist", "TemplateAdded", _arguments, NULL);
}

static void
_dbus_zeitgeist_remote_blacklist_template_removed (GObject* _sender,
                                                   const gchar* template_id,
                                                   GVariant* event_template,
                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (template_id));
	g_variant_builder_add_value (&_arguments_builder, event_template);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.Blacklist", "TemplateRemoved", _arguments, NULL);
}

guint
zeitgeist_remote_blacklist_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_blacklist_dbus_interface_info), &_zeitgeist_remote_blacklist_dbus_interface_vtable, data, _zeitgeist_remote_blacklist_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "template-added", (GCallback) _dbus_zeitgeist_remote_blacklist_template_added, data);
	g_signal_connect (object, "template-removed", (GCallback) _dbus_zeitgeist_remote_blacklist_template_removed, data);
	return result;
}

static void
_zeitgeist_remote_blacklist_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_blacklist_template_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_blacklist_template_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GHashTable*
zeitgeist_blacklist_templates_from_variant (GVariant* templates_variant,
                                            GError** error)
{
	GHashTable* blacklist = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	GHashTable* result;
	g_return_val_if_fail (templates_variant != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	blacklist = _tmp2_;
	_tmp3_ = g_variant_get_type_string (templates_variant);
	g_warn_if_fail (g_strcmp0 (_tmp3_, ZEITGEIST_BLACKLIST_TEMPLATES_SIG_BLACKLIST) == 0);
	{
		GVariantIter* _template_variant_it = NULL;
		GVariantIter* _tmp4_;
		GVariant* template_variant = NULL;
		_tmp4_ = g_variant_iter_new (templates_variant);
		_template_variant_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			GVariantIter* iter = NULL;
			GVariant* _tmp8_;
			GVariantIter* _tmp9_;
			gchar* template_id = NULL;
			GVariantIter* _tmp10_;
			GVariant* _tmp11_;
			GVariant* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			ZeitgeistEvent* template = NULL;
			GVariantIter* _tmp16_;
			GVariant* _tmp17_;
			GVariant* _tmp18_;
			ZeitgeistEvent* _tmp19_;
			ZeitgeistEvent* _tmp20_;
			GHashTable* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			ZeitgeistEvent* _tmp24_;
			ZeitgeistEvent* _tmp25_;
			_tmp5_ = _template_variant_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (template_variant);
			template_variant = _tmp6_;
			_tmp7_ = template_variant;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = template_variant;
			_tmp9_ = g_variant_iter_new (_tmp8_);
			iter = _tmp9_;
			_tmp10_ = iter;
			_tmp11_ = g_variant_iter_next_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_variant_get_string (_tmp12_, NULL);
			_tmp14_ = g_strdup (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_variant_unref0 (_tmp12_);
			template_id = _tmp15_;
			_tmp16_ = iter;
			_tmp17_ = g_variant_iter_next_value (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = zeitgeist_event_new_from_variant (_tmp18_, &_inner_error0_);
			_tmp20_ = _tmp19_;
			_g_variant_unref0 (_tmp18_);
			template = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (template_id);
					_g_variant_iter_free0 (iter);
					_g_variant_unref0 (template_variant);
					_g_variant_iter_free0 (_template_variant_it);
					_g_hash_table_unref0 (blacklist);
					return NULL;
				} else {
					_g_free0 (template_id);
					_g_variant_iter_free0 (iter);
					_g_variant_unref0 (template_variant);
					_g_variant_iter_free0 (_template_variant_it);
					_g_hash_table_unref0 (blacklist);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp21_ = blacklist;
			_tmp22_ = template_id;
			_tmp23_ = g_strdup (_tmp22_);
			_tmp24_ = template;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			g_hash_table_insert (_tmp21_, _tmp23_, _tmp25_);
			_g_object_unref0 (template);
			_g_free0 (template_id);
			_g_variant_iter_free0 (iter);
		}
		_g_variant_unref0 (template_variant);
		_g_variant_iter_free0 (_template_variant_it);
	}
	result = blacklist;
	return result;
}

GVariant*
zeitgeist_blacklist_templates_to_variant (GHashTable* blacklist)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp19_;
	GVariant* _tmp20_;
	GVariant* result;
	g_return_val_if_fail (blacklist != NULL, NULL);
	_tmp0_ = g_variant_type_new (ZEITGEIST_BLACKLIST_TEMPLATES_SIG_BLACKLIST);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	{
		GHashTableIter iter = {0};
		gchar* template_id = NULL;
		ZeitgeistEvent* event_template = NULL;
		g_hash_table_iter_init (&iter, blacklist);
		while (TRUE) {
			gconstpointer _tmp4_ = NULL;
			gconstpointer _tmp5_ = NULL;
			gboolean _tmp6_;
			gchar* _tmp7_;
			ZeitgeistEvent* _tmp8_;
			GVariantBuilder* _tmp9_;
			GVariantType* _tmp10_;
			GVariantType* _tmp11_;
			GVariantBuilder* _tmp12_;
			const gchar* _tmp13_;
			GVariantBuilder* _tmp14_;
			ZeitgeistEvent* _tmp15_;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			GVariantBuilder* _tmp18_;
			_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
			_g_free0 (template_id);
			_tmp7_ = g_strdup ((const gchar*) _tmp4_);
			template_id = _tmp7_;
			_g_object_unref0 (event_template);
			_tmp8_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp5_);
			event_template = _tmp8_;
			if (!_tmp6_) {
				break;
			}
			_tmp9_ = vb;
			_tmp10_ = g_variant_type_new ("{s(" ZEITGEIST_UTILS_SIG_EVENT ")}");
			_tmp11_ = _tmp10_;
			g_variant_builder_open (_tmp9_, _tmp11_);
			_g_variant_type_free0 (_tmp11_);
			_tmp12_ = vb;
			_tmp13_ = template_id;
			g_variant_builder_add (_tmp12_, "s", _tmp13_, NULL);
			_tmp14_ = vb;
			_tmp15_ = event_template;
			_tmp16_ = zeitgeist_event_to_variant (_tmp15_);
			_tmp17_ = _tmp16_;
			g_variant_builder_add_value (_tmp14_, _tmp17_);
			_g_variant_unref0 (_tmp17_);
			_tmp18_ = vb;
			g_variant_builder_close (_tmp18_);
		}
		_g_object_unref0 (event_template);
		_g_free0 (template_id);
	}
	_tmp19_ = vb;
	_tmp20_ = g_variant_builder_end (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	result = _tmp20_;
	_g_variant_builder_unref0 (vb);
	return result;
}

static inline gpointer
zeitgeist_blacklist_get_instance_private (ZeitgeistBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistBlacklist_private_offset);
}

static ZeitgeistBlacklist*
zeitgeist_blacklist_construct (GType object_type)
{
	ZeitgeistBlacklist * self = NULL;
	self = (ZeitgeistBlacklist*) g_object_new (object_type, NULL);
	return self;
}

static ZeitgeistBlacklist*
zeitgeist_blacklist_new (void)
{
	return zeitgeist_blacklist_construct (ZEITGEIST_TYPE_BLACKLIST);
}

static void
zeitgeist_blacklist_real_unload (ZeitgeistExtension* base)
{
	ZeitgeistBlacklist * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistBlacklist*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (self->priv->registration_id != ((guint) 0)) {
			g_dbus_connection_unregister_object (connection, self->priv->registration_id);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("ext-blacklist.vala:145: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("ext-blacklist.vala:148: %s, this.ref_count = %u", "Zeitgeist.Blacklist.unload", ((GObject*) self)->ref_count);
}

static void
zeitgeist_blacklist_flush (ZeitgeistBlacklist* self)
{
	GVariant* v = NULL;
	GHashTable* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blacklist;
	_tmp1_ = zeitgeist_blacklist_templates_to_variant (_tmp0_);
	v = _tmp1_;
	zeitgeist_extension_store_config ((ZeitgeistExtension*) self, "blacklist", v);
	_g_variant_unref0 (v);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
g_ptr_array_set (GPtrArray* self,
                 guint index,
                 gpointer data)
{
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}

static void
zeitgeist_blacklist_real_pre_insert_events (ZeitgeistExtension* base,
                                            GPtrArray* events,
                                            const char* sender)
{
	ZeitgeistBlacklist * self;
	self = (ZeitgeistBlacklist*) base;
	g_return_if_fail (events != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gconstpointer _tmp4_;
				GHashTable* _tmp5_;
				GList* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = vala_g_ptr_array_get_length (events);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (events, (guint) i);
				if (((ZeitgeistEvent*) _tmp4_) == NULL) {
					continue;
				}
				_tmp5_ = self->priv->blacklist;
				_tmp6_ = g_hash_table_get_values (_tmp5_);
				{
					GList* tmpl_collection = NULL;
					GList* tmpl_it = NULL;
					tmpl_collection = _tmp6_;
					for (tmpl_it = tmpl_collection; tmpl_it != NULL; tmpl_it = tmpl_it->next) {
						ZeitgeistEvent* tmpl = NULL;
						tmpl = (ZeitgeistEvent*) tmpl_it->data;
						{
							gconstpointer _tmp7_;
							ZeitgeistEvent* _tmp8_;
							_tmp7_ = g_ptr_array_index (events, (guint) i);
							_tmp8_ = tmpl;
							if (zeitgeist_event_matches_template ((ZeitgeistEvent*) _tmp7_, _tmp8_)) {
								g_ptr_array_set (events, (guint) i, NULL);
								break;
							}
						}
					}
					(tmpl_collection == NULL) ? NULL : (tmpl_collection = (g_list_free (tmpl_collection), NULL));
				}
			}
		}
	}
}

static void
zeitgeist_blacklist_real_add_template (ZeitgeistRemoteBlacklist* base,
                                       const gchar* template_id,
                                       GVariant* event_template,
                                       GError** error)
{
	ZeitgeistBlacklist * self;
	ZeitgeistEvent* template = NULL;
	ZeitgeistEvent* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistBlacklist*) base;
	g_return_if_fail (template_id != NULL);
	g_return_if_fail (event_template != NULL);
	_tmp0_ = zeitgeist_event_new_from_variant (event_template, &_inner_error0_);
	template = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = self->priv->blacklist;
	_tmp2_ = g_strdup (template_id);
	_tmp3_ = _g_object_ref0 (template);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	g_debug ("ext-blacklist.vala:179: Added blacklist template: [#%u]", g_str_hash (template_id));
	g_signal_emit ((ZeitgeistRemoteBlacklist*) self, zeitgeist_remote_blacklist_signals[ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_ADDED_SIGNAL], 0, template_id, event_template);
	zeitgeist_blacklist_flush (self);
	_g_object_unref0 (template);
}

static void
zeitgeist_blacklist_real_remove_template (ZeitgeistRemoteBlacklist* base,
                                          const gchar* template_id,
                                          GError** error)
{
	ZeitgeistBlacklist * self;
	ZeitgeistEvent* event_template = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	ZeitgeistEvent* _tmp2_;
	GHashTable* _tmp3_;
	self = (ZeitgeistBlacklist*) base;
	g_return_if_fail (template_id != NULL);
	_tmp0_ = self->priv->blacklist;
	_tmp1_ = g_hash_table_lookup (_tmp0_, template_id);
	_tmp2_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp1_);
	event_template = _tmp2_;
	_tmp3_ = self->priv->blacklist;
	if (g_hash_table_remove (_tmp3_, template_id)) {
		ZeitgeistEvent* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		g_debug ("ext-blacklist.vala:189: Removed blacklist template: [#%u]", g_str_hash (template_id));
		_tmp4_ = event_template;
		_tmp5_ = zeitgeist_event_to_variant (_tmp4_);
		_tmp6_ = _tmp5_;
		g_signal_emit ((ZeitgeistRemoteBlacklist*) self, zeitgeist_remote_blacklist_signals[ZEITGEIST_REMOTE_BLACKLIST_TEMPLATE_REMOVED_SIGNAL], 0, template_id, _tmp6_);
		_g_variant_unref0 (_tmp6_);
		zeitgeist_blacklist_flush (self);
	} else {
		g_debug ("ext-blacklist.vala:195: Blacklist template [#%u] not found.", g_str_hash (template_id));
	}
	_g_object_unref0 (event_template);
}

static GVariant*
zeitgeist_blacklist_real_get_templates (ZeitgeistRemoteBlacklist* base,
                                        GError** error)
{
	ZeitgeistBlacklist * self;
	GHashTable* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	self = (ZeitgeistBlacklist*) base;
	_tmp0_ = self->priv->blacklist;
	_tmp1_ = zeitgeist_blacklist_templates_to_variant (_tmp0_);
	result = _tmp1_;
	return result;
}

static GObject *
zeitgeist_blacklist_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistBlacklist * self;
	GVariant* templates = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_blacklist_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BLACKLIST, ZeitgeistBlacklist);
	_tmp0_ = zeitgeist_extension_retrieve_config ((ZeitgeistExtension*) self, "blacklist", ZEITGEIST_BLACKLIST_TEMPLATES_SIG_BLACKLIST);
	templates = _tmp0_;
	_tmp1_ = templates;
	if (_tmp1_ != NULL) {
		{
			GHashTable* _tmp2_ = NULL;
			GVariant* _tmp3_;
			GHashTable* _tmp4_;
			GHashTable* _tmp5_;
			_tmp3_ = templates;
			_tmp4_ = zeitgeist_blacklist_templates_from_variant (_tmp3_, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					goto __catch0_zeitgeist_data_model_error;
				}
				_g_variant_unref0 (templates);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_hash_table_unref0 (self->priv->blacklist);
			self->priv->blacklist = _tmp5_;
			_g_hash_table_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_zeitgeist_data_model_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			GHashFunc _tmp8_;
			GEqualFunc _tmp9_;
			GHashTable* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("ext-blacklist.vala:110: Could not load blacklist from variant: %s", _tmp7_);
			_tmp8_ = g_str_hash;
			_tmp9_ = g_str_equal;
			_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, _g_object_unref0_);
			_g_hash_table_unref0 (self->priv->blacklist);
			self->priv->blacklist = _tmp10_;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_variant_unref0 (templates);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	} else {
		GHashFunc _tmp11_;
		GEqualFunc _tmp12_;
		GHashTable* _tmp13_;
		_tmp11_ = g_str_hash;
		_tmp12_ = g_str_equal;
		_tmp13_ = g_hash_table_new_full (_tmp11_, _tmp12_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->blacklist);
		self->priv->blacklist = _tmp13_;
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp14_;
		guint _tmp15_ = 0U;
		GDBusConnection* _tmp16_;
		guint _tmp17_;
		_tmp14_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = connection;
		_tmp17_ = zeitgeist_remote_blacklist_register_object ((ZeitgeistRemoteBlacklist*) self, _tmp16_, "/org/gnome/zeitgeist/blacklist", &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch1_g_error;
		}
		self->priv->registration_id = _tmp15_;
		_g_object_unref0 (connection);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = err;
		_tmp19_ = _tmp18_->message;
		g_warning ("ext-blacklist.vala:128: %s", _tmp19_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (templates);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_variant_unref0 (templates);
	return obj;
}

static void
zeitgeist_blacklist_class_init (ZeitgeistBlacklistClass * klass,
                                gpointer klass_data)
{
	zeitgeist_blacklist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistBlacklist_private_offset);
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension*)) zeitgeist_blacklist_real_unload;
	((ZeitgeistExtensionClass *) klass)->pre_insert_events = (void (*) (ZeitgeistExtension*, GPtrArray*, const char*)) zeitgeist_blacklist_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_blacklist_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_blacklist_finalize;
}

static void
zeitgeist_blacklist_zeitgeist_remote_blacklist_interface_init (ZeitgeistRemoteBlacklistIface * iface,
                                                               gpointer iface_data)
{
	zeitgeist_blacklist_zeitgeist_remote_blacklist_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_template = (void (*) (ZeitgeistRemoteBlacklist*, const gchar*, GVariant*, GError**)) zeitgeist_blacklist_real_add_template;
	iface->remove_template = (void (*) (ZeitgeistRemoteBlacklist*, const gchar*, GError**)) zeitgeist_blacklist_real_remove_template;
	iface->get_templates = (GVariant* (*) (ZeitgeistRemoteBlacklist*, GError**)) zeitgeist_blacklist_real_get_templates;
}

static void
zeitgeist_blacklist_instance_init (ZeitgeistBlacklist * self,
                                   gpointer klass)
{
	self->priv = zeitgeist_blacklist_get_instance_private (self);
}

static void
zeitgeist_blacklist_finalize (GObject * obj)
{
	ZeitgeistBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BLACKLIST, ZeitgeistBlacklist);
	_g_hash_table_unref0 (self->priv->blacklist);
	G_OBJECT_CLASS (zeitgeist_blacklist_parent_class)->finalize (obj);
}

GType
zeitgeist_blacklist_get_type (void)
{
	return zeitgeist_blacklist_type_id;
}

GType
zeitgeist_blacklist_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistBlacklist), 0, (GInstanceInitFunc) zeitgeist_blacklist_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_blacklist_info = { (GInterfaceInitFunc) zeitgeist_blacklist_zeitgeist_remote_blacklist_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_blacklist_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistBlacklist", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_blacklist_type_id, ZEITGEIST_TYPE_REMOTE_BLACKLIST, &zeitgeist_remote_blacklist_info);
	ZeitgeistBlacklist_private_offset = sizeof (ZeitgeistBlacklistPrivate);
	return zeitgeist_blacklist_type_id;
}

GType
zeitgeist_blacklist_init (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_blacklist_register_type (module);
	zeitgeist_remote_blacklist_proxy_register_dynamic_type (module);
	zeitgeist_blacklist_register_type (module);
	result = ZEITGEIST_TYPE_BLACKLIST;
	return result;
}

