/* engine.c generated by valac 0.56.16, the Vala compiler
 * generated from engine.vala, do not modify */

/* engine.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-engine.h"
#include <glib.h>
#include "zeitgeist-internal.h"
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>

#define ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_ENGINE_0_PROPERTY,
	ZEITGEIST_ENGINE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_engine_properties[ZEITGEIST_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_ENGINE_TYPE_DATA_INSERTER (zeitgeist_engine_data_inserter_get_type ())
#define ZEITGEIST_ENGINE_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter))
#define ZEITGEIST_ENGINE_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))

typedef struct _ZeitgeistEngineDataInserter ZeitgeistEngineDataInserter;
typedef struct _ZeitgeistEngineDataInserterClass ZeitgeistEngineDataInserterClass;
#define _zeitgeist_engine_data_inserter_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_engine_data_inserter_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ZeitgeistEngineDataInserterPrivate ZeitgeistEngineDataInserterPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistEngineParamSpecDataInserter ZeitgeistEngineParamSpecDataInserter;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistEnginePrivate {
	ZeitgeistExtensionCollection* extension_collection;
	guint32 last_id;
};

struct _ZeitgeistEngineDataInserter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistEngineDataInserterPrivate * priv;
};

struct _ZeitgeistEngineDataInserterClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistEngineDataInserter *self);
};

struct _ZeitgeistEngineDataInserterPrivate {
	ZeitgeistSQLiteDatabase* database;
	gchar* type;
	GPtrArray* data;
};

struct _ZeitgeistEngineParamSpecDataInserter {
	GParamSpec parent_instance;
};

static gint ZeitgeistEngine_private_offset;
static gpointer zeitgeist_engine_parent_class = NULL;
static gint ZeitgeistEngineDataInserter_private_offset;
static gpointer zeitgeist_engine_data_inserter_parent_class = NULL;

static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self,
                                        ZeitgeistEvent* event,
                                        GError** error);
static void zeitgeist_engine_insert_event_data (ZeitgeistEngine* self,
                                         GPtrArray* events,
                                         GError** error);
static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self,
                                       ZeitgeistEvent* event,
                                       GError** error);
static gpointer zeitgeist_engine_data_inserter_ref (gpointer instance);
static void zeitgeist_engine_data_inserter_unref (gpointer instance);
static GParamSpec* zeitgeist_engine_param_spec_data_inserter (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void zeitgeist_engine_value_set_data_inserter (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void zeitgeist_engine_value_take_data_inserter (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer zeitgeist_engine_value_get_data_inserter (const GValue* value) G_GNUC_UNUSED ;
static GType zeitgeist_engine_data_inserter_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db,
                                                                 const gchar* data_type);
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_construct (GType object_type,
                                                                       ZeitgeistSQLiteDatabase* db,
                                                                       const gchar* data_type);
static void zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self,
                                         const gchar* val,
                                         GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self,
                                           GError** error);
static void zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self,
                                             sqlite3_stmt* stmt,
                                             gint position,
                                             ZeitgeistSQLiteTableLookup* table,
                                             const gchar* value_,
                                             GError** error);
static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self,
                                       ZeitgeistEvent* event);
static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self,
                                         ZeitgeistEvent* event);
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base);
static void zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter * obj);
static GType zeitgeist_engine_data_inserter_get_type_once (void);
static GObject * zeitgeist_engine_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void zeitgeist_engine_finalize (GObject * obj);
static GType zeitgeist_engine_get_type_once (void);

static inline gpointer
zeitgeist_engine_get_instance_private (ZeitgeistEngine* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistEngine_private_offset);
}

ZeitgeistEngine*
zeitgeist_engine_construct (GType object_type,
                            GError** error)
{
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	guint32 _tmp2_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistRegisterExtensionFunc* _tmp5_;
	ZeitgeistRegisterExtensionFunc* _tmp6_;
	gint _tmp6__length1;
	ZeitgeistExtensionCollection* _tmp7_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp0_, NULL);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp2_ = zeitgeist_sq_lite_database_get_last_id (_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp2_;
	_tmp5_ = g_new0 (ZeitgeistRegisterExtensionFunc, 0);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 0;
	_tmp7_ = zeitgeist_extension_collection_new (self, _tmp6_, 0);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp7_;
	_tmp6_ = (g_free (_tmp6_), NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

ZeitgeistEngine*
zeitgeist_engine_new (GError** error)
{
	return zeitgeist_engine_construct (ZEITGEIST_TYPE_ENGINE, error);
}

ZeitgeistEngine*
zeitgeist_engine_construct_with_builtins (GType object_type,
                                          ZeitgeistRegisterExtensionFunc* builtins,
                                          gint builtins_length1,
                                          GError** error)
{
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	guint32 _tmp2_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistExtensionCollection* _tmp5_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp0_, NULL);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp2_ = zeitgeist_sq_lite_database_get_last_id (_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp2_;
	_tmp5_ = zeitgeist_extension_collection_new (self, builtins, builtins_length1);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return self;
}

ZeitgeistEngine*
zeitgeist_engine_new_with_builtins (ZeitgeistRegisterExtensionFunc* builtins,
                                    gint builtins_length1,
                                    GError** error)
{
	return zeitgeist_engine_construct_with_builtins (ZEITGEIST_TYPE_ENGINE, builtins, builtins_length1, error);
}

gchar**
zeitgeist_engine_get_extension_names (ZeitgeistEngine* self,
                                      gint* result_length1)
{
	ZeitgeistExtensionCollection* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_get_extension_names (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

guint32*
zeitgeist_engine_insert_events (ZeitgeistEngine* self,
                                GPtrArray* events,
                                const char* sender,
                                gint* result_length1,
                                GError** error)
{
	ZeitgeistExtensionCollection* _tmp5_;
	guint32* event_ids = NULL;
	gint _tmp6_;
	gint _tmp7_;
	guint32* _tmp8_;
	gint event_ids_length1;
	gint _event_ids_size_;
	GError* err = NULL;
	ZeitgeistSQLiteDatabase* _tmp9_;
	ZeitgeistSQLiteDatabase* _tmp10_;
	GError* _tmp25_;
	ZeitgeistExtensionCollection* _tmp28_;
	guint32* _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_ = NULL;
	guint32* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gconstpointer _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				_tmp2_ = vala_g_ptr_array_get_length (events);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (events, (guint) i);
				zeitgeist_engine_preprocess_event (self, (ZeitgeistEvent*) _tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp5_ = self->priv->extension_collection;
	zeitgeist_extension_collection_call_pre_insert_events (_tmp5_, events, sender);
	_tmp6_ = vala_g_ptr_array_get_length (events);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (guint32, _tmp7_);
	event_ids = _tmp8_;
	event_ids_length1 = _tmp7_;
	_event_ids_size_ = event_ids_length1;
	err = NULL;
	_tmp9_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp10_ = _tmp9_;
	zeitgeist_sq_lite_database_begin_transaction (_tmp10_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		ZeitgeistSQLiteDatabase* _tmp19_;
		ZeitgeistSQLiteDatabase* _tmp20_;
		zeitgeist_engine_insert_event_data (self, events, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gconstpointer _tmp15_;
					if (!_tmp11_) {
						gint _tmp12_;
						i = i + 1;
						_tmp12_ = i;
					}
					_tmp11_ = FALSE;
					_tmp13_ = vala_g_ptr_array_get_length (events);
					_tmp14_ = _tmp13_;
					if (!(i < _tmp14_)) {
						break;
					}
					_tmp15_ = g_ptr_array_index (events, (guint) i);
					if (((ZeitgeistEvent*) _tmp15_) != NULL) {
						guint32 _tmp16_ = 0U;
						gconstpointer _tmp17_;
						guint32* _tmp18_;
						gint _tmp18__length1;
						_tmp17_ = g_ptr_array_index (events, (guint) i);
						_tmp16_ = zeitgeist_engine_insert_event (self, (ZeitgeistEvent*) _tmp17_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								goto __catch0_zeitgeist_engine_error;
							}
							_g_error_free0 (err);
							event_ids = (g_free (event_ids), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp18_ = event_ids;
						_tmp18__length1 = event_ids_length1;
						_tmp18_[i] = _tmp16_;
					}
				}
			}
		}
		_tmp19_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp20_ = _tmp19_;
		zeitgeist_sq_lite_database_end_transaction (_tmp20_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
		ZeitgeistSQLiteDatabase* _tmp23_;
		ZeitgeistSQLiteDatabase* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _g_error_copy0 (_tmp21_);
		_g_error_free0 (err);
		err = _tmp22_;
		_tmp23_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp24_ = _tmp23_;
		zeitgeist_sq_lite_database_abort_transaction (_tmp24_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			goto __finally0;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp25_ = err;
	if (_tmp25_ != NULL) {
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp26_ = err;
		_tmp27_ = _g_error_copy0 (_tmp26_);
		_inner_error0_ = _tmp27_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp28_ = self->priv->extension_collection;
	zeitgeist_extension_collection_call_post_insert_events (_tmp28_, events, sender);
	_tmp29_ = event_ids;
	_tmp29__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	_g_error_free0 (err);
	return result;
}

static void
zeitgeist_engine_preprocess_event (ZeitgeistEngine* self,
                                   ZeitgeistEvent* event,
                                   GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = zeitgeist_event_get_interpretation (event);
	_tmp3_ = _tmp2_;
	if (zeitgeist_utils_is_empty_string (_tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = zeitgeist_event_get_manifestation (event);
		_tmp5_ = _tmp4_;
		_tmp1_ = zeitgeist_utils_is_empty_string (_tmp5_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = zeitgeist_event_get_actor (event);
		_tmp7_ = _tmp6_;
		_tmp0_ = zeitgeist_utils_is_empty_string (_tmp7_);
	}
	if (_tmp0_) {
		GError* _tmp8_;
		_tmp8_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: interpretation, manifestation and actor " "are required");
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				ZeitgeistSubject* subject = NULL;
				GPtrArray* _tmp11_;
				GPtrArray* _tmp12_;
				gconstpointer _tmp13_;
				ZeitgeistSubject* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				ZeitgeistSubject* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gboolean _tmp32_ = FALSE;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gboolean _tmp52_ = FALSE;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ZeitgeistSubject* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				ZeitgeistSubject* _tmp72_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				if (!_tmp9_) {
					gint _tmp10_;
					i = i + 1;
					_tmp10_ = i;
				}
				_tmp9_ = FALSE;
				if (!(i < zeitgeist_event_num_subjects (event))) {
					break;
				}
				_tmp11_ = zeitgeist_event_get_subjects (event);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_ptr_array_index (_tmp12_, (guint) i);
				subject = (ZeitgeistSubject*) _tmp13_;
				_tmp14_ = subject;
				_tmp15_ = zeitgeist_subject_get_uri (_tmp14_);
				_tmp16_ = _tmp15_;
				if (zeitgeist_utils_is_empty_string (_tmp16_)) {
					GError* _tmp17_;
					_tmp17_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: subject without URI");
					_inner_error0_ = _tmp17_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp18_ = subject;
				_tmp19_ = zeitgeist_subject_get_current_uri (_tmp18_);
				_tmp20_ = _tmp19_;
				if (zeitgeist_utils_is_empty_string (_tmp20_)) {
					ZeitgeistSubject* _tmp21_;
					ZeitgeistSubject* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp21_ = subject;
					_tmp22_ = subject;
					_tmp23_ = zeitgeist_subject_get_uri (_tmp22_);
					_tmp24_ = _tmp23_;
					zeitgeist_subject_set_current_uri (_tmp21_, _tmp24_);
				}
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_current_origin (_tmp25_);
				_tmp27_ = _tmp26_;
				if (zeitgeist_utils_is_empty_string (_tmp27_)) {
					ZeitgeistSubject* _tmp28_;
					ZeitgeistSubject* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp28_ = subject;
					_tmp29_ = subject;
					_tmp30_ = zeitgeist_subject_get_origin (_tmp29_);
					_tmp31_ = _tmp30_;
					zeitgeist_subject_set_current_origin (_tmp28_, _tmp31_);
				}
				_tmp33_ = zeitgeist_event_get_interpretation (event);
				_tmp34_ = _tmp33_;
				if (g_strcmp0 (_tmp34_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
					ZeitgeistSubject* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					ZeitgeistSubject* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp35_ = subject;
					_tmp36_ = zeitgeist_subject_get_uri (_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = subject;
					_tmp39_ = zeitgeist_subject_get_current_uri (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp32_ = g_strcmp0 (_tmp37_, _tmp40_) == 0;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					GError* _tmp41_;
					_tmp41_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Redundant event: event.interpretation indicates " "the uri has been moved yet the subject.uri and " "subject.current_uri are identical");
					_inner_error0_ = _tmp41_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					gboolean _tmp42_ = FALSE;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					_tmp43_ = zeitgeist_event_get_interpretation (event);
					_tmp44_ = _tmp43_;
					if (g_strcmp0 (_tmp44_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
						ZeitgeistSubject* _tmp45_;
						const gchar* _tmp46_;
						const gchar* _tmp47_;
						ZeitgeistSubject* _tmp48_;
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						_tmp45_ = subject;
						_tmp46_ = zeitgeist_subject_get_uri (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = subject;
						_tmp49_ = zeitgeist_subject_get_current_uri (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp42_ = g_strcmp0 (_tmp47_, _tmp50_) != 0;
					} else {
						_tmp42_ = FALSE;
					}
					if (_tmp42_) {
						GError* _tmp51_;
						_tmp51_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.uri and " "subject.current_uri have to be the same");
						_inner_error0_ = _tmp51_;
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				_tmp53_ = zeitgeist_event_get_interpretation (event);
				_tmp54_ = _tmp53_;
				if (g_strcmp0 (_tmp54_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
					ZeitgeistSubject* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					ZeitgeistSubject* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					_tmp55_ = subject;
					_tmp56_ = zeitgeist_subject_get_origin (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = subject;
					_tmp59_ = zeitgeist_subject_get_current_origin (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp52_ = g_strcmp0 (_tmp57_, _tmp60_) != 0;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					GError* _tmp61_;
					_tmp61_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.origin and " "subject.current_origin have to be the same");
					_inner_error0_ = _tmp61_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp62_ = subject;
				_tmp63_ = zeitgeist_subject_get_manifestation (_tmp62_);
				_tmp64_ = _tmp63_;
				if (zeitgeist_utils_is_empty_string (_tmp64_)) {
					const gchar* manifestation = NULL;
					ZeitgeistSubject* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					const gchar* _tmp69_;
					_tmp65_ = subject;
					_tmp66_ = zeitgeist_subject_get_uri (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = zeitgeist_manifestation_for_uri (_tmp67_);
					manifestation = _tmp68_;
					_tmp69_ = manifestation;
					if (_tmp69_ != NULL) {
						ZeitgeistSubject* _tmp70_;
						const gchar* _tmp71_;
						_tmp70_ = subject;
						_tmp71_ = manifestation;
						zeitgeist_subject_set_manifestation (_tmp70_, _tmp71_);
					}
				}
				_tmp72_ = subject;
				_tmp73_ = zeitgeist_subject_get_interpretation (_tmp72_);
				_tmp74_ = _tmp73_;
				if (zeitgeist_utils_is_empty_string (_tmp74_)) {
					const gchar* interpretation = NULL;
					ZeitgeistSubject* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					const gchar* _tmp78_;
					const gchar* _tmp79_;
					_tmp75_ = subject;
					_tmp76_ = zeitgeist_subject_get_mimetype (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = zeitgeist_interpretation_for_mimetype (_tmp77_);
					interpretation = _tmp78_;
					_tmp79_ = interpretation;
					if (_tmp79_ != NULL) {
						ZeitgeistSubject* _tmp80_;
						const gchar* _tmp81_;
						_tmp80_ = subject;
						_tmp81_ = interpretation;
						zeitgeist_subject_set_interpretation (_tmp80_, _tmp81_);
					}
				}
			}
		}
	}
}

/**
     * Makes sure all the URIs, texts and storage values used
     * by the given events are in the database.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
zeitgeist_engine_insert_event_data (ZeitgeistEngine* self,
                                    GPtrArray* events,
                                    GError** error)
{
	ZeitgeistEngineDataInserter* uris = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistEngineDataInserter* _tmp2_;
	ZeitgeistEngineDataInserter* texts = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistEngineDataInserter* _tmp5_;
	ZeitgeistEngineDataInserter* storages = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp7_;
	ZeitgeistEngineDataInserter* _tmp8_;
	ZeitgeistEngineDataInserter* _tmp86_;
	ZeitgeistEngineDataInserter* _tmp87_;
	ZeitgeistEngineDataInserter* _tmp88_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_engine_data_inserter_new (_tmp1_, "uri");
	uris = _tmp2_;
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_engine_data_inserter_new (_tmp4_, "text");
	texts = _tmp5_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = zeitgeist_engine_data_inserter_new (_tmp7_, "storage");
	storages = _tmp8_;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_;
				ZeitgeistEvent* event = NULL;
				gconstpointer _tmp14_;
				ZeitgeistEvent* _tmp15_;
				GSList* subj_uris = NULL;
				ZeitgeistEvent* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				if (!_tmp9_) {
					gint _tmp10_;
					j = j + 1;
					_tmp10_ = j;
				}
				_tmp9_ = FALSE;
				_tmp11_ = vala_g_ptr_array_get_length (events);
				_tmp12_ = _tmp11_;
				if (!(j < _tmp12_)) {
					break;
				}
				_tmp13_ = g_ptr_array_index (events, (guint) j);
				if (((ZeitgeistEvent*) _tmp13_) == NULL) {
					continue;
				}
				_tmp14_ = g_ptr_array_index (events, (guint) j);
				_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp14_);
				event = _tmp15_;
				subj_uris = NULL;
				_tmp16_ = event;
				_tmp17_ = zeitgeist_event_get_origin (_tmp16_);
				_tmp18_ = _tmp17_;
				if (!zeitgeist_utils_is_empty_string (_tmp18_)) {
					ZeitgeistEngineDataInserter* _tmp19_;
					ZeitgeistEvent* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp19_ = uris;
					_tmp20_ = event;
					_tmp21_ = zeitgeist_event_get_origin (_tmp20_);
					_tmp22_ = _tmp21_;
					zeitgeist_engine_data_inserter_add (_tmp19_, _tmp22_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							return;
						} else {
							(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							ZeitgeistEvent* _tmp25_;
							ZeitgeistSubject* subject = NULL;
							ZeitgeistEvent* _tmp26_;
							GPtrArray* _tmp27_;
							GPtrArray* _tmp28_;
							gconstpointer _tmp29_;
							GSList* _tmp30_;
							ZeitgeistSubject* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							GCompareFunc _tmp34_;
							GSList* _tmp35_;
							ZeitgeistSubject* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
							ZeitgeistEngineDataInserter* _tmp41_;
							ZeitgeistSubject* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							ZeitgeistSubject* _tmp45_;
							const gchar* _tmp46_;
							const gchar* _tmp47_;
							ZeitgeistSubject* _tmp48_;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							ZeitgeistSubject* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							ZeitgeistSubject* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							ZeitgeistSubject* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							ZeitgeistSubject* _tmp72_;
							const gchar* _tmp73_;
							const gchar* _tmp74_;
							ZeitgeistSubject* _tmp79_;
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							if (!_tmp23_) {
								gint _tmp24_;
								i = i + 1;
								_tmp24_ = i;
							}
							_tmp23_ = FALSE;
							_tmp25_ = event;
							if (!(i < zeitgeist_event_num_subjects (_tmp25_))) {
								break;
							}
							_tmp26_ = event;
							_tmp27_ = zeitgeist_event_get_subjects (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = g_ptr_array_index (_tmp28_, (guint) i);
							subject = (ZeitgeistSubject*) _tmp29_;
							_tmp30_ = subj_uris;
							_tmp31_ = subject;
							_tmp32_ = zeitgeist_subject_get_uri (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = ((GCompareFunc) g_strcmp0);
							_tmp35_ = g_slist_find_custom (_tmp30_, _tmp33_, _tmp34_);
							if (_tmp35_ != NULL) {
								GError* _tmp36_;
								_tmp36_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_EVENT, "Events with two subjects with the same URI are not supported");
								_inner_error0_ = _tmp36_;
								if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error0_);
									(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
							}
							_tmp37_ = subject;
							_tmp38_ = zeitgeist_subject_get_uri (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_strdup (_tmp39_);
							subj_uris = g_slist_append (subj_uris, _tmp40_);
							_tmp41_ = uris;
							_tmp42_ = subject;
							_tmp43_ = zeitgeist_subject_get_uri (_tmp42_);
							_tmp44_ = _tmp43_;
							zeitgeist_engine_data_inserter_add (_tmp41_, _tmp44_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error0_);
									(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
							}
							_tmp45_ = subject;
							_tmp46_ = zeitgeist_subject_get_uri (_tmp45_);
							_tmp47_ = _tmp46_;
							_tmp48_ = subject;
							_tmp49_ = zeitgeist_subject_get_current_uri (_tmp48_);
							_tmp50_ = _tmp49_;
							if (g_strcmp0 (_tmp47_, _tmp50_) != 0) {
								ZeitgeistEngineDataInserter* _tmp51_;
								ZeitgeistSubject* _tmp52_;
								const gchar* _tmp53_;
								const gchar* _tmp54_;
								_tmp51_ = uris;
								_tmp52_ = subject;
								_tmp53_ = zeitgeist_subject_get_current_uri (_tmp52_);
								_tmp54_ = _tmp53_;
								zeitgeist_engine_data_inserter_add (_tmp51_, _tmp54_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
							_tmp55_ = subject;
							_tmp56_ = zeitgeist_subject_get_origin (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = subject;
							_tmp59_ = zeitgeist_subject_get_current_origin (_tmp58_);
							_tmp60_ = _tmp59_;
							if (g_strcmp0 (_tmp57_, _tmp60_) != 0) {
								ZeitgeistEngineDataInserter* _tmp61_;
								ZeitgeistSubject* _tmp62_;
								const gchar* _tmp63_;
								const gchar* _tmp64_;
								_tmp61_ = uris;
								_tmp62_ = subject;
								_tmp63_ = zeitgeist_subject_get_current_origin (_tmp62_);
								_tmp64_ = _tmp63_;
								zeitgeist_engine_data_inserter_add (_tmp61_, _tmp64_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
							_tmp65_ = subject;
							_tmp66_ = zeitgeist_subject_get_origin (_tmp65_);
							_tmp67_ = _tmp66_;
							if (!zeitgeist_utils_is_empty_string (_tmp67_)) {
								ZeitgeistEngineDataInserter* _tmp68_;
								ZeitgeistSubject* _tmp69_;
								const gchar* _tmp70_;
								const gchar* _tmp71_;
								_tmp68_ = uris;
								_tmp69_ = subject;
								_tmp70_ = zeitgeist_subject_get_origin (_tmp69_);
								_tmp71_ = _tmp70_;
								zeitgeist_engine_data_inserter_add (_tmp68_, _tmp71_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
							_tmp72_ = subject;
							_tmp73_ = zeitgeist_subject_get_text (_tmp72_);
							_tmp74_ = _tmp73_;
							if (!zeitgeist_utils_is_empty_string (_tmp74_)) {
								ZeitgeistEngineDataInserter* _tmp75_;
								ZeitgeistSubject* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_;
								_tmp75_ = texts;
								_tmp76_ = subject;
								_tmp77_ = zeitgeist_subject_get_text (_tmp76_);
								_tmp78_ = _tmp77_;
								zeitgeist_engine_data_inserter_add (_tmp75_, _tmp78_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
							_tmp79_ = subject;
							_tmp80_ = zeitgeist_subject_get_storage (_tmp79_);
							_tmp81_ = _tmp80_;
							if (!zeitgeist_utils_is_empty_string (_tmp81_)) {
								ZeitgeistEngineDataInserter* _tmp82_;
								ZeitgeistSubject* _tmp83_;
								const gchar* _tmp84_;
								const gchar* _tmp85_;
								_tmp82_ = storages;
								_tmp83_ = subject;
								_tmp84_ = zeitgeist_subject_get_storage (_tmp83_);
								_tmp85_ = _tmp84_;
								zeitgeist_engine_data_inserter_add (_tmp82_, _tmp85_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
						}
					}
				}
				(subj_uris == NULL) ? NULL : (subj_uris = (_g_slist_free__g_free0_ (subj_uris), NULL));
				_g_object_unref0 (event);
			}
		}
	}
	_tmp86_ = uris;
	zeitgeist_engine_data_inserter_flush (_tmp86_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp87_ = texts;
	zeitgeist_engine_data_inserter_flush (_tmp87_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp88_ = storages;
	zeitgeist_engine_data_inserter_flush (_tmp88_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_zeitgeist_engine_data_inserter_unref0 (storages);
	_zeitgeist_engine_data_inserter_unref0 (texts);
	_zeitgeist_engine_data_inserter_unref0 (uris);
}

static void
zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self,
                                        sqlite3_stmt* stmt,
                                        gint position,
                                        ZeitgeistSQLiteTableLookup* table,
                                        const gchar* value_,
                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (table != NULL);
	if (value_ != NULL) {
		gint _tmp0_ = 0;
		_tmp0_ = zeitgeist_sq_lite_table_lookup_id_for_string (table, value_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		sqlite3_bind_int64 (stmt, position, (gint64) _tmp0_);
	} else {
		sqlite3_bind_null (stmt, position);
	}
}

static guint32
zeitgeist_engine_insert_event (ZeitgeistEngine* self,
                               ZeitgeistEvent* event,
                               GError** error)
{
	guint32 _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	gint64 payload_id = 0LL;
	gint rc = 0;
	sqlite3_stmt* insert_stmt = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp140_;
	const gchar* _tmp141_;
	guint32 _tmp142_;
	guint32 _tmp143_;
	guint32 _tmp146_;
	guint32 _tmp147_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (event != NULL, 0U);
	_tmp0_ = zeitgeist_event_get_id (event);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ == ((guint32) 0), "event.id == 0", 0U);
	_vala_return_val_if_fail (zeitgeist_event_num_subjects (event) > 0, "event.num_subjects () > 0", 0U);
	self->priv->last_id = self->priv->last_id + 1;
	_tmp2_ = self->priv->last_id;
	zeitgeist_event_set_id (event, _tmp2_);
	payload_id = zeitgeist_engine_store_payload (self, event);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->event_insertion_stmt;
	insert_stmt = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				sqlite3_stmt* _tmp8_;
				sqlite3_stmt* _tmp9_;
				guint32 _tmp10_;
				guint32 _tmp11_;
				sqlite3_stmt* _tmp12_;
				gint64 _tmp13_;
				gint64 _tmp14_;
				sqlite3_stmt* _tmp15_;
				ZeitgeistSQLiteTableLookup* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				sqlite3_stmt* _tmp21_;
				ZeitgeistSQLiteTableLookup* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				sqlite3_stmt* _tmp27_;
				ZeitgeistSQLiteTableLookup* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				sqlite3_stmt* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				GDestroyNotify _tmp37_;
				sqlite3_stmt* _tmp38_;
				ZeitgeistSubject* subject = NULL;
				GPtrArray* _tmp39_;
				GPtrArray* _tmp40_;
				gconstpointer _tmp41_;
				sqlite3_stmt* _tmp42_;
				ZeitgeistSubject* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				GDestroyNotify _tmp47_;
				sqlite3_stmt* _tmp48_;
				ZeitgeistSubject* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				GDestroyNotify _tmp53_;
				sqlite3_stmt* _tmp54_;
				ZeitgeistSQLiteTableLookup* _tmp55_;
				ZeitgeistSubject* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				sqlite3_stmt* _tmp61_;
				ZeitgeistSQLiteTableLookup* _tmp62_;
				ZeitgeistSubject* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				sqlite3_stmt* _tmp68_;
				ZeitgeistSubject* _tmp69_;
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				GDestroyNotify _tmp73_;
				sqlite3_stmt* _tmp74_;
				ZeitgeistSubject* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp77_;
				gchar* _tmp78_;
				GDestroyNotify _tmp79_;
				sqlite3_stmt* _tmp80_;
				ZeitgeistSQLiteTableLookup* _tmp81_;
				ZeitgeistSubject* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				sqlite3_stmt* _tmp87_;
				ZeitgeistSubject* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				gchar* _tmp91_;
				GDestroyNotify _tmp92_;
				sqlite3_stmt* _tmp93_;
				ZeitgeistSubject* _tmp94_;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
				gchar* _tmp97_;
				GDestroyNotify _tmp98_;
				sqlite3_stmt* _tmp99_;
				if (!_tmp6_) {
					gint _tmp7_;
					i = i + 1;
					_tmp7_ = i;
				}
				_tmp6_ = FALSE;
				if (!(i < zeitgeist_event_num_subjects (event))) {
					break;
				}
				_tmp8_ = insert_stmt;
				sqlite3_reset (_tmp8_);
				_tmp9_ = insert_stmt;
				_tmp10_ = zeitgeist_event_get_id (event);
				_tmp11_ = _tmp10_;
				sqlite3_bind_int64 (_tmp9_, 1, (gint64) _tmp11_);
				_tmp12_ = insert_stmt;
				_tmp13_ = zeitgeist_event_get_timestamp (event);
				_tmp14_ = _tmp13_;
				sqlite3_bind_int64 (_tmp12_, 2, _tmp14_);
				_tmp15_ = insert_stmt;
				_tmp16_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp17_ = zeitgeist_event_get_interpretation (event);
				_tmp18_ = _tmp17_;
				zeitgeist_engine_bind_cached_reference (self, _tmp15_, 3, _tmp16_, _tmp18_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp19_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp19_;
					} else {
						guint32 _tmp20_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp20_;
					}
				}
				_tmp21_ = insert_stmt;
				_tmp22_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp23_ = zeitgeist_event_get_manifestation (event);
				_tmp24_ = _tmp23_;
				zeitgeist_engine_bind_cached_reference (self, _tmp21_, 4, _tmp22_, _tmp24_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp25_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp25_;
					} else {
						guint32 _tmp26_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp26_;
					}
				}
				_tmp27_ = insert_stmt;
				_tmp28_ = ((ZeitgeistDbReader*) self)->actors_table;
				_tmp29_ = zeitgeist_event_get_actor (event);
				_tmp30_ = _tmp29_;
				zeitgeist_engine_bind_cached_reference (self, _tmp27_, 5, _tmp28_, _tmp30_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp31_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp31_;
					} else {
						guint32 _tmp32_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp32_;
					}
				}
				_tmp33_ = insert_stmt;
				_tmp34_ = zeitgeist_event_get_origin (event);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup (_tmp35_);
				_tmp37_ = g_free;
				sqlite3_bind_text (_tmp33_, 6, _tmp36_, -1, _tmp37_);
				_tmp38_ = insert_stmt;
				sqlite3_bind_int64 (_tmp38_, 7, payload_id);
				_tmp39_ = zeitgeist_event_get_subjects (event);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_ptr_array_index (_tmp40_, (guint) i);
				subject = (ZeitgeistSubject*) _tmp41_;
				_tmp42_ = insert_stmt;
				_tmp43_ = subject;
				_tmp44_ = zeitgeist_subject_get_uri (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup (_tmp45_);
				_tmp47_ = g_free;
				sqlite3_bind_text (_tmp42_, 8, _tmp46_, -1, _tmp47_);
				_tmp48_ = insert_stmt;
				_tmp49_ = subject;
				_tmp50_ = zeitgeist_subject_get_current_uri (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup (_tmp51_);
				_tmp53_ = g_free;
				sqlite3_bind_text (_tmp48_, 9, _tmp52_, -1, _tmp53_);
				_tmp54_ = insert_stmt;
				_tmp55_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp56_ = subject;
				_tmp57_ = zeitgeist_subject_get_interpretation (_tmp56_);
				_tmp58_ = _tmp57_;
				zeitgeist_engine_bind_cached_reference (self, _tmp54_, 10, _tmp55_, _tmp58_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp59_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp59_;
					} else {
						guint32 _tmp60_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp60_;
					}
				}
				_tmp61_ = insert_stmt;
				_tmp62_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp63_ = subject;
				_tmp64_ = zeitgeist_subject_get_manifestation (_tmp63_);
				_tmp65_ = _tmp64_;
				zeitgeist_engine_bind_cached_reference (self, _tmp61_, 11, _tmp62_, _tmp65_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp66_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp66_;
					} else {
						guint32 _tmp67_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp67_;
					}
				}
				_tmp68_ = insert_stmt;
				_tmp69_ = subject;
				_tmp70_ = zeitgeist_subject_get_origin (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = g_strdup (_tmp71_);
				_tmp73_ = g_free;
				sqlite3_bind_text (_tmp68_, 12, _tmp72_, -1, _tmp73_);
				_tmp74_ = insert_stmt;
				_tmp75_ = subject;
				_tmp76_ = zeitgeist_subject_get_current_origin (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strdup (_tmp77_);
				_tmp79_ = g_free;
				sqlite3_bind_text (_tmp74_, 13, _tmp78_, -1, _tmp79_);
				_tmp80_ = insert_stmt;
				_tmp81_ = ((ZeitgeistDbReader*) self)->mimetypes_table;
				_tmp82_ = subject;
				_tmp83_ = zeitgeist_subject_get_mimetype (_tmp82_);
				_tmp84_ = _tmp83_;
				zeitgeist_engine_bind_cached_reference (self, _tmp80_, 14, _tmp81_, _tmp84_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp85_ = 0U;
						g_propagate_error (error, _inner_error0_);
						return _tmp85_;
					} else {
						guint32 _tmp86_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp86_;
					}
				}
				_tmp87_ = insert_stmt;
				_tmp88_ = subject;
				_tmp89_ = zeitgeist_subject_get_text (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = g_strdup (_tmp90_);
				_tmp92_ = g_free;
				sqlite3_bind_text (_tmp87_, 15, _tmp91_, -1, _tmp92_);
				_tmp93_ = insert_stmt;
				_tmp94_ = subject;
				_tmp95_ = zeitgeist_subject_get_storage (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = g_strdup (_tmp96_);
				_tmp98_ = g_free;
				sqlite3_bind_text (_tmp93_, 16, _tmp97_, -1, _tmp98_);
				_tmp99_ = insert_stmt;
				rc = sqlite3_step (_tmp99_);
				if (rc != SQLITE_DONE) {
					guint32 _tmp106_;
					sqlite3_stmt* retrieval_stmt = NULL;
					ZeitgeistSQLiteDatabase* _tmp107_;
					ZeitgeistSQLiteDatabase* _tmp108_;
					sqlite3_stmt* _tmp109_;
					sqlite3_stmt* _tmp110_;
					sqlite3_stmt* _tmp111_;
					gint64 _tmp112_;
					gint64 _tmp113_;
					sqlite3_stmt* _tmp114_;
					ZeitgeistSQLiteTableLookup* _tmp115_;
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					sqlite3_stmt* _tmp120_;
					ZeitgeistSQLiteTableLookup* _tmp121_;
					const gchar* _tmp122_;
					const gchar* _tmp123_;
					sqlite3_stmt* _tmp126_;
					ZeitgeistSQLiteTableLookup* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					sqlite3_stmt* _tmp132_;
					sqlite3_stmt* _tmp139_;
					if (rc != SQLITE_CONSTRAINT) {
						ZeitgeistSQLiteDatabase* _tmp100_;
						ZeitgeistSQLiteDatabase* _tmp101_;
						sqlite3* _tmp104_;
						const gchar* _tmp105_;
						_tmp100_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp101_ = _tmp100_;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp101_, rc, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								guint32 _tmp102_ = 0U;
								g_propagate_error (error, _inner_error0_);
								return _tmp102_;
							} else {
								guint32 _tmp103_ = 0U;
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp103_;
							}
						}
						_tmp104_ = ((ZeitgeistDbReader*) self)->db;
						_tmp105_ = sqlite3_errmsg (_tmp104_);
						g_warning ("engine.vala:330: SQL error: %d, %s\n", rc, _tmp105_);
						result = (guint32) 0;
						return result;
					}
					self->priv->last_id = self->priv->last_id - 1;
					_tmp106_ = self->priv->last_id;
					_tmp107_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp108_ = _tmp107_;
					_tmp109_ = _tmp108_->id_retrieval_stmt;
					retrieval_stmt = _tmp109_;
					_tmp110_ = retrieval_stmt;
					sqlite3_reset (_tmp110_);
					_tmp111_ = retrieval_stmt;
					_tmp112_ = zeitgeist_event_get_timestamp (event);
					_tmp113_ = _tmp112_;
					sqlite3_bind_int64 (_tmp111_, 1, _tmp113_);
					_tmp114_ = retrieval_stmt;
					_tmp115_ = ((ZeitgeistDbReader*) self)->interpretations_table;
					_tmp116_ = zeitgeist_event_get_interpretation (event);
					_tmp117_ = _tmp116_;
					zeitgeist_engine_bind_cached_reference (self, _tmp114_, 2, _tmp115_, _tmp117_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp118_ = 0U;
							g_propagate_error (error, _inner_error0_);
							return _tmp118_;
						} else {
							guint32 _tmp119_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp119_;
						}
					}
					_tmp120_ = retrieval_stmt;
					_tmp121_ = ((ZeitgeistDbReader*) self)->manifestations_table;
					_tmp122_ = zeitgeist_event_get_manifestation (event);
					_tmp123_ = _tmp122_;
					zeitgeist_engine_bind_cached_reference (self, _tmp120_, 3, _tmp121_, _tmp123_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp124_ = 0U;
							g_propagate_error (error, _inner_error0_);
							return _tmp124_;
						} else {
							guint32 _tmp125_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp125_;
						}
					}
					_tmp126_ = retrieval_stmt;
					_tmp127_ = ((ZeitgeistDbReader*) self)->actors_table;
					_tmp128_ = zeitgeist_event_get_actor (event);
					_tmp129_ = _tmp128_;
					zeitgeist_engine_bind_cached_reference (self, _tmp126_, 4, _tmp127_, _tmp129_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp130_ = 0U;
							g_propagate_error (error, _inner_error0_);
							return _tmp130_;
						} else {
							guint32 _tmp131_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp131_;
						}
					}
					_tmp132_ = retrieval_stmt;
					rc = sqlite3_step (_tmp132_);
					if (rc != SQLITE_ROW) {
						ZeitgeistSQLiteDatabase* _tmp133_;
						ZeitgeistSQLiteDatabase* _tmp134_;
						sqlite3* _tmp137_;
						const gchar* _tmp138_;
						_tmp133_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp134_ = _tmp133_;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp134_, rc, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								guint32 _tmp135_ = 0U;
								g_propagate_error (error, _inner_error0_);
								return _tmp135_;
							} else {
								guint32 _tmp136_ = 0U;
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp136_;
							}
						}
						_tmp137_ = ((ZeitgeistDbReader*) self)->db;
						_tmp138_ = sqlite3_errmsg (_tmp137_);
						g_warning ("engine.vala:352: SQL error: %d, %s\n", rc, _tmp138_);
						result = (guint32) 0;
						return result;
					}
					_tmp139_ = retrieval_stmt;
					result = (guint32) sqlite3_column_int (_tmp139_, 0);
					return result;
				}
			}
		}
	}
	_tmp140_ = zeitgeist_event_get_interpretation (event);
	_tmp141_ = _tmp140_;
	if (g_strcmp0 (_tmp141_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
		zeitgeist_engine_handle_move_event (self, event);
	}
	_tmp142_ = zeitgeist_event_get_id (event);
	_tmp143_ = _tmp142_;
	if ((_tmp143_ % 1000) == ((guint32) 0)) {
		ZeitgeistSQLiteDatabase* _tmp144_;
		ZeitgeistSQLiteDatabase* _tmp145_;
		_tmp144_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp145_ = _tmp144_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, (GSourceFunc) zeitgeist_sq_lite_database_analyze, g_object_ref (_tmp145_), g_object_unref);
	}
	_tmp146_ = zeitgeist_event_get_id (event);
	_tmp147_ = _tmp146_;
	result = _tmp147_;
	return result;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

ZeitgeistTimeRange*
zeitgeist_engine_delete_events (ZeitgeistEngine* self,
                                guint32* event_ids,
                                gint event_ids_length1,
                                const char* sender,
                                GError** error)
{
	ZeitgeistExtensionCollection* _tmp0_;
	gint _tmp1_ = 0;
	guint32* _tmp2_;
	ZeitgeistTimeRange* time_range = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistTimeRange* _tmp5_;
	gchar* sql_event_ids = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp7_;
	gchar* _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	gint rc = 0;
	sqlite3* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	ZeitgeistSQLiteDatabase* _tmp18_;
	ZeitgeistSQLiteDatabase* _tmp19_;
	sqlite3* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ZeitgeistExtensionCollection* _tmp23_;
	GError* _inner_error0_ = NULL;
	ZeitgeistTimeRange* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (event_ids_length1 > 0, "event_ids.length > 0", NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_call_pre_delete_events (_tmp0_, event_ids, (gint) event_ids_length1, sender, &_tmp1_);
	event_ids = _tmp2_;
	event_ids_length1 = _tmp1_;
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_sq_lite_database_get_time_range_for_event_ids (_tmp4_, event_ids, (gint) event_ids_length1, &_inner_error0_);
	time_range = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp7_, event_ids, (gint) event_ids_length1);
	sql_event_ids = _tmp8_;
	_tmp9_ = time_range;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = sql_event_ids;
		_tmp11_ = g_strdup_printf ("Tried to delete non-existing event(s): %s", _tmp10_);
		_tmp12_ = _tmp11_;
		g_warning ("engine.vala:385: %s", _tmp12_);
		_g_free0 (_tmp12_);
		result = NULL;
		_g_free0 (sql_event_ids);
		_g_object_unref0 (time_range);
		return result;
	}
	_tmp13_ = ((ZeitgeistDbReader*) self)->db;
	_tmp14_ = sql_event_ids;
	_tmp15_ = g_strdup_printf ("DELETE FROM event WHERE id IN (%s)", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _sqlite3_exec (_tmp13_, _tmp16_, NULL, NULL, NULL);
	_g_free0 (_tmp16_);
	rc = _tmp17_;
	_tmp18_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp19_ = _tmp18_;
	zeitgeist_sq_lite_database_assert_query_success (_tmp19_, rc, "engine.vala:392: SQL Error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			return NULL;
		} else {
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = ((ZeitgeistDbReader*) self)->db;
	_tmp21_ = g_strdup_printf ("Deleted %d (out of %d) events.", sqlite3_changes (_tmp20_), event_ids_length1);
	_tmp22_ = _tmp21_;
	g_message ("engine.vala:393: %s", _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->extension_collection;
	zeitgeist_extension_collection_call_post_delete_events (_tmp23_, event_ids, (gint) event_ids_length1, sender);
	result = time_range;
	_g_free0 (sql_event_ids);
	return result;
}

/**
     * Clear all resources Engine is using (close database connection,
     * unload extensions, etc.).
     *
     * After executing this method on an Engine instance, no other function
     * of said instance may be called.
     */
static void
zeitgeist_engine_real_close (ZeitgeistDbReader* base)
{
	ZeitgeistEngine * self;
	self = (ZeitgeistEngine*) base;
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = NULL;
	ZEITGEIST_DB_READER_CLASS (zeitgeist_engine_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader));
}

static void
zeitgeist_engine_handle_move_event (ZeitgeistEngine* self,
                                    ZeitgeistEvent* event)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ZeitgeistSubject* subject = NULL;
				GPtrArray* _tmp6_;
				GPtrArray* _tmp7_;
				gconstpointer _tmp8_;
				ZeitgeistSubject* _tmp9_;
				gint rc = 0;
				sqlite3_stmt* move_stmt = NULL;
				ZeitgeistSQLiteDatabase* _tmp10_;
				ZeitgeistSQLiteDatabase* _tmp11_;
				sqlite3_stmt* _tmp12_;
				sqlite3_stmt* _tmp13_;
				sqlite3_stmt* _tmp14_;
				ZeitgeistSubject* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				GDestroyNotify _tmp19_;
				sqlite3_stmt* _tmp20_;
				ZeitgeistSubject* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				GDestroyNotify _tmp25_;
				sqlite3_stmt* _tmp26_;
				ZeitgeistSubject* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				GDestroyNotify _tmp31_;
				sqlite3_stmt* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				GDestroyNotify _tmp36_;
				sqlite3_stmt* _tmp37_;
				gint64 _tmp38_;
				gint64 _tmp39_;
				sqlite3_stmt* _tmp40_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = zeitgeist_event_get_subjects (event);
				_tmp3_ = _tmp2_;
				_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = zeitgeist_event_get_subjects (event);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_ptr_array_index (_tmp7_, (guint) i);
				_tmp9_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp8_);
				subject = _tmp9_;
				_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_->move_handling_stmt;
				move_stmt = _tmp12_;
				_tmp13_ = move_stmt;
				sqlite3_reset (_tmp13_);
				_tmp14_ = move_stmt;
				_tmp15_ = subject;
				_tmp16_ = zeitgeist_subject_get_current_uri (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup (_tmp17_);
				_tmp19_ = g_free;
				sqlite3_bind_text (_tmp14_, 1, _tmp18_, -1, _tmp19_);
				_tmp20_ = move_stmt;
				_tmp21_ = subject;
				_tmp22_ = zeitgeist_subject_get_current_origin (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strdup (_tmp23_);
				_tmp25_ = g_free;
				sqlite3_bind_text (_tmp20_, 2, _tmp24_, -1, _tmp25_);
				_tmp26_ = move_stmt;
				_tmp27_ = subject;
				_tmp28_ = zeitgeist_subject_get_uri (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup (_tmp29_);
				_tmp31_ = g_free;
				sqlite3_bind_text (_tmp26_, 3, _tmp30_, -1, _tmp31_);
				_tmp32_ = move_stmt;
				_tmp33_ = zeitgeist_event_get_interpretation (event);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup (_tmp34_);
				_tmp36_ = g_free;
				sqlite3_bind_text (_tmp32_, 4, _tmp35_, -1, _tmp36_);
				_tmp37_ = move_stmt;
				_tmp38_ = zeitgeist_event_get_timestamp (event);
				_tmp39_ = _tmp38_;
				sqlite3_bind_int64 (_tmp37_, 5, _tmp39_);
				_tmp40_ = move_stmt;
				rc = sqlite3_step (_tmp40_);
				if (rc != SQLITE_DONE) {
					if (rc != SQLITE_CONSTRAINT) {
						sqlite3* _tmp43_;
						const gchar* _tmp44_;
						{
							ZeitgeistSQLiteDatabase* _tmp41_;
							ZeitgeistSQLiteDatabase* _tmp42_;
							_tmp41_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
							_tmp42_ = _tmp41_;
							zeitgeist_sq_lite_database_assert_not_corrupt (_tmp42_, rc, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
									goto __catch0_zeitgeist_engine_error;
								}
								_g_object_unref0 (subject);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
						goto __finally0;
						__catch0_zeitgeist_engine_error:
						{
							g_clear_error (&_inner_error0_);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (subject);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp43_ = ((ZeitgeistDbReader*) self)->db;
						_tmp44_ = sqlite3_errmsg (_tmp43_);
						g_warning ("engine.vala:439: SQL error: %d, %s\n", rc, _tmp44_);
					}
				}
				_g_object_unref0 (subject);
			}
		}
	}
}

static gint64
zeitgeist_engine_store_payload (ZeitgeistEngine* self,
                                ZeitgeistEvent* event)
{
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event != NULL, 0LL);
	_tmp0_ = zeitgeist_event_get_payload (event);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gint rc = 0;
		sqlite3_stmt* payload_insertion_stmt = NULL;
		ZeitgeistSQLiteDatabase* _tmp2_;
		ZeitgeistSQLiteDatabase* _tmp3_;
		sqlite3_stmt* _tmp4_;
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* _tmp6_;
		GByteArray* _tmp7_;
		GByteArray* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		GByteArray* _tmp10_;
		GByteArray* _tmp11_;
		guint8* _tmp12_;
		gint _tmp12__length1;
		sqlite3_stmt* _tmp13_;
		ZeitgeistSQLiteDatabase* _tmp20_;
		ZeitgeistSQLiteDatabase* _tmp21_;
		sqlite3* _tmp22_;
		_tmp2_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->payload_insertion_stmt;
		payload_insertion_stmt = _tmp4_;
		_tmp5_ = payload_insertion_stmt;
		sqlite3_reset (_tmp5_);
		_tmp6_ = payload_insertion_stmt;
		_tmp7_ = zeitgeist_event_get_payload (event);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->data;
		_tmp9__length1 = _tmp8_->len;
		_tmp10_ = zeitgeist_event_get_payload (event);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_->data;
		_tmp12__length1 = _tmp11_->len;
		sqlite3_bind_blob (_tmp6_, 1, _tmp9_, _tmp12__length1, NULL);
		_tmp13_ = payload_insertion_stmt;
		rc = sqlite3_step (_tmp13_);
		if (rc != SQLITE_DONE) {
			if (rc != SQLITE_CONSTRAINT) {
				sqlite3* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = ((ZeitgeistDbReader*) self)->db;
				_tmp15_ = sqlite3_errmsg (_tmp14_);
				g_warning ("engine.vala:464: SQL error: %d, %s\n", rc, _tmp15_);
				{
					ZeitgeistSQLiteDatabase* _tmp16_;
					ZeitgeistSQLiteDatabase* _tmp17_;
					_tmp16_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp17_ = _tmp16_;
					zeitgeist_sq_lite_database_assert_not_corrupt (_tmp17_, rc, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gint64 _tmp18_ = -1LL;
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							goto __catch0_zeitgeist_engine_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp18_;
					}
				}
				goto __finally0;
				__catch0_zeitgeist_engine_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint64 _tmp19_ = -1LL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp19_;
				}
			}
		}
		_tmp20_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_->database;
		result = sqlite3_last_insert_rowid (_tmp22_);
		return result;
	}
	result = (gint64) 0;
	return result;
}

static inline gpointer
zeitgeist_engine_data_inserter_get_instance_private (ZeitgeistEngineDataInserter* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistEngineDataInserter_private_offset);
}

static ZeitgeistEngineDataInserter*
zeitgeist_engine_data_inserter_construct (GType object_type,
                                          ZeitgeistSQLiteDatabase* db,
                                          const gchar* data_type)
{
	ZeitgeistEngineDataInserter* self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	self = (ZeitgeistEngineDataInserter*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (db);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	_tmp1_ = g_strdup (data_type);
	_g_free0 (self->priv->type);
	self->priv->type = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->data);
	self->priv->data = _tmp2_;
	return self;
}

static ZeitgeistEngineDataInserter*
zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db,
                                    const gchar* data_type)
{
	return zeitgeist_engine_data_inserter_construct (ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, db, data_type);
}

static void
zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self,
                                    const gchar* val,
                                    GError** error)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS) {
		zeitgeist_engine_data_inserter_flush (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp3_ = self->priv->data;
	_tmp4_ = g_strdup (val);
	g_ptr_array_add (_tmp3_, _tmp4_);
}

static void
zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self,
                                      GError** error)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		ZeitgeistSQLiteDatabase* _tmp3_;
		const gchar* _tmp4_;
		GPtrArray* _tmp5_;
		GPtrArray* _tmp6_;
		_tmp3_ = self->priv->database;
		_tmp4_ = self->priv->type;
		_tmp5_ = self->priv->data;
		zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp3_, _tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->data);
		self->priv->data = _tmp6_;
	}
}

static void
zeitgeist_engine_value_data_inserter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
zeitgeist_engine_value_data_inserter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		zeitgeist_engine_data_inserter_unref (value->data[0].v_pointer);
	}
}

static void
zeitgeist_engine_value_data_inserter_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
zeitgeist_engine_value_data_inserter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
zeitgeist_engine_value_data_inserter_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ZeitgeistEngineDataInserter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
zeitgeist_engine_value_data_inserter_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ZeitgeistEngineDataInserter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
zeitgeist_engine_param_spec_data_inserter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ZeitgeistEngineParamSpecDataInserter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
zeitgeist_engine_value_get_data_inserter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	return value->data[0].v_pointer;
}

static void
zeitgeist_engine_value_set_data_inserter (GValue* value,
                                          gpointer v_object)
{
	ZeitgeistEngineDataInserter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}

static void
zeitgeist_engine_value_take_data_inserter (GValue* value,
                                           gpointer v_object)
{
	ZeitgeistEngineDataInserter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}

static void
zeitgeist_engine_data_inserter_class_init (ZeitgeistEngineDataInserterClass * klass,
                                           gpointer klass_data)
{
	zeitgeist_engine_data_inserter_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistEngineDataInserterClass *) klass)->finalize = zeitgeist_engine_data_inserter_finalize;
	g_type_class_adjust_private_offset (klass, &ZeitgeistEngineDataInserter_private_offset);
}

static void
zeitgeist_engine_data_inserter_instance_init (ZeitgeistEngineDataInserter * self,
                                              gpointer klass)
{
	self->priv = zeitgeist_engine_data_inserter_get_instance_private (self);
	self->ref_count = 1;
}

static void
zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter * obj)
{
	ZeitgeistEngineDataInserter * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->data;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		g_warning ("engine.vala:200: DataInserter: destroyed with unflushed data");
	}
	_g_object_unref0 (self->priv->database);
	_g_free0 (self->priv->type);
	_g_ptr_array_unref0 (self->priv->data);
}

static GType
zeitgeist_engine_data_inserter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { zeitgeist_engine_value_data_inserter_init, zeitgeist_engine_value_data_inserter_free_value, zeitgeist_engine_value_data_inserter_copy_value, zeitgeist_engine_value_data_inserter_peek_pointer, "p", zeitgeist_engine_value_data_inserter_collect_value, "p", zeitgeist_engine_value_data_inserter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineDataInserterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_data_inserter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngineDataInserter), 0, (GInstanceInitFunc) zeitgeist_engine_data_inserter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType zeitgeist_engine_data_inserter_type_id;
	zeitgeist_engine_data_inserter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistEngineDataInserter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ZeitgeistEngineDataInserter_private_offset = g_type_add_instance_private (zeitgeist_engine_data_inserter_type_id, sizeof (ZeitgeistEngineDataInserterPrivate));
	return zeitgeist_engine_data_inserter_type_id;
}

static GType
zeitgeist_engine_data_inserter_get_type (void)
{
	static volatile gsize zeitgeist_engine_data_inserter_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_engine_data_inserter_type_id__once)) {
		GType zeitgeist_engine_data_inserter_type_id;
		zeitgeist_engine_data_inserter_type_id = zeitgeist_engine_data_inserter_get_type_once ();
		g_once_init_leave (&zeitgeist_engine_data_inserter_type_id__once, zeitgeist_engine_data_inserter_type_id);
	}
	return zeitgeist_engine_data_inserter_type_id__once;
}

static gpointer
zeitgeist_engine_data_inserter_ref (gpointer instance)
{
	ZeitgeistEngineDataInserter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
zeitgeist_engine_data_inserter_unref (gpointer instance)
{
	ZeitgeistEngineDataInserter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
zeitgeist_engine_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEngine * self;
	ZeitgeistExtensionStore* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	parent_class = G_OBJECT_CLASS (zeitgeist_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_tmp0_ = zeitgeist_extension_store_new (self);
	_g_object_unref0 (self->extension_store);
	self->extension_store = _tmp0_;
	_tmp1_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp2_ = _tmp1_;
	zeitgeist_sq_lite_database_set_cache_size (_tmp2_, 24);
	return obj;
}

static void
zeitgeist_engine_class_init (ZeitgeistEngineClass * klass,
                             gpointer klass_data)
{
	zeitgeist_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistEngine_private_offset);
	((ZeitgeistDbReaderClass *) klass)->close = (void (*) (ZeitgeistDbReader*)) zeitgeist_engine_real_close;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_engine_finalize;
}

static void
zeitgeist_engine_instance_init (ZeitgeistEngine * self,
                                gpointer klass)
{
	self->priv = zeitgeist_engine_get_instance_private (self);
}

static void
zeitgeist_engine_finalize (GObject * obj)
{
	ZeitgeistEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_g_object_unref0 (self->extension_store);
	_g_object_unref0 (self->priv->extension_collection);
	G_OBJECT_CLASS (zeitgeist_engine_parent_class)->finalize (obj);
}

static GType
zeitgeist_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngine), 0, (GInstanceInitFunc) zeitgeist_engine_instance_init, NULL };
	GType zeitgeist_engine_type_id;
	zeitgeist_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_DB_READER, "ZeitgeistEngine", &g_define_type_info, 0);
	ZeitgeistEngine_private_offset = g_type_add_instance_private (zeitgeist_engine_type_id, sizeof (ZeitgeistEnginePrivate));
	return zeitgeist_engine_type_id;
}

GType
zeitgeist_engine_get_type (void)
{
	static volatile gsize zeitgeist_engine_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_engine_type_id__once)) {
		GType zeitgeist_engine_type_id;
		zeitgeist_engine_type_id = zeitgeist_engine_get_type_once ();
		g_once_init_leave (&zeitgeist_engine_type_id__once, zeitgeist_engine_type_id);
	}
	return zeitgeist_engine_type_id__once;
}

