/* result-set.c generated by valac 0.56.16, the Vala compiler
 * generated from result-set.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2009 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-datamodel.h"
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static GType zeitgeist_result_set_get_type_once (void);

/**
     * Get the number of #ZeitgeistEvent<!-- -->s held in a #ZeitgeistResultSet.
     * Unlike the number obtained from zeitgeist_result_set_estimated_matches() the
     * size of the result set is always equal to the number of times you can call
     * zeitgeist_result_set_next().
     *
     * @return The number of events held in the result set
     */
guint
zeitgeist_result_set_size (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->size) {
		return _iface_->size (self);
	}
	return 0U;
}

/**
     * Get the total number of matches that would have been for the query
     * that generated the result set had it not been restricted in size.
     * For FTS the number of matches is estimated.
     *
     * For zeitgeist_log_find_events() and zeitgeist_log_get_events() this will
     * always be the same as zeitgeist_result_set_size(). For cases like
     * zeitgeist_index_search() where you specify a subset of the hits to retrieve
     * the estimated match count will often be bigger than the result set size.
     *
     * @return The number of events that matched the query
     */
guint
zeitgeist_result_set_estimated_matches (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->estimated_matches) {
		return _iface_->estimated_matches (self);
	}
	return 0U;
}

/**
     * Get the current event from the result set and advance the cursor. To
     * ensure that calls to this method will succeed you can call
     * zeitgeist_result_set_has_next().
     *
     * @return The #ZeitgeistEvent at the current cursor position, or NULL
     *         if there are no events left.
     */
ZeitgeistEvent*
zeitgeist_result_set_next_value (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->next_value) {
		return _iface_->next_value (self);
	}
	return NULL;
}

/**
     * Check if a call to zeitgeist_result_set_next() will succeed.
     *
     * @return TRUE if and only if more events can be retrieved
     *         by calling zeitgeist_result_set_next()
     */
gboolean
zeitgeist_result_set_has_next (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->has_next) {
		return _iface_->has_next (self);
	}
	return FALSE;
}

/**
     * Get the current position of the cursor.
     *
     * @return The current position of the cursor
     */
guint
zeitgeist_result_set_tell (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->tell) {
		return _iface_->tell (self);
	}
	return 0U;
}

/**
     * Resets the result set to start iterating it again from scratch.
     *
     */
void
zeitgeist_result_set_reset (ZeitgeistResultSet* self)
{
	ZeitgeistResultSetIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ZEITGEIST_RESULT_SET_GET_INTERFACE (self);
	if (_iface_->reset) {
		_iface_->reset (self);
	}
}

/**
     * Do not use this method! It is only for use by Vala.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistResultSet*
zeitgeist_result_set_iterator (ZeitgeistResultSet* self)
{
	ZeitgeistResultSet* _tmp0_;
	ZeitgeistResultSet* result;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

static void
zeitgeist_result_set_default_init (ZeitgeistResultSetIface * iface,
                                   gpointer iface_data)
{
}

/**
 * Cursor-like interface for results sets
 *
 * include: zeitgeist.h
 *
 * Interface for results returned by zeitgeist_log_find_events(),
 * zeitgeist_log_get_events(), and zeitgeist_index_search().
 *
 * This interface utilizes a cursor-like metaphor. You advance the cursor
 * by calling zeitgeist_result_set_next() or adjust it manually by calling
 * zeitgeist_result_set_seek().
 *
 * Calling zeitgeist_result_set_next() will also return the event at the
 * current cursor position. You may retrieve the current event without advancing
 * the cursor by calling zeitgeist_result_set_peek().
 *
 */
static GType
zeitgeist_result_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistResultSetIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_result_set_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType zeitgeist_result_set_type_id;
	zeitgeist_result_set_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistResultSet", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_result_set_type_id, G_TYPE_OBJECT);
	return zeitgeist_result_set_type_id;
}

GType
zeitgeist_result_set_get_type (void)
{
	static volatile gsize zeitgeist_result_set_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_result_set_type_id__once)) {
		GType zeitgeist_result_set_type_id;
		zeitgeist_result_set_type_id = zeitgeist_result_set_get_type_once ();
		g_once_init_leave (&zeitgeist_result_set_type_id__once, zeitgeist_result_set_type_id);
	}
	return zeitgeist_result_set_type_id__once;
}

