/* mimetype.c generated by valac 0.56.16, the Vala compiler
 * generated from mimetype.vala, do not modify */

/* mimetype.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2010 Canonical, Ltd.
 *             By Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _ZeitgeistMimeRegex ZeitgeistMimeRegex;
typedef struct _ZeitgeistUriScheme ZeitgeistUriScheme;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _zeitgeist_mime_regex_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_mime_regex_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _zeitgeist_uri_scheme_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_uri_scheme_free (var), NULL)))

struct _ZeitgeistMimeRegex {
	GRegex* regex;
	gchar* interpretation_uri;
};

struct _ZeitgeistUriScheme {
	gchar* uri_scheme;
	gchar* manifestation_uri;
};

VALA_EXTERN gboolean zeitgeist_mimetypes_loaded;
gboolean zeitgeist_mimetypes_loaded = FALSE;
VALA_EXTERN gboolean zeitgeist_schemes_loaded;
gboolean zeitgeist_schemes_loaded = FALSE;
VALA_EXTERN GHashTable* zeitgeist_mimetypes;
GHashTable* zeitgeist_mimetypes = NULL;
VALA_EXTERN GSList* zeitgeist_mimetypes_regexs;
GSList* zeitgeist_mimetypes_regexs = NULL;
VALA_EXTERN GSList* zeitgeist_schemes;
GSList* zeitgeist_schemes = NULL;

VALA_EXTERN void zeitgeist_mime_regex_free (ZeitgeistMimeRegex * self);
VALA_EXTERN void zeitgeist_uri_scheme_free (ZeitgeistUriScheme * self);
static void zeitgeist_mime_regex_instance_init (ZeitgeistMimeRegex * self);
VALA_EXTERN ZeitgeistMimeRegex* zeitgeist_mime_regex_new (const gchar* mimetype_regex,
                                              const gchar* interpretation_uri,
                                              GError** error);
static void zeitgeist_uri_scheme_instance_init (ZeitgeistUriScheme * self);
VALA_EXTERN ZeitgeistUriScheme* zeitgeist_uri_scheme_new (const gchar* uri_scheme,
                                              const gchar* manifestation_uri);
static void _g_free0_ (gpointer var);
VALA_EXTERN void zeitgeist_ensure_mimetypes_loaded (void);
VALA_EXTERN void zeitgeist_ensure_schemes_loaded (void);

ZeitgeistMimeRegex*
zeitgeist_mime_regex_new (const gchar* mimetype_regex,
                          const gchar* interpretation_uri,
                          GError** error)
{
	ZeitgeistMimeRegex* self;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (mimetype_regex != NULL, NULL);
	g_return_val_if_fail (interpretation_uri != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMimeRegex);
	zeitgeist_mime_regex_instance_init (self);
	_tmp1_ = g_regex_new (mimetype_regex, 0, 0, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_zeitgeist_mime_regex_free0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_regex_unref0 (self->regex);
	self->regex = _tmp2_;
	_tmp3_ = g_strdup (interpretation_uri);
	_g_free0 (self->interpretation_uri);
	self->interpretation_uri = _tmp3_;
	_g_regex_unref0 (_tmp0_);
	return self;
}

static void
zeitgeist_mime_regex_instance_init (ZeitgeistMimeRegex * self)
{
}

void
zeitgeist_mime_regex_free (ZeitgeistMimeRegex * self)
{
	_g_regex_unref0 (self->regex);
	_g_free0 (self->interpretation_uri);
	g_slice_free (ZeitgeistMimeRegex, self);
}

ZeitgeistUriScheme*
zeitgeist_uri_scheme_new (const gchar* uri_scheme,
                          const gchar* manifestation_uri)
{
	ZeitgeistUriScheme* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (uri_scheme != NULL, NULL);
	g_return_val_if_fail (manifestation_uri != NULL, NULL);
	self = g_slice_new0 (ZeitgeistUriScheme);
	zeitgeist_uri_scheme_instance_init (self);
	_tmp0_ = g_strdup (uri_scheme);
	_g_free0 (self->uri_scheme);
	self->uri_scheme = _tmp0_;
	_tmp1_ = g_strdup (manifestation_uri);
	_g_free0 (self->manifestation_uri);
	self->manifestation_uri = _tmp1_;
	return self;
}

static void
zeitgeist_uri_scheme_instance_init (ZeitgeistUriScheme * self)
{
}

void
zeitgeist_uri_scheme_free (ZeitgeistUriScheme * self)
{
	_g_free0 (self->uri_scheme);
	_g_free0 (self->manifestation_uri);
	g_slice_free (ZeitgeistUriScheme, self);
}

/**
     * zeitgeist_register_mimetype:
     *
     * Associate a MIME-type with a given interpretation type. Registered
     * MIME-types can be looked up with zeitgeist_interpretation_for_mimetype().
     *
     * You can register a regular expression as mimetype if instead of this
     * function you invoke zeitgeist_register_mimetype_regex().
     *
     * MIME-types are first looked up by their exact name and then if none is
     * found the regular expressions will be checked as fallbacks.
     *
     * This library will install a wide range a common mimetypes for you, so
     * unless you have very specific needs you will normally not have to call
     * this function.
     *
     * @param mimetype  A MIME-type string. Eg. //text/plain//
     * @param interpretation_uri A URI defining the subject interpretation
     *     type to associate with "mimetype"
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

void
zeitgeist_register_mimetype (const gchar* mimetype,
                             const gchar* interpretation_uri)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (mimetype != NULL);
	g_return_if_fail (interpretation_uri != NULL);
	_tmp0_ = zeitgeist_mimetypes;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (zeitgeist_mimetypes);
		zeitgeist_mimetypes = _tmp3_;
	}
	_tmp4_ = zeitgeist_mimetypes;
	_tmp5_ = g_strdup (mimetype);
	_tmp6_ = g_strdup (interpretation_uri);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp6_);
}

/**
     * zeitgeist_register_mimetype_regex:
     *
     * Associate a range of MIME-types with a given interpretation type.
     * Registered MIME-types can be looked up with
     * zeitgeist_interpretation_for_mimetype().
     *
     * If you only need to register one specific MIME-type, it is more efficient
     * to use zeitgeist_register_mimetype() instead of this function.
     *
     * MIME-types are first looked up by their exact name and then if none is
     * found the regular expressions will be checked as fallbacks.
     *
     * This library will install a wide range a common mimetypes for you, so
     * unless you have very specific needs you will normally not have to call
     * this function.
     *
     * @param mimetype_regex A regular expression matching a certain range of
     *     mimetypes. Eg. //text/.* // to match all //text// subtypes.
     * @param interpretation_uri A URI defining the subject interpretation
     *     type to associate with the matched MIME-types
     */
void
zeitgeist_register_mimetype_regex (const gchar* mimetype_regex,
                                   const gchar* interpretation_uri)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (mimetype_regex != NULL);
	g_return_if_fail (interpretation_uri != NULL);
	{
		ZeitgeistMimeRegex* entry = NULL;
		ZeitgeistMimeRegex* _tmp0_;
		ZeitgeistMimeRegex* _tmp1_;
		_tmp0_ = zeitgeist_mime_regex_new (mimetype_regex, interpretation_uri, &_inner_error0_);
		entry = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = entry;
		entry = NULL;
		zeitgeist_mimetypes_regexs = g_slist_append (zeitgeist_mimetypes_regexs, _tmp1_);
		_zeitgeist_mime_regex_free0 (entry);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("mimetype.vala:124: Couldn't register mimetype regex: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * zeitgeist_interpretation_for_mimetype:
     *
     * Look up the subject interpretation type associated with @mimetype.
     *
     * @param mimetype A MIME-type string. Eg. //text/plain//
     *
     * @return A URI defining the subject interpretation type associated with
     *     "mimetype" or %NULL in case "mimetype" is unknown
     */
const gchar*
zeitgeist_interpretation_for_mimetype (const gchar* mimetype)
{
	const gchar* interpretation = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	GSList* _tmp4_;
	const gchar* result;
	zeitgeist_ensure_mimetypes_loaded ();
	if (mimetype == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = zeitgeist_mimetypes;
	_tmp1_ = g_hash_table_lookup (_tmp0_, mimetype);
	interpretation = (const gchar*) _tmp1_;
	_tmp2_ = interpretation;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = interpretation;
		result = _tmp3_;
		return result;
	}
	_tmp4_ = zeitgeist_mimetypes_regexs;
	{
		GSList* mime_regex_collection = NULL;
		GSList* mime_regex_it = NULL;
		mime_regex_collection = _tmp4_;
		for (mime_regex_it = mime_regex_collection; mime_regex_it != NULL; mime_regex_it = mime_regex_it->next) {
			ZeitgeistMimeRegex* mime_regex = NULL;
			mime_regex = (ZeitgeistMimeRegex*) mime_regex_it->data;
			{
				ZeitgeistMimeRegex* _tmp5_;
				GRegex* _tmp6_;
				_tmp5_ = mime_regex;
				_tmp6_ = _tmp5_->regex;
				if (g_regex_match (_tmp6_, mimetype, 0, NULL)) {
					ZeitgeistMimeRegex* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = mime_regex;
					_tmp8_ = _tmp7_->interpretation_uri;
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

/**
     * zeitgeist_register_uri_scheme:
     *
     * Associate a URI scheme with a given subject manifestation type.
     * You can find the manifestation type of a given URI by passing it to
     * zeitgeist_manifestation_for_uri().
     *
     * This library will install a range a common URI schemes for you, so unless
     * you have very specific needs you will normally not have to call this
     * function.
     *
     * @param uri_scheme A URI scheme such as //http:\/\///
     * @param manifestation_type A URI defining the subject manifestation type
     *     to associate with "uri_scheme"
     */
void
zeitgeist_register_uri_scheme (const gchar* uri_scheme,
                               const gchar* manifestation_type)
{
	ZeitgeistUriScheme* scheme = NULL;
	ZeitgeistUriScheme* _tmp0_;
	ZeitgeistUriScheme* _tmp1_;
	g_return_if_fail (uri_scheme != NULL);
	g_return_if_fail (manifestation_type != NULL);
	_tmp0_ = zeitgeist_uri_scheme_new (uri_scheme, manifestation_type);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	scheme = NULL;
	zeitgeist_schemes = g_slist_append (zeitgeist_schemes, _tmp1_);
	_zeitgeist_uri_scheme_free0 (scheme);
}

/**
     * zeitgeist_manifestation_for_uri
     *
     * Look up a subject manifestation type for a given URI. Eg. if you pass in
     * //file:\/\/\/tmp/foo.txt// you will get back
     * ZEITGEIST_NFO_FILE_DATA_OBJECT.
     *
     * @param uri An URI
     *
     * @return A subject manifestation type for @uri or %NULL in case no
     *     suitable manifestation type is known
     */
const gchar*
zeitgeist_manifestation_for_uri (const gchar* uri)
{
	GSList* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	zeitgeist_ensure_schemes_loaded ();
	_tmp0_ = zeitgeist_schemes;
	{
		GSList* scheme_collection = NULL;
		GSList* scheme_it = NULL;
		scheme_collection = _tmp0_;
		for (scheme_it = scheme_collection; scheme_it != NULL; scheme_it = scheme_it->next) {
			ZeitgeistUriScheme* scheme = NULL;
			scheme = (ZeitgeistUriScheme*) scheme_it->data;
			{
				ZeitgeistUriScheme* _tmp1_;
				const gchar* _tmp2_;
				_tmp1_ = scheme;
				_tmp2_ = _tmp1_->uri_scheme;
				if (g_str_has_prefix (uri, _tmp2_)) {
					ZeitgeistUriScheme* _tmp3_;
					const gchar* _tmp4_;
					_tmp3_ = scheme;
					_tmp4_ = _tmp3_->manifestation_uri;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
zeitgeist_ensure_mimetypes_loaded (void)
{
	if (zeitgeist_mimetypes_loaded) {
		return;
	}
	zeitgeist_register_mimetype ("application/ecmascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/json", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/ms-excel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/ms-powerpoint", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/msexcel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/msword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/ogg", ZEITGEIST_NFO_AUDIO);
	zeitgeist_register_mimetype ("application/pdf", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/postscript", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/ps", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/rtf", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/soap+xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/vnd.corel-draw", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("application/vnd.ms-excel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/vnd.ms-powerpoint", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-7z-compressed", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-abiword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-applix-presents", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-applix-spreadsheet", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-applix-word", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-archive", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-bzip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-bzip-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-cd-image", ZEITGEIST_NFO_FILESYSTEM_IMAGE);
	zeitgeist_register_mimetype ("application/x-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-csh", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-deb", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-designer", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-desktop", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-dia-diagram", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-executable", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-fluid", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-glade", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-gnucash", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-gnumeric", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-gzip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-java-archive", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-killustrator", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("application/x-kpresenter", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-kspread", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-kword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-lzma", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-lzma-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-m4", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-ms-dos-executable", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-perl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-php", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-rpm", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-ruby", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-shellscript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-shockwave-flash", ZEITGEIST_NFO_EXECUTABLE);
	zeitgeist_register_mimetype ("application/x-sql", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-stuffit", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/xhtml+xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/xml-dtd", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/zip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("audio/x-scpls", ZEITGEIST_NFO_MEDIA_LIST);
	zeitgeist_register_mimetype ("image/gif", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/jpeg", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/pjpeg", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/png", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/svg+xml", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("image/tiff", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/vnd.microsoft.icon", ZEITGEIST_NFO_ICON);
	zeitgeist_register_mimetype ("image/x-xcf", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("inode/directory", ZEITGEIST_NFO_FOLDER);
	zeitgeist_register_mimetype ("message/alternative", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("message/partial", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("message/related", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("text/css", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/csv", ZEITGEIST_NFO_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("text/html", ZEITGEIST_NFO_HTML_DOCUMENT);
	zeitgeist_register_mimetype ("text/javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/plain", ZEITGEIST_NFO_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("text/vcard", ZEITGEIST_NCO_CONTACT);
	zeitgeist_register_mimetype ("text/x-c", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-c++", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-c++src", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-chdr", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-copying", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-credits", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-csharp", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-csrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-dsrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-eiffel", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-gettext-translation", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-gettext-translation-template", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-haskell", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-idl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-java", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-jquery-tmpl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-latex", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-lisp", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-lua", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-m4", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-makefile", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-objcsrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-ocaml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-pascal", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-patch", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-python", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-sql", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-tcl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-tex", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-troff", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-vala", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-vhdl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype_regex (".*/x-dvi", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd.ms-excel.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.ms-powerpoint.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.graphics.*", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.presentation.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.spreadsheet.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.text.*", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.presentationml.presentat" \
"ion.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.wordprocessingml.documen" \
"t.*", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd\\..*", ZEITGEIST_NFO_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/x-applix-.*", ZEITGEIST_NFO_DOCUMENT);
	zeitgeist_register_mimetype_regex ("audio/.*", ZEITGEIST_NFO_AUDIO);
	zeitgeist_register_mimetype_regex ("image/.*", ZEITGEIST_NFO_IMAGE);
	zeitgeist_register_mimetype_regex ("video/.*", ZEITGEIST_NFO_VIDEO);
	zeitgeist_mimetypes_loaded = TRUE;
}

void
zeitgeist_ensure_schemes_loaded (void)
{
	if (zeitgeist_schemes_loaded) {
		return;
	}
	zeitgeist_register_uri_scheme ("file://", ZEITGEIST_NFO_FILE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("http://", ZEITGEIST_NFO_WEB_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("https://", ZEITGEIST_NFO_WEB_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("ssh://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("sftp://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("ftp://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("dav://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("davs://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("smb://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_schemes_loaded = TRUE;
}

