/* enumerations.c generated by valac 0.56.16, the Vala compiler
 * generated from enumerations.vala, do not modify */

/* enumerations.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *          By Seif Lotfy <seif@lotfy.com>
 *          By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *          By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <gio/gio.h>
#include "zeitgeist-datamodel.h"
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static const GDBusErrorEntry zeitgeist_data_model_error_entries[] = {{ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE, "org.gnome.zeitgeist.DataModelError.InvalidSignature"}, {ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT, "org.gnome.zeitgeist.DataModelError.NullEvent"}, {ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS, "org.gnome.zeitgeist.DataModelError.TooManyResults"}};

GQuark
zeitgeist_data_model_error_quark (void)
{
	static volatile gsize zeitgeist_data_model_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("zeitgeist-data-model-error-quark", &zeitgeist_data_model_error_quark_volatile, zeitgeist_data_model_error_entries, G_N_ELEMENTS (zeitgeist_data_model_error_entries));
	return (GQuark) zeitgeist_data_model_error_quark_volatile;
}

/**
 * ZeitgeistResultType
 *
 * Used to control how the query results are grouped and sorted.
 * See zeitgeist_log_find_events(), zeitgeist_log_find_event_ids(), and
 * zeitgeist_index_search().
 */
/**
     * @param result_type A {@link ResultType}
     *
     * @return true if the results for the given result_type will be sorted
     * ascendantly by date, false if they'll be sorted descendingly.
     */
gboolean
zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type)
{
	gboolean result;
	switch (result_type) {
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			result = TRUE;
			return result;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		case ZEITGEIST_RESULT_TYPE_RELEVANCY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			g_warning ("enumerations.vala:257: Unrecognized ResultType: %u", (guint) result_type);
			result = TRUE;
			return result;
		}
	}
}

static GType
zeitgeist_result_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS", "most-recent-events"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS", "least-recent-events"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS", "most-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS", "least-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS", "most-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS", "least-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR", "most-popular-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR", "least-popular-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR", "most-recent-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR", "least-recent-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN", "most-recent-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN", "least-recent-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN", "most-popular-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN", "least-popular-origin"}, {ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR, "ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR", "oldest-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION", "most-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION", "least-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION", "most-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION", "least-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE", "most-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE", "least-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE", "most-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE", "least-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI", "most-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI", "least-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI", "most-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI", "least-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN", "most-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN", "least-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN", "most-popular-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN", "least-popular-event-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN", "most-recent-current-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN", "least-recent-current-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN", "most-popular-current-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN", "least-popular-current-origin"}, {ZEITGEIST_RESULT_TYPE_RELEVANCY, "ZEITGEIST_RESULT_TYPE_RELEVANCY", "relevancy"}, {0, NULL, NULL}};
	GType zeitgeist_result_type_type_id;
	zeitgeist_result_type_type_id = g_enum_register_static ("ZeitgeistResultType", values);
	return zeitgeist_result_type_type_id;
}

GType
zeitgeist_result_type_get_type (void)
{
	static volatile gsize zeitgeist_result_type_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_result_type_type_id__once)) {
		GType zeitgeist_result_type_type_id;
		zeitgeist_result_type_type_id = zeitgeist_result_type_get_type_once ();
		g_once_init_leave (&zeitgeist_result_type_type_id__once, zeitgeist_result_type_type_id);
	}
	return zeitgeist_result_type_type_id__once;
}

static GType
zeitgeist_relevant_result_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT, "ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT", "recent"}, {ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED, "ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED", "related"}, {0, NULL, NULL}};
	GType zeitgeist_relevant_result_type_type_id;
	zeitgeist_relevant_result_type_type_id = g_enum_register_static ("ZeitgeistRelevantResultType", values);
	return zeitgeist_relevant_result_type_type_id;
}

GType
zeitgeist_relevant_result_type_get_type (void)
{
	static volatile gsize zeitgeist_relevant_result_type_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_relevant_result_type_type_id__once)) {
		GType zeitgeist_relevant_result_type_type_id;
		zeitgeist_relevant_result_type_type_id = zeitgeist_relevant_result_type_get_type_once ();
		g_once_init_leave (&zeitgeist_relevant_result_type_type_id__once, zeitgeist_relevant_result_type_type_id);
	}
	return zeitgeist_relevant_result_type_type_id__once;
}

/**
 * Enumeration class defining the possible values for the storage
 * state of an event subject.
 *
 * The StorageState enumeration can be used to control whether or
 * not matched events must have their subjects available to the user.
 * Fx. not including deleted files, files on unplugged USB drives,
 * files available only when a network is available etc.
 */
static GType
zeitgeist_storage_state_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE, "ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE", "not-available"}, {ZEITGEIST_STORAGE_STATE_AVAILABLE, "ZEITGEIST_STORAGE_STATE_AVAILABLE", "available"}, {ZEITGEIST_STORAGE_STATE_ANY, "ZEITGEIST_STORAGE_STATE_ANY", "any"}, {0, NULL, NULL}};
	GType zeitgeist_storage_state_type_id;
	zeitgeist_storage_state_type_id = g_enum_register_static ("ZeitgeistStorageState", values);
	return zeitgeist_storage_state_type_id;
}

GType
zeitgeist_storage_state_get_type (void)
{
	static volatile gsize zeitgeist_storage_state_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_storage_state_type_id__once)) {
		GType zeitgeist_storage_state_type_id;
		zeitgeist_storage_state_type_id = zeitgeist_storage_state_get_type_once ();
		g_once_init_leave (&zeitgeist_storage_state_type_id__once, zeitgeist_storage_state_type_id);
	}
	return zeitgeist_storage_state_type_id__once;
}

