/* data-source.c generated by valac 0.56.16, the Vala compiler
 * generated from data-source.vala, do not modify */

/* 
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_DATA_SOURCE_0_PROPERTY,
	ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY,
	ZEITGEIST_DATA_SOURCE_NAME_PROPERTY,
	ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY,
	ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY,
	ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY,
	ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY,
	ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY,
	ZEITGEIST_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistDataSourcePrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	GPtrArray* _event_templates;
	gboolean _enabled;
	gboolean _running;
	gint64 _timestamp;
};

static gint ZeitgeistDataSource_private_offset;
static gpointer zeitgeist_data_source_parent_class = NULL;

static void zeitgeist_data_source_finalize (GObject * obj);
static GType zeitgeist_data_source_get_type_once (void);
static void _vala_zeitgeist_data_source_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_zeitgeist_data_source_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _g_object_unref0_ (gpointer var);
static gint __lambda4_ (ZeitgeistDataSource* a,
                 ZeitgeistDataSource* b);
static gint ___lambda4__gcompare_func (gconstpointer a,
                                gconstpointer b);

static inline gpointer
zeitgeist_data_source_get_instance_private (ZeitgeistDataSource* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistDataSource_private_offset);
}

/**
         * ZeitgeistDataSource
         *
         * Abstracts data sources used by the ZeitgeistDataSourceRegistry extension
         * 
         * ZeitgeistDataSource represents a data source used to insert events into
         * Zeitgeist. The data sources are identified using the unique_id property,
         * and when querying the data source registry you get other interesting
         * information like timestamp of the last action of the data source, flag
         * whether it is currently running etc.
         *
         */
ZeitgeistDataSource*
zeitgeist_data_source_construct (GType object_type)
{
	ZeitgeistDataSource * self = NULL;
	self = (ZeitgeistDataSource*) g_object_new (object_type, NULL);
	zeitgeist_data_source_set_enabled (self, TRUE);
	return self;
}

ZeitgeistDataSource*
zeitgeist_data_source_new (void)
{
	return zeitgeist_data_source_construct (ZEITGEIST_TYPE_DATA_SOURCE);
}

ZeitgeistDataSource*
zeitgeist_data_source_construct_full (GType object_type,
                                      const gchar* unique_id,
                                      const gchar* name,
                                      const gchar* description,
                                      GPtrArray* templates)
{
	ZeitgeistDataSource * self = NULL;
	g_return_val_if_fail (unique_id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (ZeitgeistDataSource*) g_object_new (object_type, "unique-id", unique_id, "name", name, "description", description, "event-templates", templates, NULL);
	zeitgeist_data_source_set_enabled (self, TRUE);
	return self;
}

ZeitgeistDataSource*
zeitgeist_data_source_new_full (const gchar* unique_id,
                                const gchar* name,
                                const gchar* description,
                                GPtrArray* templates)
{
	return zeitgeist_data_source_construct_full (ZEITGEIST_TYPE_DATA_SOURCE, unique_id, name, description, templates);
}

ZeitgeistDataSource*
zeitgeist_data_source_construct_from_variant (GType object_type,
                                              GVariant* variant,
                                              gboolean reset_running,
                                              GError** error)
{
	ZeitgeistDataSource * self = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	const gchar* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	GPtrArray* _tmp13_ = NULL;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (variant != NULL, NULL);
	self = (ZeitgeistDataSource*) g_object_new (object_type, NULL);
	_tmp1_ = g_variant_get_type_string (variant);
	if (g_strcmp0 (_tmp1_, "(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = g_variant_get_type_string (variant);
		_tmp0_ = g_strcmp0 (_tmp2_, "sssa(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0;
	}
	g_warn_if_fail (_tmp0_);
	_tmp3_ = g_variant_iter_new (variant);
	iter = _tmp3_;
	_vala_assert (g_variant_iter_n_children (iter) >= ((gsize) 4), "iter.n_children () >= 4");
	_tmp4_ = g_variant_iter_next_value (iter);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_string (_tmp5_, NULL);
	zeitgeist_data_source_set_unique_id (self, _tmp6_);
	_g_variant_unref0 (_tmp5_);
	_tmp7_ = g_variant_iter_next_value (iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_get_string (_tmp8_, NULL);
	zeitgeist_data_source_set_name (self, _tmp9_);
	_g_variant_unref0 (_tmp8_);
	_tmp10_ = g_variant_iter_next_value (iter);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	zeitgeist_data_source_set_description (self, _tmp12_);
	_g_variant_unref0 (_tmp11_);
	_tmp14_ = g_variant_iter_next_value (iter);
	_tmp15_ = _tmp14_;
	_tmp16_ = zeitgeist_events_from_variant (_tmp15_, &_inner_error0_);
	_tmp17_ = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp13_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	zeitgeist_data_source_set_event_templates (self, _tmp13_);
	if (g_variant_iter_n_children (iter) > ((gsize) 4)) {
		GVariant* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		GVariant* _tmp21_;
		GVariant* _tmp22_;
		GVariant* _tmp23_;
		_tmp18_ = g_variant_iter_next_value (iter);
		_tmp19_ = _tmp18_;
		zeitgeist_data_source_set_running (self, g_variant_get_boolean (_tmp19_));
		_g_variant_unref0 (_tmp19_);
		if (reset_running) {
			zeitgeist_data_source_set_running (self, FALSE);
		}
		_tmp20_ = g_variant_iter_next_value (iter);
		_tmp21_ = _tmp20_;
		zeitgeist_data_source_set_timestamp (self, g_variant_get_int64 (_tmp21_));
		_g_variant_unref0 (_tmp21_);
		_tmp22_ = g_variant_iter_next_value (iter);
		_tmp23_ = _tmp22_;
		zeitgeist_data_source_set_enabled (self, g_variant_get_boolean (_tmp23_));
		_g_variant_unref0 (_tmp23_);
	}
	_g_ptr_array_unref0 (_tmp13_);
	_g_variant_iter_free0 (iter);
	return self;
}

ZeitgeistDataSource*
zeitgeist_data_source_new_from_variant (GVariant* variant,
                                        gboolean reset_running,
                                        GError** error)
{
	return zeitgeist_data_source_construct_from_variant (ZEITGEIST_TYPE_DATA_SOURCE, variant, reset_running, error);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

GVariant*
zeitgeist_data_source_to_variant (ZeitgeistDataSource* self)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	const gchar* _tmp5_;
	GVariantBuilder* _tmp6_;
	const gchar* _tmp7_;
	GVariantBuilder* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GPtrArray* _tmp11_;
	GVariantBuilder* _tmp23_;
	gboolean _tmp24_;
	GVariantBuilder* _tmp25_;
	gint64 _tmp26_;
	GVariantBuilder* _tmp27_;
	gboolean _tmp28_;
	GVariantBuilder* _tmp29_;
	GVariant* _tmp30_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = self->priv->_unique_id;
	g_variant_builder_add (_tmp4_, "s", _tmp5_, NULL);
	_tmp6_ = vb;
	_tmp7_ = self->priv->_name;
	g_variant_builder_add (_tmp6_, "s", _tmp7_, NULL);
	_tmp8_ = vb;
	_tmp9_ = self->priv->_description;
	g_variant_builder_add (_tmp8_, "s", _tmp9_, NULL);
	_tmp11_ = self->priv->_event_templates;
	if (_tmp11_ != NULL) {
		GPtrArray* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = self->priv->_event_templates;
		_tmp13_ = vala_g_ptr_array_get_length (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ > 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GVariantBuilder* _tmp15_;
		GPtrArray* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		_tmp15_ = vb;
		_tmp16_ = self->priv->_event_templates;
		_tmp17_ = zeitgeist_events_to_variant (_tmp16_);
		_tmp18_ = _tmp17_;
		g_variant_builder_add_value (_tmp15_, _tmp18_);
		_g_variant_unref0 (_tmp18_);
	} else {
		GVariantBuilder* _tmp19_;
		GVariantType* _tmp20_;
		GVariantType* _tmp21_;
		GVariantBuilder* _tmp22_;
		_tmp19_ = vb;
		_tmp20_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
		_tmp21_ = _tmp20_;
		g_variant_builder_open (_tmp19_, _tmp21_);
		_g_variant_type_free0 (_tmp21_);
		_tmp22_ = vb;
		g_variant_builder_close (_tmp22_);
	}
	_tmp23_ = vb;
	_tmp24_ = self->priv->_running;
	g_variant_builder_add (_tmp23_, "b", _tmp24_, NULL);
	_tmp25_ = vb;
	_tmp26_ = self->priv->_timestamp;
	g_variant_builder_add (_tmp25_, "x", _tmp26_, NULL);
	_tmp27_ = vb;
	_tmp28_ = self->priv->_enabled;
	g_variant_builder_add (_tmp27_, "b", _tmp28_, NULL);
	_tmp29_ = vb;
	_tmp30_ = g_variant_builder_end (_tmp29_);
	g_variant_ref_sink (_tmp30_);
	result = _tmp30_;
	_g_variant_builder_unref0 (vb);
	return result;
}

const gchar*
zeitgeist_data_source_get_unique_id (ZeitgeistDataSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}

void
zeitgeist_data_source_set_unique_id (ZeitgeistDataSource* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_unique_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY]);
	}
}

const gchar*
zeitgeist_data_source_get_name (ZeitgeistDataSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
zeitgeist_data_source_set_name (ZeitgeistDataSource* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NAME_PROPERTY]);
	}
}

const gchar*
zeitgeist_data_source_get_description (ZeitgeistDataSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
zeitgeist_data_source_set_description (ZeitgeistDataSource* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY]);
	}
}

GPtrArray*
zeitgeist_data_source_get_event_templates (ZeitgeistDataSource* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
zeitgeist_data_source_set_event_templates (ZeitgeistDataSource* self,
                                           GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_event_templates (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_event_templates);
		self->priv->_event_templates = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY]);
	}
}

gboolean
zeitgeist_data_source_get_enabled (ZeitgeistDataSource* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enabled;
	return result;
}

void
zeitgeist_data_source_set_enabled (ZeitgeistDataSource* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_enabled (self);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY]);
	}
}

gboolean
zeitgeist_data_source_get_running (ZeitgeistDataSource* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_running;
	return result;
}

void
zeitgeist_data_source_set_running (ZeitgeistDataSource* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_running (self);
	if (old_value != value) {
		self->priv->_running = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY]);
	}
}

gint64
zeitgeist_data_source_get_timestamp (ZeitgeistDataSource* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

void
zeitgeist_data_source_set_timestamp (ZeitgeistDataSource* self,
                                     gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_data_source_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY]);
	}
}

static void
zeitgeist_data_source_class_init (ZeitgeistDataSourceClass * klass,
                                  gpointer klass_data)
{
	zeitgeist_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistDataSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_data_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_data_source_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_data_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_NAME_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY] = g_param_spec_boxed ("event-templates", "event-templates", "event-templates", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY] = g_param_spec_boolean ("running", "running", "running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
zeitgeist_data_source_instance_init (ZeitgeistDataSource * self,
                                     gpointer klass)
{
	self->priv = zeitgeist_data_source_get_instance_private (self);
}

static void
zeitgeist_data_source_finalize (GObject * obj)
{
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_ptr_array_unref0 (self->priv->_event_templates);
	G_OBJECT_CLASS (zeitgeist_data_source_parent_class)->finalize (obj);
}

static GType
zeitgeist_data_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDataSource), 0, (GInstanceInitFunc) zeitgeist_data_source_instance_init, NULL };
	GType zeitgeist_data_source_type_id;
	zeitgeist_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDataSource", &g_define_type_info, 0);
	ZeitgeistDataSource_private_offset = g_type_add_instance_private (zeitgeist_data_source_type_id, sizeof (ZeitgeistDataSourcePrivate));
	return zeitgeist_data_source_type_id;
}

GType
zeitgeist_data_source_get_type (void)
{
	static volatile gsize zeitgeist_data_source_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_data_source_type_id__once)) {
		GType zeitgeist_data_source_type_id;
		zeitgeist_data_source_type_id = zeitgeist_data_source_get_type_once ();
		g_once_init_leave (&zeitgeist_data_source_type_id__once, zeitgeist_data_source_type_id);
	}
	return zeitgeist_data_source_type_id__once;
}

static void
_vala_zeitgeist_data_source_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	switch (property_id) {
		case ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_unique_id (self));
		break;
		case ZEITGEIST_DATA_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_name (self));
		break;
		case ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_description (self));
		break;
		case ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY:
		g_value_set_boxed (value, zeitgeist_data_source_get_event_templates (self));
		break;
		case ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY:
		g_value_set_boolean (value, zeitgeist_data_source_get_enabled (self));
		break;
		case ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY:
		g_value_set_boolean (value, zeitgeist_data_source_get_running (self));
		break;
		case ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, zeitgeist_data_source_get_timestamp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_data_source_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	switch (property_id) {
		case ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY:
		zeitgeist_data_source_set_unique_id (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_NAME_PROPERTY:
		zeitgeist_data_source_set_name (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY:
		zeitgeist_data_source_set_description (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY:
		zeitgeist_data_source_set_event_templates (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY:
		zeitgeist_data_source_set_enabled (self, g_value_get_boolean (value));
		break;
		case ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY:
		zeitgeist_data_source_set_running (self, g_value_get_boolean (value));
		break;
		case ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY:
		zeitgeist_data_source_set_timestamp (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GPtrArray*
zeitgeist_data_sources_from_variant (GVariant* sources_variant,
                                     GError** error)
{
	GPtrArray* sources = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (sources_variant != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	sources = _tmp0_;
	_tmp1_ = g_variant_get_type_string (sources_variant);
	g_warn_if_fail (g_strcmp0 (_tmp1_, ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES) == 0);
	{
		GVariantIter* _ds_variant_it = NULL;
		GVariantIter* _tmp2_;
		GVariant* ds_variant = NULL;
		_tmp2_ = g_variant_iter_new (sources_variant);
		_ds_variant_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			ZeitgeistDataSource* _tmp6_ = NULL;
			GVariant* _tmp7_;
			ZeitgeistDataSource* _tmp8_;
			GPtrArray* _tmp9_;
			ZeitgeistDataSource* _tmp10_;
			_tmp3_ = _ds_variant_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (ds_variant);
			ds_variant = _tmp4_;
			_tmp5_ = ds_variant;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp7_ = ds_variant;
			_tmp8_ = zeitgeist_data_source_new_from_variant (_tmp7_, FALSE, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_ptr_array_unref0 (sources);
					return NULL;
				} else {
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_ptr_array_unref0 (sources);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp9_ = sources;
			_tmp10_ = _tmp6_;
			_tmp6_ = NULL;
			g_ptr_array_add (_tmp9_, _tmp10_);
			_g_object_unref0 (_tmp6_);
		}
		_g_variant_unref0 (ds_variant);
		_g_variant_iter_free0 (_ds_variant_it);
	}
	result = sources;
	return result;
}

static gint
__lambda4_ (ZeitgeistDataSource* a,
            ZeitgeistDataSource* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = zeitgeist_data_source_get_unique_id (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = zeitgeist_data_source_get_unique_id (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gint
___lambda4__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda4_ ((ZeitgeistDataSource*) a, (ZeitgeistDataSource*) b);
	return result;
}

GVariant*
zeitgeist_data_sources_to_variant (GHashTable* sources)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GList* data_sources = NULL;
	GList* _tmp4_;
	GList* _tmp5_;
	GVariantBuilder* _tmp10_;
	GVariant* _tmp11_;
	GVariant* result;
	g_return_val_if_fail (sources != NULL, NULL);
	_tmp0_ = g_variant_type_new (ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = g_hash_table_get_values (sources);
	data_sources = _tmp4_;
	data_sources = g_list_sort (data_sources, ___lambda4__gcompare_func);
	_tmp5_ = data_sources;
	{
		GList* ds_collection = NULL;
		GList* ds_it = NULL;
		ds_collection = _tmp5_;
		for (ds_it = ds_collection; ds_it != NULL; ds_it = ds_it->next) {
			ZeitgeistDataSource* ds = NULL;
			ds = (ZeitgeistDataSource*) ds_it->data;
			{
				GVariantBuilder* _tmp6_;
				ZeitgeistDataSource* _tmp7_;
				GVariant* _tmp8_;
				GVariant* _tmp9_;
				_tmp6_ = vb;
				_tmp7_ = ds;
				_tmp8_ = zeitgeist_data_source_to_variant (_tmp7_);
				_tmp9_ = _tmp8_;
				g_variant_builder_add_value (_tmp6_, _tmp9_);
				_g_variant_unref0 (_tmp9_);
			}
		}
	}
	_tmp10_ = vb;
	_tmp11_ = g_variant_builder_end (_tmp10_);
	g_variant_ref_sink (_tmp11_);
	result = _tmp11_;
	(data_sources == NULL) ? NULL : (data_sources = (g_list_free (data_sources), NULL));
	_g_variant_builder_unref0 (vb);
	return result;
}

