/* utils.c generated by valac 0.56.16, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UTILS (utils_get_type ())
#define UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UTILS, Utils))
#define UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UTILS, UtilsClass))
#define IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UTILS))
#define IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UTILS))
#define UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UTILS, UtilsClass))

typedef struct _Utils Utils;
typedef struct _UtilsClass UtilsClass;
typedef struct _UtilsPrivate UtilsPrivate;
enum  {
	UTILS_0_PROPERTY,
	UTILS_NUM_PROPERTIES
};
static GParamSpec* utils_properties[UTILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _Utils {
	GObject parent_instance;
	UtilsPrivate * priv;
};

struct _UtilsClass {
	GObjectClass parent_class;
};

static gpointer utils_parent_class = NULL;
static GHashTable* utils_app_to_desktop_file;
static GHashTable* utils_app_to_desktop_file = NULL;
static gchar** utils_desktop_file_prefixes;
static gint utils_desktop_file_prefixes_length1;
static gchar** utils_desktop_file_prefixes = NULL;
static gint utils_desktop_file_prefixes_length1 = 0;
static gint _utils_desktop_file_prefixes_size_ = 0;

VALA_EXTERN GType utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Utils, g_object_unref)
VALA_EXTERN gchar* utils_get_file_contents (GFile* file);
static void utils_init_desktop_id (void);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* utils_extract_desktop_id (const gchar* path);
VALA_EXTERN gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file,
                                         GDesktopAppInfo** dai);
static void utils_init_application_cache (void);
static void _g_free0_ (gpointer var);
VALA_EXTERN gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
VALA_EXTERN gchar* utils_find_desktop_file_for_app (const gchar* app_name,
                                        const gchar* mimetype);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN Utils* utils_new (void);
VALA_EXTERN Utils* utils_construct (GType object_type);
static void utils_finalize (GObject * obj);
static GType utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
utils_get_file_contents (GFile* file)
{
	guint8* contents_array = NULL;
	gint contents_array_length1;
	gint _contents_array_size_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	contents_array = NULL;
	contents_array_length1 = 0;
	_contents_array_size_ = contents_array_length1;
	{
		gboolean _tmp0_ = FALSE;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gboolean _tmp3_;
		_tmp3_ = g_file_load_contents (file, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		contents_array = (g_free (contents_array), NULL);
		contents_array = _tmp1_;
		contents_array_length1 = _tmp2_;
		_contents_array_size_ = contents_array_length1;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents_array = (g_free (contents_array), NULL);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_debug ("utils.vala:46: Couldn't get file contents %s: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		contents_array = (g_free (contents_array), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = contents_array;
	_tmp8__length1 = contents_array_length1;
	contents_array = NULL;
	contents_array_length1 = 0;
	result = (gchar*) _tmp8_;
	contents_array = (g_free (contents_array), NULL);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
utils_init_desktop_id (void)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* session_var = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	_tmp0_ = utils_desktop_file_prefixes;
	_tmp0__length1 = utils_desktop_file_prefixes_length1;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_getenv ("XDG_CURRENT_DESKTOP");
	session_var = _tmp1_;
	_tmp2_ = session_var;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = session_var;
		g_desktop_app_info_set_desktop_env (_tmp3_);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("DESKTOP_SESSION");
		session_var = _tmp4_;
		_tmp5_ = session_var;
		if (_tmp5_ == NULL) {
			g_desktop_app_info_set_desktop_env ("GNOME");
		} else {
			gchar* desktop_session = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = session_var;
			_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
			desktop_session = _tmp7_;
			_tmp8_ = desktop_session;
			if (g_str_has_prefix (_tmp8_, "GNOME")) {
				g_desktop_app_info_set_desktop_env ("GNOME");
			} else {
				const gchar* _tmp9_;
				_tmp9_ = desktop_session;
				if (g_str_has_prefix (_tmp9_, "KDE")) {
					g_desktop_app_info_set_desktop_env ("KDE");
				} else {
					const gchar* _tmp10_;
					_tmp10_ = desktop_session;
					if (g_str_has_prefix (_tmp10_, "XFCE")) {
						g_desktop_app_info_set_desktop_env ("XFCE");
					} else {
						g_desktop_app_info_set_desktop_env ("GNOME");
					}
				}
			}
			_g_free0 (desktop_session);
		}
	}
	_tmp12_ = _tmp11_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp12_;
		data_dir_collection_length1 = _vala_array_length (_tmp11_);
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = data_dir;
				_tmp14_ = g_build_path (G_DIR_SEPARATOR_S, _tmp13_, "applications", G_DIR_SEPARATOR_S, NULL, NULL);
				_vala_array_add1 (&utils_desktop_file_prefixes, &utils_desktop_file_prefixes_length1, &_utils_desktop_file_prefixes_size_, _tmp14_);
			}
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
utils_extract_desktop_id (const gchar* path)
{
	gchar* normalized_path = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	if (!g_str_has_prefix (path, "/")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (path);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = string_replace (path, "//", "/");
	normalized_path = _tmp1_;
	_tmp2_ = utils_desktop_file_prefixes;
	_tmp2__length1 = utils_desktop_file_prefixes_length1;
	{
		gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = _tmp2_;
		prefix_collection_length1 = _tmp2__length1;
		for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = normalized_path;
				_tmp4_ = prefix;
				if (g_str_has_prefix (_tmp3_, _tmp4_)) {
					gchar* without_prefix = NULL;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp5_ = normalized_path;
					_tmp6_ = prefix;
					_tmp7_ = strlen (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = string_substring (_tmp5_, (glong) _tmp8_, (glong) -1);
					without_prefix = _tmp9_;
					_tmp10_ = without_prefix;
					if (string_contains (_tmp10_, G_DIR_SEPARATOR_S)) {
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp11_ = without_prefix;
						_tmp12_ = string_replace (_tmp11_, G_DIR_SEPARATOR_S, "-");
						result = _tmp12_;
						_g_free0 (without_prefix);
						_g_free0 (normalized_path);
						return result;
					}
					result = without_prefix;
					_g_free0 (normalized_path);
					return result;
				}
			}
		}
	}
	_tmp13_ = g_path_get_basename (path);
	result = _tmp13_;
	_g_free0 (normalized_path);
	return result;
}

gchar*
utils_get_actor_for_desktop_file (const gchar* desktop_file,
                                  GDesktopAppInfo** dai)
{
	GDesktopAppInfo* _vala_dai = NULL;
	GDesktopAppInfo* _tmp2_;
	gchar* _tmp3_ = NULL;
	GDesktopAppInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* desktop_id = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	utils_init_desktop_id ();
	if (g_path_is_absolute (desktop_file)) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = g_desktop_app_info_new_from_filename (desktop_file);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp0_;
	} else {
		GDesktopAppInfo* _tmp1_;
		_tmp1_ = g_desktop_app_info_new (desktop_file);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp1_;
	}
	_tmp2_ = _vala_dai;
	if (_tmp2_ == NULL) {
		result = NULL;
		if (dai) {
			*dai = _vala_dai;
		} else {
			_g_object_unref0 (_vala_dai);
		}
		return result;
	}
	_tmp4_ = _vala_dai;
	_tmp5_ = g_app_info_get_id ((GAppInfo*) _tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp3_ = _tmp6_;
	if (_tmp3_ == NULL) {
		GDesktopAppInfo* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = _vala_dai;
		_tmp8_ = g_desktop_app_info_get_filename (_tmp7_);
		_tmp9_ = utils_extract_desktop_id (_tmp8_);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp9_;
	}
	_tmp10_ = _tmp3_;
	_tmp3_ = NULL;
	desktop_id = _tmp10_;
	_tmp11_ = desktop_id;
	_tmp12_ = g_strdup_printf ("application://%s", _tmp11_);
	result = _tmp12_;
	_g_free0 (desktop_id);
	_g_free0 (_tmp3_);
	if (dai) {
		*dai = _vala_dai;
	} else {
		_g_object_unref0 (_vala_dai);
	}
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
utils_init_application_cache (void)
{
	GHashTable* _tmp0_;
	_tmp0_ = utils_app_to_desktop_file;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (utils_app_to_desktop_file);
		utils_app_to_desktop_file = _tmp3_;
	}
}

gchar*
utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (mimetype != NULL, NULL);
	_tmp1_ = utils_find_desktop_file_for_app ("libreoffice", mimetype);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = utils_find_desktop_file_for_app ("ooffice", mimetype);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
utils_find_desktop_file_for_app (const gchar* app_name,
                                 const gchar* mimetype)
{
	gchar* _tmp0_ = NULL;
	gchar* hash_name = NULL;
	gchar* _tmp3_;
	const gchar* in_cache = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	const gchar* _tmp7_;
	gchar** data_dirs = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (app_name != NULL, NULL);
	utils_init_application_cache ();
	if (mimetype != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%s::%s", app_name, mimetype);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (app_name);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	hash_name = _tmp3_;
	_tmp4_ = utils_app_to_desktop_file;
	_tmp5_ = hash_name;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	in_cache = (const gchar*) _tmp6_;
	_tmp7_ = in_cache;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = in_cache;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_free0 (hash_name);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp11_ = _tmp10_ = g_get_system_data_dirs ();
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup1 (_tmp11_, _vala_array_length (_tmp10_)) : _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	data_dirs = _tmp12_;
	data_dirs_length1 = _tmp12__length1;
	_data_dirs_size_ = data_dirs_length1;
	_tmp13_ = g_get_user_data_dir ();
	_tmp14_ = g_strdup (_tmp13_);
	_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp14_);
	_tmp15_ = data_dirs;
	_tmp15__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp15_;
		dir_collection_length1 = _tmp15__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* p = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GFile* f = NULL;
				const gchar* _tmp21_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				_tmp16_ = dir;
				_tmp17_ = g_strdup_printf ("%s.desktop", app_name);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_build_filename (_tmp16_, "applications", _tmp18_, NULL, NULL);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				p = _tmp20_;
				_tmp21_ = p;
				_tmp22_ = g_file_new_for_path (_tmp21_);
				f = _tmp22_;
				_tmp23_ = f;
				if (g_file_query_exists (_tmp23_, NULL)) {
					GHashTable* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp24_ = utils_app_to_desktop_file;
					_tmp25_ = hash_name;
					_tmp26_ = g_strdup (_tmp25_);
					_tmp27_ = p;
					_tmp28_ = g_strdup (_tmp27_);
					g_hash_table_insert (_tmp24_, _tmp26_, _tmp28_);
					result = p;
					_g_object_unref0 (f);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					return result;
				}
				_g_object_unref0 (f);
				_g_free0 (p);
			}
		}
	}
	_tmp29_ = data_dirs;
	_tmp29__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp29_;
		dir_collection_length1 = _tmp29__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* p = NULL;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				GFile* app_dir = NULL;
				const gchar* _tmp32_;
				GFile* _tmp33_;
				GFile* _tmp34_;
				_tmp30_ = dir;
				_tmp31_ = g_build_filename (_tmp30_, "applications", NULL, NULL);
				p = _tmp31_;
				_tmp32_ = p;
				_tmp33_ = g_file_new_for_path (_tmp32_);
				app_dir = _tmp33_;
				_tmp34_ = app_dir;
				if (!g_file_query_exists (_tmp34_, NULL)) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					continue;
				}
				{
					GFileEnumerator* enumerator = NULL;
					GFile* _tmp35_;
					GFileEnumerator* _tmp36_;
					GFileInfo* fi = NULL;
					GFileEnumerator* _tmp37_;
					GFileInfo* _tmp38_;
					GFileEnumerator* _tmp66_;
					_tmp35_ = app_dir;
					_tmp36_ = g_file_enumerate_children (_tmp35_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
					enumerator = _tmp36_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp37_ = enumerator;
					_tmp38_ = g_file_enumerator_next_file (_tmp37_, NULL, &_inner_error0_);
					fi = _tmp38_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (enumerator);
						goto __catch0_g_error;
					}
					while (TRUE) {
						GFileInfo* _tmp39_;
						GFileInfo* _tmp40_;
						const gchar* _tmp41_;
						GFileInfo* _tmp62_ = NULL;
						GFileEnumerator* _tmp63_;
						GFileInfo* _tmp64_;
						GFileInfo* _tmp65_;
						_tmp39_ = fi;
						if (!(_tmp39_ != NULL)) {
							break;
						}
						_tmp40_ = fi;
						_tmp41_ = g_file_info_get_name (_tmp40_);
						if (g_str_has_suffix (_tmp41_, ".desktop")) {
							gchar* desktop_file = NULL;
							const gchar* _tmp42_;
							GFileInfo* _tmp43_;
							const gchar* _tmp44_;
							gchar* _tmp45_;
							GFile* f = NULL;
							const gchar* _tmp46_;
							GFile* _tmp47_;
							gchar* contents = NULL;
							GFile* _tmp48_;
							gchar* _tmp49_;
							const gchar* _tmp50_;
							_tmp42_ = p;
							_tmp43_ = fi;
							_tmp44_ = g_file_info_get_name (_tmp43_);
							_tmp45_ = g_build_filename (_tmp42_, _tmp44_, NULL, NULL);
							desktop_file = _tmp45_;
							_tmp46_ = desktop_file;
							_tmp47_ = g_file_new_for_path (_tmp46_);
							f = _tmp47_;
							_tmp48_ = f;
							_tmp49_ = utils_get_file_contents (_tmp48_);
							contents = _tmp49_;
							_tmp50_ = contents;
							if (_tmp50_ != NULL) {
								const gchar* _tmp51_;
								gchar* _tmp52_;
								gchar* _tmp53_;
								gboolean _tmp54_;
								_tmp51_ = contents;
								_tmp52_ = g_strdup_printf ("Exec=%s", app_name);
								_tmp53_ = _tmp52_;
								_tmp54_ = string_contains (_tmp51_, _tmp53_);
								_g_free0 (_tmp53_);
								if (_tmp54_) {
									gboolean _tmp55_ = FALSE;
									if (mimetype == NULL) {
										_tmp55_ = TRUE;
									} else {
										const gchar* _tmp56_;
										_tmp56_ = contents;
										_tmp55_ = string_contains (_tmp56_, mimetype);
									}
									if (_tmp55_) {
										GHashTable* _tmp57_;
										const gchar* _tmp58_;
										gchar* _tmp59_;
										const gchar* _tmp60_;
										gchar* _tmp61_;
										_tmp57_ = utils_app_to_desktop_file;
										_tmp58_ = hash_name;
										_tmp59_ = g_strdup (_tmp58_);
										_tmp60_ = desktop_file;
										_tmp61_ = g_strdup (_tmp60_);
										g_hash_table_insert (_tmp57_, _tmp59_, _tmp61_);
										result = desktop_file;
										_g_free0 (contents);
										_g_object_unref0 (f);
										_g_object_unref0 (fi);
										_g_object_unref0 (enumerator);
										_g_object_unref0 (app_dir);
										_g_free0 (p);
										data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (hash_name);
										_g_free0 (_tmp0_);
										return result;
									}
								}
							}
							_g_free0 (contents);
							_g_object_unref0 (f);
							_g_free0 (desktop_file);
						}
						_tmp63_ = enumerator;
						_tmp64_ = g_file_enumerator_next_file (_tmp63_, NULL, &_inner_error0_);
						_tmp62_ = _tmp64_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (fi);
							_g_object_unref0 (enumerator);
							goto __catch0_g_error;
						}
						_tmp65_ = _tmp62_;
						_tmp62_ = NULL;
						_g_object_unref0 (fi);
						fi = _tmp65_;
						_g_object_unref0 (_tmp62_);
					}
					_tmp66_ = enumerator;
					g_file_enumerator_close (_tmp66_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (fi);
						_g_object_unref0 (enumerator);
						goto __catch0_g_error;
					}
					_g_object_unref0 (fi);
					_g_object_unref0 (enumerator);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					GError* _tmp67_;
					const gchar* _tmp68_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp67_ = err;
					_tmp68_ = _tmp67_->message;
					g_warning ("utils.vala:255: %s", _tmp68_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_object_unref0 (app_dir);
				_g_free0 (p);
			}
		}
	}
	result = NULL;
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (hash_name);
	_g_free0 (_tmp0_);
	return result;
}

Utils*
utils_construct (GType object_type)
{
	Utils * self = NULL;
	self = (Utils*) g_object_new (object_type, NULL);
	return self;
}

Utils*
utils_new (void)
{
	return utils_construct (TYPE_UTILS);
}

static void
utils_class_init (UtilsClass * klass,
                  gpointer klass_data)
{
	utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = utils_finalize;
}

static void
utils_instance_init (Utils * self,
                     gpointer klass)
{
}

static void
utils_finalize (GObject * obj)
{
	Utils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UTILS, Utils);
	G_OBJECT_CLASS (utils_parent_class)->finalize (obj);
}

static GType
utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Utils), 0, (GInstanceInitFunc) utils_instance_init, NULL };
	GType utils_type_id;
	utils_type_id = g_type_register_static (G_TYPE_OBJECT, "Utils", &g_define_type_info, 0);
	return utils_type_id;
}

GType
utils_get_type (void)
{
	static volatile gsize utils_type_id__once = 0;
	if (g_once_init_enter (&utils_type_id__once)) {
		GType utils_type_id;
		utils_type_id = utils_get_type_once ();
		g_once_init_leave (&utils_type_id__once, utils_type_id);
	}
	return utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

