/* telepathy-observer.c generated by valac 0.56.16, the Vala compiler
 * generated from telepathy-observer.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2012 Collabora Ltd.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2012 Eslam Mostafa <cseslam@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <telepathy-glib/telepathy-glib.h>
#include "zeitgeist-datamodel.h"
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>

#define TELEPATHY_OBSERVER_actor "dbus://org.freedesktop.Telepathy.Logger.service"
#define TELEPATHY_OBSERVER_tp_account_path "x-telepathy-account-path:%s"
#define TELEPATHY_OBSERVER_tp_identifier "x-telepathy-identifier:%s"
#define TELEPATHY_OBSERVER_ft_json_domain "http://zeitgeist-project.com/1.0/telepathy/filetransfer"
#define TELEPATHY_OBSERVER_call_json_domain "http://zeitgeist-project.com/1.0/telepathy/call"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_TELEPATHY_OBSERVER (telepathy_observer_get_type ())
#define TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserver))
#define TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))
#define IS_TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TELEPATHY_OBSERVER))
#define IS_TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TELEPATHY_OBSERVER))
#define TELEPATHY_OBSERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))

typedef struct _TelepathyObserver TelepathyObserver;
typedef struct _TelepathyObserverClass TelepathyObserverClass;
typedef struct _TelepathyObserverPrivate TelepathyObserverPrivate;
enum  {
	TELEPATHY_OBSERVER_0_PROPERTY,
	TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY,
	TELEPATHY_OBSERVER_NAME_PROPERTY,
	TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY,
	TELEPATHY_OBSERVER_DATAHUB_PROPERTY,
	TELEPATHY_OBSERVER_ENABLED_PROPERTY,
	TELEPATHY_OBSERVER_REGISTER_PROPERTY,
	TELEPATHY_OBSERVER_NUM_PROPERTIES
};
static GParamSpec* telepathy_observer_properties[TELEPATHY_OBSERVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define __vala_TpCallStateReason_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpCallStateReason_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TelepathyObserverHandleFtchannelChangeData TelepathyObserverHandleFtchannelChangeData;
typedef struct _Block5Data Block5Data;

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _TelepathyObserver {
	DataProvider parent_instance;
	TelepathyObserverPrivate * priv;
};

struct _TelepathyObserverClass {
	DataProviderClass parent_class;
};

struct _TelepathyObserverPrivate {
	TpDBusDaemon* dbus;
	TpAutomaticClientFactory* factory;
	TpSimpleObserver* observer;
	GHashTable* call_timers;
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
};

struct _Block2Data {
	int _ref_count_;
	TelepathyObserver* self;
	TpTextChannel* channel;
	TpAccount* account;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	ZeitgeistEvent* event_template;
};

struct _Block4Data {
	int _ref_count_;
	TelepathyObserver* self;
	TpCallChannel* channel;
	TpAccount* account;
};

struct _TelepathyObserverHandleFtchannelChangeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TelepathyObserver* self;
	TpSimpleObserver* observer;
	TpAccount* account;
	TpConnection* connection;
	TpFileTransferChannel* channel;
	TpChannelDispatchOperation* dispatch_operation;
	GList* requests;
	TpObserveChannelsContext* context;
	gboolean _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	TpContact* target;
	TpContact* _tmp5_;
	TpContact* _tmp6_;
	gchar* attr;
	gchar* _tmp7_;
	GFileInfo* info;
	GFileInfo* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	GFileInfo* _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GError* err;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gchar* obj_path;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	ZeitgeistEvent* event_template;
	ZeitgeistEvent* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	ZeitgeistEvent* _tmp37_;
	ZeitgeistEvent* _tmp38_;
	ZeitgeistEvent* _tmp39_;
	ZeitgeistEvent* _tmp40_;
	ZeitgeistEvent* _tmp41_;
	ZeitgeistSubject* subj;
	ZeitgeistSubject* _tmp42_;
	ZeitgeistSubject* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	ZeitgeistSubject* _tmp49_;
	GFileInfo* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	ZeitgeistSubject* _tmp53_;
	ZeitgeistSubject* _tmp54_;
	GFileInfo* _tmp55_;
	const gchar* _tmp56_;
	ZeitgeistSubject* _tmp57_;
	GFileInfo* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	gchar** split_uri;
	GFile* _tmp62_;
	GFile* _tmp63_;
	GFile* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar** _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	gint split_uri_length1;
	gint _split_uri_size_;
	gchar* uri;
	gchar** _tmp70_;
	gint _tmp70__length1;
	gchar** _tmp71_;
	gint _tmp71__length1;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	ZeitgeistSubject* _tmp76_;
	const gchar* _tmp77_;
	ZeitgeistSubject* _tmp78_;
	TpContact* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	ZeitgeistEvent* _tmp83_;
	ZeitgeistSubject* _tmp84_;
	ZeitgeistEvent* _tmp85_;
	TpContact* _tmp86_;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	TpContact* _tmp91_;
	const gchar* _tmp92_;
	ZeitgeistSubject* _tmp93_;
	ZeitgeistSubject* _tmp94_;
	JsonGenerator* gen;
	JsonGenerator* _tmp95_;
	JsonNode* root;
	JsonNode* _tmp96_;
	JsonObject* object;
	JsonObject* _tmp97_;
	JsonNode* _tmp98_;
	JsonObject* _tmp99_;
	JsonGenerator* _tmp100_;
	JsonNode* _tmp101_;
	JsonGenerator* _tmp102_;
	JsonObject* details_obj;
	JsonObject* _tmp103_;
	TpFileTransferStateChangeReason reason;
	TpFileTransferState state;
	TpFileTransferStateChangeReason _tmp104_;
	TpFileTransferState _tmp105_;
	JsonObject* _tmp106_;
	JsonObject* _tmp107_;
	JsonObject* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	JsonObject* _tmp111_;
	const gchar* _tmp112_;
	JsonObject* _tmp113_;
	JsonObject* _tmp114_;
	const gchar* _tmp115_;
	gsize length;
	JsonObject* _tmp116_;
	JsonObject* _tmp117_;
	JsonObject* _tmp118_;
	gchar* payload_string;
	JsonGenerator* _tmp119_;
	gsize _tmp120_;
	gchar* _tmp121_;
	ZeitgeistEvent* _tmp122_;
	const gchar* _tmp123_;
	guint8* _tmp124_;
	gint _tmp124__length1;
	gint _tmp125_;
	guint8* _tmp126_;
	gint _tmp126__length1;
	guint8* _tmp127_;
	gint _tmp127__length1;
	GByteArray* _tmp128_;
	GByteArray* _tmp129_;
	ZeitgeistEvent* _tmp130_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	TelepathyObserver* self;
	TpFileTransferChannel* channel;
	TpSimpleObserver* observer;
	TpAccount* account;
	TpConnection* connection;
	TpChannelDispatchOperation* dispatch_operation;
	GList* requests;
	TpObserveChannelsContext* context;
};

static gint TelepathyObserver_private_offset;
static gpointer telepathy_observer_parent_class = NULL;

VALA_EXTERN GType data_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataProvider, g_object_unref)
VALA_EXTERN GType data_hub_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataHub, g_object_unref)
VALA_EXTERN GType telepathy_observer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TelepathyObserver, g_object_unref)
VALA_EXTERN void data_provider_start (DataProvider* self);
VALA_EXTERN void data_provider_stop (DataProvider* self);
VALA_EXTERN const gchar* data_provider_get_unique_id (DataProvider* self);
VALA_EXTERN void data_provider_set_unique_id (DataProvider* self,
                                  const gchar* value);
VALA_EXTERN const gchar* data_provider_get_name (DataProvider* self);
VALA_EXTERN void data_provider_set_name (DataProvider* self,
                             const gchar* value);
VALA_EXTERN const gchar* data_provider_get_description (DataProvider* self);
VALA_EXTERN void data_provider_set_description (DataProvider* self,
                                    const gchar* value);
VALA_EXTERN DataHub* data_provider_get_datahub (DataProvider* self);
VALA_EXTERN void data_provider_set_datahub (DataProvider* self,
                                DataHub* value);
VALA_EXTERN gboolean data_provider_get_enabled (DataProvider* self);
VALA_EXTERN void data_provider_set_enabled (DataProvider* self,
                                gboolean value);
VALA_EXTERN gboolean data_provider_get_register (DataProvider* self);
VALA_EXTERN void data_provider_set_register (DataProvider* self,
                                 gboolean value);
VALA_EXTERN TelepathyObserver* telepathy_observer_new (DataHub* datahub,
                                           GError** error);
VALA_EXTERN TelepathyObserver* telepathy_observer_construct (GType object_type,
                                                 DataHub* datahub,
                                                 GError** error);
static void telepathy_observer_push_event (TelepathyObserver* self,
                                    ZeitgeistEvent* event);
static void _g_object_unref0_ (gpointer var);
static ZeitgeistEvent* telepathy_observer_create_text_event (TelepathyObserver* self,
                                                      TpAccount* account,
                                                      TpChannel* channel);
static void telepathy_observer_observe_text_channel (TelepathyObserver* self,
                                              TpSimpleObserver* observer,
                                              TpAccount* account,
                                              TpConnection* connection,
                                              TpChannel* b_channel,
                                              TpChannelDispatchOperation* dispatch_operation,
                                              GList* requests,
                                              TpObserveChannelsContext* context);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda5_ (Block3Data* _data3_);
static void ____lambda5__tp_proxy_invalidated (TpProxy* _sender,
                                        guint domain,
                                        gint code,
                                        const gchar* message,
                                        gpointer self);
static void ___lambda6_ (Block3Data* _data3_);
static void ____lambda6__tp_text_channel_message_received (TpTextChannel* _sender,
                                                    TpSignalledMessage* message,
                                                    gpointer self);
static void ___lambda7_ (Block3Data* _data3_);
static void ____lambda7__tp_text_channel_message_sent (TpTextChannel* _sender,
                                                TpSignalledMessage* message,
                                                guint flags,
                                                const gchar* token,
                                                gpointer self);
static ZeitgeistEvent* telepathy_observer_create_call_event (TelepathyObserver* self,
                                                      TpAccount* account,
                                                      TpCallChannel* channel);
static void telepathy_observer_observe_call_channel (TelepathyObserver* self,
                                              TpSimpleObserver* observer,
                                              TpAccount* account,
                                              TpConnection* connection,
                                              TpChannel* b_channel,
                                              TpChannelDispatchOperation* dispatch_operation,
                                              GList* requests,
                                              TpObserveChannelsContext* context);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_);
static void _vala_TpCallStateReason_free (TpCallStateReason* self);
static TpCallStateReason* _vala_TpCallStateReason_copy (TpCallStateReason* self);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda8__tp_call_channel_state_changed (TpCallChannel* _sender,
                                                guint state,
                                                guint flags,
                                                TpCallStateReason* reason,
                                                GHashTable* details,
                                                gpointer self);
static void telepathy_observer_handle_ftchannel_change_data_free (gpointer _data);
static void telepathy_observer_handle_ftchannel_change (TelepathyObserver* self,
                                                 TpSimpleObserver* observer,
                                                 TpAccount* account,
                                                 TpConnection* connection,
                                                 TpFileTransferChannel* channel,
                                                 TpChannelDispatchOperation* dispatch_operation,
                                                 GList* requests,
                                                 TpObserveChannelsContext* context,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void telepathy_observer_handle_ftchannel_change_finish (TelepathyObserver* self,
                                                        GAsyncResult* _res_);
static gboolean telepathy_observer_handle_ftchannel_change_co (TelepathyObserverHandleFtchannelChangeData* _data_);
static void telepathy_observer_handle_ftchannel_change_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void telepathy_observer_observe_ft_channel (TelepathyObserver* self,
                                            TpSimpleObserver* observer,
                                            TpAccount* account,
                                            TpConnection* connection,
                                            TpChannel* b_channel,
                                            TpChannelDispatchOperation* dispatch_operation,
                                            GList* requests,
                                            TpObserveChannelsContext* context);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void telepathy_observer_observe_channels (TelepathyObserver* self,
                                          TpSimpleObserver* observer,
                                          TpAccount* account,
                                          TpConnection* connection,
                                          GList* channels,
                                          TpChannelDispatchOperation* dispatch_operation,
                                          GList* requests,
                                          TpObserveChannelsContext* context);
static void telepathy_observer_real_start (DataProvider* base);
static void _telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl (TpSimpleObserver* observer,
                                                                                    TpAccount* account,
                                                                                    TpConnection* connection,
                                                                                    GList* channels,
                                                                                    TpChannelDispatchOperation* dispatch_operation,
                                                                                    GList* requests,
                                                                                    TpObserveChannelsContext* context,
                                                                                    gpointer self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void telepathy_observer_real_stop (DataProvider* base);
static GObject * telepathy_observer_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _g_timer_destroy0_ (gpointer var);
static void telepathy_observer_finalize (GObject * obj);
static GType telepathy_observer_get_type_once (void);
static void _vala_telepathy_observer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_telepathy_observer_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
telepathy_observer_get_instance_private (TelepathyObserver* self)
{
	return G_STRUCT_MEMBER_P (self, TelepathyObserver_private_offset);
}

TelepathyObserver*
telepathy_observer_construct (GType object_type,
                              DataHub* datahub,
                              GError** error)
{
	TelepathyObserver * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (TelepathyObserver*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,telepathy-observer", "name", "Telepathy Observer", "description", "Logs IM, call and filetransfer from telepathy", "datahub", datahub, NULL);
	return self;
}

TelepathyObserver*
telepathy_observer_new (DataHub* datahub,
                        GError** error)
{
	return telepathy_observer_construct (TYPE_TELEPATHY_OBSERVER, datahub, error);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
telepathy_observer_push_event (TelepathyObserver* self,
                               ZeitgeistEvent* event)
{
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = _g_object_ref0 (event);
	g_ptr_array_add (events, _tmp1_);
	g_signal_emit_by_name ((DataProvider*) self, "items-available", events);
	_g_ptr_array_unref0 (events);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static ZeitgeistEvent*
telepathy_observer_create_text_event (TelepathyObserver* self,
                                      TpAccount* account,
                                      TpChannel* channel)
{
	TpContact* target = NULL;
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	gchar* obj_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ZeitgeistEvent* event_template = NULL;
	ZeitgeistEvent* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ZeitgeistEvent* _tmp18_;
	TpContact* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ZeitgeistSubject* _tmp23_;
	ZeitgeistSubject* _tmp24_;
	ZeitgeistEvent* _tmp25_;
	TpContact* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	TpContact* _tmp31_;
	const gchar* _tmp32_;
	ZeitgeistSubject* _tmp33_;
	ZeitgeistSubject* _tmp34_;
	ZeitgeistEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = tp_channel_get_target_contact (channel);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	target = _tmp1_;
	_tmp2_ = tp_proxy_get_object_path ((TpProxy*) account);
	_tmp3_ = g_strdup (_tmp2_);
	obj_path = _tmp3_;
	_tmp4_ = obj_path;
	_tmp5_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
	_tmp6_ = _tmp5_;
	_tmp7_ = obj_path;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_slice (_tmp4_, (glong) _tmp6_, (glong) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, _tmp11_);
	_g_free0 (obj_path);
	obj_path = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, "", TELEPATHY_OBSERVER_actor, NULL, NULL, NULL);
	event_template = _tmp13_;
	_tmp14_ = tp_channel_get_requested (channel);
	_tmp15_ = _tmp14_;
	if (!_tmp15_) {
		ZeitgeistEvent* _tmp16_;
		_tmp16_ = event_template;
		zeitgeist_event_set_manifestation (_tmp16_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	} else {
		ZeitgeistEvent* _tmp17_;
		_tmp17_ = event_template;
		zeitgeist_event_set_manifestation (_tmp17_, ZEITGEIST_ZG_USER_ACTIVITY);
	}
	_tmp18_ = event_template;
	_tmp19_ = target;
	_tmp20_ = tp_contact_get_identifier (_tmp19_);
	_tmp21_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = zeitgeist_subject_new_full ("", ZEITGEIST_NMO_IMMESSAGE, ZEITGEIST_NFO_SOFTWARE_SERVICE, "plain/text", _tmp22_, "", "net");
	_tmp24_ = _tmp23_;
	zeitgeist_event_add_subject (_tmp18_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = event_template;
	_tmp26_ = target;
	_tmp27_ = tp_contact_get_identifier (_tmp26_);
	_tmp28_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = obj_path;
	_tmp31_ = target;
	_tmp32_ = tp_contact_get_alias (_tmp31_);
	_tmp33_ = zeitgeist_subject_new_full (_tmp29_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _tmp30_, _tmp32_, "net");
	_tmp34_ = _tmp33_;
	zeitgeist_event_add_subject (_tmp25_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	_g_free0 (_tmp29_);
	result = event_template;
	_g_free0 (obj_path);
	_g_object_unref0 (target);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TelepathyObserver* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->channel);
		_g_object_unref0 (_data2_->account);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TelepathyObserver* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->event_template);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda5_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	TelepathyObserver* self;
	TpTextChannel* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->channel;
	_tmp1_ = telepathy_observer_create_text_event (self, _data2_->account, (TpChannel*) _tmp0_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp1_;
	_tmp2_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp2_, ZEITGEIST_ZG_LEAVE_EVENT);
	_tmp3_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp3_);
}

static void
____lambda5__tp_proxy_invalidated (TpProxy* _sender,
                                   guint domain,
                                   gint code,
                                   const gchar* message,
                                   gpointer self)
{
	___lambda5_ (self);
}

static void
___lambda6_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	TelepathyObserver* self;
	TpTextChannel* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->channel;
	_tmp1_ = telepathy_observer_create_text_event (self, _data2_->account, (TpChannel*) _tmp0_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp1_;
	_tmp2_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp2_, ZEITGEIST_ZG_RECEIVE_EVENT);
	_tmp3_ = _data3_->event_template;
	zeitgeist_event_set_manifestation (_tmp3_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	_tmp4_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp4_);
}

static void
____lambda6__tp_text_channel_message_received (TpTextChannel* _sender,
                                               TpSignalledMessage* message,
                                               gpointer self)
{
	___lambda6_ (self);
}

static void
___lambda7_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	TelepathyObserver* self;
	TpTextChannel* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->channel;
	_tmp1_ = telepathy_observer_create_text_event (self, _data2_->account, (TpChannel*) _tmp0_);
	_g_object_unref0 (_data3_->event_template);
	_data3_->event_template = _tmp1_;
	_tmp2_ = _data3_->event_template;
	zeitgeist_event_set_interpretation (_tmp2_, ZEITGEIST_ZG_SEND_EVENT);
	_tmp3_ = _data3_->event_template;
	zeitgeist_event_set_manifestation (_tmp3_, ZEITGEIST_ZG_USER_ACTIVITY);
	_tmp4_ = _data3_->event_template;
	telepathy_observer_push_event (self, _tmp4_);
}

static void
____lambda7__tp_text_channel_message_sent (TpTextChannel* _sender,
                                           TpSignalledMessage* message,
                                           guint flags,
                                           const gchar* token,
                                           gpointer self)
{
	___lambda7_ (self);
}

static void
telepathy_observer_observe_text_channel (TelepathyObserver* self,
                                         TpSimpleObserver* observer,
                                         TpAccount* account,
                                         TpConnection* connection,
                                         TpChannel* b_channel,
                                         TpChannelDispatchOperation* dispatch_operation,
                                         GList* requests,
                                         TpObserveChannelsContext* context)
{
	Block2Data* _data2_;
	TpAccount* _tmp0_;
	TpTextChannel* _tmp1_;
	TpContact* target = NULL;
	TpTextChannel* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data2_->account);
	_data2_->account = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b_channel, tp_text_channel_get_type (), TpTextChannel));
	_data2_->channel = _tmp1_;
	_tmp2_ = _data2_->channel;
	_tmp3_ = tp_channel_get_target_contact ((TpChannel*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	target = _tmp4_;
	_tmp5_ = target;
	if (_tmp5_ != NULL) {
		Block3Data* _data3_;
		TpTextChannel* _tmp6_;
		ZeitgeistEvent* _tmp7_;
		ZeitgeistEvent* _tmp8_;
		TpTextChannel* _tmp9_;
		GList* _tmp10_;
		TpTextChannel* _tmp17_;
		TpTextChannel* _tmp18_;
		TpTextChannel* _tmp19_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp6_ = _data2_->channel;
		_tmp7_ = telepathy_observer_create_text_event (self, _data2_->account, (TpChannel*) _tmp6_);
		_data3_->event_template = _tmp7_;
		_tmp8_ = _data3_->event_template;
		telepathy_observer_push_event (self, _tmp8_);
		_tmp9_ = _data2_->channel;
		_tmp10_ = tp_text_channel_get_pending_messages (_tmp9_);
		{
			GList* message_collection = NULL;
			GList* message_it = NULL;
			message_collection = _tmp10_;
			for (message_it = message_collection; message_it != NULL; message_it = message_it->next) {
				TpSignalledMessage* message = NULL;
				message = (TpSignalledMessage*) message_it->data;
				{
					TpSignalledMessage* _tmp11_;
					_tmp11_ = message;
					if (!tp_message_is_delivery_report ((TpMessage*) _tmp11_)) {
						TpTextChannel* _tmp12_;
						ZeitgeistEvent* _tmp13_;
						ZeitgeistEvent* _tmp14_;
						ZeitgeistEvent* _tmp15_;
						ZeitgeistEvent* _tmp16_;
						_tmp12_ = _data2_->channel;
						_tmp13_ = telepathy_observer_create_text_event (self, _data2_->account, (TpChannel*) _tmp12_);
						_g_object_unref0 (_data3_->event_template);
						_data3_->event_template = _tmp13_;
						_tmp14_ = _data3_->event_template;
						zeitgeist_event_set_interpretation (_tmp14_, ZEITGEIST_ZG_RECEIVE_EVENT);
						_tmp15_ = _data3_->event_template;
						zeitgeist_event_set_manifestation (_tmp15_, ZEITGEIST_ZG_WORLD_ACTIVITY);
						_tmp16_ = _data3_->event_template;
						telepathy_observer_push_event (self, _tmp16_);
					}
				}
			}
			(message_collection == NULL) ? NULL : (message_collection = (g_list_free (message_collection), NULL));
		}
		_tmp17_ = _data2_->channel;
		g_signal_connect_data ((TpProxy*) _tmp17_, "invalidated", (GCallback) ____lambda5__tp_proxy_invalidated, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp18_ = _data2_->channel;
		g_signal_connect_data (_tmp18_, "message-received", (GCallback) ____lambda6__tp_text_channel_message_received, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp19_ = _data2_->channel;
		g_signal_connect_data (_tmp19_, "message-sent", (GCallback) ____lambda7__tp_text_channel_message_sent, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	_g_object_unref0 (target);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static ZeitgeistEvent*
telepathy_observer_create_call_event (TelepathyObserver* self,
                                      TpAccount* account,
                                      TpCallChannel* channel)
{
	GHashTable* targets = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	TpContact* target = NULL;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	TpContact* _tmp7_;
	gchar* obj_path = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ZeitgeistEvent* event_template = NULL;
	ZeitgeistEvent* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	ZeitgeistEvent* _tmp23_;
	TpContact* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	TpContact* _tmp28_;
	const gchar* _tmp29_;
	ZeitgeistSubject* _tmp30_;
	ZeitgeistSubject* _tmp31_;
	ZeitgeistEvent* _tmp32_;
	TpContact* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	TpContact* _tmp38_;
	const gchar* _tmp39_;
	ZeitgeistSubject* _tmp40_;
	ZeitgeistSubject* _tmp41_;
	ZeitgeistEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = tp_call_channel_get_members (channel);
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	targets = _tmp1_;
	_tmp2_ = targets;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_hash_table_unref0 (targets);
		return result;
	}
	_tmp3_ = targets;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = (TpContact*) _tmp6_;
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	target = _tmp7_;
	_tmp8_ = tp_proxy_get_object_path ((TpProxy*) account);
	_tmp9_ = g_strdup (_tmp8_);
	obj_path = _tmp9_;
	_tmp10_ = obj_path;
	_tmp11_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
	_tmp12_ = _tmp11_;
	_tmp13_ = obj_path;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = string_slice (_tmp10_, (glong) _tmp12_, (glong) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, _tmp17_);
	_g_free0 (obj_path);
	obj_path = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, TELEPATHY_OBSERVER_actor, NULL, NULL, NULL);
	event_template = _tmp19_;
	_tmp20_ = tp_channel_get_requested ((TpChannel*) channel);
	_tmp21_ = _tmp20_;
	if (!_tmp21_) {
		ZeitgeistEvent* _tmp22_;
		_tmp22_ = event_template;
		zeitgeist_event_set_manifestation (_tmp22_, ZEITGEIST_ZG_WORLD_ACTIVITY);
	}
	_tmp23_ = event_template;
	_tmp24_ = target;
	_tmp25_ = tp_contact_get_identifier (_tmp24_);
	_tmp26_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = target;
	_tmp29_ = tp_contact_get_alias (_tmp28_);
	_tmp30_ = zeitgeist_subject_new_full ("", ZEITGEIST_NFO_AUDIO, ZEITGEIST_NFO_MEDIA_STREAM, "x-telepathy/call", _tmp27_, _tmp29_, "net");
	_tmp31_ = _tmp30_;
	zeitgeist_event_add_subject (_tmp23_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_g_free0 (_tmp27_);
	_tmp32_ = event_template;
	_tmp33_ = target;
	_tmp34_ = tp_contact_get_identifier (_tmp33_);
	_tmp35_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = obj_path;
	_tmp38_ = target;
	_tmp39_ = tp_contact_get_alias (_tmp38_);
	_tmp40_ = zeitgeist_subject_new_full (_tmp36_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _tmp37_, _tmp39_, "net");
	_tmp41_ = _tmp40_;
	zeitgeist_event_add_subject (_tmp32_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	_g_free0 (_tmp36_);
	result = event_template;
	_g_free0 (obj_path);
	_g_hash_table_unref0 (targets);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TelepathyObserver* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->channel);
		_g_object_unref0 (_data4_->account);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_TpCallStateReason_free (TpCallStateReason* self)
{
	g_boxed_free (tp_call_state_reason_get_type (), self);
}

static TpCallStateReason*
_vala_TpCallStateReason_copy (TpCallStateReason* self)
{
	return g_boxed_copy (tp_call_state_reason_get_type (), self);
}

static gpointer
__vala_TpCallStateReason_copy0 (gpointer self)
{
	return self ? _vala_TpCallStateReason_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
__lambda8_ (Block4Data* _data4_)
{
	TelepathyObserver* self;
	TpCallFlags flags = 0U;
	TpCallStateReason* reason = NULL;
	TpCallState state = 0;
	TpCallFlags _tmp0_ = 0U;
	TpCallStateReason* _tmp1_ = NULL;
	TpCallState _tmp2_;
	TpCallStateReason* _tmp3_;
	ZeitgeistEvent* event_template = NULL;
	ZeitgeistEvent* _tmp4_;
	self = _data4_->self;
	_tmp2_ = tp_call_channel_get_state (_data4_->channel, &_tmp0_, NULL, &_tmp1_);
	flags = _tmp0_;
	__vala_TpCallStateReason_free0 (reason);
	_tmp3_ = __vala_TpCallStateReason_copy0 (_tmp1_);
	reason = _tmp3_;
	state = _tmp2_;
	_tmp4_ = telepathy_observer_create_call_event (self, _data4_->account, _data4_->channel);
	event_template = _tmp4_;
	if (state == TP_CALL_STATE_INITIALISED) {
		ZeitgeistEvent* _tmp5_;
		GTimer* t = NULL;
		GTimer* _tmp6_;
		GTimer* _tmp7_;
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GTimer* _tmp11_;
		ZeitgeistEvent* _tmp12_;
		_tmp5_ = event_template;
		zeitgeist_event_set_interpretation (_tmp5_, ZEITGEIST_ZG_CREATE_EVENT);
		_tmp6_ = g_timer_new ();
		t = _tmp6_;
		_tmp7_ = t;
		g_timer_stop (_tmp7_);
		_tmp8_ = self->priv->call_timers;
		_tmp9_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = t;
		t = NULL;
		g_hash_table_insert (_tmp8_, _tmp10_, _tmp11_);
		_tmp12_ = event_template;
		telepathy_observer_push_event (self, _tmp12_);
		_g_timer_destroy0 (t);
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		if (state == TP_CALL_STATE_ACTIVE) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = state == TP_CALL_STATE_ENDED;
		}
		if (_tmp14_) {
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = self->priv->call_timers;
			_tmp16_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
			_tmp13_ = g_hash_table_contains (_tmp15_, _tmp16_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			if (state == TP_CALL_STATE_ACTIVE) {
				ZeitgeistEvent* _tmp17_;
				GHashTable* _tmp18_;
				const gchar* _tmp19_;
				gconstpointer _tmp20_;
				ZeitgeistEvent* _tmp21_;
				_tmp17_ = event_template;
				zeitgeist_event_set_interpretation (_tmp17_, ZEITGEIST_ZG_ACCESS_EVENT);
				_tmp18_ = self->priv->call_timers;
				_tmp19_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
				_tmp20_ = g_hash_table_lookup (_tmp18_, _tmp19_);
				g_timer_start ((GTimer*) _tmp20_);
				_tmp21_ = event_template;
				telepathy_observer_push_event (self, _tmp21_);
			} else {
				if (state == TP_CALL_STATE_ENDED) {
					ZeitgeistEvent* _tmp22_;
					gboolean _tmp23_ = FALSE;
					TpCallStateReason* _tmp24_;
					gdouble duration = 0.0;
					GHashTable* _tmp33_;
					const gchar* _tmp34_;
					gconstpointer _tmp35_;
					GHashTable* _tmp36_;
					const gchar* _tmp37_;
					gconstpointer _tmp38_;
					GHashTable* _tmp39_;
					const gchar* _tmp40_;
					JsonGenerator* gen = NULL;
					JsonGenerator* _tmp41_;
					JsonNode* root = NULL;
					JsonNode* _tmp42_;
					JsonObject* object = NULL;
					JsonObject* _tmp43_;
					JsonNode* _tmp44_;
					JsonObject* _tmp45_;
					JsonGenerator* _tmp46_;
					JsonNode* _tmp47_;
					JsonGenerator* _tmp48_;
					JsonObject* details_obj = NULL;
					JsonObject* _tmp49_;
					JsonObject* _tmp50_;
					JsonObject* _tmp51_;
					TpCallStateReason* _tmp52_;
					JsonObject* _tmp53_;
					gboolean _tmp54_;
					gboolean _tmp55_;
					JsonObject* _tmp56_;
					gsize length = 0UL;
					JsonObject* _tmp57_;
					JsonObject* _tmp58_;
					JsonObject* _tmp59_;
					gchar* payload_string = NULL;
					JsonGenerator* _tmp60_;
					gsize _tmp61_ = 0UL;
					gchar* _tmp62_;
					ZeitgeistEvent* _tmp63_;
					const gchar* _tmp64_;
					guint8* _tmp65_;
					gint _tmp65__length1;
					gint _tmp66_ = 0;
					guint8* _tmp67_;
					gint _tmp67__length1;
					guint8* _tmp68_;
					gint _tmp68__length1;
					GByteArray* _tmp69_;
					GByteArray* _tmp70_;
					ZeitgeistEvent* _tmp71_;
					_tmp22_ = event_template;
					zeitgeist_event_set_interpretation (_tmp22_, ZEITGEIST_ZG_LEAVE_EVENT);
					_tmp24_ = reason;
					if (_tmp24_->reason == TP_CALL_STATE_CHANGE_REASON_REJECTED) {
						_tmp23_ = TRUE;
					} else {
						TpCallStateReason* _tmp25_;
						_tmp25_ = reason;
						_tmp23_ = _tmp25_->reason == TP_CALL_STATE_CHANGE_REASON_NO_ANSWER;
					}
					if (_tmp23_) {
						gboolean _tmp26_;
						gboolean _tmp27_;
						TpCallStateReason* _tmp30_;
						_tmp26_ = tp_channel_get_requested ((TpChannel*) _data4_->channel);
						_tmp27_ = _tmp26_;
						if (_tmp27_) {
							ZeitgeistEvent* _tmp28_;
							_tmp28_ = event_template;
							zeitgeist_event_set_manifestation (_tmp28_, ZEITGEIST_ZG_WORLD_ACTIVITY);
						} else {
							ZeitgeistEvent* _tmp29_;
							_tmp29_ = event_template;
							zeitgeist_event_set_interpretation (_tmp29_, ZEITGEIST_ZG_USER_ACTIVITY);
						}
						_tmp30_ = reason;
						if (_tmp30_->reason == TP_CALL_STATE_CHANGE_REASON_NO_ANSWER) {
							ZeitgeistEvent* _tmp31_;
							_tmp31_ = event_template;
							zeitgeist_event_set_interpretation (_tmp31_, ZEITGEIST_ZG_EXPIRE_EVENT);
						} else {
							ZeitgeistEvent* _tmp32_;
							_tmp32_ = event_template;
							zeitgeist_event_set_interpretation (_tmp32_, ZEITGEIST_ZG_DENY_EVENT);
						}
					}
					_tmp33_ = self->priv->call_timers;
					_tmp34_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					_tmp35_ = g_hash_table_lookup (_tmp33_, _tmp34_);
					duration = g_timer_elapsed ((GTimer*) _tmp35_, NULL);
					_tmp36_ = self->priv->call_timers;
					_tmp37_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					_tmp38_ = g_hash_table_lookup (_tmp36_, _tmp37_);
					_tmp39_ = self->priv->call_timers;
					_tmp40_ = tp_proxy_get_object_path ((TpProxy*) _data4_->channel);
					g_hash_table_remove (_tmp39_, _tmp40_);
					_tmp41_ = json_generator_new ();
					gen = _tmp41_;
					_tmp42_ = json_node_new (JSON_NODE_OBJECT);
					root = _tmp42_;
					_tmp43_ = json_object_new ();
					object = _tmp43_;
					_tmp44_ = root;
					_tmp45_ = object;
					json_node_set_object (_tmp44_, _tmp45_);
					_tmp46_ = gen;
					_tmp47_ = root;
					json_generator_set_root (_tmp46_, _tmp47_);
					_tmp48_ = gen;
					json_generator_set_pretty (_tmp48_, TRUE);
					_tmp49_ = json_object_new ();
					details_obj = _tmp49_;
					_tmp50_ = details_obj;
					json_object_set_int_member (_tmp50_, "state", (gint64) state);
					_tmp51_ = details_obj;
					_tmp52_ = reason;
					json_object_set_int_member (_tmp51_, "reason", (gint64) _tmp52_->reason);
					_tmp53_ = details_obj;
					_tmp54_ = tp_channel_get_requested ((TpChannel*) _data4_->channel);
					_tmp55_ = _tmp54_;
					json_object_set_boolean_member (_tmp53_, "requested", _tmp55_);
					_tmp56_ = details_obj;
					json_object_set_double_member (_tmp56_, "duration", duration);
					_tmp57_ = object;
					_tmp58_ = details_obj;
					_tmp59_ = _json_object_ref0 (_tmp58_);
					json_object_set_object_member (_tmp57_, TELEPATHY_OBSERVER_call_json_domain, _tmp59_);
					_tmp60_ = gen;
					_tmp62_ = json_generator_to_data (_tmp60_, &_tmp61_);
					length = _tmp61_;
					payload_string = _tmp62_;
					_tmp63_ = event_template;
					_tmp64_ = payload_string;
					_tmp65_ = string_get_data (_tmp64_, &_tmp66_);
					_tmp65__length1 = _tmp66_;
					_tmp67_ = _tmp65_;
					_tmp67__length1 = _tmp65__length1;
					_tmp68_ = (_tmp67_ != NULL) ? _vala_array_dup2 (_tmp67_, _tmp67__length1) : _tmp67_;
					_tmp68__length1 = _tmp67__length1;
					_tmp69_ = g_byte_array_new_take (_tmp68_, _tmp68__length1);
					_tmp70_ = _tmp69_;
					zeitgeist_event_set_payload (_tmp63_, _tmp70_);
					_g_byte_array_unref0 (_tmp70_);
					_tmp71_ = event_template;
					telepathy_observer_push_event (self, _tmp71_);
					_g_free0 (payload_string);
					_json_object_unref0 (details_obj);
					_json_object_unref0 (object);
					__vala_JsonNode_free0 (root);
					_g_object_unref0 (gen);
				}
			}
		}
	}
	_g_object_unref0 (event_template);
	__vala_TpCallStateReason_free0 (reason);
}

static void
___lambda8__tp_call_channel_state_changed (TpCallChannel* _sender,
                                           guint state,
                                           guint flags,
                                           TpCallStateReason* reason,
                                           GHashTable* details,
                                           gpointer self)
{
	__lambda8_ (self);
}

static void
telepathy_observer_observe_call_channel (TelepathyObserver* self,
                                         TpSimpleObserver* observer,
                                         TpAccount* account,
                                         TpConnection* connection,
                                         TpChannel* b_channel,
                                         TpChannelDispatchOperation* dispatch_operation,
                                         GList* requests,
                                         TpObserveChannelsContext* context)
{
	Block4Data* _data4_;
	TpAccount* _tmp0_;
	TpCallChannel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data4_->account);
	_data4_->account = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b_channel, tp_call_channel_get_type (), TpCallChannel));
	_data4_->channel = _tmp1_;
	g_signal_connect_data (_data4_->channel, "state-changed", (GCallback) ___lambda8__tp_call_channel_state_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
telepathy_observer_handle_ftchannel_change_data_free (gpointer _data)
{
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->observer);
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->connection);
	_g_object_unref0 (_data_->channel);
	_g_object_unref0 (_data_->dispatch_operation);
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->self);
	g_slice_free (TelepathyObserverHandleFtchannelChangeData, _data_);
}

static void
telepathy_observer_handle_ftchannel_change (TelepathyObserver* self,
                                            TpSimpleObserver* observer,
                                            TpAccount* account,
                                            TpConnection* connection,
                                            TpFileTransferChannel* channel,
                                            TpChannelDispatchOperation* dispatch_operation,
                                            GList* requests,
                                            TpObserveChannelsContext* context,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TelepathyObserverHandleFtchannelChangeData* _data_;
	TelepathyObserver* _tmp0_;
	TpSimpleObserver* _tmp1_;
	TpAccount* _tmp2_;
	TpConnection* _tmp3_;
	TpFileTransferChannel* _tmp4_;
	TpChannelDispatchOperation* _tmp5_;
	TpObserveChannelsContext* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (context != NULL);
	_data_ = g_slice_new0 (TelepathyObserverHandleFtchannelChangeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, telepathy_observer_handle_ftchannel_change_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (observer);
	_g_object_unref0 (_data_->observer);
	_data_->observer = _tmp1_;
	_tmp2_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	_tmp3_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data_->connection);
	_data_->connection = _tmp3_;
	_tmp4_ = _g_object_ref0 (channel);
	_g_object_unref0 (_data_->channel);
	_data_->channel = _tmp4_;
	_tmp5_ = _g_object_ref0 (dispatch_operation);
	_g_object_unref0 (_data_->dispatch_operation);
	_data_->dispatch_operation = _tmp5_;
	_data_->requests = requests;
	_tmp6_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp6_;
	telepathy_observer_handle_ftchannel_change_co (_data_);
}

static void
telepathy_observer_handle_ftchannel_change_finish (TelepathyObserver* self,
                                                   GAsyncResult* _res_)
{
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
telepathy_observer_handle_ftchannel_change_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	TelepathyObserverHandleFtchannelChangeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	telepathy_observer_handle_ftchannel_change_co (_data_);
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
telepathy_observer_handle_ftchannel_change_co (TelepathyObserverHandleFtchannelChangeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_get (_data_->channel, "state", &_data_->_tmp1_, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == ((guint) TP_FILE_TRANSFER_STATE_COMPLETED)) {
		_data_->_tmp0_ = TRUE;
	} else {
		g_object_get (_data_->channel, "state", &_data_->_tmp3_, NULL);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ == ((guint) TP_FILE_TRANSFER_STATE_CANCELLED);
	}
	if (_data_->_tmp0_) {
		_data_->_tmp5_ = tp_channel_get_target_contact ((TpChannel*) _data_->channel);
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
		_data_->target = _data_->_tmp6_;
		_data_->_tmp7_ = g_strdup_printf ("%s, %s, %s", G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_SIZE);
		_data_->attr = _data_->_tmp7_;
		_data_->info = NULL;
		{
			g_object_get (_data_->channel, "file", &_data_->_tmp9_, NULL);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->attr;
			_data_->_state_ = 1;
			g_file_query_info_async (_data_->_tmp11_, _data_->_tmp12_, 0, G_PRIORITY_DEFAULT, NULL, telepathy_observer_handle_ftchannel_change_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp13_ = g_file_query_info_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_g_object_unref0 (_data_->_tmp11_);
			_data_->_tmp8_ = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp15_ = _data_->_tmp8_;
			_data_->_tmp8_ = NULL;
			_g_object_unref0 (_data_->info);
			_data_->info = _data_->_tmp15_;
			_g_object_unref0 (_data_->_tmp8_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			g_object_get (_data_->channel, "file", &_data_->_tmp16_, NULL);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = g_file_get_path (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = _data_->err;
			_data_->_tmp22_ = _data_->_tmp21_->message;
			g_warning ("telepathy-observer.vala:362: Couldn't process %s: %s", _data_->_tmp20_, _data_->_tmp22_);
			_g_free0 (_data_->_tmp20_);
			_g_object_unref0 (_data_->_tmp18_);
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->info);
			_g_free0 (_data_->attr);
			_g_object_unref0 (_data_->target);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->info);
			_g_free0 (_data_->attr);
			_g_object_unref0 (_data_->target);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = tp_proxy_get_object_path ((TpProxy*) _data_->account);
		_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
		_data_->obj_path = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->obj_path;
		_data_->_tmp26_ = strlen (TP_ACCOUNT_OBJECT_PATH_BASE);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = _data_->obj_path;
		_data_->_tmp29_ = strlen (_data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = string_slice (_data_->_tmp25_, (glong) _data_->_tmp27_, (glong) _data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_account_path, "%s", _data_->_tmp32_);
		_g_free0 (_data_->obj_path);
		_data_->obj_path = _data_->_tmp33_;
		_g_free0 (_data_->_tmp32_);
		_data_->_tmp34_ = zeitgeist_event_new ();
		_data_->event_template = _data_->_tmp34_;
		_data_->_tmp35_ = tp_channel_get_requested ((TpChannel*) _data_->channel);
		_data_->_tmp36_ = _data_->_tmp35_;
		if (_data_->_tmp36_) {
			_data_->_tmp37_ = _data_->event_template;
			zeitgeist_event_set_interpretation (_data_->_tmp37_, ZEITGEIST_ZG_SEND_EVENT);
			_data_->_tmp38_ = _data_->event_template;
			zeitgeist_event_set_manifestation (_data_->_tmp38_, ZEITGEIST_ZG_USER_ACTIVITY);
		} else {
			_data_->_tmp39_ = _data_->event_template;
			zeitgeist_event_set_interpretation (_data_->_tmp39_, ZEITGEIST_ZG_RECEIVE_EVENT);
			_data_->_tmp40_ = _data_->event_template;
			zeitgeist_event_set_manifestation (_data_->_tmp40_, ZEITGEIST_ZG_WORLD_ACTIVITY);
		}
		_data_->_tmp41_ = _data_->event_template;
		zeitgeist_event_set_actor (_data_->_tmp41_, TELEPATHY_OBSERVER_actor);
		_data_->_tmp42_ = zeitgeist_subject_new ();
		_data_->subj = _data_->_tmp42_;
		_data_->_tmp43_ = _data_->subj;
		g_object_get (_data_->channel, "file", &_data_->_tmp44_, NULL);
		_data_->_tmp45_ = _data_->_tmp44_;
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = g_file_get_uri (_data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		zeitgeist_subject_set_uri (_data_->_tmp43_, _data_->_tmp48_);
		_g_free0 (_data_->_tmp48_);
		_g_object_unref0 (_data_->_tmp46_);
		_data_->_tmp49_ = _data_->subj;
		_data_->_tmp50_ = _data_->info;
		_data_->_tmp51_ = g_file_info_get_content_type (_data_->_tmp50_);
		_data_->_tmp52_ = zeitgeist_interpretation_for_mimetype (_data_->_tmp51_);
		zeitgeist_subject_set_interpretation (_data_->_tmp49_, _data_->_tmp52_);
		_data_->_tmp53_ = _data_->subj;
		zeitgeist_subject_set_manifestation (_data_->_tmp53_, ZEITGEIST_NFO_FILE_DATA_OBJECT);
		_data_->_tmp54_ = _data_->subj;
		_data_->_tmp55_ = _data_->info;
		_data_->_tmp56_ = g_file_info_get_display_name (_data_->_tmp55_);
		zeitgeist_subject_set_text (_data_->_tmp54_, _data_->_tmp56_);
		_data_->_tmp57_ = _data_->subj;
		_data_->_tmp58_ = _data_->info;
		_data_->_tmp59_ = g_file_info_get_content_type (_data_->_tmp58_);
		zeitgeist_subject_set_mimetype (_data_->_tmp57_, _data_->_tmp59_);
		_data_->_tmp60_ = tp_channel_get_requested ((TpChannel*) _data_->channel);
		_data_->_tmp61_ = _data_->_tmp60_;
		if (_data_->_tmp61_ == TRUE) {
			g_object_get (_data_->channel, "file", &_data_->_tmp62_, NULL);
			_data_->_tmp63_ = _data_->_tmp62_;
			_data_->_tmp64_ = _data_->_tmp63_;
			_data_->_tmp65_ = g_file_get_uri (_data_->_tmp64_);
			_data_->_tmp66_ = _data_->_tmp65_;
			_data_->_tmp68_ = _data_->_tmp67_ = g_strsplit (_data_->_tmp66_, "/", 0);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp69__length1 = _vala_array_length (_data_->_tmp67_);
			_g_free0 (_data_->_tmp66_);
			_g_object_unref0 (_data_->_tmp64_);
			_data_->split_uri = _data_->_tmp69_;
			_data_->split_uri_length1 = _data_->_tmp69__length1;
			_data_->_split_uri_size_ = _data_->split_uri_length1;
			_data_->_tmp70_ = _data_->split_uri;
			_data_->_tmp70__length1 = _data_->split_uri_length1;
			_data_->_tmp71_ = _data_->split_uri;
			_data_->_tmp71__length1 = _data_->split_uri_length1;
			_data_->_tmp72_ = g_strjoin ("/", _data_->_tmp70_ + 0, NULL);
			_data_->_tmp73_ = _data_->_tmp72_;
			_data_->_tmp74_ = g_strdup_printf ("%s/", _data_->_tmp73_);
			_data_->_tmp75_ = _data_->_tmp74_;
			_g_free0 (_data_->_tmp73_);
			_data_->uri = _data_->_tmp75_;
			_data_->_tmp76_ = _data_->subj;
			_data_->_tmp77_ = _data_->uri;
			zeitgeist_subject_set_origin (_data_->_tmp76_, _data_->_tmp77_);
			_g_free0 (_data_->uri);
			_data_->split_uri = (_vala_array_free (_data_->split_uri, _data_->split_uri_length1, (GDestroyNotify) g_free), NULL);
		} else {
			_data_->_tmp78_ = _data_->subj;
			_data_->_tmp79_ = _data_->target;
			_data_->_tmp80_ = tp_contact_get_identifier (_data_->_tmp79_);
			_data_->_tmp81_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _data_->_tmp80_);
			_data_->_tmp82_ = _data_->_tmp81_;
			zeitgeist_subject_set_origin (_data_->_tmp78_, _data_->_tmp82_);
			_g_free0 (_data_->_tmp82_);
		}
		_data_->_tmp83_ = _data_->event_template;
		_data_->_tmp84_ = _data_->subj;
		zeitgeist_event_add_subject (_data_->_tmp83_, _data_->_tmp84_);
		_data_->_tmp85_ = _data_->event_template;
		_data_->_tmp86_ = _data_->target;
		_data_->_tmp87_ = tp_contact_get_identifier (_data_->_tmp86_);
		_data_->_tmp88_ = g_strdup_printf (TELEPATHY_OBSERVER_tp_identifier, _data_->_tmp87_);
		_data_->_tmp89_ = _data_->_tmp88_;
		_data_->_tmp90_ = _data_->obj_path;
		_data_->_tmp91_ = _data_->target;
		_data_->_tmp92_ = tp_contact_get_alias (_data_->_tmp91_);
		_data_->_tmp93_ = zeitgeist_subject_new_full (_data_->_tmp89_, ZEITGEIST_NCO_CONTACT, ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT, "", _data_->_tmp90_, _data_->_tmp92_, "net");
		_data_->_tmp94_ = _data_->_tmp93_;
		zeitgeist_event_add_subject (_data_->_tmp85_, _data_->_tmp94_);
		_g_object_unref0 (_data_->_tmp94_);
		_g_free0 (_data_->_tmp89_);
		_data_->_tmp95_ = json_generator_new ();
		_data_->gen = _data_->_tmp95_;
		_data_->_tmp96_ = json_node_new (JSON_NODE_OBJECT);
		_data_->root = _data_->_tmp96_;
		_data_->_tmp97_ = json_object_new ();
		_data_->object = _data_->_tmp97_;
		_data_->_tmp98_ = _data_->root;
		_data_->_tmp99_ = _data_->object;
		json_node_set_object (_data_->_tmp98_, _data_->_tmp99_);
		_data_->_tmp100_ = _data_->gen;
		_data_->_tmp101_ = _data_->root;
		json_generator_set_root (_data_->_tmp100_, _data_->_tmp101_);
		_data_->_tmp102_ = _data_->gen;
		json_generator_set_pretty (_data_->_tmp102_, TRUE);
		_data_->_tmp103_ = json_object_new ();
		_data_->details_obj = _data_->_tmp103_;
		_data_->_tmp104_ = 0;
		_data_->_tmp105_ = tp_file_transfer_channel_get_state (_data_->channel, &_data_->_tmp104_);
		_data_->reason = _data_->_tmp104_;
		_data_->state = _data_->_tmp105_;
		_data_->_tmp106_ = _data_->details_obj;
		json_object_set_int_member (_data_->_tmp106_, "state", (gint64) _data_->state);
		_data_->_tmp107_ = _data_->details_obj;
		json_object_set_int_member (_data_->_tmp107_, "reason", (gint64) _data_->reason);
		_data_->_tmp108_ = _data_->details_obj;
		_data_->_tmp109_ = tp_channel_get_requested ((TpChannel*) _data_->channel);
		_data_->_tmp110_ = _data_->_tmp109_;
		json_object_set_boolean_member (_data_->_tmp108_, "requested", _data_->_tmp110_);
		_data_->_tmp111_ = _data_->details_obj;
		_data_->_tmp112_ = tp_file_transfer_channel_get_description (_data_->channel);
		json_object_set_string_member (_data_->_tmp111_, "description", _data_->_tmp112_);
		_data_->_tmp113_ = _data_->details_obj;
		json_object_set_double_member (_data_->_tmp113_, "size", (gdouble) ((gint64) tp_file_transfer_channel_get_size (_data_->channel)));
		_data_->_tmp114_ = _data_->details_obj;
		_data_->_tmp115_ = tp_file_transfer_channel_get_service_name (_data_->channel);
		json_object_set_string_member (_data_->_tmp114_, "service", _data_->_tmp115_);
		_data_->_tmp116_ = _data_->object;
		_data_->_tmp117_ = _data_->details_obj;
		_data_->_tmp118_ = _json_object_ref0 (_data_->_tmp117_);
		json_object_set_object_member (_data_->_tmp116_, TELEPATHY_OBSERVER_ft_json_domain, _data_->_tmp118_);
		_data_->_tmp119_ = _data_->gen;
		_data_->_tmp120_ = 0UL;
		_data_->_tmp121_ = json_generator_to_data (_data_->_tmp119_, &_data_->_tmp120_);
		_data_->length = _data_->_tmp120_;
		_data_->payload_string = _data_->_tmp121_;
		_data_->_tmp122_ = _data_->event_template;
		_data_->_tmp123_ = _data_->payload_string;
		_data_->_tmp125_ = 0;
		_data_->_tmp124_ = string_get_data (_data_->_tmp123_, &_data_->_tmp125_);
		_data_->_tmp124__length1 = _data_->_tmp125_;
		_data_->_tmp126_ = _data_->_tmp124_;
		_data_->_tmp126__length1 = _data_->_tmp124__length1;
		_data_->_tmp127_ = (_data_->_tmp126_ != NULL) ? _vala_array_dup3 (_data_->_tmp126_, _data_->_tmp126__length1) : _data_->_tmp126_;
		_data_->_tmp127__length1 = _data_->_tmp126__length1;
		_data_->_tmp128_ = g_byte_array_new_take (_data_->_tmp127_, _data_->_tmp127__length1);
		_data_->_tmp129_ = _data_->_tmp128_;
		zeitgeist_event_set_payload (_data_->_tmp122_, _data_->_tmp129_);
		_g_byte_array_unref0 (_data_->_tmp129_);
		_data_->_tmp130_ = _data_->event_template;
		telepathy_observer_push_event (_data_->self, _data_->_tmp130_);
		_g_free0 (_data_->payload_string);
		_json_object_unref0 (_data_->details_obj);
		_json_object_unref0 (_data_->object);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->gen);
		_g_object_unref0 (_data_->subj);
		_g_object_unref0 (_data_->event_template);
		_g_free0 (_data_->obj_path);
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->attr);
		_g_object_unref0 (_data_->target);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TelepathyObserver* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->channel);
		_g_object_unref0 (_data5_->observer);
		_g_object_unref0 (_data5_->account);
		_g_object_unref0 (_data5_->connection);
		_g_object_unref0 (_data5_->dispatch_operation);
		_g_object_unref0 (_data5_->context);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda9_ (Block5Data* _data5_)
{
	TelepathyObserver* self;
	self = _data5_->self;
	telepathy_observer_handle_ftchannel_change (self, _data5_->observer, _data5_->account, _data5_->connection, _data5_->channel, _data5_->dispatch_operation, _data5_->requests, _data5_->context, NULL, NULL);
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ (self);
}

static void
telepathy_observer_observe_ft_channel (TelepathyObserver* self,
                                       TpSimpleObserver* observer,
                                       TpAccount* account,
                                       TpConnection* connection,
                                       TpChannel* b_channel,
                                       TpChannelDispatchOperation* dispatch_operation,
                                       GList* requests,
                                       TpObserveChannelsContext* context)
{
	Block5Data* _data5_;
	TpSimpleObserver* _tmp0_;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_;
	TpChannelDispatchOperation* _tmp3_;
	TpObserveChannelsContext* _tmp4_;
	TpFileTransferChannel* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (b_channel != NULL);
	g_return_if_fail (context != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (observer);
	_g_object_unref0 (_data5_->observer);
	_data5_->observer = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data5_->account);
	_data5_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data5_->connection);
	_data5_->connection = _tmp2_;
	_tmp3_ = _g_object_ref0 (dispatch_operation);
	_g_object_unref0 (_data5_->dispatch_operation);
	_data5_->dispatch_operation = _tmp3_;
	_data5_->requests = requests;
	_tmp4_ = _g_object_ref0 (context);
	_g_object_unref0 (_data5_->context);
	_data5_->context = _tmp4_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b_channel, tp_file_transfer_channel_get_type (), TpFileTransferChannel));
	_data5_->channel = _tmp5_;
	g_signal_connect_data ((GObject*) _data5_->channel, "notify::state", (GCallback) ___lambda9__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
telepathy_observer_observe_channels (TelepathyObserver* self,
                                     TpSimpleObserver* observer,
                                     TpAccount* account,
                                     TpConnection* connection,
                                     GList* channels,
                                     TpChannelDispatchOperation* dispatch_operation,
                                     GList* requests,
                                     TpObserveChannelsContext* context)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (observer != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (context != NULL);
	{
		{
			GList* channel_collection = NULL;
			GList* channel_it = NULL;
			channel_collection = channels;
			for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
				TpChannel* _tmp0_;
				TpChannel* channel = NULL;
				_tmp0_ = _g_object_ref0 ((TpChannel*) channel_it->data);
				channel = _tmp0_;
				{
					TpChannel* _tmp1_;
					_tmp1_ = channel;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, tp_text_channel_get_type ())) {
						TpChannel* _tmp2_;
						_tmp2_ = channel;
						telepathy_observer_observe_text_channel (self, observer, account, connection, _tmp2_, dispatch_operation, requests, context);
					} else {
						TpChannel* _tmp3_;
						_tmp3_ = channel;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, tp_call_channel_get_type ())) {
							TpChannel* _tmp4_;
							_tmp4_ = channel;
							telepathy_observer_observe_call_channel (self, observer, account, connection, _tmp4_, dispatch_operation, requests, context);
						} else {
							TpChannel* _tmp5_;
							_tmp5_ = channel;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, tp_file_transfer_channel_get_type ())) {
								TpChannel* _tmp6_;
								_tmp6_ = channel;
								telepathy_observer_observe_ft_channel (self, observer, account, connection, _tmp6_, dispatch_operation, requests, context);
							}
						}
					}
					_g_object_unref0 (channel);
				}
			}
		}
	}
	__finally0:
	{
		tp_observe_channels_context_accept (context);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl (TpSimpleObserver* observer,
                                                                               TpAccount* account,
                                                                               TpConnection* connection,
                                                                               GList* channels,
                                                                               TpChannelDispatchOperation* dispatch_operation,
                                                                               GList* requests,
                                                                               TpObserveChannelsContext* context,
                                                                               gpointer self)
{
	telepathy_observer_observe_channels ((TelepathyObserver*) self, observer, account, connection, channels, dispatch_operation, requests, context);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static void
telepathy_observer_real_start (DataProvider* base)
{
	TelepathyObserver * self;
	TpAutomaticClientFactory* _tmp0_;
	TpSimpleObserver* _tmp1_;
	GHashTable* call_filter = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	GValue* _tmp6_ = NULL;
	gchar* _tmp7_;
	GValue* _tmp8_ = NULL;
	TpSimpleObserver* _tmp9_;
	GHashTable* text_filter = NULL;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	GValue* _tmp14_ = NULL;
	gchar* _tmp15_;
	GValue* _tmp16_ = NULL;
	TpSimpleObserver* _tmp17_;
	GHashTable* ft_filter = NULL;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	gchar* _tmp21_;
	GValue* _tmp22_ = NULL;
	gchar* _tmp23_;
	GValue* _tmp24_ = NULL;
	TpSimpleObserver* _tmp25_;
	GError* _inner_error0_ = NULL;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->factory;
	_tmp1_ = (TpSimpleObserver*) tp_simple_observer_new_with_factory ((TpSimpleClientFactory*) _tmp0_, TRUE, "Zeitgeist", FALSE, _telepathy_observer_observe_channels_tp_simple_observer_observe_channels_impl, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->observer);
	self->priv->observer = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, __vala_GValue_free0_);
	call_filter = _tmp4_;
	_tmp5_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, TP_IFACE_CHANNEL_TYPE_CALL);
	g_hash_table_insert (call_filter, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_INT);
	g_value_set_int (_tmp8_, 1);
	g_hash_table_insert (call_filter, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp9_, call_filter);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, __vala_GValue_free0_);
	text_filter = _tmp12_;
	_tmp13_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp14_ = g_new0 (GValue, 1);
	g_value_init (_tmp14_, G_TYPE_STRING);
	g_value_set_string (_tmp14_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (text_filter, _tmp13_, _tmp14_);
	_tmp15_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp16_ = g_new0 (GValue, 1);
	g_value_init (_tmp16_, G_TYPE_INT);
	g_value_set_int (_tmp16_, 1);
	g_hash_table_insert (text_filter, _tmp15_, _tmp16_);
	_tmp17_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp17_, text_filter);
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, __vala_GValue_free0_);
	ft_filter = _tmp20_;
	_tmp21_ = g_strdup (TP_PROP_CHANNEL_CHANNEL_TYPE);
	_tmp22_ = g_new0 (GValue, 1);
	g_value_init (_tmp22_, G_TYPE_STRING);
	g_value_set_string (_tmp22_, TP_IFACE_CHANNEL_TYPE_FILE_TRANSFER);
	g_hash_table_insert (ft_filter, _tmp21_, _tmp22_);
	_tmp23_ = g_strdup (TP_PROP_CHANNEL_TARGET_HANDLE_TYPE);
	_tmp24_ = g_new0 (GValue, 1);
	g_value_init (_tmp24_, G_TYPE_INT);
	g_value_set_int (_tmp24_, 1);
	g_hash_table_insert (ft_filter, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->observer;
	tp_base_client_add_observer_filter ((TpBaseClient*) _tmp25_, ft_filter);
	{
		TpSimpleObserver* _tmp26_;
		_tmp26_ = self->priv->observer;
		tp_base_client_register ((TpBaseClient*) _tmp26_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = err;
		_tmp28_ = _tmp27_->message;
		g_warning ("telepathy-observer.vala:515: Couldn't register observer: %s", _tmp28_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (ft_filter);
		_g_hash_table_unref0 (text_filter);
		_g_hash_table_unref0 (call_filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_hash_table_unref0 (ft_filter);
	_g_hash_table_unref0 (text_filter);
	_g_hash_table_unref0 (call_filter);
}

static void
telepathy_observer_real_stop (DataProvider* base)
{
	TelepathyObserver * self;
	TpSimpleObserver* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->observer;
	tp_base_client_unregister ((TpBaseClient*) _tmp0_);
}

static const gchar*
telepathy_observer_real_get_unique_id (DataProvider* base)
{
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}

static void
telepathy_observer_real_set_unique_id (DataProvider* base,
                                       const gchar* value)
{
	TelepathyObserver* self;
	gchar* old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_unique_id (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY]);
	}
}

static const gchar*
telepathy_observer_real_get_name (DataProvider* base)
{
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
telepathy_observer_real_set_name (DataProvider* base,
                                  const gchar* value)
{
	TelepathyObserver* self;
	gchar* old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_NAME_PROPERTY]);
	}
}

static const gchar*
telepathy_observer_real_get_description (DataProvider* base)
{
	const gchar* result;
	TelepathyObserver* self;
	const gchar* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
telepathy_observer_real_set_description (DataProvider* base,
                                         const gchar* value)
{
	TelepathyObserver* self;
	gchar* old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_description (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY]);
	}
}

static DataHub*
telepathy_observer_real_get_datahub (DataProvider* base)
{
	DataHub* result;
	TelepathyObserver* self;
	DataHub* _tmp0_;
	self = (TelepathyObserver*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}

static void
telepathy_observer_real_set_datahub (DataProvider* base,
                                     DataHub* value)
{
	TelepathyObserver* self;
	DataHub* old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_datahub (base);
	if (old_value != value) {
		DataHub* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_DATAHUB_PROPERTY]);
	}
}

static gboolean
telepathy_observer_real_get_enabled (DataProvider* base)
{
	gboolean result;
	TelepathyObserver* self;
	self = (TelepathyObserver*) base;
	result = self->priv->_enabled;
	return result;
}

static void
telepathy_observer_real_set_enabled (DataProvider* base,
                                     gboolean value)
{
	TelepathyObserver* self;
	gboolean old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_ENABLED_PROPERTY]);
	}
}

static gboolean
telepathy_observer_real_get_register (DataProvider* base)
{
	gboolean result;
	TelepathyObserver* self;
	self = (TelepathyObserver*) base;
	result = self->priv->_register;
	return result;
}

static void
telepathy_observer_real_set_register (DataProvider* base,
                                      gboolean value)
{
	TelepathyObserver* self;
	gboolean old_value;
	self = (TelepathyObserver*) base;
	old_value = telepathy_observer_real_get_register (base);
	if (old_value != value) {
		self->priv->_register = value;
		g_object_notify_by_pspec ((GObject *) self, telepathy_observer_properties[TELEPATHY_OBSERVER_REGISTER_PROPERTY]);
	}
}

static void
_g_timer_destroy0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL));
}

static GObject *
telepathy_observer_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TelepathyObserver * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	TpDBusDaemon* _tmp8_;
	TpAutomaticClientFactory* _tmp9_;
	GQuark* channel_quark = NULL;
	GQuark* _tmp10_;
	gint channel_quark_length1;
	gint _channel_quark_size_;
	TpContactFeature* contact_quark = NULL;
	TpContactFeature* _tmp11_;
	gint contact_quark_length1;
	gint _contact_quark_size_;
	TpAutomaticClientFactory* _tmp12_;
	GQuark* _tmp13_;
	gint _tmp13__length1;
	TpAutomaticClientFactory* _tmp14_;
	TpContactFeature* _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (telepathy_observer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TELEPATHY_OBSERVER, TelepathyObserver);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_timer_destroy0_);
	_g_hash_table_unref0 (self->priv->call_timers);
	self->priv->call_timers = _tmp2_;
	{
		TpDBusDaemon* _tmp3_ = NULL;
		TpDBusDaemon* _tmp4_;
		TpDBusDaemon* _tmp5_;
		_tmp4_ = tp_dbus_daemon_dup (&_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->dbus);
		self->priv->dbus = _tmp5_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("telepathy-observer.vala:57: Couldn't dup DBusDaemon: %s", _tmp7_);
		_g_error_free0 (err);
		return obj;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp8_ = self->priv->dbus;
	_tmp9_ = tp_automatic_client_factory_new (_tmp8_);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp9_;
	_tmp10_ = g_new0 (GQuark, 1);
	_tmp10_[0] = tp_channel_get_feature_quark_contacts ();
	channel_quark = _tmp10_;
	channel_quark_length1 = 1;
	_channel_quark_size_ = channel_quark_length1;
	_tmp11_ = g_new0 (TpContactFeature, 1);
	_tmp11_[0] = TP_CONTACT_FEATURE_ALIAS;
	contact_quark = _tmp11_;
	contact_quark_length1 = 1;
	_contact_quark_size_ = contact_quark_length1;
	_tmp12_ = self->priv->factory;
	_tmp13_ = channel_quark;
	_tmp13__length1 = channel_quark_length1;
	tp_simple_client_factory_add_channel_features ((TpSimpleClientFactory*) _tmp12_, _tmp13_);
	_tmp14_ = self->priv->factory;
	_tmp15_ = contact_quark;
	_tmp15__length1 = contact_quark_length1;
	tp_simple_client_factory_add_contact_features ((TpSimpleClientFactory*) _tmp14_, (guint) _tmp15__length1, _tmp15_);
	contact_quark = (g_free (contact_quark), NULL);
	channel_quark = (g_free (channel_quark), NULL);
	return obj;
}

static void
telepathy_observer_class_init (TelepathyObserverClass * klass,
                               gpointer klass_data)
{
	telepathy_observer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TelepathyObserver_private_offset);
	((DataProviderClass *) klass)->start = (void (*) (DataProvider*)) telepathy_observer_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider*)) telepathy_observer_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = (const gchar* (*) (DataProvider*)) telepathy_observer_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = (void (*) (DataProvider*, const gchar*)) telepathy_observer_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = (const gchar* (*) (DataProvider*)) telepathy_observer_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = (void (*) (DataProvider*, const gchar*)) telepathy_observer_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = (const gchar* (*) (DataProvider*)) telepathy_observer_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = (void (*) (DataProvider*, const gchar*)) telepathy_observer_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = (DataHub* (*) (DataProvider*)) telepathy_observer_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = (void (*) (DataProvider*, DataHub*)) telepathy_observer_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = (gboolean (*) (DataProvider*)) telepathy_observer_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = (void (*) (DataProvider*, gboolean)) telepathy_observer_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = (gboolean (*) (DataProvider*)) telepathy_observer_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = (void (*) (DataProvider*, gboolean)) telepathy_observer_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_telepathy_observer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_telepathy_observer_set_property;
	G_OBJECT_CLASS (klass)->constructor = telepathy_observer_constructor;
	G_OBJECT_CLASS (klass)->finalize = telepathy_observer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_NAME_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_DATAHUB_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_ENABLED_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TELEPATHY_OBSERVER_REGISTER_PROPERTY, telepathy_observer_properties[TELEPATHY_OBSERVER_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
telepathy_observer_instance_init (TelepathyObserver * self,
                                  gpointer klass)
{
	self->priv = telepathy_observer_get_instance_private (self);
	self->priv->dbus = NULL;
	self->priv->factory = NULL;
	self->priv->observer = NULL;
	self->priv->call_timers = NULL;
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
}

static void
telepathy_observer_finalize (GObject * obj)
{
	TelepathyObserver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TELEPATHY_OBSERVER, TelepathyObserver);
	_g_object_unref0 (self->priv->dbus);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->observer);
	_g_hash_table_unref0 (self->priv->call_timers);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	G_OBJECT_CLASS (telepathy_observer_parent_class)->finalize (obj);
}

static GType
telepathy_observer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TelepathyObserverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) telepathy_observer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TelepathyObserver), 0, (GInstanceInitFunc) telepathy_observer_instance_init, NULL };
	GType telepathy_observer_type_id;
	telepathy_observer_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "TelepathyObserver", &g_define_type_info, 0);
	TelepathyObserver_private_offset = g_type_add_instance_private (telepathy_observer_type_id, sizeof (TelepathyObserverPrivate));
	return telepathy_observer_type_id;
}

GType
telepathy_observer_get_type (void)
{
	static volatile gsize telepathy_observer_type_id__once = 0;
	if (g_once_init_enter (&telepathy_observer_type_id__once)) {
		GType telepathy_observer_type_id;
		telepathy_observer_type_id = telepathy_observer_get_type_once ();
		g_once_init_leave (&telepathy_observer_type_id__once, telepathy_observer_type_id);
	}
	return telepathy_observer_type_id__once;
}

static void
_vala_telepathy_observer_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	TelepathyObserver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TELEPATHY_OBSERVER, TelepathyObserver);
	switch (property_id) {
		case TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case TELEPATHY_OBSERVER_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_telepathy_observer_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	TelepathyObserver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TELEPATHY_OBSERVER, TelepathyObserver);
	switch (property_id) {
		case TELEPATHY_OBSERVER_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case TELEPATHY_OBSERVER_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case TELEPATHY_OBSERVER_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case TELEPATHY_OBSERVER_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

