/* desktop-launch-listener.c generated by valac 0.56.16, the Vala compiler
 * generated from desktop-launch-listener.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010, 2012 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include "zeitgeist-datamodel.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_DESKTOP_LAUNCH_LISTENER (desktop_launch_listener_get_type ())
#define DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener))
#define DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))
#define IS_DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_LAUNCH_LISTENER))
#define IS_DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_LAUNCH_LISTENER))
#define DESKTOP_LAUNCH_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))

typedef struct _DesktopLaunchListener DesktopLaunchListener;
typedef struct _DesktopLaunchListenerClass DesktopLaunchListenerClass;
typedef struct _DesktopLaunchListenerPrivate DesktopLaunchListenerPrivate;
enum  {
	DESKTOP_LAUNCH_LISTENER_0_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_NUM_PROPERTIES
};
static GParamSpec* desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _DesktopLaunchListener {
	DataProvider parent_instance;
	DesktopLaunchListenerPrivate * priv;
};

struct _DesktopLaunchListenerClass {
	DataProviderClass parent_class;
};

struct _DesktopLaunchListenerPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GDBusConnection* bus;
	guint launched_signal_id;
};

static gint DesktopLaunchListener_private_offset;
static gpointer desktop_launch_listener_parent_class = NULL;

VALA_EXTERN GType data_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataProvider, g_object_unref)
VALA_EXTERN GType data_hub_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataHub, g_object_unref)
VALA_EXTERN GType desktop_launch_listener_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopLaunchListener, g_object_unref)
VALA_EXTERN void data_provider_start (DataProvider* self);
VALA_EXTERN void data_provider_stop (DataProvider* self);
VALA_EXTERN const gchar* data_provider_get_unique_id (DataProvider* self);
VALA_EXTERN void data_provider_set_unique_id (DataProvider* self,
                                  const gchar* value);
VALA_EXTERN const gchar* data_provider_get_name (DataProvider* self);
VALA_EXTERN void data_provider_set_name (DataProvider* self,
                             const gchar* value);
VALA_EXTERN const gchar* data_provider_get_description (DataProvider* self);
VALA_EXTERN void data_provider_set_description (DataProvider* self,
                                    const gchar* value);
VALA_EXTERN DataHub* data_provider_get_datahub (DataProvider* self);
VALA_EXTERN void data_provider_set_datahub (DataProvider* self,
                                DataHub* value);
VALA_EXTERN gboolean data_provider_get_enabled (DataProvider* self);
VALA_EXTERN void data_provider_set_enabled (DataProvider* self,
                                gboolean value);
VALA_EXTERN gboolean data_provider_get_register (DataProvider* self);
VALA_EXTERN void data_provider_set_register (DataProvider* self,
                                 gboolean value);
VALA_EXTERN DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub);
VALA_EXTERN DesktopLaunchListener* desktop_launch_listener_construct (GType object_type,
                                                          DataHub* datahub);
static void desktop_launch_listener_real_start (DataProvider* base);
static void desktop_launch_listener_signal_received (DesktopLaunchListener* self,
                                              GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* signal_name,
                                              GVariant* parameters);
static void _desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection,
                                                                      const gchar* sender_name,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* signal_name,
                                                                      GVariant* parameters,
                                                                      gpointer self);
static GHashTable* _variant_get1 (GVariant* value);
VALA_EXTERN gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file,
                                         GDesktopAppInfo** dai);
static void _g_object_unref0_ (gpointer var);
static void desktop_launch_listener_real_stop (DataProvider* base);
static GObject * desktop_launch_listener_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void desktop_launch_listener_finalize (GObject * obj);
static GType desktop_launch_listener_get_type_once (void);
static void _vala_desktop_launch_listener_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_desktop_launch_listener_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
desktop_launch_listener_get_instance_private (DesktopLaunchListener* self)
{
	return G_STRUCT_MEMBER_P (self, DesktopLaunchListener_private_offset);
}

DesktopLaunchListener*
desktop_launch_listener_construct (GType object_type,
                                   DataHub* datahub)
{
	DesktopLaunchListener * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (DesktopLaunchListener*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,gio-launch-listener", "name", "Launched desktop files", "description", "Logs events about launched desktop files using GIO", "datahub", datahub, NULL);
	return self;
}

DesktopLaunchListener*
desktop_launch_listener_new (DataHub* datahub)
{
	return desktop_launch_listener_construct (TYPE_DESKTOP_LAUNCH_LISTENER, datahub);
}

static void
_desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection,
                                                                 const gchar* sender_name,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* signal_name,
                                                                 GVariant* parameters,
                                                                 gpointer self)
{
	desktop_launch_listener_signal_received ((DesktopLaunchListener*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
desktop_launch_listener_real_start (DataProvider* base)
{
	DesktopLaunchListener * self;
	GDBusConnection* _tmp0_;
	self = (DesktopLaunchListener*) base;
	if (self->priv->launched_signal_id != ((guint) 0)) {
		return;
	}
	_tmp0_ = self->priv->bus;
	self->priv->launched_signal_id = g_dbus_connection_signal_subscribe (_tmp0_, NULL, "org.gtk.gio.DesktopAppInfo", "Launched", "/org/gtk/gio/DesktopAppInfo", NULL, 0, _desktop_launch_listener_signal_received_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
}

static GHashTable*
_variant_get1 (GVariant* value)
{
	GHashTable* _tmp0_;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp1_, value);
	while (g_variant_iter_loop (&_tmp1_, "{?*}", &_tmp2_, &_tmp3_)) {
		g_hash_table_insert (_tmp0_, g_variant_dup_string (_tmp2_, NULL), g_variant_get_variant (_tmp3_));
	}
	return _tmp0_;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
desktop_launch_listener_signal_received (DesktopLaunchListener* self,
                                         GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* signal_name,
                                         GVariant* parameters)
{
	GVariant* desktop_variant = NULL;
	GVariantIter* uris = NULL;
	GVariant* dict = NULL;
	gint64 pid = 0LL;
	GVariant* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gchar* desktop_file = NULL;
	GVariant* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* uri = NULL;
	GHashTable* extra_params = NULL;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	GDesktopAppInfo* dai = NULL;
	gchar* launched_uri = NULL;
	const gchar* _tmp14_;
	GDesktopAppInfo* _tmp15_ = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* launcher_uri = NULL;
	GVariant* origin_df = NULL;
	GHashTable* _tmp19_;
	gconstpointer _tmp20_;
	GVariant* _tmp21_;
	GDesktopAppInfo* _tmp37_;
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp38_;
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp39_;
	ZeitgeistEvent* _tmp40_;
	const gchar* _tmp41_;
	ZeitgeistEvent* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	ZeitgeistEvent* _tmp44_;
	ZeitgeistSubject* _tmp45_;
	ZeitgeistSubject* _tmp46_;
	const gchar* _tmp47_;
	ZeitgeistSubject* _tmp48_;
	ZeitgeistSubject* _tmp49_;
	ZeitgeistSubject* _tmp50_;
	ZeitgeistSubject* _tmp51_;
	GDesktopAppInfo* _tmp52_;
	const gchar* _tmp53_;
	GPtrArray* arr = NULL;
	GPtrArray* _tmp54_;
	GPtrArray* _tmp55_;
	ZeitgeistEvent* _tmp56_;
	ZeitgeistEvent* _tmp57_;
	GPtrArray* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_variant_get (parameters, "(@aysxas@a{sv})", &_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, NULL);
	_g_variant_unref0 (desktop_variant);
	desktop_variant = _tmp0_;
	pid = _tmp1_;
	_g_variant_iter_free0 (uris);
	uris = _tmp2_;
	_g_variant_unref0 (dict);
	dict = _tmp3_;
	_tmp4_ = desktop_variant;
	_tmp5_ = g_variant_get_bytestring (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	desktop_file = _tmp6_;
	_tmp7_ = desktop_file;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	while (TRUE) {
		GVariantIter* _tmp8_;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = uris;
		_tmp10_ = g_variant_iter_next (_tmp8_, "s", &_tmp9_, NULL);
		_g_free0 (uri);
		uri = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = uri;
		g_debug ("desktop-launch-listener.vala:103: ran with uri: %s", _tmp11_);
	}
	_tmp12_ = dict;
	_tmp13_ = _variant_get1 (_tmp12_);
	extra_params = _tmp13_;
	_tmp14_ = desktop_file;
	_tmp16_ = utils_get_actor_for_desktop_file (_tmp14_, &_tmp15_);
	_g_object_unref0 (dai);
	dai = _tmp15_;
	launched_uri = _tmp16_;
	_tmp17_ = launched_uri;
	if (_tmp17_ == NULL) {
		const gchar* _tmp18_;
		_tmp18_ = desktop_file;
		g_warning ("desktop-launch-listener.vala:114: Unable to open desktop file '%s'", _tmp18_);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	launcher_uri = NULL;
	_tmp19_ = extra_params;
	_tmp20_ = g_hash_table_lookup (_tmp19_, "origin-desktop-file");
	origin_df = (GVariant*) _tmp20_;
	_tmp21_ = origin_df;
	if (_tmp21_ != NULL) {
		GVariant* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = origin_df;
		_tmp23_ = g_variant_get_bytestring (_tmp22_);
		_tmp24_ = utils_get_actor_for_desktop_file (_tmp23_, NULL);
		_g_free0 (launcher_uri);
		launcher_uri = _tmp24_;
	} else {
		GVariant* origin_prgname = NULL;
		GHashTable* _tmp25_;
		gconstpointer _tmp26_;
		GVariant* _tmp27_;
		_tmp25_ = extra_params;
		_tmp26_ = g_hash_table_lookup (_tmp25_, "origin-prgname");
		origin_prgname = (GVariant*) _tmp26_;
		_tmp27_ = origin_prgname;
		if (_tmp27_ != NULL) {
			const gchar* prgname = NULL;
			GVariant* _tmp28_;
			const gchar* _tmp29_;
			gchar* origin_desktop_id = NULL;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			GDesktopAppInfo* id_check = NULL;
			const gchar* _tmp32_;
			GDesktopAppInfo* _tmp33_;
			GDesktopAppInfo* _tmp34_;
			_tmp28_ = origin_prgname;
			_tmp29_ = g_variant_get_bytestring (_tmp28_);
			prgname = _tmp29_;
			_tmp30_ = prgname;
			_tmp31_ = g_strconcat (_tmp30_, ".desktop", NULL);
			origin_desktop_id = _tmp31_;
			_tmp32_ = origin_desktop_id;
			_tmp33_ = g_desktop_app_info_new (_tmp32_);
			id_check = _tmp33_;
			_tmp34_ = id_check;
			if (_tmp34_ != NULL) {
				const gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp35_ = origin_desktop_id;
				_tmp36_ = g_strdup_printf ("application://%s", _tmp35_);
				_g_free0 (launcher_uri);
				launcher_uri = _tmp36_;
			}
			_g_object_unref0 (id_check);
			_g_free0 (origin_desktop_id);
		}
	}
	_tmp37_ = dai;
	if (!g_app_info_should_show ((GAppInfo*) _tmp37_)) {
		_g_free0 (launcher_uri);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	_tmp38_ = zeitgeist_event_new ();
	event = _tmp38_;
	_tmp39_ = zeitgeist_subject_new ();
	subject = _tmp39_;
	_tmp40_ = event;
	_tmp41_ = launcher_uri;
	zeitgeist_event_set_actor (_tmp40_, _tmp41_);
	_tmp42_ = event;
	zeitgeist_event_set_interpretation (_tmp42_, ZEITGEIST_ZG_ACCESS_EVENT);
	_tmp43_ = event;
	zeitgeist_event_set_manifestation (_tmp43_, ZEITGEIST_ZG_USER_ACTIVITY);
	_tmp44_ = event;
	_tmp45_ = subject;
	zeitgeist_event_add_subject (_tmp44_, _tmp45_);
	_tmp46_ = subject;
	_tmp47_ = launched_uri;
	zeitgeist_subject_set_uri (_tmp46_, _tmp47_);
	_tmp48_ = subject;
	zeitgeist_subject_set_interpretation (_tmp48_, ZEITGEIST_NFO_SOFTWARE);
	_tmp49_ = subject;
	zeitgeist_subject_set_manifestation (_tmp49_, ZEITGEIST_NFO_SOFTWARE_ITEM);
	_tmp50_ = subject;
	zeitgeist_subject_set_mimetype (_tmp50_, "application/x-desktop");
	_tmp51_ = subject;
	_tmp52_ = dai;
	_tmp53_ = g_app_info_get_display_name ((GAppInfo*) _tmp52_);
	zeitgeist_subject_set_text (_tmp51_, _tmp53_);
	_tmp54_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	arr = _tmp54_;
	_tmp55_ = arr;
	_tmp56_ = event;
	_tmp57_ = _g_object_ref0 (_tmp56_);
	g_ptr_array_add (_tmp55_, _tmp57_);
	_tmp58_ = arr;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp58_);
	_g_ptr_array_unref0 (arr);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
	_g_free0 (launcher_uri);
	_g_free0 (launched_uri);
	_g_object_unref0 (dai);
	_g_hash_table_unref0 (extra_params);
	_g_free0 (uri);
	_g_free0 (desktop_file);
	_g_variant_unref0 (dict);
	_g_variant_iter_free0 (uris);
	_g_variant_unref0 (desktop_variant);
}

static void
desktop_launch_listener_real_stop (DataProvider* base)
{
	DesktopLaunchListener * self;
	self = (DesktopLaunchListener*) base;
	if (self->priv->launched_signal_id != ((guint) 0)) {
		GDBusConnection* _tmp0_;
		_tmp0_ = self->priv->bus;
		g_dbus_connection_signal_unsubscribe (_tmp0_, self->priv->launched_signal_id);
		self->priv->launched_signal_id = (guint) 0;
	}
}

static const gchar*
desktop_launch_listener_real_get_unique_id (DataProvider* base)
{
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}

static void
desktop_launch_listener_real_set_unique_id (DataProvider* base,
                                            const gchar* value)
{
	DesktopLaunchListener* self;
	gchar* old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_unique_id (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY]);
	}
}

static const gchar*
desktop_launch_listener_real_get_name (DataProvider* base)
{
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
desktop_launch_listener_real_set_name (DataProvider* base,
                                       const gchar* value)
{
	DesktopLaunchListener* self;
	gchar* old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY]);
	}
}

static const gchar*
desktop_launch_listener_real_get_description (DataProvider* base)
{
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
desktop_launch_listener_real_set_description (DataProvider* base,
                                              const gchar* value)
{
	DesktopLaunchListener* self;
	gchar* old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_description (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY]);
	}
}

static DataHub*
desktop_launch_listener_real_get_datahub (DataProvider* base)
{
	DataHub* result;
	DesktopLaunchListener* self;
	DataHub* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}

static void
desktop_launch_listener_real_set_datahub (DataProvider* base,
                                          DataHub* value)
{
	DesktopLaunchListener* self;
	DataHub* old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_datahub (base);
	if (old_value != value) {
		DataHub* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY]);
	}
}

static gboolean
desktop_launch_listener_real_get_enabled (DataProvider* base)
{
	gboolean result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_enabled;
	return result;
}

static void
desktop_launch_listener_real_set_enabled (DataProvider* base,
                                          gboolean value)
{
	DesktopLaunchListener* self;
	gboolean old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY]);
	}
}

static gboolean
desktop_launch_listener_real_get_register (DataProvider* base)
{
	gboolean result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_register;
	return result;
}

static void
desktop_launch_listener_real_set_register (DataProvider* base,
                                           gboolean value)
{
	DesktopLaunchListener* self;
	gboolean old_value;
	self = (DesktopLaunchListener*) base;
	old_value = desktop_launch_listener_real_get_register (base);
	if (old_value != value) {
		self->priv->_register = value;
		g_object_notify_by_pspec ((GObject *) self, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY]);
	}
}

static GObject *
desktop_launch_listener_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DesktopLaunchListener * self;
	const gchar* desktop_env = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (desktop_launch_listener_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("desktop-launch-listener.vala:56: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp5_ = g_getenv ("XDG_CURRENT_DESKTOP");
	desktop_env = _tmp5_;
	_tmp6_ = desktop_env;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = desktop_env;
		g_desktop_app_info_set_desktop_env (_tmp7_);
		return obj;
	}
	return obj;
}

static void
desktop_launch_listener_class_init (DesktopLaunchListenerClass * klass,
                                    gpointer klass_data)
{
	desktop_launch_listener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DesktopLaunchListener_private_offset);
	((DataProviderClass *) klass)->start = (void (*) (DataProvider*)) desktop_launch_listener_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider*)) desktop_launch_listener_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = (const gchar* (*) (DataProvider*)) desktop_launch_listener_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = (void (*) (DataProvider*, const gchar*)) desktop_launch_listener_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = (const gchar* (*) (DataProvider*)) desktop_launch_listener_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = (void (*) (DataProvider*, const gchar*)) desktop_launch_listener_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = (const gchar* (*) (DataProvider*)) desktop_launch_listener_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = (void (*) (DataProvider*, const gchar*)) desktop_launch_listener_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = (DataHub* (*) (DataProvider*)) desktop_launch_listener_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = (void (*) (DataProvider*, DataHub*)) desktop_launch_listener_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = (gboolean (*) (DataProvider*)) desktop_launch_listener_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = (void (*) (DataProvider*, gboolean)) desktop_launch_listener_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = (gboolean (*) (DataProvider*)) desktop_launch_listener_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = (void (*) (DataProvider*, gboolean)) desktop_launch_listener_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_desktop_launch_listener_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_desktop_launch_listener_set_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_launch_listener_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_launch_listener_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY, desktop_launch_listener_properties[DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
desktop_launch_listener_instance_init (DesktopLaunchListener * self,
                                       gpointer klass)
{
	self->priv = desktop_launch_listener_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->launched_signal_id = (guint) 0;
}

static void
desktop_launch_listener_finalize (GObject * obj)
{
	DesktopLaunchListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (desktop_launch_listener_parent_class)->finalize (obj);
}

static GType
desktop_launch_listener_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DesktopLaunchListenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_launch_listener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopLaunchListener), 0, (GInstanceInitFunc) desktop_launch_listener_instance_init, NULL };
	GType desktop_launch_listener_type_id;
	desktop_launch_listener_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "DesktopLaunchListener", &g_define_type_info, 0);
	DesktopLaunchListener_private_offset = g_type_add_instance_private (desktop_launch_listener_type_id, sizeof (DesktopLaunchListenerPrivate));
	return desktop_launch_listener_type_id;
}

GType
desktop_launch_listener_get_type (void)
{
	static volatile gsize desktop_launch_listener_type_id__once = 0;
	if (g_once_init_enter (&desktop_launch_listener_type_id__once)) {
		GType desktop_launch_listener_type_id;
		desktop_launch_listener_type_id = desktop_launch_listener_get_type_once ();
		g_once_init_leave (&desktop_launch_listener_type_id__once, desktop_launch_listener_type_id);
	}
	return desktop_launch_listener_type_id__once;
}

static void
_vala_desktop_launch_listener_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DesktopLaunchListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_desktop_launch_listener_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DesktopLaunchListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

