/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __XDP_LOAD_BYTES_SKEL_H__
#define __XDP_LOAD_BYTES_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct xdp_load_bytes {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_program *xdp_probe_prog;
	} progs;
	struct {
		struct bpf_link *xdp_probe_prog;
	} links;

#ifdef __cplusplus
	static inline struct xdp_load_bytes *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct xdp_load_bytes *open_and_load();
	static inline int load(struct xdp_load_bytes *skel);
	static inline int attach(struct xdp_load_bytes *skel);
	static inline void detach(struct xdp_load_bytes *skel);
	static inline void destroy(struct xdp_load_bytes *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
xdp_load_bytes__destroy(struct xdp_load_bytes *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
xdp_load_bytes__create_skeleton(struct xdp_load_bytes *obj);

static inline struct xdp_load_bytes *
xdp_load_bytes__open_opts(const struct bpf_object_open_opts *opts)
{
	struct xdp_load_bytes *obj;
	int err;

	obj = (struct xdp_load_bytes *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = xdp_load_bytes__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	xdp_load_bytes__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct xdp_load_bytes *
xdp_load_bytes__open(void)
{
	return xdp_load_bytes__open_opts(NULL);
}

static inline int
xdp_load_bytes__load(struct xdp_load_bytes *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct xdp_load_bytes *
xdp_load_bytes__open_and_load(void)
{
	struct xdp_load_bytes *obj;
	int err;

	obj = xdp_load_bytes__open();
	if (!obj)
		return NULL;
	err = xdp_load_bytes__load(obj);
	if (err) {
		xdp_load_bytes__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
xdp_load_bytes__attach(struct xdp_load_bytes *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
xdp_load_bytes__detach(struct xdp_load_bytes *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *xdp_load_bytes__elf_bytes(size_t *sz);

static inline int
xdp_load_bytes__create_skeleton(struct xdp_load_bytes *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "xdp_load_bytes";
	s->obj = &obj->obj;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "xdp_probe_prog";
	s->progs[0].prog = &obj->progs.xdp_probe_prog;
	s->progs[0].link = &obj->links.xdp_probe_prog;

	s->data = xdp_load_bytes__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *xdp_load_bytes__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x30\x0f\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x18\0\
\x01\0\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf6\xff\xff\xff\xb7\x02\0\0\0\0\0\0\xb7\
\x04\0\0\x0a\0\0\0\x85\0\0\0\xbd\0\0\0\xbf\x01\0\0\0\0\0\0\x67\x01\0\0\x20\0\0\
\0\x77\x01\0\0\x20\0\0\0\xb7\0\0\0\x01\0\0\0\x15\x01\x01\0\0\0\0\0\xb7\0\0\0\0\
\0\0\0\x67\0\0\0\x01\0\0\0\x95\0\0\0\0\0\0\0\x47\x50\x4c\0\x28\0\0\0\x05\0\x08\
\0\x02\0\0\0\x08\0\0\0\x0e\0\0\0\x04\0\x28\x01\x51\0\x04\x30\x38\x0d\x71\0\xa8\
\xa7\x80\x80\0\xa8\xab\x80\x80\0\x9f\0\x01\x11\x01\x25\x25\x13\x05\x03\x25\x72\
\x17\x10\x17\x1b\x25\x11\x1b\x12\x06\x73\x17\x8c\x01\x17\0\0\x02\x24\0\x03\x25\
\x3e\x0b\x0b\x0b\0\0\x03\x34\0\x03\x25\x49\x13\x3f\x19\x3a\x0b\x3b\x0b\x02\x18\
\0\0\x04\x01\x01\x49\x13\0\0\x05\x21\0\x49\x13\x37\x0b\0\0\x06\x24\0\x03\x25\
\x0b\x0b\x3e\x0b\0\0\x07\x34\0\x03\x25\x49\x13\x3a\x0b\x3b\x05\0\0\x08\x0f\0\
\x49\x13\0\0\x09\x15\x01\x49\x13\x27\x19\0\0\x0a\x05\0\x49\x13\0\0\x0b\x13\x01\
\x03\x25\x0b\x0b\x3a\x0b\x3b\x05\0\0\x0c\x0d\0\x03\x25\x49\x13\x3a\x0b\x3b\x05\
\x38\x0b\0\0\x0d\x16\0\x49\x13\x03\x25\x3a\x0b\x3b\x0b\0\0\x0e\x0f\0\0\0\x0f\
\x04\x01\x49\x13\x03\x25\x0b\x0b\x3a\x0b\x3b\x05\0\0\x10\x28\0\x03\x25\x1c\x0f\
\0\0\x11\x2e\x01\x11\x1b\x12\x06\x40\x18\x7a\x19\x03\x25\x3a\x0b\x3b\x0b\x27\
\x19\x49\x13\x3f\x19\0\0\x12\x05\0\x02\x22\x03\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\
\x13\x34\0\x02\x18\x03\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\x14\x34\0\x02\x22\x03\
\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\0\x2f\x01\0\0\x05\0\x01\x08\0\0\0\0\x01\0\x1d\
\0\x01\x08\0\0\0\0\0\0\0\x02\x01\x68\0\0\0\x08\0\0\0\x0c\0\0\0\x02\x18\x07\x08\
\x02\x17\x07\x04\x03\x03\x3a\0\0\0\0\x17\x02\xa1\0\x04\x46\0\0\0\x05\x4a\0\0\0\
\x04\0\x02\x04\x06\x01\x06\x05\x08\x07\x07\x06\x57\0\0\0\x03\xf9\x10\x08\x5c\0\
\0\0\x09\x76\0\0\0\x0a\x7a\0\0\0\x0a\xc2\0\0\0\x0a\xce\0\0\0\x0a\xc2\0\0\0\0\
\x02\x07\x05\x08\x08\x7f\0\0\0\x0b\x10\x18\x02\x38\x17\x0c\x08\xc2\0\0\0\x02\
\x39\x17\0\x0c\x0b\xc2\0\0\0\x02\x3a\x17\x04\x0c\x0c\xc2\0\0\0\x02\x3b\x17\x08\
\x0c\x0d\xc2\0\0\0\x02\x3d\x17\x0c\x0c\x0e\xc2\0\0\0\x02\x3e\x17\x10\x0c\x0f\
\xc2\0\0\0\x02\x40\x17\x14\0\x0d\xca\0\0\0\x0a\x01\x1b\x02\x09\x07\x04\x0e\x0f\
\xca\0\0\0\x16\x04\x02\x2d\x17\x10\x11\0\x10\x12\x01\x10\x13\x02\x10\x14\x03\
\x10\x15\x04\0\x11\x01\x68\0\0\0\x01\x5a\x19\0\x0b\x16\x01\0\0\x12\0\x1e\0\x0b\
\x7a\0\0\0\x13\x02\x91\x06\x1b\0\x0d\x1a\x01\0\0\x14\x01\x1f\0\x0e\x16\x01\0\0\
\0\x02\x1a\x05\x04\x04\x26\x01\0\0\x05\x4a\0\0\0\x0a\0\x0d\x2e\x01\0\0\x1d\x01\
\x15\x02\x1c\x08\x01\0\x84\0\0\0\x05\0\0\0\0\0\0\0\x15\0\0\0\x2a\0\0\0\x5c\0\0\
\0\x65\0\0\0\x6a\0\0\0\x7e\0\0\0\x91\0\0\0\x96\0\0\0\x9b\0\0\0\xa8\0\0\0\xae\0\
\0\0\xb7\0\0\0\xc1\0\0\0\xd1\0\0\0\xe0\0\0\0\xef\0\0\0\xf6\0\0\0\x02\x01\0\0\
\x0b\x01\0\0\x14\x01\0\0\x1b\x01\0\0\x28\x01\0\0\x33\x01\0\0\x46\x01\0\0\x59\
\x01\0\0\x68\x01\0\0\x6c\x01\0\0\x70\x01\0\0\x7e\x01\0\0\x83\x01\0\0\x87\x01\0\
\0\x63\x6c\x61\x6e\x67\x20\x76\x65\x72\x73\x69\x6f\x6e\x20\x31\x36\x2e\x30\x2e\
\x36\0\x78\x64\x70\x5f\x6c\x6f\x61\x64\x5f\x62\x79\x74\x65\x73\x2e\x62\x70\x66\
\x2e\x63\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\x64\
\x70\x2d\x74\x6f\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\x31\
\x2e\x34\x2e\x32\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x5f\x6c\x69\x63\x65\x6e\
\x73\x65\0\x63\x68\x61\x72\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\
\x5f\x54\x59\x50\x45\x5f\x5f\0\x62\x70\x66\x5f\x78\x64\x70\x5f\x6c\x6f\x61\x64\
\x5f\x62\x79\x74\x65\x73\0\x6c\x6f\x6e\x67\0\x64\x61\x74\x61\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x5f\x5f\x75\x33\x32\0\x64\x61\x74\x61\x5f\
\x65\x6e\x64\0\x64\x61\x74\x61\x5f\x6d\x65\x74\x61\0\x69\x6e\x67\x72\x65\x73\
\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\x72\x78\x5f\x71\x75\x65\x75\x65\x5f\x69\
\x6e\x64\x65\x78\0\x65\x67\x72\x65\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\
\x78\x64\x70\x5f\x6d\x64\0\x58\x44\x50\x5f\x41\x42\x4f\x52\x54\x45\x44\0\x58\
\x44\x50\x5f\x44\x52\x4f\x50\0\x58\x44\x50\x5f\x50\x41\x53\x53\0\x58\x44\x50\
\x5f\x54\x58\0\x58\x44\x50\x5f\x52\x45\x44\x49\x52\x45\x43\x54\0\x78\x64\x70\
\x5f\x61\x63\x74\x69\x6f\x6e\0\x44\x57\x5f\x41\x54\x45\x5f\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x5f\x33\x32\0\x44\x57\x5f\x41\x54\x45\x5f\x75\x6e\x73\x69\x67\x6e\
\x65\x64\x5f\x36\x34\0\x78\x64\x70\x5f\x70\x72\x6f\x62\x65\x5f\x70\x72\x6f\x67\
\0\x69\x6e\x74\0\x62\x75\x66\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x63\x68\x61\
\x72\0\x5f\x5f\x75\x38\0\x63\x74\x78\0\x65\x72\x72\0\x14\0\0\0\x05\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x0c\x01\0\0\x0c\
\x01\0\0\xed\0\0\0\0\0\0\0\0\0\0\x02\x02\0\0\0\x01\0\0\0\x06\0\0\x04\x18\0\0\0\
\x08\0\0\0\x03\0\0\0\0\0\0\0\x0d\0\0\0\x03\0\0\0\x20\0\0\0\x16\0\0\0\x03\0\0\0\
\x40\0\0\0\x20\0\0\0\x03\0\0\0\x60\0\0\0\x30\0\0\0\x03\0\0\0\x80\0\0\0\x3f\0\0\
\0\x03\0\0\0\xa0\0\0\0\x4e\0\0\0\0\0\0\x08\x04\0\0\0\x54\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\0\0\0\0\0\x01\0\0\x0d\x06\0\0\0\x61\0\0\0\x01\0\0\0\x65\0\0\0\0\0\
\0\x01\x04\0\0\0\x20\0\0\x01\x69\0\0\0\x01\0\0\x0c\x05\0\0\0\xc3\0\0\0\0\0\0\
\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x08\0\0\0\x0a\0\0\0\x04\0\
\0\0\xc8\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\xdc\0\0\0\0\0\0\x0e\x09\0\0\0\x01\
\0\0\0\xe5\0\0\0\x01\0\0\x0f\0\0\0\0\x0b\0\0\0\0\0\0\0\x04\0\0\0\0\x78\x64\x70\
\x5f\x6d\x64\0\x64\x61\x74\x61\0\x64\x61\x74\x61\x5f\x65\x6e\x64\0\x64\x61\x74\
\x61\x5f\x6d\x65\x74\x61\0\x69\x6e\x67\x72\x65\x73\x73\x5f\x69\x66\x69\x6e\x64\
\x65\x78\0\x72\x78\x5f\x71\x75\x65\x75\x65\x5f\x69\x6e\x64\x65\x78\0\x65\x67\
\x72\x65\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\x5f\x5f\x75\x33\x32\0\x75\
\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x63\x74\x78\0\x69\x6e\x74\0\x78\
\x64\x70\x5f\x70\x72\x6f\x62\x65\x5f\x70\x72\x6f\x67\0\x78\x64\x70\0\x2f\x75\
\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\x64\x70\x2d\x74\x6f\
\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\x31\x2e\x34\x2e\x32\
\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\x2f\x78\x64\x70\x5f\x6c\x6f\x61\x64\x5f\
\x62\x79\x74\x65\x73\x2e\x62\x70\x66\x2e\x63\0\x63\x68\x61\x72\0\x5f\x5f\x41\
\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x5f\x6c\x69\
\x63\x65\x6e\x73\x65\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\0\x20\0\
\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\x5c\0\0\0\x70\0\0\0\0\0\0\0\x08\0\0\0\x78\0\0\
\0\x01\0\0\0\0\0\0\0\x07\0\0\0\x10\0\0\0\x78\0\0\0\x05\0\0\0\0\0\0\0\x7c\0\0\0\
\0\0\0\0\0\x2c\0\0\x08\0\0\0\x7c\0\0\0\0\0\0\0\0\0\0\0\x10\0\0\0\x7c\0\0\0\0\0\
\0\0\x08\x40\0\0\x30\0\0\0\x7c\0\0\0\0\0\0\0\x06\x44\0\0\x58\0\0\0\x7c\0\0\0\0\
\0\0\0\x01\x54\0\0\0\0\0\0\x0c\0\0\0\xff\xff\xff\xff\x04\0\x08\0\x08\x7c\x0b\0\
\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\0\0\0\0\0\0\0\xb3\0\0\0\x05\0\x08\0\x7e\
\0\0\0\x08\x01\x01\xfb\x0e\x0d\0\x01\x01\x01\x01\0\0\0\x01\0\0\x01\x01\x01\x1f\
\x03\0\0\0\0\x32\0\0\0\x37\0\0\0\x03\x01\x1f\x02\x0f\x05\x1e\x04\x4b\0\0\0\0\
\x35\x27\x15\x81\x9f\x97\x31\x76\x1c\x8f\xaa\x75\x93\x8f\x1e\xdf\x60\0\0\0\x01\
\xb8\x10\xf2\x70\x73\x3e\x10\x63\x19\xb6\x7e\xf5\x12\xc6\x24\x6e\x7f\0\0\0\x02\
\x19\xe7\xa2\x78\xdd\x5e\x69\xad\xb0\x87\xc4\x19\x97\x7e\x86\xe0\x85\0\0\0\x01\
\x09\xcf\xcd\x71\x69\xc2\x4b\xec\x44\x8f\x30\x58\x2e\x8c\x6d\xb9\x04\0\0\x09\
\x02\0\0\0\0\0\0\0\0\x03\x0b\x01\x06\x03\x74\x20\x05\x08\x06\x0a\x03\x10\x20\
\x05\x06\x4b\x06\x03\x6f\x4a\x05\x01\x06\x03\x15\x20\x02\x02\0\x01\x01\x2f\x75\
\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\x64\x70\x2d\x74\x6f\
\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\x31\x2e\x34\x2e\x32\
\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x2f\x75\x73\x72\0\x2e\x2e\x2f\x2e\x2e\
\x2f\x68\x65\x61\x64\x65\x72\x73\x2f\x6c\x69\x6e\x75\x78\0\x78\x64\x70\x5f\x6c\
\x6f\x61\x64\x5f\x62\x79\x74\x65\x73\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x63\x6c\
\x75\x64\x65\x2f\x61\x73\x6d\x2d\x67\x65\x6e\x65\x72\x69\x63\x2f\x69\x6e\x74\
\x2d\x6c\x6c\x36\x34\x2e\x68\0\x62\x70\x66\x2e\x68\0\x69\x6e\x63\x6c\x75\x64\
\x65\x2f\x62\x70\x66\x2f\x62\x70\x66\x5f\x68\x65\x6c\x70\x65\x72\x5f\x64\x65\
\x66\x73\x2e\x68\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xc1\0\0\0\x04\0\xf1\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xef\0\0\0\0\0\x03\0\x58\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x06\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0c\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x16\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x68\0\0\
\0\0\0\0\0\x97\0\0\0\x11\0\x04\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\x03\0\0\0\x05\0\0\0\x11\0\0\0\0\0\0\0\x03\0\0\0\x06\0\0\0\x15\0\0\0\0\0\
\0\0\x03\0\0\0\x0a\0\0\0\x1f\0\0\0\0\0\0\0\x03\0\0\0\x08\0\0\0\x23\0\0\0\0\0\0\
\0\x03\0\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x0c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x10\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x14\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x18\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x1c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x20\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x24\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x28\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x2c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x30\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x34\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x38\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x3c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x44\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x48\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x4c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x50\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x54\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x58\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x5c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x60\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x64\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x68\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x6c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x70\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x74\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x78\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x7c\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x80\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x84\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x02\0\0\0\x0d\0\0\0\x10\0\0\0\0\0\0\0\
\x02\0\0\0\x02\0\0\0\x1c\x01\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\0\x2c\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x70\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x14\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x18\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x22\0\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\x26\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x2a\0\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\x36\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x4b\0\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\x60\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x75\0\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\x8f\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\0\x2e\x64\x65\x62\
\x75\x67\x5f\x61\x62\x62\x72\x65\x76\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\
\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x2e\x64\x65\x62\x75\x67\x5f\x6c\x6f\x63\x6c\
\x69\x73\x74\x73\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x73\x74\x72\x5f\
\x6f\x66\x66\x73\x65\x74\x73\0\x2e\x64\x65\x62\x75\x67\x5f\x73\x74\x72\0\x2e\
\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\x5f\x73\x74\x72\0\x2e\x72\x65\x6c\x2e\
\x64\x65\x62\x75\x67\x5f\x61\x64\x64\x72\0\x78\x64\x70\0\x2e\x72\x65\x6c\x2e\
\x64\x65\x62\x75\x67\x5f\x69\x6e\x66\x6f\0\x78\x64\x70\x5f\x70\x72\x6f\x62\x65\
\x5f\x70\x72\x6f\x67\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\x65\x6c\x2e\
\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\
\x67\x5f\x66\x72\x61\x6d\x65\0\x78\x64\x70\x5f\x6c\x6f\x61\x64\x5f\x62\x79\x74\
\x65\x73\x2e\x62\x70\x66\x2e\x63\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\
\x6d\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x42\x42\x30\x5f\x32\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd6\0\0\0\x03\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\x0e\0\0\0\0\0\0\xf6\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x74\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\
\0\0\0\0\0\0\0\x68\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x98\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x22\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac\0\0\0\0\0\0\0\x2c\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xd8\0\0\0\0\0\0\0\x02\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7c\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xda\x01\0\0\0\0\0\0\x33\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x78\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb8\
\x0a\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x17\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x10\0\
\0\0\0\0\0\0\x36\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0d\x03\0\0\0\
\0\0\0\x88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x32\
\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x0b\0\0\0\0\0\0\0\x02\0\
\0\0\0\0\0\x17\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x49\0\0\0\
\x01\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x95\x03\0\0\0\0\0\0\x8b\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x68\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x05\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x64\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x08\x0d\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x17\0\0\0\x0c\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xea\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x38\x05\0\0\0\0\0\0\x11\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xe6\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x28\x0d\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x17\0\0\0\x0e\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x19\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x4c\x07\
\0\0\0\0\0\0\x90\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x15\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\x0d\0\0\0\0\0\0\
\x60\0\0\0\0\0\0\0\x17\0\0\0\x10\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xb4\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x07\0\0\0\0\0\0\x28\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\0\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\x0d\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x17\0\
\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xa4\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x08\x08\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xb8\x0d\0\0\0\0\0\0\x80\0\0\0\0\0\0\0\x17\0\0\0\x14\0\0\0\x08\0\0\0\
\0\0\0\0\x10\0\0\0\0\0\0\0\x54\0\0\0\x01\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xbf\x08\0\0\0\0\0\0\xa3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x01\
\0\0\0\0\0\0\0\xde\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\x09\0\0\
\0\0\0\0\x50\x01\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\
\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct xdp_load_bytes *xdp_load_bytes::open(const struct bpf_object_open_opts *opts) { return xdp_load_bytes__open_opts(opts); }
struct xdp_load_bytes *xdp_load_bytes::open_and_load() { return xdp_load_bytes__open_and_load(); }
int xdp_load_bytes::load(struct xdp_load_bytes *skel) { return xdp_load_bytes__load(skel); }
int xdp_load_bytes::attach(struct xdp_load_bytes *skel) { return xdp_load_bytes__attach(skel); }
void xdp_load_bytes::detach(struct xdp_load_bytes *skel) { xdp_load_bytes__detach(skel); }
void xdp_load_bytes::destroy(struct xdp_load_bytes *skel) { xdp_load_bytes__destroy(skel); }
const void *xdp_load_bytes::elf_bytes(size_t *sz) { return xdp_load_bytes__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
xdp_load_bytes__assert(struct xdp_load_bytes *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __XDP_LOAD_BYTES_SKEL_H__ */
