/* Generated by wayland-scanner 1.21.0 */

#ifndef WPE_DMABUF_POOL_SERVER_PROTOCOL_H
#define WPE_DMABUF_POOL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wpe_dmabuf_pool The wpe_dmabuf_pool protocol
 * @section page_ifaces_wpe_dmabuf_pool Interfaces
 * - @subpage page_iface_wpe_dmabuf_pool_manager - 
 * - @subpage page_iface_wpe_dmabuf_pool - 
 * - @subpage page_iface_wpe_dmabuf_data - 
 * @section page_copyright_wpe_dmabuf_pool Copyright
 * <pre>
 *
 * Copyright © 2020 Igalia S.L.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_surface;
struct wpe_dmabuf_data;
struct wpe_dmabuf_pool;
struct wpe_dmabuf_pool_manager;

#ifndef WPE_DMABUF_POOL_MANAGER_INTERFACE
#define WPE_DMABUF_POOL_MANAGER_INTERFACE
/**
 * @page page_iface_wpe_dmabuf_pool_manager wpe_dmabuf_pool_manager
 * @section page_iface_wpe_dmabuf_pool_manager_api API
 * See @ref iface_wpe_dmabuf_pool_manager.
 */
/**
 * @defgroup iface_wpe_dmabuf_pool_manager The wpe_dmabuf_pool_manager interface
 */
extern const struct wl_interface wpe_dmabuf_pool_manager_interface;
#endif
#ifndef WPE_DMABUF_POOL_INTERFACE
#define WPE_DMABUF_POOL_INTERFACE
/**
 * @page page_iface_wpe_dmabuf_pool wpe_dmabuf_pool
 * @section page_iface_wpe_dmabuf_pool_api API
 * See @ref iface_wpe_dmabuf_pool.
 */
/**
 * @defgroup iface_wpe_dmabuf_pool The wpe_dmabuf_pool interface
 */
extern const struct wl_interface wpe_dmabuf_pool_interface;
#endif
#ifndef WPE_DMABUF_DATA_INTERFACE
#define WPE_DMABUF_DATA_INTERFACE
/**
 * @page page_iface_wpe_dmabuf_data wpe_dmabuf_data
 * @section page_iface_wpe_dmabuf_data_api API
 * See @ref iface_wpe_dmabuf_data.
 */
/**
 * @defgroup iface_wpe_dmabuf_data The wpe_dmabuf_data interface
 */
extern const struct wl_interface wpe_dmabuf_data_interface;
#endif

/**
 * @ingroup iface_wpe_dmabuf_pool_manager
 * @struct wpe_dmabuf_pool_manager_interface
 */
struct wpe_dmabuf_pool_manager_interface {
	/**
	 */
	void (*create_pool)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    struct wl_resource *surface);
};


/**
 * @ingroup iface_wpe_dmabuf_pool_manager
 */
#define WPE_DMABUF_POOL_MANAGER_CREATE_POOL_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_dmabuf_pool
 * @struct wpe_dmabuf_pool_interface
 */
struct wpe_dmabuf_pool_interface {
	/**
	 */
	void (*create_buffer)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t buffer_id,
			      uint32_t width,
			      uint32_t height);
	/**
	 */
	void (*get_dmabuf_data)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t dmabuf_data_id,
				struct wl_resource *buffer);
};


/**
 * @ingroup iface_wpe_dmabuf_pool
 */
#define WPE_DMABUF_POOL_CREATE_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_dmabuf_pool
 */
#define WPE_DMABUF_POOL_GET_DMABUF_DATA_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_dmabuf_data
 * @struct wpe_dmabuf_data_interface
 */
struct wpe_dmabuf_data_interface {
	/**
	 */
	void (*request)(struct wl_client *client,
			struct wl_resource *resource);
};

#define WPE_DMABUF_DATA_ATTRIBUTES 0
#define WPE_DMABUF_DATA_PLANE 1
#define WPE_DMABUF_DATA_COMPLETE 2

/**
 * @ingroup iface_wpe_dmabuf_data
 */
#define WPE_DMABUF_DATA_ATTRIBUTES_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_dmabuf_data
 */
#define WPE_DMABUF_DATA_PLANE_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_dmabuf_data
 */
#define WPE_DMABUF_DATA_COMPLETE_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_dmabuf_data
 */
#define WPE_DMABUF_DATA_REQUEST_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_dmabuf_data
 * Sends an attributes event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wpe_dmabuf_data_send_attributes(struct wl_resource *resource_, uint32_t width, uint32_t height, uint32_t format, uint32_t num_planes)
{
	wl_resource_post_event(resource_, WPE_DMABUF_DATA_ATTRIBUTES, width, height, format, num_planes);
}

/**
 * @ingroup iface_wpe_dmabuf_data
 * Sends an plane event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wpe_dmabuf_data_send_plane(struct wl_resource *resource_, uint32_t id, int32_t fd, uint32_t stride, uint32_t offset, uint32_t modifier_hi, uint32_t modifier_lo)
{
	wl_resource_post_event(resource_, WPE_DMABUF_DATA_PLANE, id, fd, stride, offset, modifier_hi, modifier_lo);
}

/**
 * @ingroup iface_wpe_dmabuf_data
 * Sends an complete event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wpe_dmabuf_data_send_complete(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WPE_DMABUF_DATA_COMPLETE);
}

#ifdef  __cplusplus
}
#endif

#endif
