/* Grid.c generated by valac 0.56.16, the Vala compiler
 * generated from Grid.vala, do not modify */

/*
 * Copyright 2011–2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <libical-glib/libical-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_WIDGETS_GRID_0_PROPERTY,
	DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY,
	DATE_TIME_WIDGETS_GRID_NUM_PROPERTIES
};
static GParamSpec* date_time_widgets_grid_properties[DATE_TIME_WIDGETS_GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
enum  {
	DATE_TIME_WIDGETS_GRID_ON_EVENT_ADD_SIGNAL,
	DATE_TIME_WIDGETS_GRID_SELECTION_CHANGED_SIGNAL,
	DATE_TIME_WIDGETS_GRID_NUM_SIGNALS
};
static guint date_time_widgets_grid_signals[DATE_TIME_WIDGETS_GRID_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DateTimeWidgetsGridPrivate {
	UtilDateRange* _grid_range;
	GeeHashMap* data;
	DateTimeWidgetsGridDay* selected_gridday;
	GtkLabel** header_labels;
	gint header_labels_length1;
	gint _header_labels_size_;
	GtkRevealer** week_labels;
	gint week_labels_length1;
	gint _week_labels_size_;
};

struct _Block8Data {
	int _ref_count_;
	DateTimeWidgetsGrid* self;
	DateTimeWidgetsGridDay* day;
};

static gint DateTimeWidgetsGrid_private_offset;
static gpointer date_time_widgets_grid_parent_class = NULL;
static DateTimeWidgetsCalendarModel* date_time_widgets_grid_events_model;
static DateTimeWidgetsCalendarModel* date_time_widgets_grid_events_model = NULL;
static DateTimeWidgetsCalendarModel* date_time_widgets_grid_tasks_model;
static DateTimeWidgetsCalendarModel* date_time_widgets_grid_tasks_model = NULL;

static void date_time_widgets_grid_add_component_dots (DateTimeWidgetsGrid* self,
                                                ESource* source,
                                                GeeCollection* components);
static guint date_time_widgets_grid_day_hash (DateTimeWidgetsGrid* self,
                                       GDateTime* date);
static void date_time_widgets_grid_remove_component_dots (DateTimeWidgetsGrid* self,
                                                   ESource* source,
                                                   GeeCollection* components);
static void date_time_widgets_grid_on_day_focus_in (DateTimeWidgetsGrid* self,
                                             DateTimeWidgetsGridDay* day);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static DateTimeWidgetsGridDay* date_time_widgets_grid_update_day (DateTimeWidgetsGrid* self,
                                                           DateTimeWidgetsGridDay* day,
                                                           GDateTime* new_date,
                                                           GDateTime* today,
                                                           GDateTime* month_start);
static void _____lambda23_ (DateTimeWidgetsGrid* self,
                     GDateTime* date);
static void ______lambda23__date_time_widgets_grid_day_on_event_add (DateTimeWidgetsGridDay* _sender,
                                                              GDateTime* date,
                                                              gpointer self);
static gboolean _____lambda24_ (Block8Data* _data8_,
                         GdkEventFocus* event);
static gboolean ______lambda24__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                    GdkEventFocus* event,
                                                    gpointer self);
static void date_time_widgets_grid_set_grid_range (DateTimeWidgetsGrid* self,
                                            UtilDateRange* value);
static void date_time_widgets_grid_update_today_style (DateTimeWidgetsGrid* self,
                                                DateTimeWidgetsGridDay* day,
                                                GDateTime* date,
                                                GDateTime* today);
static GObject * date_time_widgets_grid_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _date_time_widgets_grid_add_component_dots_date_time_widgets_calendar_model_components_added (DateTimeWidgetsCalendarModel* _sender,
                                                                                                   ESource* source,
                                                                                                   GeeCollection* components,
                                                                                                   gpointer self);
static void _date_time_widgets_grid_remove_component_dots_date_time_widgets_calendar_model_components_removed (DateTimeWidgetsCalendarModel* _sender,
                                                                                                        ESource* source,
                                                                                                        GeeCollection* components,
                                                                                                        gpointer self);
static void date_time_widgets_grid_finalize (GObject * obj);
static GType date_time_widgets_grid_get_type_once (void);
static void _vala_date_time_widgets_grid_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_date_time_widgets_grid_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
date_time_widgets_grid_get_instance_private (DateTimeWidgetsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeWidgetsGrid_private_offset);
}

static void
date_time_widgets_grid_add_component_dots (DateTimeWidgetsGrid* self,
                                           ESource* source,
                                           GeeCollection* components)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (components != NULL);
	{
		GeeIterator* _component_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) components);
		_component_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* component = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ICalComponent* ical = NULL;
			ECalComponent* _tmp4_;
			ICalComponent* _tmp5_;
			glong start_time = 0L;
			ICalComponent* _tmp6_;
			ICalTime* _tmp7_;
			ICalTime* _tmp8_;
			glong _tmp9_;
			GDateTime* date_time = NULL;
			GDateTime* _tmp10_;
			guint date_hash = 0U;
			GDateTime* _tmp11_;
			GeeHashMap* _tmp12_;
			_tmp1_ = _component_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _component_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			component = (ECalComponent*) _tmp3_;
			_tmp4_ = component;
			_tmp5_ = e_cal_component_get_icalcomponent (_tmp4_);
			ical = _tmp5_;
			_tmp6_ = ical;
			_tmp7_ = i_cal_component_get_dtstart (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = i_cal_time_as_timet (_tmp8_);
			_g_object_unref0 (_tmp8_);
			start_time = _tmp9_;
			_tmp10_ = g_date_time_new_from_unix_utc ((gint64) start_time);
			date_time = _tmp10_;
			_tmp11_ = date_time;
			date_hash = date_time_widgets_grid_day_hash (self, _tmp11_);
			_tmp12_ = self->priv->data;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, (gpointer) ((guintptr) date_hash))) {
				GeeHashMap* _tmp13_;
				gpointer _tmp14_;
				DateTimeWidgetsGridDay* _tmp15_;
				ICalComponent* _tmp16_;
				_tmp13_ = self->priv->data;
				_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) date_hash));
				_tmp15_ = (DateTimeWidgetsGridDay*) _tmp14_;
				_tmp16_ = ical;
				date_time_widgets_grid_day_add_component_dot (_tmp15_, source, _tmp16_);
				_g_object_unref0 (_tmp15_);
			}
			_g_date_time_unref0 (date_time);
			_g_object_unref0 (component);
		}
		_g_object_unref0 (_component_it);
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

static void
date_time_widgets_grid_remove_component_dots (DateTimeWidgetsGrid* self,
                                              ESource* source,
                                              GeeCollection* components)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (components != NULL);
	{
		GeeIterator* _component_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) components);
		_component_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* component = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ICalComponent* ical = NULL;
			ECalComponent* _tmp4_;
			ICalComponent* _tmp5_;
			glong start_time = 0L;
			ICalComponent* _tmp6_;
			ICalTime* _tmp7_;
			ICalTime* _tmp8_;
			glong _tmp9_;
			GDateTime* date_time = NULL;
			GDateTime* _tmp10_;
			guint date_hash = 0U;
			GDateTime* _tmp11_;
			GeeHashMap* _tmp12_;
			_tmp1_ = _component_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _component_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			component = (ECalComponent*) _tmp3_;
			_tmp4_ = component;
			_tmp5_ = e_cal_component_get_icalcomponent (_tmp4_);
			ical = _tmp5_;
			_tmp6_ = ical;
			_tmp7_ = i_cal_component_get_dtstart (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = i_cal_time_as_timet (_tmp8_);
			_g_object_unref0 (_tmp8_);
			start_time = _tmp9_;
			_tmp10_ = g_date_time_new_from_unix_utc ((gint64) start_time);
			date_time = _tmp10_;
			_tmp11_ = date_time;
			date_hash = date_time_widgets_grid_day_hash (self, _tmp11_);
			_tmp12_ = self->priv->data;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, (gpointer) ((guintptr) date_hash))) {
				gchar* component_uid = NULL;
				ICalComponent* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				GeeHashMap* _tmp16_;
				gpointer _tmp17_;
				DateTimeWidgetsGridDay* _tmp18_;
				const gchar* _tmp19_;
				_tmp13_ = ical;
				_tmp14_ = i_cal_component_get_uid (_tmp13_);
				_tmp15_ = g_strdup (_tmp14_);
				component_uid = _tmp15_;
				_tmp16_ = self->priv->data;
				_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, (gpointer) ((guintptr) date_hash));
				_tmp18_ = (DateTimeWidgetsGridDay*) _tmp17_;
				_tmp19_ = component_uid;
				date_time_widgets_grid_day_remove_component_dot (_tmp18_, _tmp19_);
				_g_object_unref0 (_tmp18_);
				_g_free0 (component_uid);
			}
			_g_date_time_unref0 (date_time);
			_g_object_unref0 (component);
		}
		_g_object_unref0 (_component_it);
	}
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
date_time_widgets_grid_on_day_focus_in (DateTimeWidgetsGrid* self,
                                        DateTimeWidgetsGridDay* day)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	DateTimeWidgetsGridDay* _tmp4_;
	GDateTime* selected_date = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	DateTimeWidgetsGridDay* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (day != NULL);
	_tmp0_ = date_time_widgets_grid_day_get_date (day);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("Grid.vala:115: on_day_focus_in %s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->selected_gridday;
	if (_tmp4_ != NULL) {
		DateTimeWidgetsGridDay* _tmp5_;
		_tmp5_ = self->priv->selected_gridday;
		date_time_widgets_grid_day_set_selected (_tmp5_, FALSE);
	}
	_tmp6_ = date_time_widgets_grid_day_get_date (day);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_date_time_ref0 (_tmp7_);
	selected_date = _tmp8_;
	_tmp9_ = _g_object_ref0 (day);
	_g_object_unref0 (self->priv->selected_gridday);
	self->priv->selected_gridday = _tmp9_;
	date_time_widgets_grid_day_set_selected (day, TRUE);
	gtk_widget_set_state_flags ((GtkWidget*) day, GTK_STATE_FLAG_FOCUSED, FALSE);
	g_signal_emit (self, date_time_widgets_grid_signals[DATE_TIME_WIDGETS_GRID_SELECTION_CHANGED_SIGNAL], 0, selected_date);
	_g_date_time_unref0 (selected_date);
}

void
date_time_widgets_grid_set_focus_to_today (DateTimeWidgetsGrid* self)
{
	UtilDateRange* _tmp0_;
	GeeList* dates = NULL;
	UtilDateRange* _tmp1_;
	GeeList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid_range;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_grid_range;
	_tmp2_ = util_date_range_to_list (_tmp1_);
	dates = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GDateTime* date = NULL;
				GeeList* _tmp8_;
				gpointer _tmp9_;
				DateTimeWidgetsGridDay* day = NULL;
				GeeHashMap* _tmp10_;
				GDateTime* _tmp11_;
				gpointer _tmp12_;
				gboolean _tmp13_ = FALSE;
				DateTimeWidgetsGridDay* _tmp14_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = dates;
				_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = dates;
				_tmp9_ = gee_list_get (_tmp8_, i);
				date = (GDateTime*) _tmp9_;
				_tmp10_ = self->priv->data;
				_tmp11_ = date;
				_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((guintptr) date_time_widgets_grid_day_hash (self, _tmp11_)));
				day = (DateTimeWidgetsGridDay*) _tmp12_;
				_tmp14_ = day;
				if (_tmp14_ != NULL) {
					DateTimeWidgetsGridDay* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = day;
					_tmp16_ = gtk_widget_get_name ((GtkWidget*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp13_ = g_strcmp0 (_tmp17_, "today") == 0;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					DateTimeWidgetsGridDay* _tmp18_;
					_tmp18_ = day;
					date_time_widgets_grid_day_grab_focus_force (_tmp18_);
					_g_object_unref0 (day);
					_g_date_time_unref0 (date);
					_g_object_unref0 (dates);
					return;
				}
				_g_object_unref0 (day);
				_g_date_time_unref0 (date);
			}
		}
	}
	_g_object_unref0 (dates);
}

/**
         * Sets the given range to be displayed in the grid. Note that the number of days
         * must remain the same.
         */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		DateTimeWidgetsGrid* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->day);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_____lambda23_ (DateTimeWidgetsGrid* self,
                GDateTime* date)
{
	g_return_if_fail (date != NULL);
	g_signal_emit (self, date_time_widgets_grid_signals[DATE_TIME_WIDGETS_GRID_ON_EVENT_ADD_SIGNAL], 0, date);
}

static void
______lambda23__date_time_widgets_grid_day_on_event_add (DateTimeWidgetsGridDay* _sender,
                                                         GDateTime* date,
                                                         gpointer self)
{
	_____lambda23_ ((DateTimeWidgetsGrid*) self, date);
}

static gboolean
_____lambda24_ (Block8Data* _data8_,
                GdkEventFocus* event)
{
	DateTimeWidgetsGrid* self;
	DateTimeWidgetsGridDay* _tmp0_;
	gboolean result;
	self = _data8_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data8_->day;
	date_time_widgets_grid_on_day_focus_in (self, _tmp0_);
	result = FALSE;
	return result;
}

static gboolean
______lambda24__gtk_widget_focus_in_event (GtkWidget* _sender,
                                           GdkEventFocus* event,
                                           gpointer self)
{
	gboolean result;
	result = _____lambda24_ (self, event);
	return result;
}

void
date_time_widgets_grid_set_range (DateTimeWidgetsGrid* self,
                                  UtilDateRange* new_range,
                                  GDateTime* month_start)
{
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	GeeList* old_dates = NULL;
	UtilDateRange* _tmp1_;
	GeeList* new_dates = NULL;
	GeeList* _tmp5_;
	GeeHashMap* data_new = NULL;
	GeeHashMap* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDateTime* date = NULL;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	DateTimeWidgetsCalendarModel* _tmp13_;
	GDateWeekday _tmp14_;
	GDateWeekday _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	GtkLabel** _tmp18_;
	gint _tmp18__length1;
	gint i = 0;
	gint col = 0;
	gint row = 0;
	GeeHashMap* _tmp69_;
	GeeHashMap* _tmp70_;
	GeeHashMap* _tmp71_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_range != NULL);
	g_return_if_fail (month_start != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	today = _tmp0_;
	_tmp1_ = self->priv->_grid_range;
	if (_tmp1_ == NULL) {
		GeeArrayList* _tmp2_;
		_tmp2_ = gee_array_list_new (G_TYPE_DATE_TIME, (GBoxedCopyFunc) g_date_time_ref, (GDestroyNotify) g_date_time_unref, NULL, NULL, NULL);
		_g_object_unref0 (old_dates);
		old_dates = (GeeList*) _tmp2_;
	} else {
		UtilDateRange* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = self->priv->_grid_range;
		_tmp4_ = util_date_range_to_list (_tmp3_);
		_g_object_unref0 (old_dates);
		old_dates = _tmp4_;
	}
	_tmp5_ = util_date_range_to_list (new_range);
	new_dates = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DATE_TIME_WIDGETS_TYPE_GRID_DAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	data_new = _tmp6_;
	_tmp7_ = new_dates;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert ((_tmp9_ % 7) == 0, "new_dates.size % 7 == 0");
	_tmp10_ = today;
	_tmp11_ = util_strip_time (_tmp10_);
	date = _tmp11_;
	_tmp12_ = date;
	_tmp13_ = date_time_widgets_grid_events_model;
	_tmp14_ = date_time_widgets_calendar_model_get_week_starts_on (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = date;
	_tmp17_ = g_date_time_add_days (_tmp12_, (gint) (_tmp15_ - g_date_time_get_day_of_week (_tmp16_)));
	_g_date_time_unref0 (date);
	date = _tmp17_;
	_tmp18_ = self->priv->header_labels;
	_tmp18__length1 = self->priv->header_labels_length1;
	{
		GtkLabel** label_collection = NULL;
		gint label_collection_length1 = 0;
		gint _label_collection_size_ = 0;
		gint label_it = 0;
		label_collection = _tmp18_;
		label_collection_length1 = _tmp18__length1;
		for (label_it = 0; label_it < label_collection_length1; label_it = label_it + 1) {
			GtkLabel* _tmp19_;
			GtkLabel* label = NULL;
			_tmp19_ = _g_object_ref0 (label_collection[label_it]);
			label = _tmp19_;
			{
				GtkLabel* _tmp20_;
				GDateTime* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GDateTime* _tmp24_;
				GDateTime* _tmp25_;
				_tmp20_ = label;
				_tmp21_ = date;
				_tmp22_ = g_date_time_format (_tmp21_, "%a");
				_tmp23_ = _tmp22_;
				gtk_label_set_label (_tmp20_, _tmp23_);
				_g_free0 (_tmp23_);
				_tmp24_ = date;
				_tmp25_ = g_date_time_add_days (_tmp24_, 1);
				_g_date_time_unref0 (date);
				date = _tmp25_;
				_g_object_unref0 (label);
			}
		}
	}
	i = 0;
	col = 0;
	row = 1;
	{
		gboolean _tmp26_ = FALSE;
		i = 0;
		_tmp26_ = TRUE;
		while (TRUE) {
			Block8Data* _data8_;
			GeeList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GDateTime* new_date = NULL;
			GeeList* _tmp31_;
			gpointer _tmp32_;
			GeeList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp55_ = 0;
			GeeHashMap* _tmp56_;
			GDateTime* _tmp57_;
			DateTimeWidgetsGridDay* _tmp58_;
			_data8_ = g_slice_new0 (Block8Data);
			_data8_->_ref_count_ = 1;
			_data8_->self = g_object_ref (self);
			if (!_tmp26_) {
				gint _tmp27_;
				_tmp27_ = i;
				i = _tmp27_ + 1;
			}
			_tmp26_ = FALSE;
			_tmp28_ = new_dates;
			_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			if (!(i < _tmp30_)) {
				block8_data_unref (_data8_);
				_data8_ = NULL;
				break;
			}
			_tmp31_ = new_dates;
			_tmp32_ = gee_list_get (_tmp31_, i);
			new_date = (GDateTime*) _tmp32_;
			_tmp33_ = old_dates;
			_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			if (i < _tmp35_) {
				GDateTime* old_date = NULL;
				GeeList* _tmp36_;
				gpointer _tmp37_;
				GeeHashMap* _tmp38_;
				GDateTime* _tmp39_;
				gpointer _tmp40_;
				DateTimeWidgetsGridDay* _tmp41_;
				GDateTime* _tmp42_;
				GDateTime* _tmp43_;
				DateTimeWidgetsGridDay* _tmp44_;
				_tmp36_ = old_dates;
				_tmp37_ = gee_list_get (_tmp36_, i);
				old_date = (GDateTime*) _tmp37_;
				_tmp38_ = self->priv->data;
				_tmp39_ = old_date;
				_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, (gpointer) ((guintptr) date_time_widgets_grid_day_hash (self, _tmp39_)));
				_tmp41_ = (DateTimeWidgetsGridDay*) _tmp40_;
				_tmp42_ = new_date;
				_tmp43_ = today;
				_tmp44_ = date_time_widgets_grid_update_day (self, _tmp41_, _tmp42_, _tmp43_, month_start);
				_g_object_unref0 (_data8_->day);
				_data8_->day = _tmp44_;
				_g_object_unref0 (_tmp41_);
				_g_date_time_unref0 (old_date);
			} else {
				GDateTime* _tmp45_;
				DateTimeWidgetsGridDay* _tmp46_;
				DateTimeWidgetsGridDay* _tmp47_;
				GDateTime* _tmp48_;
				GDateTime* _tmp49_;
				DateTimeWidgetsGridDay* _tmp50_;
				DateTimeWidgetsGridDay* _tmp51_;
				DateTimeWidgetsGridDay* _tmp52_;
				DateTimeWidgetsGridDay* _tmp53_;
				DateTimeWidgetsGridDay* _tmp54_;
				_tmp45_ = new_date;
				_tmp46_ = date_time_widgets_grid_day_new (_tmp45_);
				g_object_ref_sink (_tmp46_);
				_tmp47_ = _tmp46_;
				_tmp48_ = new_date;
				_tmp49_ = today;
				_tmp50_ = date_time_widgets_grid_update_day (self, _tmp47_, _tmp48_, _tmp49_, month_start);
				_g_object_unref0 (_data8_->day);
				_data8_->day = _tmp50_;
				_g_object_unref0 (_tmp47_);
				_tmp51_ = _data8_->day;
				g_signal_connect_object (_tmp51_, "on-event-add", (GCallback) ______lambda23__date_time_widgets_grid_day_on_event_add, self, 0);
				_tmp52_ = _data8_->day;
				g_signal_connect_data ((GtkWidget*) _tmp52_, "focus-in-event", (GCallback) ______lambda24__gtk_widget_focus_in_event, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_tmp53_ = _data8_->day;
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp53_, col + 2, row, 1, 1);
				_tmp54_ = _data8_->day;
				gtk_widget_show_all ((GtkWidget*) _tmp54_);
			}
			col = (col + 1) % 7;
			if (col == 0) {
				_tmp55_ = row + 1;
			} else {
				_tmp55_ = row;
			}
			row = _tmp55_;
			_tmp56_ = data_new;
			_tmp57_ = new_date;
			_tmp58_ = _data8_->day;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp56_, (gpointer) ((guintptr) date_time_widgets_grid_day_hash (self, _tmp57_)), _tmp58_);
			_g_date_time_unref0 (new_date);
			block8_data_unref (_data8_);
			_data8_ = NULL;
		}
	}
	while (TRUE) {
		GeeList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		GDateTime* old_date = NULL;
		GeeList* _tmp62_;
		gpointer _tmp63_;
		DateTimeWidgetsGridDay* old_day = NULL;
		GeeHashMap* _tmp64_;
		GDateTime* _tmp65_;
		gpointer _tmp66_;
		DateTimeWidgetsGridDay* _tmp67_;
		gint _tmp68_;
		_tmp59_ = old_dates;
		_tmp60_ = gee_collection_get_size ((GeeCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		if (!(i < _tmp61_)) {
			break;
		}
		_tmp62_ = old_dates;
		_tmp63_ = gee_list_get (_tmp62_, i);
		old_date = (GDateTime*) _tmp63_;
		_tmp64_ = self->priv->data;
		_tmp65_ = old_date;
		_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, (gpointer) ((guintptr) date_time_widgets_grid_day_hash (self, _tmp65_)));
		old_day = (DateTimeWidgetsGridDay*) _tmp66_;
		_tmp67_ = old_day;
		gtk_widget_destroy ((GtkWidget*) _tmp67_);
		_tmp68_ = i;
		i = _tmp68_ + 1;
		_g_object_unref0 (old_day);
		_g_date_time_unref0 (old_date);
	}
	_tmp69_ = self->priv->data;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp69_);
	_tmp70_ = self->priv->data;
	_tmp71_ = data_new;
	gee_map_set_all ((GeeMap*) _tmp70_, (GeeMap*) _tmp71_);
	date_time_widgets_grid_set_grid_range (self, new_range);
	_g_date_time_unref0 (date);
	_g_object_unref0 (data_new);
	_g_object_unref0 (new_dates);
	_g_object_unref0 (old_dates);
	_g_date_time_unref0 (today);
}

/**
         * Updates the given GridDay so that it shows the given date. Changes to its style etc.
         */
static DateTimeWidgetsGridDay*
date_time_widgets_grid_update_day (DateTimeWidgetsGrid* self,
                                   DateTimeWidgetsGridDay* day,
                                   GDateTime* new_date,
                                   GDateTime* today,
                                   GDateTime* month_start)
{
	DateTimeWidgetsGridDay* _tmp0_;
	DateTimeWidgetsGridDay* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (day != NULL, NULL);
	g_return_val_if_fail (new_date != NULL, NULL);
	g_return_val_if_fail (today != NULL, NULL);
	g_return_val_if_fail (month_start != NULL, NULL);
	date_time_widgets_grid_update_today_style (self, day, new_date, today);
	if (g_date_time_get_month (new_date) == g_date_time_get_month (month_start)) {
		date_time_widgets_grid_day_sensitive_container (day, TRUE);
	} else {
		date_time_widgets_grid_day_sensitive_container (day, FALSE);
	}
	date_time_widgets_grid_day_set_date (day, new_date);
	_tmp0_ = _g_object_ref0 (day);
	result = _tmp0_;
	return result;
}

void
date_time_widgets_grid_update_weeks (DateTimeWidgetsGrid* self,
                                     GDateTime* date,
                                     gint nr_of_weeks)
{
	GtkRevealer** _tmp0_;
	gint _tmp0__length1;
	GDateTime* next = NULL;
	GDateTime* _tmp3_;
	gint days_to_add = 0;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GtkRevealer** _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = self->priv->week_labels;
	_tmp0__length1 = self->priv->week_labels_length1;
	if (_tmp0_ != NULL) {
		GtkRevealer** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->week_labels;
		_tmp1__length1 = self->priv->week_labels_length1;
		{
			GtkRevealer** widget_collection = NULL;
			gint widget_collection_length1 = 0;
			gint _widget_collection_size_ = 0;
			gint widget_it = 0;
			widget_collection = _tmp1_;
			widget_collection_length1 = _tmp1__length1;
			for (widget_it = 0; widget_it < widget_collection_length1; widget_it = widget_it + 1) {
				GtkWidget* widget = NULL;
				widget = (GtkWidget*) widget_collection[widget_it];
				{
					GtkWidget* _tmp2_;
					_tmp2_ = widget;
					gtk_widget_destroy (_tmp2_);
				}
			}
		}
	}
	_tmp3_ = _g_date_time_ref0 (date);
	next = _tmp3_;
	_tmp4_ = next;
	days_to_add = (8 - g_date_time_get_day_of_week (_tmp4_)) % 7;
	_tmp5_ = next;
	_tmp6_ = g_date_time_add_days (_tmp5_, days_to_add);
	_g_date_time_unref0 (next);
	next = _tmp6_;
	_tmp7_ = g_new0 (GtkRevealer*, nr_of_weeks + 1);
	self->priv->week_labels = (_vala_array_free (self->priv->week_labels, self->priv->week_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->week_labels = _tmp7_;
	self->priv->week_labels_length1 = nr_of_weeks;
	self->priv->_week_labels_size_ = self->priv->week_labels_length1;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GtkLabel* week_label = NULL;
				GDateTime* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GtkLabel* _tmp13_ = NULL;
				GtkLabel* _tmp14_;
				GtkLabel* _tmp15_;
				GtkStyleContext* _tmp16_;
				GtkRevealer** _tmp17_;
				gint _tmp17__length1;
				GtkRevealer* _tmp18_ = NULL;
				GtkRevealer** _tmp19_;
				gint _tmp19__length1;
				GtkRevealer* _tmp20_;
				GtkLabel* _tmp21_;
				GtkRevealer** _tmp22_;
				gint _tmp22__length1;
				GtkRevealer* _tmp23_;
				GSettings* _tmp24_;
				GtkRevealer** _tmp25_;
				gint _tmp25__length1;
				GtkRevealer* _tmp26_;
				GtkRevealer** _tmp27_;
				gint _tmp27__length1;
				GtkRevealer* _tmp28_;
				GDateTime* _tmp29_;
				GDateTime* _tmp30_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = c;
					c = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(c < nr_of_weeks)) {
					break;
				}
				_tmp10_ = next;
				_tmp11_ = g_strdup_printf ("%i", g_date_time_get_week_of_year (_tmp10_));
				_tmp12_ = _tmp11_;
				_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
				gtk_widget_set_margin_bottom ((GtkWidget*) _tmp13_, 6);
				gtk_label_set_width_chars (_tmp13_, 2);
				g_object_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				week_label = _tmp14_;
				_tmp15_ = week_label;
				_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
				gtk_style_context_add_class (_tmp16_, GRANITE_STYLE_CLASS_H4_LABEL);
				_tmp17_ = self->priv->week_labels;
				_tmp17__length1 = self->priv->week_labels_length1;
				_tmp18_ = (GtkRevealer*) gtk_revealer_new ();
				gtk_revealer_set_transition_type (_tmp18_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
				g_object_ref_sink (_tmp18_);
				_g_object_unref0 (_tmp17_[c]);
				_tmp17_[c] = _tmp18_;
				_tmp19_ = self->priv->week_labels;
				_tmp19__length1 = self->priv->week_labels_length1;
				_tmp20_ = _tmp19_[c];
				_tmp21_ = week_label;
				gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
				_tmp22_ = self->priv->week_labels;
				_tmp22__length1 = self->priv->week_labels_length1;
				_tmp23_ = _tmp22_[c];
				gtk_widget_show_all ((GtkWidget*) _tmp23_);
				_tmp24_ = date_time_indicator_settings;
				_tmp25_ = self->priv->week_labels;
				_tmp25__length1 = self->priv->week_labels_length1;
				_tmp26_ = _tmp25_[c];
				g_settings_bind (_tmp24_, "show-weeks", (GObject*) _tmp26_, "reveal-child", G_SETTINGS_BIND_DEFAULT);
				_tmp27_ = self->priv->week_labels;
				_tmp27__length1 = self->priv->week_labels_length1;
				_tmp28_ = _tmp27_[c];
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp28_, 0, c + 1, 1, 1);
				_tmp29_ = next;
				_tmp30_ = g_date_time_add_weeks (_tmp29_, 1);
				_g_date_time_unref0 (next);
				next = _tmp30_;
				_g_object_unref0 (week_label);
			}
		}
	}
	_g_date_time_unref0 (next);
}

void
date_time_widgets_grid_update_today (DateTimeWidgetsGrid* self)
{
	UtilDateRange* _tmp0_;
	GeeList* dates = NULL;
	UtilDateRange* _tmp1_;
	GeeList* _tmp2_;
	GDateTime* today = NULL;
	GDateTime* _tmp3_;
	gint i = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid_range;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_grid_range;
	_tmp2_ = util_date_range_to_list (_tmp1_);
	dates = _tmp2_;
	_tmp3_ = g_date_time_new_now_local ();
	today = _tmp3_;
	i = 0;
	{
		gboolean _tmp4_ = FALSE;
		i = 0;
		_tmp4_ = TRUE;
		while (TRUE) {
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GDateTime* date = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			DateTimeWidgetsGridDay* day = NULL;
			GeeHashMap* _tmp11_;
			GDateTime* _tmp12_;
			gpointer _tmp13_;
			DateTimeWidgetsGridDay* _tmp14_;
			DateTimeWidgetsGridDay* _tmp15_;
			GDateTime* _tmp16_;
			GDateTime* _tmp17_;
			if (!_tmp4_) {
				gint _tmp5_;
				_tmp5_ = i;
				i = _tmp5_ + 1;
			}
			_tmp4_ = FALSE;
			_tmp6_ = dates;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (!(i < _tmp8_)) {
				break;
			}
			_tmp9_ = dates;
			_tmp10_ = gee_list_get (_tmp9_, i);
			date = (GDateTime*) _tmp10_;
			_tmp11_ = self->priv->data;
			_tmp12_ = date;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) date_time_widgets_grid_day_hash (self, _tmp12_)));
			day = (DateTimeWidgetsGridDay*) _tmp13_;
			_tmp14_ = day;
			if (_tmp14_ == NULL) {
				_g_object_unref0 (day);
				_g_date_time_unref0 (date);
				_g_date_time_unref0 (today);
				_g_object_unref0 (dates);
				return;
			}
			_tmp15_ = day;
			_tmp16_ = date;
			_tmp17_ = today;
			date_time_widgets_grid_update_today_style (self, _tmp15_, _tmp16_, _tmp17_);
			_g_object_unref0 (day);
			_g_date_time_unref0 (date);
		}
	}
	_g_date_time_unref0 (today);
	_g_object_unref0 (dates);
}

static void
date_time_widgets_grid_update_today_style (DateTimeWidgetsGrid* self,
                                           DateTimeWidgetsGridDay* day,
                                           GDateTime* date,
                                           GDateTime* today)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (day != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (today != NULL);
	if (g_date_time_get_day_of_year (date) == g_date_time_get_day_of_year (today)) {
		_tmp0_ = g_date_time_get_year (date) == g_date_time_get_year (today);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		gtk_widget_set_name ((GtkWidget*) day, "today");
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) day);
		gtk_style_context_add_class (_tmp1_, GRANITE_STYLE_CLASS_ACCENT);
		gtk_widget_set_receives_default ((GtkWidget*) day, TRUE);
		gtk_widget_show_all ((GtkWidget*) day);
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = gtk_widget_get_name ((GtkWidget*) day);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "today") == 0) {
			GtkStyleContext* _tmp4_;
			gtk_widget_set_name ((GtkWidget*) day, "");
			_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) day);
			gtk_style_context_remove_class (_tmp4_, GRANITE_STYLE_CLASS_ACCENT);
			gtk_widget_set_receives_default ((GtkWidget*) day, FALSE);
			gtk_widget_show_all ((GtkWidget*) day);
		}
	}
}

static guint
date_time_widgets_grid_day_hash (DateTimeWidgetsGrid* self,
                                 GDateTime* date)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (date != NULL, 0U);
	result = (guint) (((g_date_time_get_year (date) * 10000) + (g_date_time_get_month (date) * 100)) + g_date_time_get_day_of_month (date));
	return result;
}

DateTimeWidgetsGrid*
date_time_widgets_grid_construct (GType object_type)
{
	DateTimeWidgetsGrid * self = NULL;
	self = (DateTimeWidgetsGrid*) g_object_new (object_type, NULL);
	return self;
}

DateTimeWidgetsGrid*
date_time_widgets_grid_new (void)
{
	return date_time_widgets_grid_construct (DATE_TIME_WIDGETS_TYPE_GRID);
}

UtilDateRange*
date_time_widgets_grid_get_grid_range (DateTimeWidgetsGrid* self)
{
	UtilDateRange* result;
	UtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_grid_range;
	result = _tmp0_;
	return result;
}

static void
date_time_widgets_grid_set_grid_range (DateTimeWidgetsGrid* self,
                                       UtilDateRange* value)
{
	UtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_grid_get_grid_range (self);
	if (old_value != value) {
		UtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_grid_range);
		self->priv->_grid_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_grid_properties[DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY]);
	}
}

static void
_date_time_widgets_grid_add_component_dots_date_time_widgets_calendar_model_components_added (DateTimeWidgetsCalendarModel* _sender,
                                                                                              ESource* source,
                                                                                              GeeCollection* components,
                                                                                              gpointer self)
{
	date_time_widgets_grid_add_component_dots ((DateTimeWidgetsGrid*) self, source, components);
}

static void
_date_time_widgets_grid_remove_component_dots_date_time_widgets_calendar_model_components_removed (DateTimeWidgetsCalendarModel* _sender,
                                                                                                   ESource* source,
                                                                                                   GeeCollection* components,
                                                                                                   gpointer self)
{
	date_time_widgets_grid_remove_component_dots ((DateTimeWidgetsGrid*) self, source, components);
}

static GObject *
date_time_widgets_grid_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeWidgetsGrid * self;
	GtkLabel** _tmp0_;
	GtkSeparator* week_sep = NULL;
	GtkSeparator* _tmp10_ = NULL;
	GtkRevealer* week_sep_revealer = NULL;
	GtkRevealer* _tmp11_ = NULL;
	GtkRevealer* _tmp12_;
	GtkSeparator* _tmp13_;
	GtkRevealer* _tmp14_;
	GSettings* _tmp15_;
	GtkRevealer* _tmp16_;
	GeeHashMap* _tmp17_;
	DateTimeWidgetsCalendarModel* _tmp18_;
	DateTimeWidgetsCalendarModel* _tmp19_;
	DateTimeWidgetsCalendarModel* _tmp20_;
	DateTimeWidgetsCalendarModel* _tmp21_;
	parent_class = G_OBJECT_CLASS (date_time_widgets_grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_GRID, DateTimeWidgetsGrid);
	_tmp0_ = g_new0 (GtkLabel*, 7 + 1);
	self->priv->header_labels = (_vala_array_free (self->priv->header_labels, self->priv->header_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->header_labels = _tmp0_;
	self->priv->header_labels_length1 = 7;
	self->priv->_header_labels_size_ = self->priv->header_labels_length1;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkLabel** _tmp3_;
				gint _tmp3__length1;
				GtkLabel* _tmp4_;
				GtkLabel** _tmp5_;
				gint _tmp5__length1;
				GtkLabel* _tmp6_;
				GtkStyleContext* _tmp7_;
				GtkLabel** _tmp8_;
				gint _tmp8__length1;
				GtkLabel* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = c;
					c = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(c < 7)) {
					break;
				}
				_tmp3_ = self->priv->header_labels;
				_tmp3__length1 = self->priv->header_labels_length1;
				_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
				g_object_ref_sink (_tmp4_);
				_g_object_unref0 (_tmp3_[c]);
				_tmp3_[c] = _tmp4_;
				_tmp5_ = self->priv->header_labels;
				_tmp5__length1 = self->priv->header_labels_length1;
				_tmp6_ = _tmp5_[c];
				_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
				gtk_style_context_add_class (_tmp7_, GRANITE_STYLE_CLASS_H4_LABEL);
				_tmp8_ = self->priv->header_labels;
				_tmp8__length1 = self->priv->header_labels_length1;
				_tmp9_ = _tmp8_[c];
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp9_, c + 2, 0, 1, 1);
			}
		}
	}
	_tmp10_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp10_, 9);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 3);
	g_object_ref_sink (_tmp10_);
	week_sep = _tmp10_;
	_tmp11_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp11_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	g_object_ref_sink (_tmp11_);
	week_sep_revealer = _tmp11_;
	_tmp12_ = week_sep_revealer;
	_tmp13_ = week_sep;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	_tmp14_ = week_sep_revealer;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 1, 1, 1, 6);
	_tmp15_ = date_time_indicator_settings;
	_tmp16_ = week_sep_revealer;
	g_settings_bind (_tmp15_, "show-weeks", (GObject*) _tmp16_, "reveal-child", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DATE_TIME_WIDGETS_TYPE_GRID_DAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->data);
	self->priv->data = _tmp17_;
	_tmp18_ = date_time_widgets_grid_events_model;
	g_signal_connect_object (_tmp18_, "components-added", (GCallback) _date_time_widgets_grid_add_component_dots_date_time_widgets_calendar_model_components_added, self, 0);
	_tmp19_ = date_time_widgets_grid_tasks_model;
	g_signal_connect_object (_tmp19_, "components-added", (GCallback) _date_time_widgets_grid_add_component_dots_date_time_widgets_calendar_model_components_added, self, 0);
	_tmp20_ = date_time_widgets_grid_events_model;
	g_signal_connect_object (_tmp20_, "components-removed", (GCallback) _date_time_widgets_grid_remove_component_dots_date_time_widgets_calendar_model_components_removed, self, 0);
	_tmp21_ = date_time_widgets_grid_tasks_model;
	g_signal_connect_object (_tmp21_, "components-removed", (GCallback) _date_time_widgets_grid_remove_component_dots_date_time_widgets_calendar_model_components_removed, self, 0);
	_g_object_unref0 (week_sep_revealer);
	_g_object_unref0 (week_sep);
	return obj;
}

static void
date_time_widgets_grid_class_init (DateTimeWidgetsGridClass * klass,
                                   gpointer klass_data)
{
	DateTimeWidgetsCalendarModel* _tmp0_;
	DateTimeWidgetsCalendarModel* _tmp1_;
	date_time_widgets_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeWidgetsGrid_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_date_time_widgets_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_date_time_widgets_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = date_time_widgets_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_widgets_grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY, date_time_widgets_grid_properties[DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY] = g_param_spec_object ("grid-range", "grid-range", "grid-range", UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	date_time_widgets_grid_signals[DATE_TIME_WIDGETS_GRID_ON_EVENT_ADD_SIGNAL] = g_signal_new ("on-event-add", DATE_TIME_WIDGETS_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	date_time_widgets_grid_signals[DATE_TIME_WIDGETS_GRID_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", DATE_TIME_WIDGETS_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	_tmp0_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_EVENTS);
	_g_object_unref0 (date_time_widgets_grid_events_model);
	date_time_widgets_grid_events_model = _tmp0_;
	_tmp1_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_TASKS);
	_g_object_unref0 (date_time_widgets_grid_tasks_model);
	date_time_widgets_grid_tasks_model = _tmp1_;
}

static void
date_time_widgets_grid_instance_init (DateTimeWidgetsGrid * self,
                                      gpointer klass)
{
	self->priv = date_time_widgets_grid_get_instance_private (self);
}

static void
date_time_widgets_grid_finalize (GObject * obj)
{
	DateTimeWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_GRID, DateTimeWidgetsGrid);
	_g_object_unref0 (self->priv->_grid_range);
	_g_object_unref0 (self->priv->data);
	_g_object_unref0 (self->priv->selected_gridday);
	self->priv->header_labels = (_vala_array_free (self->priv->header_labels, self->priv->header_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->week_labels = (_vala_array_free (self->priv->week_labels, self->priv->week_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (date_time_widgets_grid_parent_class)->finalize (obj);
}

/**
 * Represents the entire date grid as a table.
 */
static GType
date_time_widgets_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeWidgetsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_widgets_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeWidgetsGrid), 0, (GInstanceInitFunc) date_time_widgets_grid_instance_init, NULL };
	GType date_time_widgets_grid_type_id;
	date_time_widgets_grid_type_id = g_type_register_static (gtk_grid_get_type (), "DateTimeWidgetsGrid", &g_define_type_info, 0);
	DateTimeWidgetsGrid_private_offset = g_type_add_instance_private (date_time_widgets_grid_type_id, sizeof (DateTimeWidgetsGridPrivate));
	return date_time_widgets_grid_type_id;
}

GType
date_time_widgets_grid_get_type (void)
{
	static volatile gsize date_time_widgets_grid_type_id__once = 0;
	if (g_once_init_enter (&date_time_widgets_grid_type_id__once)) {
		GType date_time_widgets_grid_type_id;
		date_time_widgets_grid_type_id = date_time_widgets_grid_get_type_once ();
		g_once_init_leave (&date_time_widgets_grid_type_id__once, date_time_widgets_grid_type_id);
	}
	return date_time_widgets_grid_type_id__once;
}

static void
_vala_date_time_widgets_grid_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	DateTimeWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_GRID, DateTimeWidgetsGrid);
	switch (property_id) {
		case DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY:
		g_value_set_object (value, date_time_widgets_grid_get_grid_range (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_date_time_widgets_grid_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	DateTimeWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_GRID, DateTimeWidgetsGrid);
	switch (property_id) {
		case DATE_TIME_WIDGETS_GRID_GRID_RANGE_PROPERTY:
		date_time_widgets_grid_set_grid_range (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

