/* CalendarView.c generated by valac 0.56.16, the Vala compiler
 * generated from CalendarView.vala, do not modify */

/*-
 * Copyright (c) 2011–2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <glib.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <libecal/libecal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_WIDGETS_CALENDAR_VIEW_0_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_VIEW_NUM_PROPERTIES
};
static GParamSpec* date_time_widgets_calendar_view_properties[DATE_TIME_WIDGETS_CALENDAR_VIEW_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DATE_TIME_WIDGETS_CALENDAR_VIEW_DAY_DOUBLE_CLICK_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_VIEW_EVENT_UPDATES_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_VIEW_NUM_SIGNALS
};
static guint date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_NUM_SIGNALS] = {0};

struct _DateTimeWidgetsCalendarViewPrivate {
	GDateTime* _selected_date;
	HdyCarousel* carousel;
	guint position;
	gint rel_postion;
	DateTimeWidgetsCalendarModel* events_model;
	DateTimeWidgetsCalendarModel* tasks_model;
	GDateTime* start_month;
	DateTimeWidgetsGrid* start_month_grid;
	GtkLabel* label;
	gboolean showtoday;
};

static gint DateTimeWidgetsCalendarView_private_offset;
static gpointer date_time_widgets_calendar_view_parent_class = NULL;

static DateTimeWidgetsGrid* date_time_widgets_calendar_view_create_grid (DateTimeWidgetsCalendarView* self);
static void __lambda25_ (DateTimeWidgetsCalendarView* self,
                  GDateTime* date);
static void ___lambda25__date_time_widgets_grid_on_event_add (DateTimeWidgetsGrid* _sender,
                                                       GDateTime* date,
                                                       gpointer self);
static void __lambda26_ (DateTimeWidgetsCalendarView* self,
                  GDateTime* date);
static void date_time_widgets_calendar_view_set_selected_date (DateTimeWidgetsCalendarView* self,
                                                        GDateTime* value);
static void ___lambda26__date_time_widgets_grid_selection_changed (DateTimeWidgetsGrid* _sender,
                                                            GDateTime* new_date,
                                                            gpointer self);
static void date_time_widgets_calendar_view_show_today (DateTimeWidgetsCalendarView* self,
                                                 gboolean refresh);
static GObject * date_time_widgets_calendar_view_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _date_time_widgets_calendar_view___lambda27_ (DateTimeWidgetsCalendarView* self);
static void __date_time_widgets_calendar_view___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _date_time_widgets_calendar_view___lambda28_ (DateTimeWidgetsCalendarView* self);
static void __date_time_widgets_calendar_view___lambda28__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _date_time_widgets_calendar_view___lambda29_ (DateTimeWidgetsCalendarView* self);
static void __date_time_widgets_calendar_view___lambda29__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _date_time_widgets_calendar_view___lambda30_ (DateTimeWidgetsCalendarView* self,
                                                   guint index);
static void __date_time_widgets_calendar_view___lambda30__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                              guint index,
                                                                              gpointer self);
static void date_time_widgets_calendar_view_finalize (GObject * obj);
static GType date_time_widgets_calendar_view_get_type_once (void);
static void _vala_date_time_widgets_calendar_view_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_date_time_widgets_calendar_view_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
date_time_widgets_calendar_view_get_instance_private (DateTimeWidgetsCalendarView* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeWidgetsCalendarView_private_offset);
}

static void
__lambda25_ (DateTimeWidgetsCalendarView* self,
             GDateTime* date)
{
	g_return_if_fail (date != NULL);
	date_time_widgets_calendar_view_show_date_in_maya (self, date);
	g_signal_emit (self, date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_DAY_DOUBLE_CLICK_SIGNAL], 0);
}

static void
___lambda25__date_time_widgets_grid_on_event_add (DateTimeWidgetsGrid* _sender,
                                                  GDateTime* date,
                                                  gpointer self)
{
	__lambda25_ ((DateTimeWidgetsCalendarView*) self, date);
}

static void
__lambda26_ (DateTimeWidgetsCalendarView* self,
             GDateTime* date)
{
	g_return_if_fail (date != NULL);
	date_time_widgets_calendar_view_set_selected_date (self, date);
	g_signal_emit (self, date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL], 0, date);
}

static void
___lambda26__date_time_widgets_grid_selection_changed (DateTimeWidgetsGrid* _sender,
                                                       GDateTime* new_date,
                                                       gpointer self)
{
	__lambda26_ ((DateTimeWidgetsCalendarView*) self, new_date);
}

static DateTimeWidgetsGrid*
date_time_widgets_calendar_view_create_grid (DateTimeWidgetsCalendarView* self)
{
	DateTimeWidgetsGrid* grid = NULL;
	DateTimeWidgetsGrid* _tmp0_;
	DateTimeWidgetsGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = date_time_widgets_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_widget_show_all ((GtkWidget*) grid);
	g_signal_connect_object (grid, "on-event-add", (GCallback) ___lambda25__date_time_widgets_grid_on_event_add, self, 0);
	g_signal_connect_object (grid, "selection-changed", (GCallback) ___lambda26__date_time_widgets_grid_selection_changed, self, 0);
	result = grid;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
date_time_widgets_calendar_view_show_today (DateTimeWidgetsCalendarView* self,
                                            gboolean refresh)
{
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* start = NULL;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	HdyCarousel* _tmp94_;
	g_return_if_fail (self != NULL);
	self->priv->showtoday = TRUE;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = util_strip_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	today = _tmp3_;
	_tmp4_ = today;
	_tmp5_ = _g_date_time_ref0 (_tmp4_);
	_tmp6_ = util_get_start_of_month (_tmp5_);
	start = _tmp6_;
	_tmp7_ = today;
	date_time_widgets_calendar_view_set_selected_date (self, _tmp7_);
	_tmp9_ = start;
	_tmp10_ = self->priv->start_month;
	if (g_date_time_equal (_tmp9_, _tmp10_)) {
		_tmp8_ = !refresh;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		HdyCarousel* _tmp11_;
		HdyCarousel* _tmp12_;
		self->priv->position = self->priv->position - self->priv->rel_postion;
		_tmp11_ = self->priv->carousel;
		_tmp12_ = self->priv->carousel;
		hdy_swipeable_switch_child ((HdySwipeable*) _tmp11_, self->priv->position, (gint64) hdy_carousel_get_animation_duration (_tmp12_));
	} else {
		HdyCarousel* _tmp13_;
		HdyCarousel* _tmp14_;
		GList* _tmp15_;
		GDateTime* _tmp18_;
		DateTimeWidgetsCalendarModel* _tmp19_;
		GDateTime* _tmp20_;
		DateTimeWidgetsCalendarModel* _tmp21_;
		GDateTime* _tmp22_;
		DateTimeWidgetsGrid* _tmp23_;
		DateTimeWidgetsGrid* _tmp24_;
		DateTimeWidgetsCalendarModel* _tmp25_;
		UtilDateRange* _tmp26_;
		UtilDateRange* _tmp27_;
		DateTimeWidgetsCalendarModel* _tmp28_;
		GDateTime* _tmp29_;
		GDateTime* _tmp30_;
		DateTimeWidgetsGrid* _tmp31_;
		DateTimeWidgetsCalendarModel* _tmp32_;
		UtilDateRange* _tmp33_;
		UtilDateRange* _tmp34_;
		GDateTime* _tmp35_;
		GDateTime* _tmp36_;
		DateTimeWidgetsCalendarModel* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		DateTimeWidgetsCalendarModel* _tmp40_;
		DateTimeWidgetsCalendarModel* _tmp41_;
		DateTimeWidgetsGrid* left_grid = NULL;
		DateTimeWidgetsGrid* _tmp42_;
		DateTimeWidgetsGrid* _tmp43_;
		DateTimeWidgetsCalendarModel* _tmp44_;
		UtilDateRange* _tmp45_;
		UtilDateRange* _tmp46_;
		DateTimeWidgetsCalendarModel* _tmp47_;
		GDateTime* _tmp48_;
		GDateTime* _tmp49_;
		DateTimeWidgetsGrid* _tmp50_;
		DateTimeWidgetsCalendarModel* _tmp51_;
		UtilDateRange* _tmp52_;
		UtilDateRange* _tmp53_;
		GDateTime* _tmp54_;
		GDateTime* _tmp55_;
		DateTimeWidgetsCalendarModel* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		DateTimeWidgetsCalendarModel* _tmp59_;
		DateTimeWidgetsCalendarModel* _tmp60_;
		DateTimeWidgetsGrid* right_grid = NULL;
		DateTimeWidgetsGrid* _tmp61_;
		DateTimeWidgetsGrid* _tmp62_;
		DateTimeWidgetsCalendarModel* _tmp63_;
		UtilDateRange* _tmp64_;
		UtilDateRange* _tmp65_;
		DateTimeWidgetsCalendarModel* _tmp66_;
		GDateTime* _tmp67_;
		GDateTime* _tmp68_;
		DateTimeWidgetsGrid* _tmp69_;
		DateTimeWidgetsCalendarModel* _tmp70_;
		UtilDateRange* _tmp71_;
		UtilDateRange* _tmp72_;
		GDateTime* _tmp73_;
		GDateTime* _tmp74_;
		DateTimeWidgetsCalendarModel* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		DateTimeWidgetsCalendarModel* _tmp78_;
		DateTimeWidgetsCalendarModel* _tmp79_;
		HdyCarousel* _tmp80_;
		DateTimeWidgetsGrid* _tmp81_;
		HdyCarousel* _tmp82_;
		DateTimeWidgetsGrid* _tmp83_;
		HdyCarousel* _tmp84_;
		DateTimeWidgetsGrid* _tmp85_;
		HdyCarousel* _tmp86_;
		DateTimeWidgetsGrid* _tmp87_;
		GtkLabel* _tmp88_;
		DateTimeWidgetsCalendarModel* _tmp89_;
		GDateTime* _tmp90_;
		GDateTime* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp13_ = self->priv->carousel;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, TRUE);
		_tmp14_ = self->priv->carousel;
		_tmp15_ = gtk_container_get_children ((GtkContainer*) _tmp14_);
		{
			GList* grid_collection = NULL;
			GList* grid_it = NULL;
			grid_collection = _tmp15_;
			for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
				GtkWidget* grid = NULL;
				grid = (GtkWidget*) grid_it->data;
				{
					HdyCarousel* _tmp16_;
					GtkWidget* _tmp17_;
					_tmp16_ = self->priv->carousel;
					_tmp17_ = grid;
					gtk_container_remove ((GtkContainer*) _tmp16_, _tmp17_);
				}
			}
			(grid_collection == NULL) ? NULL : (grid_collection = (g_list_free (grid_collection), NULL));
		}
		_tmp18_ = util_get_start_of_month (NULL);
		_g_date_time_unref0 (self->priv->start_month);
		self->priv->start_month = _tmp18_;
		_tmp19_ = self->priv->events_model;
		_tmp20_ = self->priv->start_month;
		date_time_widgets_calendar_model_set_month_start (_tmp19_, _tmp20_);
		_tmp21_ = self->priv->tasks_model;
		_tmp22_ = self->priv->start_month;
		date_time_widgets_calendar_model_set_month_start (_tmp21_, _tmp22_);
		_tmp23_ = date_time_widgets_calendar_view_create_grid (self);
		_g_object_unref0 (self->priv->start_month_grid);
		self->priv->start_month_grid = _tmp23_;
		_tmp24_ = self->priv->start_month_grid;
		_tmp25_ = self->priv->events_model;
		_tmp26_ = date_time_widgets_calendar_model_get_data_range (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->events_model;
		_tmp29_ = date_time_widgets_calendar_model_get_month_start (_tmp28_);
		_tmp30_ = _tmp29_;
		date_time_widgets_grid_set_range (_tmp24_, _tmp27_, _tmp30_);
		_tmp31_ = self->priv->start_month_grid;
		_tmp32_ = self->priv->events_model;
		_tmp33_ = date_time_widgets_calendar_model_get_data_range (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = util_date_range_get_first_dt (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->events_model;
		_tmp38_ = date_time_widgets_calendar_model_get_num_weeks (_tmp37_);
		_tmp39_ = _tmp38_;
		date_time_widgets_grid_update_weeks (_tmp31_, _tmp36_, _tmp39_);
		_tmp40_ = self->priv->events_model;
		date_time_widgets_calendar_model_change_month (_tmp40_, -1);
		_tmp41_ = self->priv->tasks_model;
		date_time_widgets_calendar_model_change_month (_tmp41_, -1);
		_tmp42_ = date_time_widgets_calendar_view_create_grid (self);
		left_grid = _tmp42_;
		_tmp43_ = left_grid;
		_tmp44_ = self->priv->events_model;
		_tmp45_ = date_time_widgets_calendar_model_get_data_range (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->events_model;
		_tmp48_ = date_time_widgets_calendar_model_get_month_start (_tmp47_);
		_tmp49_ = _tmp48_;
		date_time_widgets_grid_set_range (_tmp43_, _tmp46_, _tmp49_);
		_tmp50_ = left_grid;
		_tmp51_ = self->priv->events_model;
		_tmp52_ = date_time_widgets_calendar_model_get_data_range (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = util_date_range_get_first_dt (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = self->priv->events_model;
		_tmp57_ = date_time_widgets_calendar_model_get_num_weeks (_tmp56_);
		_tmp58_ = _tmp57_;
		date_time_widgets_grid_update_weeks (_tmp50_, _tmp55_, _tmp58_);
		_tmp59_ = self->priv->events_model;
		date_time_widgets_calendar_model_change_month (_tmp59_, 2);
		_tmp60_ = self->priv->tasks_model;
		date_time_widgets_calendar_model_change_month (_tmp60_, 2);
		_tmp61_ = date_time_widgets_calendar_view_create_grid (self);
		right_grid = _tmp61_;
		_tmp62_ = right_grid;
		_tmp63_ = self->priv->events_model;
		_tmp64_ = date_time_widgets_calendar_model_get_data_range (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = self->priv->events_model;
		_tmp67_ = date_time_widgets_calendar_model_get_month_start (_tmp66_);
		_tmp68_ = _tmp67_;
		date_time_widgets_grid_set_range (_tmp62_, _tmp65_, _tmp68_);
		_tmp69_ = right_grid;
		_tmp70_ = self->priv->events_model;
		_tmp71_ = date_time_widgets_calendar_model_get_data_range (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = util_date_range_get_first_dt (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = self->priv->events_model;
		_tmp76_ = date_time_widgets_calendar_model_get_num_weeks (_tmp75_);
		_tmp77_ = _tmp76_;
		date_time_widgets_grid_update_weeks (_tmp69_, _tmp74_, _tmp77_);
		_tmp78_ = self->priv->events_model;
		date_time_widgets_calendar_model_change_month (_tmp78_, -1);
		_tmp79_ = self->priv->tasks_model;
		date_time_widgets_calendar_model_change_month (_tmp79_, -1);
		_tmp80_ = self->priv->carousel;
		_tmp81_ = left_grid;
		gtk_container_add ((GtkContainer*) _tmp80_, (GtkWidget*) _tmp81_);
		_tmp82_ = self->priv->carousel;
		_tmp83_ = self->priv->start_month_grid;
		gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp83_);
		_tmp84_ = self->priv->carousel;
		_tmp85_ = right_grid;
		gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
		_tmp86_ = self->priv->carousel;
		_tmp87_ = self->priv->start_month_grid;
		hdy_carousel_scroll_to (_tmp86_, (GtkWidget*) _tmp87_);
		_tmp88_ = self->priv->label;
		_tmp89_ = self->priv->events_model;
		_tmp90_ = date_time_widgets_calendar_model_get_month_start (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_date_time_format (_tmp91_, _ ("%OB, %Y"));
		_tmp93_ = _tmp92_;
		gtk_label_set_label (_tmp88_, _tmp93_);
		_g_free0 (_tmp93_);
		self->priv->position = (guint) 1;
		self->priv->rel_postion = 0;
		_g_object_unref0 (right_grid);
		_g_object_unref0 (left_grid);
	}
	_tmp94_ = self->priv->carousel;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp94_, FALSE);
	_g_date_time_unref0 (start);
	_g_date_time_unref0 (today);
}

void
date_time_widgets_calendar_view_show_date_in_maya (DateTimeWidgetsCalendarView* self,
                                                   GDateTime* date)
{
	gchar* command = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = g_date_time_format (date, "%F");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("io.elementary.calendar --show-day %s", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	command = _tmp3_;
	{
		GAppInfo* appinfo = NULL;
		const gchar* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
		_tmp4_ = command;
		_tmp5_ = g_app_info_create_from_commandline (_tmp4_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		appinfo = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = appinfo;
		g_app_info_launch_uris (_tmp6_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* dialog = NULL;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable To Launch Calendar"), _ ("The program \"io.elementary.calendar\" may not be installed"), "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp7_);
		dialog = _tmp7_;
		_tmp8_ = dialog;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		granite_message_dialog_show_error_details (_tmp8_, _tmp10_);
		_tmp11_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp11_);
		_tmp12_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (command);
}

void
date_time_widgets_calendar_view_refresh (DateTimeWidgetsCalendarView* self)
{
	g_return_if_fail (self != NULL);
	date_time_widgets_calendar_view_show_today (self, TRUE);
}

DateTimeWidgetsCalendarView*
date_time_widgets_calendar_view_construct (GType object_type)
{
	DateTimeWidgetsCalendarView * self = NULL;
	self = (DateTimeWidgetsCalendarView*) g_object_new (object_type, NULL);
	return self;
}

DateTimeWidgetsCalendarView*
date_time_widgets_calendar_view_new (void)
{
	return date_time_widgets_calendar_view_construct (DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW);
}

GDateTime*
date_time_widgets_calendar_view_get_selected_date (DateTimeWidgetsCalendarView* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_date;
	result = _tmp0_;
	return result;
}

static void
date_time_widgets_calendar_view_set_selected_date (DateTimeWidgetsCalendarView* self,
                                                   GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_view_get_selected_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_selected_date);
		self->priv->_selected_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_view_properties[DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY]);
	}
}

static void
_date_time_widgets_calendar_view___lambda27_ (DateTimeWidgetsCalendarView* self)
{
	HdyCarousel* _tmp0_;
	HdyCarousel* _tmp1_;
	HdyCarousel* _tmp2_;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->carousel;
	_tmp2_ = self->priv->carousel;
	hdy_swipeable_switch_child ((HdySwipeable*) _tmp0_, (guint) (((gint) hdy_carousel_get_position (_tmp1_)) - 1), (gint64) hdy_carousel_get_animation_duration (_tmp2_));
}

static void
__date_time_widgets_calendar_view___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_date_time_widgets_calendar_view___lambda27_ ((DateTimeWidgetsCalendarView*) self);
}

static void
_date_time_widgets_calendar_view___lambda28_ (DateTimeWidgetsCalendarView* self)
{
	HdyCarousel* _tmp0_;
	HdyCarousel* _tmp1_;
	HdyCarousel* _tmp2_;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->carousel;
	_tmp2_ = self->priv->carousel;
	hdy_swipeable_switch_child ((HdySwipeable*) _tmp0_, (guint) (((gint) hdy_carousel_get_position (_tmp1_)) + 1), (gint64) hdy_carousel_get_animation_duration (_tmp2_));
}

static void
__date_time_widgets_calendar_view___lambda28__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_date_time_widgets_calendar_view___lambda28_ ((DateTimeWidgetsCalendarView*) self);
}

static void
_date_time_widgets_calendar_view___lambda29_ (DateTimeWidgetsCalendarView* self)
{
	date_time_widgets_calendar_view_show_today (self, FALSE);
}

static void
__date_time_widgets_calendar_view___lambda29__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_date_time_widgets_calendar_view___lambda29_ ((DateTimeWidgetsCalendarView*) self);
}

static void
_date_time_widgets_calendar_view___lambda30_ (DateTimeWidgetsCalendarView* self,
                                              guint index)
{
	DateTimeWidgetsCalendarModel* _tmp0_;
	DateTimeWidgetsCalendarModel* _tmp1_;
	DateTimeWidgetsCalendarModel* _tmp16_;
	DateTimeWidgetsCalendarModel* _tmp17_;
	GDateTime* _tmp18_;
	HdyCarousel* _tmp19_;
	GtkLabel* _tmp67_;
	DateTimeWidgetsCalendarModel* _tmp68_;
	GDateTime* _tmp69_;
	GDateTime* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	_tmp0_ = self->priv->events_model;
	date_time_widgets_calendar_model_change_month (_tmp0_, -self->priv->rel_postion);
	_tmp1_ = self->priv->tasks_model;
	date_time_widgets_calendar_model_change_month (_tmp1_, -self->priv->rel_postion);
	if (self->priv->position > index) {
		gint _tmp2_;
		guint _tmp3_;
		_tmp2_ = self->priv->rel_postion;
		self->priv->rel_postion = _tmp2_ - 1;
		_tmp3_ = self->priv->position;
		self->priv->position = _tmp3_ - 1;
	} else {
		if (self->priv->position < index) {
			gint _tmp4_;
			guint _tmp5_;
			_tmp4_ = self->priv->rel_postion;
			self->priv->rel_postion = _tmp4_ + 1;
			_tmp5_ = self->priv->position;
			self->priv->position = _tmp5_ + 1;
		} else {
			if (self->priv->showtoday) {
				HdyCarousel* _tmp6_;
				GtkLabel* _tmp7_;
				DateTimeWidgetsCalendarModel* _tmp8_;
				GDateTime* _tmp9_;
				GDateTime* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				DateTimeWidgetsGrid* _tmp13_;
				self->priv->showtoday = FALSE;
				self->priv->rel_postion = 0;
				_tmp6_ = self->priv->carousel;
				self->priv->position = (guint) ((gint) hdy_carousel_get_position (_tmp6_));
				_tmp7_ = self->priv->label;
				_tmp8_ = self->priv->events_model;
				_tmp9_ = date_time_widgets_calendar_model_get_month_start (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_date_time_format (_tmp10_, _ ("%OB, %Y"));
				_tmp12_ = _tmp11_;
				gtk_label_set_label (_tmp7_, _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = self->priv->start_month_grid;
				date_time_widgets_grid_set_focus_to_today (_tmp13_);
				return;
			} else {
				DateTimeWidgetsCalendarModel* _tmp14_;
				DateTimeWidgetsCalendarModel* _tmp15_;
				_tmp14_ = self->priv->events_model;
				date_time_widgets_calendar_model_change_month (_tmp14_, self->priv->rel_postion);
				_tmp15_ = self->priv->tasks_model;
				date_time_widgets_calendar_model_change_month (_tmp15_, self->priv->rel_postion);
				return;
			}
		}
	}
	_tmp16_ = self->priv->events_model;
	date_time_widgets_calendar_model_change_month (_tmp16_, self->priv->rel_postion);
	_tmp17_ = self->priv->tasks_model;
	date_time_widgets_calendar_model_change_month (_tmp17_, self->priv->rel_postion);
	date_time_widgets_calendar_view_set_selected_date (self, NULL);
	_tmp18_ = self->priv->_selected_date;
	g_signal_emit (self, date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL], 0, _tmp18_);
	_tmp19_ = self->priv->carousel;
	if ((index + 1) == ((guint) ((gint) hdy_carousel_get_n_pages (_tmp19_)))) {
		DateTimeWidgetsCalendarModel* _tmp20_;
		DateTimeWidgetsCalendarModel* _tmp21_;
		DateTimeWidgetsGrid* grid = NULL;
		DateTimeWidgetsGrid* _tmp22_;
		DateTimeWidgetsGrid* _tmp23_;
		DateTimeWidgetsCalendarModel* _tmp24_;
		UtilDateRange* _tmp25_;
		UtilDateRange* _tmp26_;
		DateTimeWidgetsCalendarModel* _tmp27_;
		GDateTime* _tmp28_;
		GDateTime* _tmp29_;
		DateTimeWidgetsGrid* _tmp30_;
		DateTimeWidgetsCalendarModel* _tmp31_;
		UtilDateRange* _tmp32_;
		UtilDateRange* _tmp33_;
		GDateTime* _tmp34_;
		GDateTime* _tmp35_;
		DateTimeWidgetsCalendarModel* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		HdyCarousel* _tmp39_;
		DateTimeWidgetsGrid* _tmp40_;
		DateTimeWidgetsCalendarModel* _tmp41_;
		DateTimeWidgetsCalendarModel* _tmp42_;
		_tmp20_ = self->priv->events_model;
		date_time_widgets_calendar_model_change_month (_tmp20_, 1);
		_tmp21_ = self->priv->tasks_model;
		date_time_widgets_calendar_model_change_month (_tmp21_, 1);
		_tmp22_ = date_time_widgets_calendar_view_create_grid (self);
		grid = _tmp22_;
		_tmp23_ = grid;
		_tmp24_ = self->priv->events_model;
		_tmp25_ = date_time_widgets_calendar_model_get_data_range (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->events_model;
		_tmp28_ = date_time_widgets_calendar_model_get_month_start (_tmp27_);
		_tmp29_ = _tmp28_;
		date_time_widgets_grid_set_range (_tmp23_, _tmp26_, _tmp29_);
		_tmp30_ = grid;
		_tmp31_ = self->priv->events_model;
		_tmp32_ = date_time_widgets_calendar_model_get_data_range (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = util_date_range_get_first_dt (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->events_model;
		_tmp37_ = date_time_widgets_calendar_model_get_num_weeks (_tmp36_);
		_tmp38_ = _tmp37_;
		date_time_widgets_grid_update_weeks (_tmp30_, _tmp35_, _tmp38_);
		_tmp39_ = self->priv->carousel;
		_tmp40_ = grid;
		gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
		_tmp41_ = self->priv->events_model;
		date_time_widgets_calendar_model_change_month (_tmp41_, -1);
		_tmp42_ = self->priv->tasks_model;
		date_time_widgets_calendar_model_change_month (_tmp42_, -1);
		_g_object_unref0 (grid);
	} else {
		if (index == ((guint) 0)) {
			DateTimeWidgetsCalendarModel* _tmp43_;
			DateTimeWidgetsCalendarModel* _tmp44_;
			DateTimeWidgetsGrid* grid = NULL;
			DateTimeWidgetsGrid* _tmp45_;
			DateTimeWidgetsGrid* _tmp46_;
			DateTimeWidgetsCalendarModel* _tmp47_;
			UtilDateRange* _tmp48_;
			UtilDateRange* _tmp49_;
			DateTimeWidgetsCalendarModel* _tmp50_;
			GDateTime* _tmp51_;
			GDateTime* _tmp52_;
			DateTimeWidgetsGrid* _tmp53_;
			DateTimeWidgetsCalendarModel* _tmp54_;
			UtilDateRange* _tmp55_;
			UtilDateRange* _tmp56_;
			GDateTime* _tmp57_;
			GDateTime* _tmp58_;
			DateTimeWidgetsCalendarModel* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			HdyCarousel* _tmp62_;
			DateTimeWidgetsGrid* _tmp63_;
			DateTimeWidgetsCalendarModel* _tmp64_;
			DateTimeWidgetsCalendarModel* _tmp65_;
			guint _tmp66_;
			_tmp43_ = self->priv->events_model;
			date_time_widgets_calendar_model_change_month (_tmp43_, -1);
			_tmp44_ = self->priv->tasks_model;
			date_time_widgets_calendar_model_change_month (_tmp44_, -1);
			_tmp45_ = date_time_widgets_calendar_view_create_grid (self);
			grid = _tmp45_;
			_tmp46_ = grid;
			_tmp47_ = self->priv->events_model;
			_tmp48_ = date_time_widgets_calendar_model_get_data_range (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = self->priv->events_model;
			_tmp51_ = date_time_widgets_calendar_model_get_month_start (_tmp50_);
			_tmp52_ = _tmp51_;
			date_time_widgets_grid_set_range (_tmp46_, _tmp49_, _tmp52_);
			_tmp53_ = grid;
			_tmp54_ = self->priv->events_model;
			_tmp55_ = date_time_widgets_calendar_model_get_data_range (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = util_date_range_get_first_dt (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = self->priv->events_model;
			_tmp60_ = date_time_widgets_calendar_model_get_num_weeks (_tmp59_);
			_tmp61_ = _tmp60_;
			date_time_widgets_grid_update_weeks (_tmp53_, _tmp58_, _tmp61_);
			_tmp62_ = self->priv->carousel;
			_tmp63_ = grid;
			hdy_carousel_prepend (_tmp62_, (GtkWidget*) _tmp63_);
			_tmp64_ = self->priv->events_model;
			date_time_widgets_calendar_model_change_month (_tmp64_, 1);
			_tmp65_ = self->priv->tasks_model;
			date_time_widgets_calendar_model_change_month (_tmp65_, 1);
			_tmp66_ = self->priv->position;
			self->priv->position = _tmp66_ + 1;
			_g_object_unref0 (grid);
		}
	}
	_tmp67_ = self->priv->label;
	_tmp68_ = self->priv->events_model;
	_tmp69_ = date_time_widgets_calendar_model_get_month_start (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_date_time_format (_tmp70_, _ ("%OB, %Y"));
	_tmp72_ = _tmp71_;
	gtk_label_set_label (_tmp67_, _tmp72_);
	_g_free0 (_tmp72_);
}

static void
__date_time_widgets_calendar_view___lambda30__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                         guint index,
                                                                         gpointer self)
{
	_date_time_widgets_calendar_view___lambda30_ ((DateTimeWidgetsCalendarView*) self, index);
}

static GObject *
date_time_widgets_calendar_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeWidgetsCalendarView * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_ = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp5_;
	GtkCssProvider* _tmp6_;
	GtkStyleContext* label_style_context = NULL;
	GtkLabel* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkCssProvider* _tmp12_;
	GtkButton* left_button = NULL;
	GtkButton* _tmp13_;
	GtkButton* center_button = NULL;
	gchar* _tmp14_;
	GtkButton* _tmp15_ = NULL;
	GtkButton* right_button = NULL;
	GtkButton* _tmp16_;
	GtkBox* box_buttons = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkBox* _tmp20_;
	GtkButton* _tmp21_;
	GtkBox* _tmp22_;
	GtkButton* _tmp23_;
	GtkBox* _tmp24_;
	GtkButton* _tmp25_;
	DateTimeWidgetsCalendarModel* _tmp26_;
	DateTimeWidgetsCalendarModel* _tmp27_;
	GDateTime* _tmp28_;
	DateTimeWidgetsGrid* _tmp29_;
	DateTimeWidgetsGrid* _tmp30_;
	DateTimeWidgetsCalendarModel* _tmp31_;
	UtilDateRange* _tmp32_;
	UtilDateRange* _tmp33_;
	DateTimeWidgetsCalendarModel* _tmp34_;
	GDateTime* _tmp35_;
	GDateTime* _tmp36_;
	DateTimeWidgetsGrid* _tmp37_;
	DateTimeWidgetsCalendarModel* _tmp38_;
	UtilDateRange* _tmp39_;
	UtilDateRange* _tmp40_;
	GDateTime* _tmp41_;
	GDateTime* _tmp42_;
	DateTimeWidgetsCalendarModel* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	DateTimeWidgetsCalendarModel* _tmp46_;
	DateTimeWidgetsCalendarModel* _tmp47_;
	DateTimeWidgetsGrid* left_grid = NULL;
	DateTimeWidgetsGrid* _tmp48_;
	DateTimeWidgetsGrid* _tmp49_;
	DateTimeWidgetsCalendarModel* _tmp50_;
	UtilDateRange* _tmp51_;
	UtilDateRange* _tmp52_;
	DateTimeWidgetsCalendarModel* _tmp53_;
	GDateTime* _tmp54_;
	GDateTime* _tmp55_;
	DateTimeWidgetsGrid* _tmp56_;
	DateTimeWidgetsCalendarModel* _tmp57_;
	UtilDateRange* _tmp58_;
	UtilDateRange* _tmp59_;
	GDateTime* _tmp60_;
	GDateTime* _tmp61_;
	DateTimeWidgetsCalendarModel* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	DateTimeWidgetsCalendarModel* _tmp65_;
	DateTimeWidgetsCalendarModel* _tmp66_;
	DateTimeWidgetsGrid* right_grid = NULL;
	DateTimeWidgetsGrid* _tmp67_;
	DateTimeWidgetsGrid* _tmp68_;
	DateTimeWidgetsCalendarModel* _tmp69_;
	UtilDateRange* _tmp70_;
	UtilDateRange* _tmp71_;
	DateTimeWidgetsCalendarModel* _tmp72_;
	GDateTime* _tmp73_;
	GDateTime* _tmp74_;
	DateTimeWidgetsGrid* _tmp75_;
	DateTimeWidgetsCalendarModel* _tmp76_;
	UtilDateRange* _tmp77_;
	UtilDateRange* _tmp78_;
	GDateTime* _tmp79_;
	GDateTime* _tmp80_;
	DateTimeWidgetsCalendarModel* _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	DateTimeWidgetsCalendarModel* _tmp84_;
	DateTimeWidgetsCalendarModel* _tmp85_;
	HdyCarousel* _tmp86_ = NULL;
	HdyCarousel* _tmp87_;
	DateTimeWidgetsGrid* _tmp88_;
	HdyCarousel* _tmp89_;
	DateTimeWidgetsGrid* _tmp90_;
	HdyCarousel* _tmp91_;
	DateTimeWidgetsGrid* _tmp92_;
	HdyCarousel* _tmp93_;
	DateTimeWidgetsGrid* _tmp94_;
	HdyCarousel* _tmp95_;
	GtkLabel* _tmp96_;
	GtkBox* _tmp97_;
	HdyCarousel* _tmp98_;
	GtkButton* _tmp99_;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	HdyCarousel* _tmp102_;
	parent_class = G_OBJECT_CLASS (date_time_widgets_calendar_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, DateTimeWidgetsCalendarView);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, _ ("%OB, %Y"));
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 6);
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	gtk_label_set_width_chars (_tmp4_, 13);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp4_;
	_g_free0 (_tmp3_);
	_g_date_time_unref0 (_tmp1_);
	_tmp5_ = gtk_css_provider_new ();
	provider = _tmp5_;
	_tmp6_ = provider;
	gtk_css_provider_load_from_resource (_tmp6_, "/io/elementary/desktop/wingpanel/datetime/ControlHeader.css");
	_tmp7_ = self->priv->label;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	label_style_context = _tmp8_;
	_tmp9_ = label_style_context;
	gtk_style_context_add_class (_tmp9_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp10_ = label_style_context;
	gtk_style_context_add_class (_tmp10_, "header-label");
	_tmp11_ = label_style_context;
	_tmp12_ = provider;
	gtk_style_context_add_provider (_tmp11_, (GtkStyleProvider*) _tmp12_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp13_);
	left_button = _tmp13_;
	_tmp14_ = g_strdup (_ ("Go to today's date"));
	_tmp15_ = (GtkButton*) gtk_button_new_from_icon_name ("office-calendar-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	center_button = _tmp15_;
	_tmp16_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp16_);
	right_button = _tmp16_;
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp17_);
	box_buttons = _tmp17_;
	_tmp18_ = box_buttons;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_LINKED);
	_tmp20_ = box_buttons;
	_tmp21_ = left_button;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = box_buttons;
	_tmp23_ = center_button;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = box_buttons;
	_tmp25_ = right_button;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_EVENTS);
	_g_object_unref0 (self->priv->events_model);
	self->priv->events_model = _tmp26_;
	_tmp27_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_TASKS);
	_g_object_unref0 (self->priv->tasks_model);
	self->priv->tasks_model = _tmp27_;
	_tmp28_ = util_get_start_of_month (NULL);
	_g_date_time_unref0 (self->priv->start_month);
	self->priv->start_month = _tmp28_;
	_tmp29_ = date_time_widgets_calendar_view_create_grid (self);
	_g_object_unref0 (self->priv->start_month_grid);
	self->priv->start_month_grid = _tmp29_;
	_tmp30_ = self->priv->start_month_grid;
	_tmp31_ = self->priv->events_model;
	_tmp32_ = date_time_widgets_calendar_model_get_data_range (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->events_model;
	_tmp35_ = date_time_widgets_calendar_model_get_month_start (_tmp34_);
	_tmp36_ = _tmp35_;
	date_time_widgets_grid_set_range (_tmp30_, _tmp33_, _tmp36_);
	_tmp37_ = self->priv->start_month_grid;
	_tmp38_ = self->priv->events_model;
	_tmp39_ = date_time_widgets_calendar_model_get_data_range (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = util_date_range_get_first_dt (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->priv->events_model;
	_tmp44_ = date_time_widgets_calendar_model_get_num_weeks (_tmp43_);
	_tmp45_ = _tmp44_;
	date_time_widgets_grid_update_weeks (_tmp37_, _tmp42_, _tmp45_);
	_tmp46_ = self->priv->events_model;
	date_time_widgets_calendar_model_change_month (_tmp46_, -1);
	_tmp47_ = self->priv->tasks_model;
	date_time_widgets_calendar_model_change_month (_tmp47_, -1);
	_tmp48_ = date_time_widgets_calendar_view_create_grid (self);
	left_grid = _tmp48_;
	_tmp49_ = left_grid;
	_tmp50_ = self->priv->events_model;
	_tmp51_ = date_time_widgets_calendar_model_get_data_range (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = self->priv->events_model;
	_tmp54_ = date_time_widgets_calendar_model_get_month_start (_tmp53_);
	_tmp55_ = _tmp54_;
	date_time_widgets_grid_set_range (_tmp49_, _tmp52_, _tmp55_);
	_tmp56_ = left_grid;
	_tmp57_ = self->priv->events_model;
	_tmp58_ = date_time_widgets_calendar_model_get_data_range (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = util_date_range_get_first_dt (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = self->priv->events_model;
	_tmp63_ = date_time_widgets_calendar_model_get_num_weeks (_tmp62_);
	_tmp64_ = _tmp63_;
	date_time_widgets_grid_update_weeks (_tmp56_, _tmp61_, _tmp64_);
	_tmp65_ = self->priv->events_model;
	date_time_widgets_calendar_model_change_month (_tmp65_, 2);
	_tmp66_ = self->priv->tasks_model;
	date_time_widgets_calendar_model_change_month (_tmp66_, 2);
	_tmp67_ = date_time_widgets_calendar_view_create_grid (self);
	right_grid = _tmp67_;
	_tmp68_ = right_grid;
	_tmp69_ = self->priv->events_model;
	_tmp70_ = date_time_widgets_calendar_model_get_data_range (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = self->priv->events_model;
	_tmp73_ = date_time_widgets_calendar_model_get_month_start (_tmp72_);
	_tmp74_ = _tmp73_;
	date_time_widgets_grid_set_range (_tmp68_, _tmp71_, _tmp74_);
	_tmp75_ = right_grid;
	_tmp76_ = self->priv->events_model;
	_tmp77_ = date_time_widgets_calendar_model_get_data_range (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = util_date_range_get_first_dt (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = self->priv->events_model;
	_tmp82_ = date_time_widgets_calendar_model_get_num_weeks (_tmp81_);
	_tmp83_ = _tmp82_;
	date_time_widgets_grid_update_weeks (_tmp75_, _tmp80_, _tmp83_);
	_tmp84_ = self->priv->events_model;
	date_time_widgets_calendar_model_change_month (_tmp84_, -1);
	_tmp85_ = self->priv->tasks_model;
	date_time_widgets_calendar_model_change_month (_tmp85_, -1);
	_tmp86_ = (HdyCarousel*) hdy_carousel_new ();
	hdy_carousel_set_interactive (_tmp86_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp86_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp86_, TRUE);
	hdy_carousel_set_spacing (_tmp86_, (guint) 15);
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (self->priv->carousel);
	self->priv->carousel = _tmp86_;
	_tmp87_ = self->priv->carousel;
	_tmp88_ = left_grid;
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = self->priv->carousel;
	_tmp90_ = self->priv->start_month_grid;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->carousel;
	_tmp92_ = right_grid;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = self->priv->carousel;
	_tmp94_ = self->priv->start_month_grid;
	hdy_carousel_scroll_to (_tmp93_, (GtkWidget*) _tmp94_);
	self->priv->position = (guint) 1;
	self->priv->rel_postion = 0;
	self->priv->showtoday = FALSE;
	_tmp95_ = self->priv->carousel;
	gtk_widget_show_all ((GtkWidget*) _tmp95_);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	gtk_widget_set_margin_end ((GtkWidget*) self, 10);
	gtk_widget_set_margin_start ((GtkWidget*) self, 10);
	_tmp96_ = self->priv->label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp96_, 0, 0, 1, 1);
	_tmp97_ = box_buttons;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp97_, 1, 0, 1, 1);
	_tmp98_ = self->priv->carousel;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp98_, 0, 1, 2, 1);
	_tmp99_ = left_button;
	g_signal_connect_object (_tmp99_, "clicked", (GCallback) __date_time_widgets_calendar_view___lambda27__gtk_button_clicked, self, 0);
	_tmp100_ = right_button;
	g_signal_connect_object (_tmp100_, "clicked", (GCallback) __date_time_widgets_calendar_view___lambda28__gtk_button_clicked, self, 0);
	_tmp101_ = center_button;
	g_signal_connect_object (_tmp101_, "clicked", (GCallback) __date_time_widgets_calendar_view___lambda29__gtk_button_clicked, self, 0);
	_tmp102_ = self->priv->carousel;
	g_signal_connect_object (_tmp102_, "page-changed", (GCallback) __date_time_widgets_calendar_view___lambda30__hdy_carousel_page_changed, self, 0);
	_g_object_unref0 (right_grid);
	_g_object_unref0 (left_grid);
	_g_object_unref0 (box_buttons);
	_g_object_unref0 (right_button);
	_g_object_unref0 (center_button);
	_g_object_unref0 (left_button);
	_g_object_unref0 (provider);
	return obj;
}

static void
date_time_widgets_calendar_view_class_init (DateTimeWidgetsCalendarViewClass * klass,
                                            gpointer klass_data)
{
	date_time_widgets_calendar_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeWidgetsCalendarView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_date_time_widgets_calendar_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_date_time_widgets_calendar_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = date_time_widgets_calendar_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_widgets_calendar_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY, date_time_widgets_calendar_view_properties[DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY] = g_param_spec_boxed ("selected-date", "selected-date", "selected-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_DAY_DOUBLE_CLICK_SIGNAL] = g_signal_new ("day-double-click", DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_EVENT_UPDATES_SIGNAL] = g_signal_new ("event-updates", DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	date_time_widgets_calendar_view_signals[DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
}

static void
date_time_widgets_calendar_view_instance_init (DateTimeWidgetsCalendarView * self,
                                               gpointer klass)
{
	self->priv = date_time_widgets_calendar_view_get_instance_private (self);
}

static void
date_time_widgets_calendar_view_finalize (GObject * obj)
{
	DateTimeWidgetsCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, DateTimeWidgetsCalendarView);
	_g_date_time_unref0 (self->priv->_selected_date);
	_g_object_unref0 (self->priv->carousel);
	_g_object_unref0 (self->priv->events_model);
	_g_object_unref0 (self->priv->tasks_model);
	_g_date_time_unref0 (self->priv->start_month);
	_g_object_unref0 (self->priv->start_month_grid);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (date_time_widgets_calendar_view_parent_class)->finalize (obj);
}

static GType
date_time_widgets_calendar_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeWidgetsCalendarViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_widgets_calendar_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeWidgetsCalendarView), 0, (GInstanceInitFunc) date_time_widgets_calendar_view_instance_init, NULL };
	GType date_time_widgets_calendar_view_type_id;
	date_time_widgets_calendar_view_type_id = g_type_register_static (gtk_grid_get_type (), "DateTimeWidgetsCalendarView", &g_define_type_info, 0);
	DateTimeWidgetsCalendarView_private_offset = g_type_add_instance_private (date_time_widgets_calendar_view_type_id, sizeof (DateTimeWidgetsCalendarViewPrivate));
	return date_time_widgets_calendar_view_type_id;
}

GType
date_time_widgets_calendar_view_get_type (void)
{
	static volatile gsize date_time_widgets_calendar_view_type_id__once = 0;
	if (g_once_init_enter (&date_time_widgets_calendar_view_type_id__once)) {
		GType date_time_widgets_calendar_view_type_id;
		date_time_widgets_calendar_view_type_id = date_time_widgets_calendar_view_get_type_once ();
		g_once_init_leave (&date_time_widgets_calendar_view_type_id__once, date_time_widgets_calendar_view_type_id);
	}
	return date_time_widgets_calendar_view_type_id__once;
}

static void
_vala_date_time_widgets_calendar_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	DateTimeWidgetsCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, DateTimeWidgetsCalendarView);
	switch (property_id) {
		case DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		g_value_set_boxed (value, date_time_widgets_calendar_view_get_selected_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_date_time_widgets_calendar_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	DateTimeWidgetsCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_CALENDAR_VIEW, DateTimeWidgetsCalendarView);
	switch (property_id) {
		case DATE_TIME_WIDGETS_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		date_time_widgets_calendar_view_set_selected_date (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

