/* CalendarModel.c generated by valac 0.56.16, the Vala compiler
 * generated from CalendarModel.vala, do not modify */

/*
 * Copyright (c) 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "datetime.h"
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libecal/libecal.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <libical-glib/libical-glib.h>
#include <langinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_WIDGETS_CALENDAR_MODEL_0_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_PROPERTIES
};
static GParamSpec* date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DateTimeWidgetsCalendarModelOpenData DateTimeWidgetsCalendarModelOpenData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _DateTimeWidgetsCalendarModelAddSourceAsyncData DateTimeWidgetsCalendarModelAddSourceAsyncData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
enum  {
	DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_ADDED_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_UPDATED_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_REMOVED_SIGNAL,
	DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_SIGNALS
};
static guint date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DateTimeWidgetsCalendarModelPrivate {
	UtilDateRange* _data_range;
	GDateTime* _month_start;
	gint _num_weeks;
	GDateWeekday _week_starts_on;
	GHashTable* _source_components;
	ESourceRegistry* _registry;
	GHashTable* source_client;
	GRecMutex __lock_source_client;
	GHashTable* source_view;
	ECalClientSourceType _source_type;
};

struct _DateTimeWidgetsCalendarModelOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DateTimeWidgetsCalendarModel* self;
	ESourceRegistry* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceRegistry* _tmp2_;
	ESourceRegistry* _tmp3_;
	ECalClientSourceType _tmp4_;
	ESourceRegistry* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	ESourceRegistry* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	DateTimeWidgetsCalendarModel* self;
	ECalClient* client;
	ESource* source;
};

struct _Block3Data {
	int _ref_count_;
	DateTimeWidgetsCalendarModel* self;
	ESource* source;
	gpointer _async_data_;
};

struct _DateTimeWidgetsCalendarModelAddSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DateTimeWidgetsCalendarModel* self;
	ESource* source;
	Block3Data* _data3_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ECalClientSourceType _tmp2_;
	gboolean _tmp3_;
	ECalClientSourceType _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	EClient* _tmp7_;
	ECalClientSourceType _tmp8_;
	EClient* _tmp9_;
	ECalClient* client;
	ECalClient* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	ECalClient* _tmp13_;
	ECalClient* _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	DateTimeWidgetsCalendarModel* self;
	GeeTreeMultiMap* components;
	GeeArrayList* added_components;
	ESource* source;
	ECalClient* client;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	const gchar* uid;
};

struct _Block6Data {
	int _ref_count_;
	DateTimeWidgetsCalendarModel* self;
	GeeArrayList* updated_components;
	ESource* source;
};

struct _Block7Data {
	int _ref_count_;
	DateTimeWidgetsCalendarModel* self;
	GeeTreeMultiMap* components;
	GeeArrayList* removed_components;
	ESource* source;
};

static gint DateTimeWidgetsCalendarModel_private_offset;
static gpointer date_time_widgets_calendar_model_parent_class = NULL;
static GHashTable* date_time_widgets_calendar_model_calendar_model;
static GRecMutex __lock_date_time_widgets_calendar_model_date_time_widgets_calendar_model_calendar_model = {0};
static GHashTable* date_time_widgets_calendar_model_calendar_model = NULL;

static void _g_object_unref0_ (gpointer var);
static void date_time_widgets_calendar_model_open_data_free (gpointer _data);
static void date_time_widgets_calendar_model_open (DateTimeWidgetsCalendarModel* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void date_time_widgets_calendar_model_open_finish (DateTimeWidgetsCalendarModel* self,
                                                   GAsyncResult* _res_);
static gboolean date_time_widgets_calendar_model_open_co (DateTimeWidgetsCalendarModelOpenData* _data_);
static void date_time_widgets_calendar_model_open_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void date_time_widgets_calendar_model_set_registry (DateTimeWidgetsCalendarModel* self,
                                                    ESourceRegistry* value);
static ESourceRegistry* date_time_widgets_calendar_model_get_registry (DateTimeWidgetsCalendarModel* self);
static void date_time_widgets_calendar_model_remove_source (DateTimeWidgetsCalendarModel* self,
                                                     ESource* source);
static void _date_time_widgets_calendar_model_remove_source_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                       ESource* source,
                                                                                       gpointer self);
static void ___lambda10_ (DateTimeWidgetsCalendarModel* self,
                   ESource* source);
static void date_time_widgets_calendar_model_add_source_async (DateTimeWidgetsCalendarModel* self,
                                                        ESource* source,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void date_time_widgets_calendar_model_add_source_finish (DateTimeWidgetsCalendarModel* self,
                                                         GAsyncResult* _res_);
static void ____lambda10__e_source_registry_source_added (ESourceRegistry* _sender,
                                                   ESource* source,
                                                   gpointer self);
static void ____lambda20_ (DateTimeWidgetsCalendarModel* self,
                    ESource* source);
static void _____lambda20__gfunc (gconstpointer data,
                           gpointer self);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda21_ (DateTimeWidgetsCalendarModel* self,
                    ESource* source);
static void _____lambda21__gfunc (gconstpointer data,
                           gpointer self);
static void date_time_widgets_calendar_model_load_all_sources (DateTimeWidgetsCalendarModel* self);
static void date_time_widgets_calendar_model_load_source (DateTimeWidgetsCalendarModel* self,
                                                   ESource* source);
static void date_time_widgets_calendar_model_compute_ranges (DateTimeWidgetsCalendarModel* self);
static void date_time_widgets_calendar_model_set_data_range (DateTimeWidgetsCalendarModel* self,
                                                      UtilDateRange* value);
static void date_time_widgets_calendar_model_set_num_weeks (DateTimeWidgetsCalendarModel* self,
                                                     gint value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda12_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* results);
static ECalClientView* date_time_widgets_calendar_model_on_client_view_received (DateTimeWidgetsCalendarModel* self,
                                                                          GAsyncResult* results,
                                                                          ESource* source,
                                                                          ECalClient* client);
static void __lambda13_ (Block2Data* _data2_,
                  GSList* objects);
static void date_time_widgets_calendar_model_on_objects_added (DateTimeWidgetsCalendarModel* self,
                                                        ESource* source,
                                                        ECalClient* client,
                                                        GSList* objects);
static void ___lambda13__e_cal_client_view_objects_added (ECalClientView* _sender,
                                                   GSList* objects,
                                                   gpointer self);
static void __lambda16_ (Block2Data* _data2_,
                  GSList* objects);
static void date_time_widgets_calendar_model_on_objects_removed (DateTimeWidgetsCalendarModel* self,
                                                          ESource* source,
                                                          ECalClient* client,
                                                          GSList* cids);
static void ___lambda16__e_cal_client_view_objects_removed (ECalClientView* _sender,
                                                     GSList* uids,
                                                     gpointer self);
static void __lambda18_ (Block2Data* _data2_,
                  GSList* objects);
static void date_time_widgets_calendar_model_on_objects_modified (DateTimeWidgetsCalendarModel* self,
                                                           ESource* source,
                                                           ECalClient* client,
                                                           GSList* objects);
static void ___lambda18__e_cal_client_view_objects_modified (ECalClientView* _sender,
                                                      GSList* objects,
                                                      gpointer self);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void date_time_widgets_calendar_model_add_source_async_data_free (gpointer _data);
static gboolean date_time_widgets_calendar_model_add_source_async_co (DateTimeWidgetsCalendarModelAddSourceAsyncData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block3Data* _data3_);
static gboolean ___lambda11__gsource_func (gpointer self);
static void date_time_widgets_calendar_model_debug_component (DateTimeWidgetsCalendarModel* self,
                                                       ESource* source,
                                                       ECalComponent* component);
static void date_time_widgets_calendar_model_on_parameter_changed (DateTimeWidgetsCalendarModel* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda14_ (Block4Data* _data4_,
                  ICalComponent* comp);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block5Data* _data5_,
                      ICalComponent* comp,
                      ICalTime* start,
                      ICalTime* end,
                      GError** error);
static gboolean ___lambda15__ecal_recur_instance_cb (ICalComponent* icomp,
                                              ICalTime* instance_start,
                                              ICalTime* instance_end,
                                              gpointer self,
                                              GCancellable* cancellable,
                                              GError** error);
static void ___lambda14__gfunc (gconstpointer data,
                         gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda19_ (Block6Data* _data6_,
                  ICalComponent* comp);
static void ___lambda19__gfunc (gconstpointer data,
                         gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda17_ (Block7Data* _data7_,
                  ECalComponentId* cid);
static void ___lambda17__gfunc (gconstpointer data,
                         gpointer self);
static void date_time_widgets_calendar_model_set_source_components (DateTimeWidgetsCalendarModel* self,
                                                             GHashTable* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * date_time_widgets_calendar_model_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static guint _util_source_hash_func_ghash_func (gconstpointer key);
static gboolean _util_source_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void _date_time_widgets_calendar_model_on_parameter_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self);
static void date_time_widgets_calendar_model_finalize (GObject * obj);
static GType date_time_widgets_calendar_model_get_type_once (void);
static void _vala_date_time_widgets_calendar_model_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_date_time_widgets_calendar_model_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);

static inline gpointer
date_time_widgets_calendar_model_get_instance_private (DateTimeWidgetsCalendarModel* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeWidgetsCalendarModel_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DateTimeWidgetsCalendarModel*
date_time_widgets_calendar_model_get_default (ECalClientSourceType source_type)
{
	GHashTable* _tmp9_;
	gconstpointer _tmp10_;
	DateTimeWidgetsCalendarModel* _tmp11_;
	GError* _inner_error0_ = NULL;
	DateTimeWidgetsCalendarModel* result;
	{
		GHashTable* _tmp0_;
		_tmp0_ = date_time_widgets_calendar_model_calendar_model;
		g_rec_mutex_lock (&__lock_date_time_widgets_calendar_model_date_time_widgets_calendar_model_calendar_model);
		{
			GHashTable* _tmp1_;
			GHashTable* _tmp5_;
			_tmp1_ = date_time_widgets_calendar_model_calendar_model;
			if (_tmp1_ == NULL) {
				GHashFunc _tmp2_;
				GEqualFunc _tmp3_;
				GHashTable* _tmp4_;
				_tmp2_ = g_direct_hash;
				_tmp3_ = g_direct_equal;
				_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_object_unref0_);
				_g_hash_table_unref0 (date_time_widgets_calendar_model_calendar_model);
				date_time_widgets_calendar_model_calendar_model = _tmp4_;
			}
			_tmp5_ = date_time_widgets_calendar_model_calendar_model;
			if (!g_hash_table_contains (_tmp5_, (gpointer) ((gintptr) source_type))) {
				GHashTable* _tmp6_;
				DateTimeWidgetsCalendarModel* _tmp7_;
				_tmp6_ = date_time_widgets_calendar_model_calendar_model;
				_tmp7_ = date_time_widgets_calendar_model_new (source_type);
				g_hash_table_insert (_tmp6_, (gpointer) ((gintptr) source_type), _tmp7_);
			}
		}
		__finally0:
		{
			GHashTable* _tmp8_;
			_tmp8_ = date_time_widgets_calendar_model_calendar_model;
			g_rec_mutex_unlock (&__lock_date_time_widgets_calendar_model_date_time_widgets_calendar_model_calendar_model);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = date_time_widgets_calendar_model_calendar_model;
	_tmp10_ = g_hash_table_lookup (_tmp9_, (gpointer) ((gintptr) source_type));
	_tmp11_ = _g_object_ref0 ((DateTimeWidgetsCalendarModel*) _tmp10_);
	result = _tmp11_;
	return result;
}

DateTimeWidgetsCalendarModel*
date_time_widgets_calendar_model_construct (GType object_type,
                                            ECalClientSourceType source_type)
{
	DateTimeWidgetsCalendarModel * self = NULL;
	self = (DateTimeWidgetsCalendarModel*) g_object_new (object_type, "source-type", source_type, NULL);
	return self;
}

DateTimeWidgetsCalendarModel*
date_time_widgets_calendar_model_new (ECalClientSourceType source_type)
{
	return date_time_widgets_calendar_model_construct (DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, source_type);
}

static void
date_time_widgets_calendar_model_open_data_free (gpointer _data)
{
	DateTimeWidgetsCalendarModelOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DateTimeWidgetsCalendarModelOpenData, _data_);
}

static void
date_time_widgets_calendar_model_open (DateTimeWidgetsCalendarModel* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	DateTimeWidgetsCalendarModelOpenData* _data_;
	DateTimeWidgetsCalendarModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DateTimeWidgetsCalendarModelOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, date_time_widgets_calendar_model_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	date_time_widgets_calendar_model_open_co (_data_);
}

static void
date_time_widgets_calendar_model_open_finish (DateTimeWidgetsCalendarModel* self,
                                              GAsyncResult* _res_)
{
	DateTimeWidgetsCalendarModelOpenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
date_time_widgets_calendar_model_open_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	DateTimeWidgetsCalendarModelOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	date_time_widgets_calendar_model_open_co (_data_);
}

static void
_date_time_widgets_calendar_model_remove_source_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                  ESource* source,
                                                                                  gpointer self)
{
	date_time_widgets_calendar_model_remove_source ((DateTimeWidgetsCalendarModel*) self, source);
}

static void
___lambda10_ (DateTimeWidgetsCalendarModel* self,
              ESource* source)
{
	g_return_if_fail (source != NULL);
	date_time_widgets_calendar_model_add_source_async (self, source, NULL, NULL);
}

static void
____lambda10__e_source_registry_source_added (ESourceRegistry* _sender,
                                              ESource* source,
                                              gpointer self)
{
	___lambda10_ ((DateTimeWidgetsCalendarModel*) self, source);
}

static void
____lambda20_ (DateTimeWidgetsCalendarModel* self,
               ESource* source)
{
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	ESourceTaskList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESourceTaskList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList));
	list = _tmp1_;
	_tmp3_ = list;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		date_time_widgets_calendar_model_add_source_async (self, source, NULL, NULL);
	}
	_g_object_unref0 (list);
}

static void
_____lambda20__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda20_ ((DateTimeWidgetsCalendarModel*) self, (ESource*) data);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
____lambda21_ (DateTimeWidgetsCalendarModel* self,
               ESource* source)
{
	ESourceCalendar* cal = NULL;
	ESourceExtension* _tmp0_;
	ESourceCalendar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESourceCalendar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp1_;
	_tmp3_ = cal;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		date_time_widgets_calendar_model_add_source_async (self, source, NULL, NULL);
	}
	_g_object_unref0 (cal);
}

static void
_____lambda21__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda21_ ((DateTimeWidgetsCalendarModel*) self, (ESource*) data);
}

static gboolean
date_time_widgets_calendar_model_open_co (DateTimeWidgetsCalendarModelOpenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		e_source_registry_new (NULL, date_time_widgets_calendar_model_open_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		date_time_widgets_calendar_model_set_registry (_data_->self, _data_->_tmp0_);
		_data_->_tmp2_ = _data_->self->priv->_registry;
		g_signal_connect_object (_data_->_tmp2_, "source-removed", (GCallback) _date_time_widgets_calendar_model_remove_source_e_source_registry_source_removed, _data_->self, 0);
		_data_->_tmp3_ = _data_->self->priv->_registry;
		g_signal_connect_object (_data_->_tmp3_, "source-added", (GCallback) ____lambda10__e_source_registry_source_added, _data_->self, 0);
		_data_->_tmp4_ = _data_->self->priv->_source_type;
		if (_data_->_tmp4_ == E_CAL_CLIENT_SOURCE_TYPE_TASKS) {
			_data_->_tmp5_ = _data_->self->priv->_registry;
			_data_->_tmp6_ = e_source_registry_list_sources (_data_->_tmp5_, E_SOURCE_EXTENSION_TASK_LIST);
			_data_->_tmp7_ = _data_->_tmp6_;
			g_list_foreach (_data_->_tmp7_, _____lambda20__gfunc, _data_->self);
			(_data_->_tmp7_ == NULL) ? NULL : (_data_->_tmp7_ = (_g_list_free__g_object_unref0_ (_data_->_tmp7_), NULL));
		} else {
			_data_->_tmp8_ = _data_->self->priv->_registry;
			_data_->_tmp9_ = e_source_registry_list_sources (_data_->_tmp8_, E_SOURCE_EXTENSION_CALENDAR);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_list_foreach (_data_->_tmp10_, _____lambda21__gfunc, _data_->self);
			(_data_->_tmp10_ == NULL) ? NULL : (_data_->_tmp10_ = (_g_list_free__g_object_unref0_ (_data_->_tmp10_), NULL));
		}
		date_time_widgets_calendar_model_load_all_sources (_data_->self);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->_error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("CalendarModel.vala:113: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
date_time_widgets_calendar_model_load_all_sources (DateTimeWidgetsCalendarModel* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp1_;
			GList* _tmp2_;
			_tmp1_ = self->priv->source_client;
			_tmp2_ = g_hash_table_get_keys (_tmp1_);
			{
				GList* id_collection = NULL;
				GList* id_it = NULL;
				id_collection = _tmp2_;
				for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
					const gchar* id = NULL;
					id = (const gchar*) id_it->data;
					{
						ESource* source = NULL;
						ESourceRegistry* _tmp3_;
						const gchar* _tmp4_;
						ESource* _tmp5_;
						ECalClientSourceType _tmp6_;
						_tmp3_ = self->priv->_registry;
						_tmp4_ = id;
						_tmp5_ = e_source_registry_ref_source (_tmp3_, _tmp4_);
						source = _tmp5_;
						_tmp6_ = self->priv->_source_type;
						if (_tmp6_ == E_CAL_CLIENT_SOURCE_TYPE_TASKS) {
							ESourceTaskList* list = NULL;
							ESource* _tmp7_;
							ESourceExtension* _tmp8_;
							ESourceTaskList* _tmp9_;
							gboolean _tmp10_ = FALSE;
							ESourceTaskList* _tmp11_;
							gboolean _tmp12_;
							gboolean _tmp13_;
							_tmp7_ = source;
							_tmp8_ = e_source_get_extension (_tmp7_, E_SOURCE_EXTENSION_TASK_LIST);
							_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, e_source_task_list_get_type (), ESourceTaskList));
							list = _tmp9_;
							_tmp11_ = list;
							_tmp12_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp11_);
							_tmp13_ = _tmp12_;
							if (_tmp13_ == TRUE) {
								ESource* _tmp14_;
								gboolean _tmp15_;
								gboolean _tmp16_;
								_tmp14_ = source;
								_tmp15_ = e_source_get_enabled (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp10_ = _tmp16_ == TRUE;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								ESource* _tmp17_;
								_tmp17_ = source;
								date_time_widgets_calendar_model_load_source (self, _tmp17_);
							}
							_g_object_unref0 (list);
						} else {
							ESourceCalendar* cal = NULL;
							ESource* _tmp18_;
							ESourceExtension* _tmp19_;
							ESourceCalendar* _tmp20_;
							gboolean _tmp21_ = FALSE;
							ESourceCalendar* _tmp22_;
							gboolean _tmp23_;
							gboolean _tmp24_;
							_tmp18_ = source;
							_tmp19_ = e_source_get_extension (_tmp18_, E_SOURCE_EXTENSION_CALENDAR);
							_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, e_source_calendar_get_type (), ESourceCalendar));
							cal = _tmp20_;
							_tmp22_ = cal;
							_tmp23_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp22_);
							_tmp24_ = _tmp23_;
							if (_tmp24_ == TRUE) {
								ESource* _tmp25_;
								gboolean _tmp26_;
								gboolean _tmp27_;
								_tmp25_ = source;
								_tmp26_ = e_source_get_enabled (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp21_ = _tmp27_ == TRUE;
							} else {
								_tmp21_ = FALSE;
							}
							if (_tmp21_) {
								ESource* _tmp28_;
								_tmp28_ = source;
								date_time_widgets_calendar_model_load_source (self, _tmp28_);
							}
							_g_object_unref0 (cal);
						}
						_g_object_unref0 (source);
					}
				}
				(id_collection == NULL) ? NULL : (id_collection = (g_list_free (id_collection), NULL));
			}
		}
		__finally0:
		{
			GHashTable* _tmp29_;
			_tmp29_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
date_time_widgets_calendar_model_remove_source (DateTimeWidgetsCalendarModel* self,
                                                ESource* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* uid = NULL;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	ECalClientView* current_view = NULL;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gconstpointer _tmp7_;
	ECalClientView* _tmp8_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	GeeCollection* components = NULL;
	GHashTable* _tmp18_;
	gconstpointer _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GHashTable* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_dup_display_name (source);
	_tmp1_ = _tmp0_;
	g_debug ("CalendarModel.vala:141: Removing source '%s'", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = e_source_get_uid (source);
	uid = _tmp2_;
	_tmp3_ = self->priv->source_view;
	_tmp4_ = uid;
	if (!g_hash_table_contains (_tmp3_, _tmp4_)) {
		return;
	}
	_tmp5_ = self->priv->source_view;
	_tmp6_ = uid;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	_tmp8_ = _g_object_ref0 ((ECalClientView*) _tmp7_);
	current_view = _tmp8_;
	{
		ECalClientView* _tmp9_;
		_tmp9_ = current_view;
		e_cal_client_view_stop (_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("CalendarModel.vala:153: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (current_view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = self->priv->source_view;
	_tmp13_ = uid;
	g_hash_table_remove (_tmp12_, _tmp13_);
	{
		GHashTable* _tmp14_;
		_tmp14_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = self->priv->source_client;
			_tmp16_ = uid;
			g_hash_table_remove (_tmp15_, _tmp16_);
		}
		__finally1:
		{
			GHashTable* _tmp17_;
			_tmp17_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (current_view);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = self->priv->_source_components;
	_tmp19_ = g_hash_table_lookup (_tmp18_, source);
	_tmp20_ = gee_multi_map_get_values ((GeeMultiMap*) ((GeeTreeMultiMap*) _tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = gee_collection_get_read_only_view (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp21_);
	components = _tmp24_;
	_tmp25_ = components;
	g_signal_emit (self, date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_REMOVED_SIGNAL], 0, source, _tmp25_);
	_tmp26_ = self->priv->_source_components;
	g_hash_table_remove (_tmp26_, source);
	_g_object_unref0 (components);
	_g_object_unref0 (current_view);
}

void
date_time_widgets_calendar_model_change_month (DateTimeWidgetsCalendarModel* self,
                                               gint relative)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_month_start;
	_tmp1_ = g_date_time_add_months (_tmp0_, relative);
	_tmp2_ = _tmp1_;
	date_time_widgets_calendar_model_set_month_start (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}

void
date_time_widgets_calendar_model_change_year (DateTimeWidgetsCalendarModel* self,
                                              gint relative)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_month_start;
	_tmp1_ = g_date_time_add_years (_tmp0_, relative);
	_tmp2_ = _tmp1_;
	date_time_widgets_calendar_model_set_month_start (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
date_time_widgets_calendar_model_compute_ranges (DateTimeWidgetsCalendarModel* self)
{
	GDateTime* month_end = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint dow = 0;
	GDateTime* _tmp2_;
	gint wso = 0;
	GDateWeekday _tmp3_;
	gint offset = 0;
	GDateTime* data_range_first = NULL;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateWeekday _tmp7_;
	GDateTime* data_range_last = NULL;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	UtilDateRange* _tmp11_;
	UtilDateRange* _tmp12_;
	UtilDateRange* _tmp13_;
	GeeList* _tmp14_;
	GeeList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GDateTime* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GDateTime* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GDateTime* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_month_start;
	_tmp1_ = g_date_time_add_full (_tmp0_, 0, 1, -1, 0, 0, (gdouble) 0);
	month_end = _tmp1_;
	_tmp2_ = self->priv->_month_start;
	dow = g_date_time_get_day_of_week (_tmp2_);
	_tmp3_ = self->priv->_week_starts_on;
	wso = (gint) _tmp3_;
	offset = 0;
	if (wso < dow) {
		offset = dow - wso;
	} else {
		if (wso > dow) {
			offset = (7 + dow) - wso;
		}
	}
	_tmp4_ = self->priv->_month_start;
	_tmp5_ = g_date_time_add_days (_tmp4_, -offset);
	data_range_first = _tmp5_;
	_tmp6_ = month_end;
	dow = g_date_time_get_day_of_week (_tmp6_);
	_tmp7_ = self->priv->_week_starts_on;
	wso = (gint) (_tmp7_ + 6);
	if (wso > 7) {
		wso = wso - 7;
	}
	offset = 0;
	if (wso < dow) {
		offset = (7 + wso) - dow;
	} else {
		if (wso > dow) {
			offset = wso - dow;
		}
	}
	_tmp8_ = month_end;
	_tmp9_ = g_date_time_add_days (_tmp8_, offset);
	data_range_last = _tmp9_;
	_tmp10_ = data_range_first;
	_tmp11_ = util_date_range_new (_tmp10_, data_range_last);
	_tmp12_ = _tmp11_;
	date_time_widgets_calendar_model_set_data_range (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->_data_range;
	_tmp14_ = util_date_range_to_list (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	date_time_widgets_calendar_model_set_num_weeks (self, _tmp17_ / 7);
	_g_object_unref0 (_tmp15_);
	_tmp18_ = data_range_first;
	_tmp19_ = g_date_time_to_string (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->_month_start;
	_tmp22_ = g_date_time_to_string (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = month_end;
	_tmp25_ = g_date_time_to_string (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_date_time_to_string (data_range_last);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("Date ranges: (", _tmp20_, " <= ", _tmp23_, " < ", _tmp26_, " <= ", _tmp28_, ")", NULL);
	_tmp30_ = _tmp29_;
	g_debug ("CalendarModel.vala:212: %s", _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_date_time_unref0 (data_range_last);
	_g_date_time_unref0 (data_range_first);
	_g_date_time_unref0 (month_end);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->client);
		_g_object_unref0 (_data2_->source);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda13_ (Block2Data* _data2_,
             GSList* objects)
{
	DateTimeWidgetsCalendarModel* self;
	self = _data2_->self;
	date_time_widgets_calendar_model_on_objects_added (self, _data2_->source, _data2_->client, objects);
}

static void
___lambda13__e_cal_client_view_objects_added (ECalClientView* _sender,
                                              GSList* objects,
                                              gpointer self)
{
	__lambda13_ (self, objects);
}

static void
__lambda16_ (Block2Data* _data2_,
             GSList* objects)
{
	DateTimeWidgetsCalendarModel* self;
	self = _data2_->self;
	date_time_widgets_calendar_model_on_objects_removed (self, _data2_->source, _data2_->client, objects);
}

static void
___lambda16__e_cal_client_view_objects_removed (ECalClientView* _sender,
                                                GSList* uids,
                                                gpointer self)
{
	__lambda16_ (self, uids);
}

static void
__lambda18_ (Block2Data* _data2_,
             GSList* objects)
{
	DateTimeWidgetsCalendarModel* self;
	self = _data2_->self;
	date_time_widgets_calendar_model_on_objects_modified (self, _data2_->source, _data2_->client, objects);
}

static void
___lambda18__e_cal_client_view_objects_modified (ECalClientView* _sender,
                                                 GSList* objects,
                                                 gpointer self)
{
	__lambda18_ (self, objects);
}

static void
__lambda12_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* results)
{
	DateTimeWidgetsCalendarModel* self;
	ECalClientView* view = NULL;
	ECalClientView* _tmp0_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	ECalClientView* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (results != NULL);
	_tmp0_ = date_time_widgets_calendar_model_on_client_view_received (self, results, _data2_->source, _data2_->client);
	view = _tmp0_;
	g_signal_connect_data (view, "objects-added", (GCallback) ___lambda13__e_cal_client_view_objects_added, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data (view, "objects-removed", (GCallback) ___lambda16__e_cal_client_view_objects_removed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data (view, "objects-modified", (GCallback) ___lambda18__e_cal_client_view_objects_modified, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	{
		e_cal_client_view_start (view, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("CalendarModel.vala:249: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->source_view;
	_tmp4_ = e_source_dup_uid (_data2_->source);
	_tmp5_ = _g_object_ref0 (view);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_g_object_unref0 (view);
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ (self, source_object, res);
	block2_data_unref (self);
}

static void
date_time_widgets_calendar_model_load_source (DateTimeWidgetsCalendarModel* self,
                                              ESource* source)
{
	Block2Data* _data2_;
	ESource* _tmp0_;
	GeeTreeMultiMap* components = NULL;
	GCompareFunc _tmp1_;
	GeeTreeMultiMap* _tmp2_;
	GHashTable* _tmp3_;
	ESource* _tmp4_;
	GeeTreeMultiMap* _tmp5_;
	GeeTreeMultiMap* _tmp6_;
	gchar* iso_first = NULL;
	UtilDateRange* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* iso_last = NULL;
	UtilDateRange* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* query = NULL;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	ECalClientSourceType _tmp23_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data2_->source);
	_data2_->source = _tmp0_;
	_tmp1_ = ((GCompareFunc) g_strcmp0);
	_tmp2_ = gee_tree_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GCompareDataFunc) _tmp1_, NULL, NULL, (GCompareDataFunc) util_calcomponent_compare_func, NULL, NULL);
	components = _tmp2_;
	_tmp3_ = self->priv->_source_components;
	_tmp4_ = _g_object_ref0 (_data2_->source);
	_tmp5_ = components;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp6_);
	_tmp7_ = self->priv->_data_range;
	_tmp8_ = util_date_range_get_first_dt (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = isodate_from_time_t ((time_t) g_date_time_to_unix (_tmp9_));
	iso_first = _tmp10_;
	_tmp11_ = self->priv->_data_range;
	_tmp12_ = util_date_range_get_last_dt (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_date_time_add_days (_tmp13_, 1);
	_tmp15_ = _tmp14_;
	_tmp16_ = isodate_from_time_t ((time_t) g_date_time_to_unix (_tmp15_));
	_tmp17_ = _tmp16_;
	_g_date_time_unref0 (_tmp15_);
	iso_last = _tmp17_;
	_tmp18_ = iso_first;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = iso_last;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("(occur-in-time-range? (make-time \"", _tmp19_, "\") (make-time \"", _tmp21_, "\"))", NULL);
	query = _tmp22_;
	_tmp23_ = self->priv->_source_type;
	if (_tmp23_ == E_CAL_CLIENT_SOURCE_TYPE_TASKS) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = iso_first;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = iso_last;
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = g_strconcat ("AND (NOT is-completed?) (due-in-time-range? (make-time \"", _tmp25_, "\") (make-time \"", _tmp27_, "\"))", NULL);
		_g_free0 (query);
		query = _tmp28_;
	}
	{
		GHashTable* _tmp29_;
		_tmp29_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gconstpointer _tmp33_;
			ECalClient* _tmp34_;
			_tmp30_ = self->priv->source_client;
			_tmp31_ = e_source_dup_uid (_data2_->source);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_hash_table_lookup (_tmp30_, _tmp32_);
			_tmp34_ = _g_object_ref0 ((ECalClient*) _tmp33_);
			_g_object_unref0 (_data2_->client);
			_data2_->client = _tmp34_;
			_g_free0 (_tmp32_);
		}
		__finally0:
		{
			GHashTable* _tmp35_;
			_tmp35_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (query);
			_g_free0 (iso_last);
			_g_free0 (iso_first);
			_g_object_unref0 (components);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (_data2_->client == NULL) {
		_g_free0 (query);
		_g_free0 (iso_last);
		_g_free0 (iso_first);
		_g_object_unref0 (components);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp36_ = e_source_dup_display_name (_data2_->source);
	_tmp37_ = _tmp36_;
	g_debug ("CalendarModel.vala:240: Getting client-view for source '%s'", _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = query;
	e_cal_client_get_view (_data2_->client, _tmp38_, NULL, ___lambda12__gasync_ready_callback, block2_data_ref (_data2_));
	_g_free0 (query);
	_g_free0 (iso_last);
	_g_free0 (iso_first);
	_g_object_unref0 (components);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
date_time_widgets_calendar_model_add_source_async_data_free (gpointer _data)
{
	DateTimeWidgetsCalendarModelAddSourceAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DateTimeWidgetsCalendarModelAddSourceAsyncData, _data_);
}

static void
date_time_widgets_calendar_model_add_source_async (DateTimeWidgetsCalendarModel* self,
                                                   ESource* source,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	DateTimeWidgetsCalendarModelAddSourceAsyncData* _data_;
	DateTimeWidgetsCalendarModel* _tmp0_;
	ESource* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (DateTimeWidgetsCalendarModelAddSourceAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, date_time_widgets_calendar_model_add_source_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	date_time_widgets_calendar_model_add_source_async_co (_data_);
}

static void
date_time_widgets_calendar_model_add_source_finish (DateTimeWidgetsCalendarModel* self,
                                                    GAsyncResult* _res_)
{
	DateTimeWidgetsCalendarModelAddSourceAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->source);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda11_ (Block3Data* _data3_)
{
	DateTimeWidgetsCalendarModel* self;
	gboolean result;
	self = _data3_->self;
	date_time_widgets_calendar_model_load_source (self, _data3_->source);
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
	return result;
}

static gboolean
date_time_widgets_calendar_model_add_source_async_co (DateTimeWidgetsCalendarModelAddSourceAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data3_->source);
	_data_->_data3_->source = _data_->source;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->self->priv->_source_type;
	if (_data_->_tmp2_ == E_CAL_CLIENT_SOURCE_TYPE_TASKS) {
		_data_->_tmp1_ = !e_source_has_extension (_data_->_data3_->source, E_SOURCE_EXTENSION_TASK_LIST);
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_source_type;
		if (_data_->_tmp4_ == E_CAL_CLIENT_SOURCE_TYPE_EVENTS) {
			_data_->_tmp3_ = !e_source_has_extension (_data_->_data3_->source, E_SOURCE_EXTENSION_CALENDAR);
		} else {
			_data_->_tmp3_ = FALSE;
		}
		_data_->_tmp0_ = _data_->_tmp3_;
	}
	if (_data_->_tmp0_) {
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = e_source_dup_display_name (_data_->_data3_->source);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("CalendarModel.vala:262: Adding source '%s'", _data_->_tmp6_);
	_g_free0 (_data_->_tmp6_);
	{
		_data_->_tmp8_ = _data_->self->priv->_source_type;
		_data_->_tmp9_ = e_cal_client_connect_sync (_data_->_data3_->source, _data_->_tmp8_, (guint32) -1, NULL, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, e_cal_client_get_type (), ECalClient));
		_data_->client = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->self->priv->source_client;
		_data_->_tmp12_ = e_source_dup_uid (_data_->_data3_->source);
		_data_->_tmp13_ = _data_->client;
		_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
		g_hash_table_insert (_data_->_tmp11_, _data_->_tmp12_, _data_->_tmp14_);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_critical ("CalendarModel.vala:267: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
date_time_widgets_calendar_model_debug_component (DateTimeWidgetsCalendarModel* self,
                                                  ESource* source,
                                                  ECalComponent* component)
{
	ICalComponent* comp = NULL;
	ICalComponent* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (component != NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (component);
	comp = _tmp0_;
	_tmp1_ = i_cal_component_get_summary (comp);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = e_source_dup_display_name (source);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = i_cal_component_get_uid (comp);
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("Component ['", _tmp2_, "', ", _tmp5_, ", ", _tmp7_, ")]", NULL);
	_tmp9_ = _tmp8_;
	g_debug ("CalendarModel.vala:279: %s", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
}

static void
date_time_widgets_calendar_model_on_parameter_changed (DateTimeWidgetsCalendarModel* self)
{
	g_return_if_fail (self != NULL);
	date_time_widgets_calendar_model_compute_ranges (self);
	date_time_widgets_calendar_model_load_all_sources (self);
}

static ECalClientView*
date_time_widgets_calendar_model_on_client_view_received (DateTimeWidgetsCalendarModel* self,
                                                          GAsyncResult* results,
                                                          ESource* source,
                                                          ECalClient* client)
{
	ECalClientView* view = NULL;
	GError* _inner_error0_ = NULL;
	ECalClientView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (results != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (client != NULL, NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean status = FALSE;
		ECalClientView* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp0_ = e_source_dup_display_name (source);
		_tmp1_ = _tmp0_;
		g_debug ("CalendarModel.vala:291: Received client-view for source '%s'", _tmp1_);
		_g_free0 (_tmp1_);
		_tmp3_ = e_cal_client_get_view_finish (client, results, &_tmp2_, &_inner_error0_);
		_g_object_unref0 (view);
		view = _tmp2_;
		status = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_vala_assert (status == TRUE, "status == true");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e_source_dup_display_name (source);
		_tmp5_ = _tmp4_;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("CalendarModel.vala:295: Error loading client-view from source '%s': %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = view;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->added_components);
		_g_object_unref0 (_data4_->components);
		_g_object_unref0 (_data4_->source);
		_g_object_unref0 (_data4_->client);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data5_->_data4_->self;
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda15_ (Block5Data* _data5_,
             ICalComponent* comp,
             ICalTime* start,
             ICalTime* end,
             GError** error)
{
	Block4Data* _data4_;
	DateTimeWidgetsCalendarModel* self;
	ECalComponent* component = NULL;
	ICalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (comp != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (end != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (comp);
	_tmp1_ = e_cal_component_new_from_icalcomponent (_tmp0_);
	component = _tmp1_;
	date_time_widgets_calendar_model_debug_component (self, _data4_->source, component);
	gee_multi_map_set ((GeeMultiMap*) _data4_->components, _data5_->uid, component);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data4_->added_components, component);
	result = TRUE;
	_g_object_unref0 (component);
	return result;
}

static gboolean
___lambda15__ecal_recur_instance_cb (ICalComponent* icomp,
                                     ICalTime* instance_start,
                                     ICalTime* instance_end,
                                     gpointer self,
                                     GCancellable* cancellable,
                                     GError** error)
{
	gboolean result;
	result = __lambda15_ (self, icomp, instance_start, instance_end, error);
	return result;
}

static void
__lambda14_ (Block4Data* _data4_,
             ICalComponent* comp)
{
	DateTimeWidgetsCalendarModel* self;
	Block5Data* _data5_;
	const gchar* _tmp0_;
	UtilDateRange* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	UtilDateRange* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	self = _data4_->self;
	g_return_if_fail (comp != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->_data4_ = block4_data_ref (_data4_);
	_tmp0_ = i_cal_component_get_uid (comp);
	_data5_->uid = _tmp0_;
	_tmp1_ = self->priv->_data_range;
	_tmp2_ = util_date_range_get_first_dt (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_data_range;
	_tmp5_ = util_date_range_get_last_dt (_tmp4_);
	_tmp6_ = _tmp5_;
	e_cal_client_generate_instances_for_object_sync (_data4_->client, comp, (time_t) g_date_time_to_unix (_tmp3_), (time_t) g_date_time_to_unix (_tmp6_), NULL, ___lambda15__ecal_recur_instance_cb, _data5_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
___lambda14__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda14_ (self, (ICalComponent*) data);
}

static void
date_time_widgets_calendar_model_on_objects_added (DateTimeWidgetsCalendarModel* self,
                                                   ESource* source,
                                                   ECalClient* client,
                                                   GSList* objects)
{
	Block4Data* _data4_;
	ESource* _tmp0_;
	ECalClient* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	gconstpointer _tmp9_;
	GeeTreeMultiMap* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirList* _tmp13_;
	GeeBidirList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data4_->source);
	_data4_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (client);
	_g_object_unref0 (_data4_->client);
	_data4_->client = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u", g_slist_length (objects));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Received ", _tmp3_, " added component(s) for source '%s'", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_source_dup_display_name (_data4_->source);
	_tmp7_ = _tmp6_;
	g_debug (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp8_ = self->priv->_source_components;
	_tmp9_ = g_hash_table_lookup (_tmp8_, _data4_->source);
	_tmp10_ = _g_object_ref0 ((GeeTreeMultiMap*) _tmp9_);
	_data4_->components = _tmp10_;
	_tmp11_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) util_calcomponent_equal_func, NULL, NULL);
	_data4_->added_components = _tmp11_;
	g_slist_foreach (objects, ___lambda14__gfunc, _data4_);
	_tmp12_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data4_->added_components);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	g_signal_emit (self, date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_ADDED_SIGNAL], 0, _data4_->source, (GeeCollection*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->updated_components);
		_g_object_unref0 (_data6_->source);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda19_ (Block6Data* _data6_,
             ICalComponent* comp)
{
	DateTimeWidgetsCalendarModel* self;
	const gchar* uid = NULL;
	const gchar* _tmp0_;
	GeeCollection* components = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	self = _data6_->self;
	g_return_if_fail (comp != NULL);
	_tmp0_ = i_cal_component_get_uid (comp);
	uid = _tmp0_;
	_tmp1_ = self->priv->_source_components;
	_tmp2_ = g_hash_table_lookup (_tmp1_, _data6_->source);
	_tmp3_ = uid;
	_tmp4_ = gee_multi_map_get ((GeeMultiMap*) ((GeeTreeMultiMap*) _tmp2_), _tmp3_);
	components = _tmp4_;
	_tmp5_ = components;
	gee_array_list_add_all (_data6_->updated_components, _tmp5_);
	{
		GeeIterator* _component_it = NULL;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp6_ = components;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_component_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			ECalComponent* component = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			ECalComponent* _tmp11_;
			_tmp8_ = _component_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _component_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			component = (ECalComponent*) _tmp10_;
			_tmp11_ = component;
			date_time_widgets_calendar_model_debug_component (self, _data6_->source, _tmp11_);
			_g_object_unref0 (component);
		}
		_g_object_unref0 (_component_it);
	}
	_g_object_unref0 (components);
}

static void
___lambda19__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda19_ (self, (ICalComponent*) data);
}

static void
date_time_widgets_calendar_model_on_objects_modified (DateTimeWidgetsCalendarModel* self,
                                                      ESource* source,
                                                      ECalClient* client,
                                                      GSList* objects)
{
	Block6Data* _data6_;
	ESource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeBidirList* _tmp8_;
	GeeBidirList* _tmp9_;
	GeeBidirList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data6_->source);
	_data6_->source = _tmp0_;
	_tmp1_ = g_strdup_printf ("%u", g_slist_length (objects));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Received ", _tmp2_, " modified component(s) for source '%s'", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = e_source_dup_display_name (_data6_->source);
	_tmp6_ = _tmp5_;
	g_debug (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) util_calcomponent_equal_func, NULL, NULL);
	_data6_->updated_components = _tmp7_;
	g_slist_foreach (objects, ___lambda19__gfunc, _data6_);
	_tmp8_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data6_->updated_components);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	g_signal_emit (self, date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_UPDATED_SIGNAL], 0, _data6_->source, (GeeCollection*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		DateTimeWidgetsCalendarModel* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->removed_components);
		_g_object_unref0 (_data7_->components);
		_g_object_unref0 (_data7_->source);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda17_ (Block7Data* _data7_,
             ECalComponentId* cid)
{
	DateTimeWidgetsCalendarModel* self;
	GeeCollection* comps = NULL;
	const gchar* _tmp0_;
	GeeCollection* _tmp1_;
	self = _data7_->self;
	if (cid == NULL) {
		return;
	}
	_tmp0_ = e_cal_component_id_get_uid (cid);
	_tmp1_ = gee_multi_map_get ((GeeMultiMap*) _data7_->components, _tmp0_);
	comps = _tmp1_;
	{
		GeeIterator* _component_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = comps;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_component_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			ECalComponent* component = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			ECalComponent* _tmp7_;
			ECalComponent* _tmp8_;
			_tmp4_ = _component_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _component_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			component = (ECalComponent*) _tmp6_;
			_tmp7_ = component;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->removed_components, _tmp7_);
			_tmp8_ = component;
			date_time_widgets_calendar_model_debug_component (self, _data7_->source, _tmp8_);
			_g_object_unref0 (component);
		}
		_g_object_unref0 (_component_it);
	}
	_g_object_unref0 (comps);
}

static void
___lambda17__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda17_ (self, (ECalComponentId*) data);
}

static void
date_time_widgets_calendar_model_on_objects_removed (DateTimeWidgetsCalendarModel* self,
                                                     ESource* source,
                                                     ECalClient* client,
                                                     GSList* cids)
{
	Block7Data* _data7_;
	ESource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_;
	GeeTreeMultiMap* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeBidirList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data7_->source);
	_data7_->source = _tmp0_;
	_tmp1_ = g_strdup_printf ("%u", g_slist_length (cids));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Received ", _tmp2_, " removed component(s) for source '%s'", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = e_source_dup_display_name (_data7_->source);
	_tmp6_ = _tmp5_;
	g_debug (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->_source_components;
	_tmp8_ = g_hash_table_lookup (_tmp7_, _data7_->source);
	_tmp9_ = _g_object_ref0 ((GeeTreeMultiMap*) _tmp8_);
	_data7_->components = _tmp9_;
	_tmp10_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) util_calcomponent_equal_func, NULL, NULL);
	_data7_->removed_components = _tmp10_;
	g_slist_foreach (cids, ___lambda17__gfunc, _data7_);
	_tmp11_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data7_->removed_components);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	g_signal_emit (self, date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_REMOVED_SIGNAL], 0, _data7_->source, (GeeCollection*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

UtilDateRange*
date_time_widgets_calendar_model_get_data_range (DateTimeWidgetsCalendarModel* self)
{
	UtilDateRange* result;
	UtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_range;
	result = _tmp0_;
	return result;
}

static void
date_time_widgets_calendar_model_set_data_range (DateTimeWidgetsCalendarModel* self,
                                                 UtilDateRange* value)
{
	UtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_data_range (self);
	if (old_value != value) {
		UtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_range);
		self->priv->_data_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY]);
	}
}

GDateTime*
date_time_widgets_calendar_model_get_month_start (DateTimeWidgetsCalendarModel* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_month_start;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
date_time_widgets_calendar_model_set_month_start (DateTimeWidgetsCalendarModel* self,
                                                  GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_month_start (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_month_start);
		self->priv->_month_start = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY]);
	}
}

gint
date_time_widgets_calendar_model_get_num_weeks (DateTimeWidgetsCalendarModel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num_weeks;
	return result;
}

static void
date_time_widgets_calendar_model_set_num_weeks (DateTimeWidgetsCalendarModel* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_num_weeks (self);
	if (old_value != value) {
		self->priv->_num_weeks = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY]);
	}
}

GDateWeekday
date_time_widgets_calendar_model_get_week_starts_on (DateTimeWidgetsCalendarModel* self)
{
	GDateWeekday result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_week_starts_on;
	return result;
}

void
date_time_widgets_calendar_model_set_week_starts_on (DateTimeWidgetsCalendarModel* self,
                                                     GDateWeekday value)
{
	GDateWeekday old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_week_starts_on (self);
	if (old_value != value) {
		self->priv->_week_starts_on = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY]);
	}
}

GHashTable*
date_time_widgets_calendar_model_get_source_components (DateTimeWidgetsCalendarModel* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_components;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
date_time_widgets_calendar_model_set_source_components (DateTimeWidgetsCalendarModel* self,
                                                        GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_source_components (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_source_components);
		self->priv->_source_components = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY]);
	}
}

static ESourceRegistry*
date_time_widgets_calendar_model_get_registry (DateTimeWidgetsCalendarModel* self)
{
	ESourceRegistry* result;
	ESourceRegistry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_registry;
	result = _tmp0_;
	return result;
}

static void
date_time_widgets_calendar_model_set_registry (DateTimeWidgetsCalendarModel* self,
                                               ESourceRegistry* value)
{
	ESourceRegistry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_registry);
	self->priv->_registry = _tmp0_;
}

ECalClientSourceType
date_time_widgets_calendar_model_get_source_type (DateTimeWidgetsCalendarModel* self)
{
	ECalClientSourceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_source_type;
	return result;
}

static void
date_time_widgets_calendar_model_set_source_type (DateTimeWidgetsCalendarModel* self,
                                                  ECalClientSourceType value)
{
	ECalClientSourceType old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_widgets_calendar_model_get_source_type (self);
	if (old_value != value) {
		self->priv->_source_type = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static guint
_util_source_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = util_source_hash_func ((ESource*) key);
	return result;
}

static gboolean
_util_source_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = util_source_equal_func ((ESource*) a, (ESource*) b);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_date_time_widgets_calendar_model_on_parameter_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self)
{
	date_time_widgets_calendar_model_on_parameter_changed ((DateTimeWidgetsCalendarModel*) self);
}

static GObject *
date_time_widgets_calendar_model_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeWidgetsCalendarModel * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	gint week_start = 0;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8 _tmp12_;
	gboolean _tmp13_ = FALSE;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	parent_class = G_OBJECT_CLASS (date_time_widgets_calendar_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, DateTimeWidgetsCalendarModel);
	date_time_widgets_calendar_model_open (self, NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->source_client);
	self->priv->source_client = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_util_source_hash_func_ghash_func, _util_source_equal_func_gequal_func, _g_object_unref0_, _g_object_unref0_);
	_tmp4_ = _tmp3_;
	date_time_widgets_calendar_model_set_source_components (self, _tmp4_);
	_g_hash_table_unref0 (_tmp4_);
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp7_;
	_tmp8_ = nl_langinfo (_NL_TIME_FIRST_WEEKDAY);
	_tmp9_ = string_get_data (_tmp8_, &_tmp10_);
	_tmp9__length1 = _tmp10_;
	_tmp11_ = _tmp9_;
	_tmp11__length1 = _tmp9__length1;
	_tmp12_ = _tmp11_[0];
	week_start = (gint) _tmp12_;
	if (week_start >= 1) {
		_tmp13_ = week_start <= 7;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		date_time_widgets_calendar_model_set_week_starts_on (self, (GDateWeekday) (week_start - 1));
	}
	_tmp14_ = util_get_start_of_month (NULL);
	_tmp15_ = _tmp14_;
	date_time_widgets_calendar_model_set_month_start (self, _tmp15_);
	_g_date_time_unref0 (_tmp15_);
	date_time_widgets_calendar_model_compute_ranges (self);
	g_signal_connect_object ((GObject*) self, "notify::month-start", (GCallback) _date_time_widgets_calendar_model_on_parameter_changed_g_object_notify, self, 0);
	return obj;
}

static void
date_time_widgets_calendar_model_class_init (DateTimeWidgetsCalendarModelClass * klass,
                                             gpointer klass_data)
{
	date_time_widgets_calendar_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeWidgetsCalendarModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_date_time_widgets_calendar_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_date_time_widgets_calendar_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = date_time_widgets_calendar_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_widgets_calendar_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY] = g_param_spec_object ("data-range", "data-range", "data-range", UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY] = g_param_spec_boxed ("month-start", "month-start", "month-start", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY] = g_param_spec_int ("num-weeks", "num-weeks", "num-weeks", G_MININT, G_MAXINT, 6, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY] = g_param_spec_int ("week-starts-on", "week-starts-on", "week-starts-on", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY] = g_param_spec_boxed ("source-components", "source-components", "source-components", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY, date_time_widgets_calendar_model_properties[DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY] = g_param_spec_enum ("source-type", "source-type", "source-type", e_cal_client_source_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_ADDED_SIGNAL] = g_signal_new ("components-added", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_UPDATED_SIGNAL] = g_signal_new ("components-updated", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	date_time_widgets_calendar_model_signals[DATE_TIME_WIDGETS_CALENDAR_MODEL_COMPONENTS_REMOVED_SIGNAL] = g_signal_new ("components-removed", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	g_rec_mutex_init (&__lock_date_time_widgets_calendar_model_date_time_widgets_calendar_model_calendar_model);
}

static void
date_time_widgets_calendar_model_instance_init (DateTimeWidgetsCalendarModel * self,
                                                gpointer klass)
{
	self->priv = date_time_widgets_calendar_model_get_instance_private (self);
	self->priv->_num_weeks = 6;
	g_rec_mutex_init (&self->priv->__lock_source_client);
}

static void
date_time_widgets_calendar_model_finalize (GObject * obj)
{
	DateTimeWidgetsCalendarModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, DateTimeWidgetsCalendarModel);
	_g_object_unref0 (self->priv->_data_range);
	_g_date_time_unref0 (self->priv->_month_start);
	_g_hash_table_unref0 (self->priv->_source_components);
	_g_object_unref0 (self->priv->_registry);
	g_rec_mutex_clear (&self->priv->__lock_source_client);
	_g_hash_table_unref0 (self->priv->source_client);
	_g_hash_table_unref0 (self->priv->source_view);
	G_OBJECT_CLASS (date_time_widgets_calendar_model_parent_class)->finalize (obj);
}

static GType
date_time_widgets_calendar_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeWidgetsCalendarModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_widgets_calendar_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeWidgetsCalendarModel), 0, (GInstanceInitFunc) date_time_widgets_calendar_model_instance_init, NULL };
	GType date_time_widgets_calendar_model_type_id;
	date_time_widgets_calendar_model_type_id = g_type_register_static (G_TYPE_OBJECT, "DateTimeWidgetsCalendarModel", &g_define_type_info, 0);
	DateTimeWidgetsCalendarModel_private_offset = g_type_add_instance_private (date_time_widgets_calendar_model_type_id, sizeof (DateTimeWidgetsCalendarModelPrivate));
	return date_time_widgets_calendar_model_type_id;
}

GType
date_time_widgets_calendar_model_get_type (void)
{
	static volatile gsize date_time_widgets_calendar_model_type_id__once = 0;
	if (g_once_init_enter (&date_time_widgets_calendar_model_type_id__once)) {
		GType date_time_widgets_calendar_model_type_id;
		date_time_widgets_calendar_model_type_id = date_time_widgets_calendar_model_get_type_once ();
		g_once_init_leave (&date_time_widgets_calendar_model_type_id__once, date_time_widgets_calendar_model_type_id);
	}
	return date_time_widgets_calendar_model_type_id__once;
}

static void
_vala_date_time_widgets_calendar_model_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	DateTimeWidgetsCalendarModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, DateTimeWidgetsCalendarModel);
	switch (property_id) {
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY:
		g_value_set_object (value, date_time_widgets_calendar_model_get_data_range (self));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY:
		g_value_set_boxed (value, date_time_widgets_calendar_model_get_month_start (self));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY:
		g_value_set_int (value, date_time_widgets_calendar_model_get_num_weeks (self));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY:
		g_value_set_int (value, date_time_widgets_calendar_model_get_week_starts_on (self));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY:
		g_value_set_boxed (value, date_time_widgets_calendar_model_get_source_components (self));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY:
		g_value_set_enum (value, date_time_widgets_calendar_model_get_source_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_date_time_widgets_calendar_model_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	DateTimeWidgetsCalendarModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, DateTimeWidgetsCalendarModel);
	switch (property_id) {
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_DATA_RANGE_PROPERTY:
		date_time_widgets_calendar_model_set_data_range (self, g_value_get_object (value));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_MONTH_START_PROPERTY:
		date_time_widgets_calendar_model_set_month_start (self, g_value_get_boxed (value));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_NUM_WEEKS_PROPERTY:
		date_time_widgets_calendar_model_set_num_weeks (self, g_value_get_int (value));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_WEEK_STARTS_ON_PROPERTY:
		date_time_widgets_calendar_model_set_week_starts_on (self, g_value_get_int (value));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_COMPONENTS_PROPERTY:
		date_time_widgets_calendar_model_set_source_components (self, g_value_get_boxed (value));
		break;
		case DATE_TIME_WIDGETS_CALENDAR_MODEL_SOURCE_TYPE_PROPERTY:
		date_time_widgets_calendar_model_set_source_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

