/* ComponentRow.c generated by valac 0.56.16, the Vala compiler
 * generated from ComponentRow.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "datetime.h"
#include <glib.h>
#include <libical-glib/libical-glib.h>
#include <libedataserver/libedataserver.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_COMPONENT_ROW_0_PROPERTY,
	DATE_TIME_COMPONENT_ROW_DATE_PROPERTY,
	DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY,
	DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY,
	DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY,
	DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY,
	DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY,
	DATE_TIME_COMPONENT_ROW_NUM_PROPERTIES
};
static GParamSpec* date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DateTimeComponentRowPrivate {
	GDateTime* _date;
	ICalComponent* _component;
	ESourceSelectable* _source_selectable;
	GDateTime* _start_time;
	GDateTime* _end_time;
	gboolean _is_allday;
	GtkGrid* grid;
	GtkImage* component_image;
	GtkLabel* name_label;
	GtkLabel* time_label;
};

static gint DateTimeComponentRow_private_offset;
static gpointer date_time_component_row_parent_class = NULL;
static DateTimeServicesTimeManager* date_time_component_row_time_manager;
static DateTimeServicesTimeManager* date_time_component_row_time_manager = NULL;
static GtkCssProvider* date_time_component_row_css_provider;
static GtkCssProvider* date_time_component_row_css_provider = NULL;

static void date_time_component_row_update_timelabel (DateTimeComponentRow* self);
static void date_time_component_row_set_color (DateTimeComponentRow* self);
static void date_time_component_row_set_start_time (DateTimeComponentRow* self,
                                             GDateTime* value);
static void date_time_component_row_set_end_time (DateTimeComponentRow* self,
                                           GDateTime* value);
static void date_time_component_row_set_is_allday (DateTimeComponentRow* self,
                                            gboolean value);
static GObject * date_time_component_row_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _date_time_component_row_set_color_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void _date_time_component_row_update_timelabel_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void date_time_component_row_finalize (GObject * obj);
static GType date_time_component_row_get_type_once (void);
static void _vala_date_time_component_row_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_date_time_component_row_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
date_time_component_row_get_instance_private (DateTimeComponentRow* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeComponentRow_private_offset);
}

DateTimeComponentRow*
date_time_component_row_construct (GType object_type,
                                   GDateTime* date,
                                   ICalComponent* component,
                                   ESource* source)
{
	DateTimeComponentRow * self = NULL;
	ESourceSelectable* source_selectable = NULL;
	ESourceSelectable* _tmp2_;
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (component != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	source_selectable = NULL;
	if (e_source_has_extension (source, E_SOURCE_EXTENSION_TASK_LIST)) {
		ESourceExtension* _tmp0_;
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
		source_selectable = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_selectable_get_type (), ESourceSelectable);
	} else {
		ESourceExtension* _tmp1_;
		_tmp1_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		source_selectable = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_selectable_get_type (), ESourceSelectable);
	}
	_tmp2_ = source_selectable;
	self = (DateTimeComponentRow*) g_object_new (object_type, "component", component, "date", date, "source-selectable", _tmp2_, NULL);
	return self;
}

DateTimeComponentRow*
date_time_component_row_new (GDateTime* date,
                             ICalComponent* component,
                             ESource* source)
{
	return date_time_component_row_construct (DATE_TIME_TYPE_COMPONENT_ROW, date, component, source);
}

static void
date_time_component_row_update_timelabel (DateTimeComponentRow* self)
{
	gchar* time_format = NULL;
	DateTimeServicesTimeManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	ESourceSelectable* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = date_time_component_row_time_manager;
	_tmp1_ = date_time_services_time_manager_get_is_12h (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = granite_date_time_get_default_time_format (_tmp2_, FALSE);
	time_format = _tmp3_;
	_tmp4_ = self->priv->_source_selectable;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, e_source_task_list_get_type ())) {
		GtkLabel* _tmp5_;
		GDateTime* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = self->priv->time_label;
		_tmp6_ = self->priv->_start_time;
		_tmp7_ = time_format;
		_tmp8_ = g_date_time_format (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("<small>Due by %s</small>", _tmp9_);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp5_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
		GtkLabel* _tmp12_;
		GDateTime* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GDateTime* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp12_ = self->priv->time_label;
		_tmp13_ = self->priv->_start_time;
		_tmp14_ = time_format;
		_tmp15_ = g_date_time_format (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->_end_time;
		_tmp18_ = time_format;
		_tmp19_ = g_date_time_format (_tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("<small>%s – %s</small>", _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		gtk_label_set_label (_tmp12_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp16_);
	}
	_g_free0 (time_format);
}

static void
date_time_component_row_set_color (DateTimeComponentRow* self)
{
	ESourceSelectable* _tmp0_;
	GtkGrid* _tmp1_;
	ESourceSelectable* _tmp2_;
	GtkImage* _tmp3_;
	ESourceSelectable* _tmp4_;
	GtkLabel* _tmp5_;
	ESourceSelectable* _tmp6_;
	GtkLabel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_selectable;
	_tmp1_ = self->priv->grid;
	util_set_component_calendar_color (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->_source_selectable;
	_tmp3_ = self->priv->component_image;
	util_set_component_calendar_color (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_source_selectable;
	_tmp5_ = self->priv->name_label;
	util_set_component_calendar_color (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_source_selectable;
	_tmp7_ = self->priv->time_label;
	util_set_component_calendar_color (_tmp6_, (GtkWidget*) _tmp7_);
}

GDateTime*
date_time_component_row_get_date (DateTimeComponentRow* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
date_time_component_row_set_date (DateTimeComponentRow* self,
                                  GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_date);
		self->priv->_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_DATE_PROPERTY]);
	}
}

ICalComponent*
date_time_component_row_get_component (DateTimeComponentRow* self)
{
	ICalComponent* result;
	ICalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_component;
	result = _tmp0_;
	return result;
}

static void
date_time_component_row_set_component (DateTimeComponentRow* self,
                                       ICalComponent* value)
{
	ICalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_component (self);
	if (old_value != value) {
		self->priv->_component = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY]);
	}
}

ESourceSelectable*
date_time_component_row_get_source_selectable (DateTimeComponentRow* self)
{
	ESourceSelectable* result;
	ESourceSelectable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_selectable;
	result = _tmp0_;
	return result;
}

static void
date_time_component_row_set_source_selectable (DateTimeComponentRow* self,
                                               ESourceSelectable* value)
{
	ESourceSelectable* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_source_selectable (self);
	if (old_value != value) {
		self->priv->_source_selectable = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY]);
	}
}

GDateTime*
date_time_component_row_get_start_time (DateTimeComponentRow* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start_time;
	result = _tmp0_;
	return result;
}

static void
date_time_component_row_set_start_time (DateTimeComponentRow* self,
                                        GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_start_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_start_time);
		self->priv->_start_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY]);
	}
}

GDateTime*
date_time_component_row_get_end_time (DateTimeComponentRow* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_end_time;
	result = _tmp0_;
	return result;
}

static void
date_time_component_row_set_end_time (DateTimeComponentRow* self,
                                      GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_end_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_end_time);
		self->priv->_end_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY]);
	}
}

gboolean
date_time_component_row_get_is_allday (DateTimeComponentRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_allday;
	return result;
}

static void
date_time_component_row_set_is_allday (DateTimeComponentRow* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = date_time_component_row_get_is_allday (self);
	if (old_value != value) {
		self->priv->_is_allday = value;
		g_object_notify_by_pspec ((GObject *) self, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_date_time_component_row_set_color_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	date_time_component_row_set_color ((DateTimeComponentRow*) self);
}

static void
_date_time_component_row_update_timelabel_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	date_time_component_row_update_timelabel ((DateTimeComponentRow*) self);
}

static GObject *
date_time_component_row_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeComponentRow * self;
	ICalTime* dt_start = NULL;
	ICalComponent* _tmp0_;
	ICalTime* _tmp1_;
	ICalTime* _tmp2_;
	ESourceSelectable* _tmp11_;
	gchar* icon_name = NULL;
	gchar* _tmp27_;
	ESourceSelectable* _tmp28_;
	const gchar* _tmp32_;
	GtkImage* _tmp33_ = NULL;
	GtkStyleContext* component_image_context = NULL;
	GtkImage* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkStyleContext* _tmp36_;
	GtkCssProvider* _tmp37_;
	ICalComponent* _tmp38_;
	const gchar* _tmp39_;
	GtkLabel* _tmp40_ = NULL;
	GtkStyleContext* name_label_context = NULL;
	GtkLabel* _tmp41_;
	GtkStyleContext* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkStyleContext* _tmp44_;
	GtkStyleContext* _tmp45_;
	GtkCssProvider* _tmp46_;
	GtkLabel* _tmp47_ = NULL;
	GtkLabel* _tmp48_;
	GtkStyleContext* _tmp49_;
	GtkGrid* _tmp50_ = NULL;
	GtkGrid* _tmp51_;
	GtkImage* _tmp52_;
	GtkGrid* _tmp53_;
	GtkLabel* _tmp54_;
	gboolean _tmp55_;
	GtkStyleContext* grid_context = NULL;
	GtkGrid* _tmp58_;
	GtkStyleContext* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkStyleContext* _tmp61_;
	GtkCssProvider* _tmp62_;
	GtkGrid* _tmp63_;
	ESourceSelectable* _tmp64_;
	DateTimeServicesTimeManager* _tmp65_;
	parent_class = G_OBJECT_CLASS (date_time_component_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow);
	_tmp0_ = self->priv->_component;
	_tmp1_ = i_cal_component_get_dtstart (_tmp0_);
	dt_start = _tmp1_;
	_tmp2_ = dt_start;
	if (i_cal_time_is_date (_tmp2_)) {
		ICalTime* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp3_ = dt_start;
		_tmp4_ = util_ical_to_date_time (_tmp3_);
		_tmp5_ = _tmp4_;
		date_time_component_row_set_start_time (self, _tmp5_);
		_g_date_time_unref0 (_tmp5_);
	} else {
		ICalTime* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		_tmp6_ = dt_start;
		_tmp7_ = util_ical_to_date_time (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_to_local (_tmp8_);
		_tmp10_ = _tmp9_;
		date_time_component_row_set_start_time (self, _tmp10_);
		_g_date_time_unref0 (_tmp10_);
		_g_date_time_unref0 (_tmp8_);
	}
	_tmp11_ = self->priv->_source_selectable;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, e_source_task_list_get_type ())) {
		ICalTime* dt_end = NULL;
		ICalComponent* _tmp12_;
		ICalTime* _tmp13_;
		ICalTime* _tmp14_;
		gboolean _tmp23_ = FALSE;
		GDateTime* _tmp24_;
		_tmp12_ = self->priv->_component;
		_tmp13_ = i_cal_component_get_dtend (_tmp12_);
		dt_end = _tmp13_;
		_tmp14_ = dt_end;
		if (i_cal_time_is_date (_tmp14_)) {
			ICalTime* _tmp15_;
			GDateTime* _tmp16_;
			GDateTime* _tmp17_;
			_tmp15_ = dt_end;
			_tmp16_ = util_ical_to_date_time (_tmp15_);
			_tmp17_ = _tmp16_;
			date_time_component_row_set_end_time (self, _tmp17_);
			_g_date_time_unref0 (_tmp17_);
		} else {
			ICalTime* _tmp18_;
			GDateTime* _tmp19_;
			GDateTime* _tmp20_;
			GDateTime* _tmp21_;
			GDateTime* _tmp22_;
			_tmp18_ = dt_end;
			_tmp19_ = util_ical_to_date_time (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_date_time_to_local (_tmp20_);
			_tmp22_ = _tmp21_;
			date_time_component_row_set_end_time (self, _tmp22_);
			_g_date_time_unref0 (_tmp22_);
			_g_date_time_unref0 (_tmp20_);
		}
		_tmp24_ = self->priv->_end_time;
		if (_tmp24_ != NULL) {
			GDateTime* _tmp25_;
			GDateTime* _tmp26_;
			_tmp25_ = self->priv->_start_time;
			_tmp26_ = self->priv->_end_time;
			_tmp23_ = util_is_the_all_day (_tmp25_, _tmp26_);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			date_time_component_row_set_is_allday (self, TRUE);
		}
		_g_object_unref0 (dt_end);
	}
	_tmp27_ = g_strdup ("office-calendar-symbolic");
	icon_name = _tmp27_;
	_tmp28_ = self->priv->_source_selectable;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, e_source_task_list_get_type ())) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup ("office-task-symbolic");
		_g_free0 (icon_name);
		icon_name = _tmp29_;
	} else {
		GDateTime* _tmp30_;
		_tmp30_ = self->priv->_end_time;
		if (_tmp30_ == NULL) {
			gchar* _tmp31_;
			_tmp31_ = g_strdup ("alarm-symbolic");
			_g_free0 (icon_name);
			icon_name = _tmp31_;
		}
	}
	_tmp32_ = icon_name;
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp32_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->component_image);
	self->priv->component_image = _tmp33_;
	_tmp34_ = self->priv->component_image;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	component_image_context = _tmp35_;
	_tmp36_ = component_image_context;
	_tmp37_ = date_time_component_row_css_provider;
	gtk_style_context_add_provider (_tmp36_, (GtkStyleProvider*) _tmp37_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp38_ = self->priv->_component;
	_tmp39_ = i_cal_component_get_summary (_tmp38_);
	_tmp40_ = (GtkLabel*) gtk_label_new (_tmp39_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	gtk_label_set_ellipsize (_tmp40_, PANGO_ELLIPSIZE_END);
	gtk_label_set_lines (_tmp40_, 3);
	gtk_label_set_max_width_chars (_tmp40_, 30);
	g_object_set (_tmp40_, "wrap", TRUE, NULL);
	g_object_set (_tmp40_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_xalign (_tmp40_, (gfloat) 0);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp40_;
	_tmp41_ = self->priv->name_label;
	_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) _tmp41_);
	_tmp43_ = _g_object_ref0 (_tmp42_);
	name_label_context = _tmp43_;
	_tmp44_ = name_label_context;
	gtk_style_context_add_class (_tmp44_, "title");
	_tmp45_ = name_label_context;
	_tmp46_ = date_time_component_row_css_provider;
	gtk_style_context_add_provider (_tmp45_, (GtkStyleProvider*) _tmp46_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp47_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_use_markup (_tmp47_, TRUE);
	gtk_label_set_xalign (_tmp47_, (gfloat) 0);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->time_label);
	self->priv->time_label = _tmp47_;
	_tmp48_ = self->priv->time_label;
	_tmp49_ = gtk_widget_get_style_context ((GtkWidget*) _tmp48_);
	gtk_style_context_add_class (_tmp49_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp50_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp50_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp50_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp50_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp50_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp50_, 6);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp50_;
	_tmp51_ = self->priv->grid;
	_tmp52_ = self->priv->component_image;
	gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, 0, 0, 1, 1);
	_tmp53_ = self->priv->grid;
	_tmp54_ = self->priv->name_label;
	gtk_grid_attach (_tmp53_, (GtkWidget*) _tmp54_, 1, 0, 1, 1);
	_tmp55_ = self->priv->_is_allday;
	if (!_tmp55_) {
		GtkGrid* _tmp56_;
		GtkLabel* _tmp57_;
		_tmp56_ = self->priv->grid;
		_tmp57_ = self->priv->time_label;
		gtk_grid_attach (_tmp56_, (GtkWidget*) _tmp57_, 1, 1, 1, 1);
	}
	_tmp58_ = self->priv->grid;
	_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
	grid_context = _tmp59_;
	_tmp60_ = grid_context;
	gtk_style_context_add_class (_tmp60_, "event");
	_tmp61_ = grid_context;
	_tmp62_ = date_time_component_row_css_provider;
	gtk_style_context_add_provider (_tmp61_, (GtkStyleProvider*) _tmp62_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp63_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp63_);
	date_time_component_row_set_color (self);
	_tmp64_ = self->priv->_source_selectable;
	g_signal_connect_object ((GObject*) _tmp64_, "notify::color", (GCallback) _date_time_component_row_set_color_g_object_notify, self, 0);
	date_time_component_row_update_timelabel (self);
	_tmp65_ = date_time_component_row_time_manager;
	g_signal_connect_object ((GObject*) _tmp65_, "notify::is-12h", (GCallback) _date_time_component_row_update_timelabel_g_object_notify, self, 0);
	_g_object_unref0 (name_label_context);
	_g_free0 (icon_name);
	_g_object_unref0 (dt_start);
	return obj;
}

static void
date_time_component_row_class_init (DateTimeComponentRowClass * klass,
                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	DateTimeServicesTimeManager* _tmp2_;
	date_time_component_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeComponentRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_date_time_component_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_date_time_component_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = date_time_component_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_component_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_DATE_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_DATE_PROPERTY] = g_param_spec_boxed ("date", "date", "date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY] = g_param_spec_object ("component", "component", "component", i_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY] = g_param_spec_object ("source-selectable", "source-selectable", "source-selectable", e_source_selectable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY] = g_param_spec_boxed ("start-time", "start-time", "start-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY] = g_param_spec_boxed ("end-time", "end-time", "end-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY, date_time_component_row_properties[DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY] = g_param_spec_boolean ("is-allday", "is-allday", "is-allday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (date_time_component_row_css_provider);
	date_time_component_row_css_provider = _tmp0_;
	_tmp1_ = date_time_component_row_css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/desktop/wingpanel/datetime/EventRow.css");
	_tmp2_ = date_time_services_time_manager_get_default ();
	_g_object_unref0 (date_time_component_row_time_manager);
	date_time_component_row_time_manager = _tmp2_;
}

static void
date_time_component_row_instance_init (DateTimeComponentRow * self,
                                       gpointer klass)
{
	self->priv = date_time_component_row_get_instance_private (self);
	self->priv->_is_allday = FALSE;
}

static void
date_time_component_row_finalize (GObject * obj)
{
	DateTimeComponentRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow);
	_g_date_time_unref0 (self->priv->_date);
	_g_date_time_unref0 (self->priv->_start_time);
	_g_date_time_unref0 (self->priv->_end_time);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->component_image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->time_label);
	G_OBJECT_CLASS (date_time_component_row_parent_class)->finalize (obj);
}

static GType
date_time_component_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeComponentRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_component_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeComponentRow), 0, (GInstanceInitFunc) date_time_component_row_instance_init, NULL };
	GType date_time_component_row_type_id;
	date_time_component_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "DateTimeComponentRow", &g_define_type_info, 0);
	DateTimeComponentRow_private_offset = g_type_add_instance_private (date_time_component_row_type_id, sizeof (DateTimeComponentRowPrivate));
	return date_time_component_row_type_id;
}

GType
date_time_component_row_get_type (void)
{
	static volatile gsize date_time_component_row_type_id__once = 0;
	if (g_once_init_enter (&date_time_component_row_type_id__once)) {
		GType date_time_component_row_type_id;
		date_time_component_row_type_id = date_time_component_row_get_type_once ();
		g_once_init_leave (&date_time_component_row_type_id__once, date_time_component_row_type_id);
	}
	return date_time_component_row_type_id__once;
}

static void
_vala_date_time_component_row_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DateTimeComponentRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow);
	switch (property_id) {
		case DATE_TIME_COMPONENT_ROW_DATE_PROPERTY:
		g_value_set_boxed (value, date_time_component_row_get_date (self));
		break;
		case DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY:
		g_value_set_object (value, date_time_component_row_get_component (self));
		break;
		case DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY:
		g_value_set_object (value, date_time_component_row_get_source_selectable (self));
		break;
		case DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY:
		g_value_set_boxed (value, date_time_component_row_get_start_time (self));
		break;
		case DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY:
		g_value_set_boxed (value, date_time_component_row_get_end_time (self));
		break;
		case DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY:
		g_value_set_boolean (value, date_time_component_row_get_is_allday (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_date_time_component_row_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DateTimeComponentRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow);
	switch (property_id) {
		case DATE_TIME_COMPONENT_ROW_DATE_PROPERTY:
		date_time_component_row_set_date (self, g_value_get_boxed (value));
		break;
		case DATE_TIME_COMPONENT_ROW_COMPONENT_PROPERTY:
		date_time_component_row_set_component (self, g_value_get_object (value));
		break;
		case DATE_TIME_COMPONENT_ROW_SOURCE_SELECTABLE_PROPERTY:
		date_time_component_row_set_source_selectable (self, g_value_get_object (value));
		break;
		case DATE_TIME_COMPONENT_ROW_START_TIME_PROPERTY:
		date_time_component_row_set_start_time (self, g_value_get_boxed (value));
		break;
		case DATE_TIME_COMPONENT_ROW_END_TIME_PROPERTY:
		date_time_component_row_set_end_time (self, g_value_get_boxed (value));
		break;
		case DATE_TIME_COMPONENT_ROW_IS_ALLDAY_PROPERTY:
		date_time_component_row_set_is_allday (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

