/* Indicator.c generated by valac 0.56.16, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright (c) 2011-2016 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "datetime.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <wingpanel.h>
#include <libical-glib/libical-glib.h>
#include <glib-object.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <libedataserver/libedataserver.h>
#include <gio/gdesktopappinfo.h>
#include <gee.h>
#include <libecal/libecal.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_INDICATOR_0_PROPERTY,
	DATE_TIME_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* date_time_indicator_properties[DATE_TIME_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _DateTimeIndicatorPrivate {
	DateTimeWidgetsPanelLabel* panel_label;
	GtkGrid* main_grid;
	DateTimeWidgetsCalendarView* calendar;
	GtkListBox* component_listbox;
	guint update_components_idle_source;
};

struct _Block1Data {
	int _ref_count_;
	DateTimeIndicator* self;
	GDateTime* date;
	GeeTreeMap* components_on_day;
};

static gint DateTimeIndicator_private_offset;
static gpointer date_time_indicator_parent_class = NULL;
GSettings* date_time_indicator_settings = NULL;

static GtkWidget* date_time_indicator_real_get_display_widget (WingpanelIndicator* base);
static gboolean ___lambda31_ (DateTimeIndicator* self,
                       GdkEventButton* e);
static gboolean ____lambda31__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static GtkWidget* date_time_indicator_real_get_widget (WingpanelIndicator* base);
static void date_time_indicator_header_update_func (DateTimeIndicator* self,
                                             GtkListBoxRow* lbrow,
                                             GtkListBoxRow* lbbefore);
static void _date_time_indicator_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                              GtkListBoxRow* before,
                                                                              gpointer self);
static gint date_time_indicator_sort_function (GtkListBoxRow* child1,
                                        GtkListBoxRow* child2,
                                        DateTimeIndicator* self);
static gint _date_time_indicator_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                GtkListBoxRow* row2,
                                                                gpointer self);
static void ___lambda32_ (DateTimeIndicator* self);
static void ____lambda32__date_time_widgets_calendar_view_day_double_click (DateTimeWidgetsCalendarView* _sender,
                                                                     gpointer self);
static void ___lambda33_ (DateTimeIndicator* self,
                   GDateTime* date);
static void date_time_indicator_idle_update_components (DateTimeIndicator* self);
static void ____lambda33__date_time_widgets_calendar_view_selection_changed (DateTimeWidgetsCalendarView* _sender,
                                                                      GDateTime* new_date,
                                                                      gpointer self);
static void ___lambda36_ (DateTimeIndicator* self,
                   GtkListBoxRow* row);
static void ____lambda36__gtk_list_box_row_activated (GtkListBox* _sender,
                                               GtkListBoxRow* row,
                                               gpointer self);
static void ___lambda37_ (DateTimeIndicator* self);
static void ____lambda37__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void date_time_indicator_update_components_model (DateTimeIndicator* self,
                                                  ESource* source,
                                                  GeeCollection* events);
static gboolean date_time_indicator_update_components (DateTimeIndicator* self);
static gboolean _date_time_indicator_update_components_gsource_func (gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda34_ (Block1Data* _data1_,
                  ESource* source,
                  GeeTreeMultiMap* component_map);
static void ___lambda34__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void __lambda35_ (Block1Data* _data1_,
                  ESource* source,
                  GeeTreeMultiMap* component_map);
static void ___lambda35__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void date_time_indicator_real_opened (WingpanelIndicator* base);
static void _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added (DateTimeWidgetsCalendarModel* _sender,
                                                                                                     ESource* source,
                                                                                                     GeeCollection* components,
                                                                                                     gpointer self);
static void _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated (DateTimeWidgetsCalendarModel* _sender,
                                                                                                       ESource* source,
                                                                                                       GeeCollection* components,
                                                                                                       gpointer self);
static void _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed (DateTimeWidgetsCalendarModel* _sender,
                                                                                                       ESource* source,
                                                                                                       GeeCollection* components,
                                                                                                       gpointer self);
static void date_time_indicator_real_closed (WingpanelIndicator* base);
static GObject * date_time_indicator_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void date_time_indicator_finalize (GObject * obj);
static GType date_time_indicator_get_type_once (void);

static inline gpointer
date_time_indicator_get_instance_private (DateTimeIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeIndicator_private_offset);
}

DateTimeIndicator*
date_time_indicator_construct (GType object_type)
{
	DateTimeIndicator * self = NULL;
	self = (DateTimeIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_DATETIME, NULL);
	return self;
}

DateTimeIndicator*
date_time_indicator_new (void)
{
	return date_time_indicator_construct (DATE_TIME_TYPE_INDICATOR);
}

static gboolean
___lambda31_ (DateTimeIndicator* self,
              GdkEventButton* e)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		gchar* command = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_date_time_new_now_local ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_date_time_format (_tmp1_, "%F");
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("io.elementary.calendar --show-day %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_date_time_unref0 (_tmp1_);
		command = _tmp5_;
		{
			GAppInfo* appinfo = NULL;
			const gchar* _tmp6_;
			GAppInfo* _tmp7_;
			GAppInfo* _tmp8_;
			_tmp6_ = command;
			_tmp7_ = g_app_info_create_from_commandline (_tmp6_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
			appinfo = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = appinfo;
			g_app_info_launch_uris (_tmp8_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (appinfo);
				goto __catch0_g_error;
			}
			_g_object_unref0 (appinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GraniteMessageDialog* dialog = NULL;
			GraniteMessageDialog* _tmp9_;
			GraniteMessageDialog* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			GraniteMessageDialog* _tmp13_;
			GraniteMessageDialog* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable To Launch Calendar"), _ ("The program \"io.elementary.calendar\" may not be installed"), "dialog-error", GTK_BUTTONS_CLOSE);
			g_object_ref_sink (_tmp9_);
			dialog = _tmp9_;
			_tmp10_ = dialog;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			granite_message_dialog_show_error_details (_tmp10_, _tmp12_);
			_tmp13_ = dialog;
			gtk_dialog_run ((GtkDialog*) _tmp13_);
			_tmp14_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
			_g_object_unref0 (dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_free0 (command);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
		result = GDK_EVENT_STOP;
		_g_free0 (command);
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda31__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = ___lambda31_ ((DateTimeIndicator*) self, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
date_time_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	DateTimeIndicator * self;
	DateTimeWidgetsPanelLabel* _tmp0_;
	DateTimeWidgetsPanelLabel* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* result;
	self = (DateTimeIndicator*) base;
	_tmp0_ = self->priv->panel_label;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		DateTimeWidgetsPanelLabel* _tmp2_ = NULL;
		DateTimeWidgetsPanelLabel* _tmp3_;
		_tmp1_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Middle-click to open Calendar"));
		_tmp2_ = date_time_widgets_panel_label_new ();
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp2_, _tmp1_);
		_g_free0 (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->panel_label);
		self->priv->panel_label = _tmp2_;
		_tmp3_ = self->priv->panel_label;
		g_signal_connect_object ((GtkWidget*) _tmp3_, "button-press-event", (GCallback) ____lambda31__gtk_widget_button_press_event, self, 0);
	}
	_tmp4_ = self->priv->panel_label;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	result = _tmp5_;
	return result;
}

static void
_date_time_indicator_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self)
{
	date_time_indicator_header_update_func ((DateTimeIndicator*) self, row, before);
}

static gint
_date_time_indicator_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                           GtkListBoxRow* row2,
                                                           gpointer self)
{
	gint result;
	result = date_time_indicator_sort_function (row1, row2, (DateTimeIndicator*) self);
	return result;
}

static void
___lambda32_ (DateTimeIndicator* self)
{
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
____lambda32__date_time_widgets_calendar_view_day_double_click (DateTimeWidgetsCalendarView* _sender,
                                                                gpointer self)
{
	___lambda32_ ((DateTimeIndicator*) self);
}

static void
___lambda33_ (DateTimeIndicator* self,
              GDateTime* date)
{
	date_time_indicator_idle_update_components (self);
}

static void
____lambda33__date_time_widgets_calendar_view_selection_changed (DateTimeWidgetsCalendarView* _sender,
                                                                 GDateTime* new_date,
                                                                 gpointer self)
{
	___lambda33_ ((DateTimeIndicator*) self, new_date);
}

static void
___lambda36_ (DateTimeIndicator* self,
              GtkListBoxRow* row)
{
	DateTimeComponentRow* component_row = NULL;
	DateTimeComponentRow* _tmp0_;
	DateTimeComponentRow* _tmp1_;
	ESourceSelectable* _tmp2_;
	ESourceSelectable* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
	component_row = _tmp0_;
	_tmp1_ = component_row;
	_tmp2_ = date_time_component_row_get_source_selectable (_tmp1_);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, e_source_calendar_get_type ())) {
		DateTimeWidgetsCalendarView* _tmp4_;
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		_tmp4_ = self->priv->calendar;
		_tmp5_ = date_time_component_row_get_date (G_TYPE_CHECK_INSTANCE_CAST (row, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
		_tmp6_ = _tmp5_;
		date_time_widgets_calendar_view_show_date_in_maya (_tmp4_, _tmp6_);
		g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	} else {
		DateTimeComponentRow* _tmp7_;
		ESourceSelectable* _tmp8_;
		ESourceSelectable* _tmp9_;
		_tmp7_ = component_row;
		_tmp8_ = date_time_component_row_get_source_selectable (_tmp7_);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, e_source_task_list_get_type ())) {
			GDesktopAppInfo* appinfo = NULL;
			GDesktopAppInfo* _tmp10_;
			_tmp10_ = g_desktop_app_info_new ("io.elementary.tasks.desktop");
			appinfo = _tmp10_;
			{
				GDesktopAppInfo* _tmp11_;
				_tmp11_ = appinfo;
				g_app_info_launch ((GAppInfo*) _tmp11_, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GraniteMessageDialog* dialog = NULL;
				GraniteMessageDialog* _tmp12_;
				GraniteMessageDialog* _tmp13_;
				GError* _tmp14_;
				const gchar* _tmp15_;
				GraniteMessageDialog* _tmp16_;
				GraniteMessageDialog* _tmp17_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable To launch Tasks"), _ ("The program \"io.elementary.tasks\" may not be installed"), "dialog-error", GTK_BUTTONS_CLOSE);
				g_object_ref_sink (_tmp12_);
				dialog = _tmp12_;
				_tmp13_ = dialog;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				granite_message_dialog_show_error_details (_tmp13_, _tmp15_);
				_tmp16_ = dialog;
				gtk_dialog_run ((GtkDialog*) _tmp16_);
				_tmp17_ = dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp17_);
				_g_object_unref0 (dialog);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (appinfo);
				_g_object_unref0 (component_row);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
			_g_object_unref0 (appinfo);
		}
	}
	_g_object_unref0 (component_row);
}

static void
____lambda36__gtk_list_box_row_activated (GtkListBox* _sender,
                                          GtkListBoxRow* row,
                                          gpointer self)
{
	___lambda36_ ((DateTimeIndicator*) self, row);
}

static void
___lambda37_ (DateTimeIndicator* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://time", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Indicator.vala:171: Could not open time and date settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda37__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda37_ ((DateTimeIndicator*) self);
}

static GtkWidget*
date_time_indicator_real_get_widget (WingpanelIndicator* base)
{
	DateTimeIndicator * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWidget* result;
	self = (DateTimeIndicator*) base;
	_tmp0_ = self->priv->main_grid;
	if (_tmp0_ == NULL) {
		DateTimeWidgetsCalendarView* _tmp1_ = NULL;
		GtkLabel* placeholder_label = NULL;
		GtkLabel* _tmp2_ = NULL;
		GtkLabel* _tmp3_;
		GtkStyleContext* placeholder_style_context = NULL;
		GtkLabel* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkListBox* _tmp9_ = NULL;
		GtkListBox* _tmp10_;
		GtkListBox* _tmp11_;
		GtkLabel* _tmp12_;
		GtkListBox* _tmp13_;
		GtkScrolledWindow* scrolled_window = NULL;
		GtkScrolledWindow* _tmp14_ = NULL;
		GtkScrolledWindow* _tmp15_;
		GtkListBox* _tmp16_;
		GtkModelButton* settings_button = NULL;
		gchar* _tmp17_;
		GtkModelButton* _tmp18_ = NULL;
		GtkSeparator* sep = NULL;
		GtkSeparator* _tmp19_ = NULL;
		GtkGrid* _tmp20_ = NULL;
		GtkGrid* _tmp21_;
		DateTimeWidgetsCalendarView* _tmp22_;
		GtkGrid* _tmp23_;
		GtkScrolledWindow* _tmp24_;
		GtkGrid* _tmp25_;
		GtkSeparator* _tmp26_;
		GtkGrid* _tmp27_;
		GtkModelButton* _tmp28_;
		GtkSizeGroup* size_group = NULL;
		GtkSizeGroup* _tmp29_;
		GtkSizeGroup* _tmp30_;
		DateTimeWidgetsCalendarView* _tmp31_;
		GtkSizeGroup* _tmp32_;
		GtkListBox* _tmp33_;
		DateTimeWidgetsCalendarView* _tmp34_;
		DateTimeWidgetsCalendarView* _tmp35_;
		GtkListBox* _tmp36_;
		GtkModelButton* _tmp37_;
		_tmp1_ = date_time_widgets_calendar_view_new ();
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 6);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->calendar);
		self->priv->calendar = _tmp1_;
		_tmp2_ = (GtkLabel*) gtk_label_new (_ ("No events this day"));
		g_object_set (_tmp2_, "wrap", TRUE, NULL);
		g_object_set (_tmp2_, "wrap-mode", PANGO_WRAP_WORD, NULL);
		gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, 12);
		gtk_widget_set_margin_end ((GtkWidget*) _tmp2_, 12);
		gtk_label_set_max_width_chars (_tmp2_, 20);
		gtk_label_set_justify (_tmp2_, GTK_JUSTIFY_CENTER);
		g_object_ref_sink (_tmp2_);
		placeholder_label = _tmp2_;
		_tmp3_ = placeholder_label;
		gtk_widget_show_all ((GtkWidget*) _tmp3_);
		_tmp4_ = placeholder_label;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		placeholder_style_context = _tmp6_;
		_tmp7_ = placeholder_style_context;
		gtk_style_context_add_class (_tmp7_, GTK_STYLE_CLASS_DIM_LABEL);
		_tmp8_ = placeholder_style_context;
		gtk_style_context_add_class (_tmp8_, GRANITE_STYLE_CLASS_H3_LABEL);
		_tmp9_ = (GtkListBox*) gtk_list_box_new ();
		gtk_list_box_set_selection_mode (_tmp9_, GTK_SELECTION_NONE);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->component_listbox);
		self->priv->component_listbox = _tmp9_;
		_tmp10_ = self->priv->component_listbox;
		gtk_list_box_set_header_func (_tmp10_, _date_time_indicator_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
		_tmp11_ = self->priv->component_listbox;
		_tmp12_ = placeholder_label;
		gtk_list_box_set_placeholder (_tmp11_, (GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->component_listbox;
		gtk_list_box_set_sort_func (_tmp13_, _date_time_indicator_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
		_tmp14_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_set (_tmp14_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
		g_object_ref_sink (_tmp14_);
		scrolled_window = _tmp14_;
		_tmp15_ = scrolled_window;
		_tmp16_ = self->priv->component_listbox;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = g_strdup (_ ("Date & Time Settings…"));
		_tmp18_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_set (_tmp18_, "text", _tmp17_, NULL);
		_g_free0 (_tmp17_);
		g_object_ref_sink (_tmp18_);
		settings_button = _tmp18_;
		_tmp19_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 3);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp19_, 3);
		g_object_ref_sink (_tmp19_);
		sep = _tmp19_;
		_tmp20_ = (GtkGrid*) gtk_grid_new ();
		gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 12);
		g_object_ref_sink (_tmp20_);
		_g_object_unref0 (self->priv->main_grid);
		self->priv->main_grid = _tmp20_;
		_tmp21_ = self->priv->main_grid;
		_tmp22_ = self->priv->calendar;
		gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 0, 0, 1, 1);
		_tmp23_ = self->priv->main_grid;
		_tmp24_ = scrolled_window;
		gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 1, 0, 1, 1);
		_tmp25_ = self->priv->main_grid;
		_tmp26_ = sep;
		gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, 2, 2, 1);
		_tmp27_ = self->priv->main_grid;
		_tmp28_ = settings_button;
		gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 3, 2, 1);
		_tmp29_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		size_group = _tmp29_;
		_tmp30_ = size_group;
		_tmp31_ = self->priv->calendar;
		gtk_size_group_add_widget (_tmp30_, (GtkWidget*) _tmp31_);
		_tmp32_ = size_group;
		_tmp33_ = self->priv->component_listbox;
		gtk_size_group_add_widget (_tmp32_, (GtkWidget*) _tmp33_);
		_tmp34_ = self->priv->calendar;
		g_signal_connect_object (_tmp34_, "day-double-click", (GCallback) ____lambda32__date_time_widgets_calendar_view_day_double_click, self, 0);
		_tmp35_ = self->priv->calendar;
		g_signal_connect_object (_tmp35_, "selection-changed", (GCallback) ____lambda33__date_time_widgets_calendar_view_selection_changed, self, 0);
		_tmp36_ = self->priv->component_listbox;
		g_signal_connect_object (_tmp36_, "row-activated", (GCallback) ____lambda36__gtk_list_box_row_activated, self, 0);
		_tmp37_ = settings_button;
		g_signal_connect_object ((GtkButton*) _tmp37_, "clicked", (GCallback) ____lambda37__gtk_button_clicked, self, 0);
		_g_object_unref0 (size_group);
		_g_object_unref0 (sep);
		_g_object_unref0 (settings_button);
		_g_object_unref0 (scrolled_window);
		_g_object_unref0 (placeholder_style_context);
		_g_object_unref0 (placeholder_label);
	}
	_tmp38_ = self->priv->main_grid;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	result = _tmp39_;
	return result;
}

static void
date_time_indicator_header_update_func (DateTimeIndicator* self,
                                        GtkListBoxRow* lbrow,
                                        GtkListBoxRow* lbbefore)
{
	DateTimeComponentRow* row = NULL;
	DateTimeComponentRow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
	row = _tmp0_;
	if (lbbefore != NULL) {
		DateTimeComponentRow* before = NULL;
		DateTimeComponentRow* _tmp1_;
		DateTimeComponentRow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		DateTimeComponentRow* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		DateTimeComponentRow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		DateTimeComponentRow* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
		before = _tmp1_;
		_tmp2_ = row;
		_tmp3_ = date_time_component_row_get_is_allday (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = before;
		_tmp6_ = date_time_component_row_get_is_allday (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp4_ == _tmp7_) {
			DateTimeComponentRow* _tmp8_;
			_tmp8_ = row;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp8_, NULL);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_tmp9_ = row;
		_tmp10_ = date_time_component_row_get_is_allday (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = before;
		_tmp13_ = date_time_component_row_get_is_allday (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp11_ != _tmp14_) {
			GraniteHeaderLabel* header_label = NULL;
			GraniteHeaderLabel* _tmp15_;
			GraniteHeaderLabel* _tmp16_;
			GraniteHeaderLabel* _tmp17_;
			DateTimeComponentRow* _tmp18_;
			GraniteHeaderLabel* _tmp19_;
			_tmp15_ = granite_header_label_new (_ ("During the Day"));
			g_object_ref_sink (_tmp15_);
			header_label = _tmp15_;
			_tmp16_ = header_label;
			_tmp17_ = header_label;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 6);
			gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 6);
			_tmp18_ = row;
			_tmp19_ = header_label;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp18_, (GtkWidget*) _tmp19_);
			_g_object_unref0 (header_label);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	} else {
		DateTimeComponentRow* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = row;
		_tmp21_ = date_time_component_row_get_is_allday (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GraniteHeaderLabel* allday_header = NULL;
			GraniteHeaderLabel* _tmp23_;
			GraniteHeaderLabel* _tmp24_;
			GraniteHeaderLabel* _tmp25_;
			DateTimeComponentRow* _tmp26_;
			GraniteHeaderLabel* _tmp27_;
			_tmp23_ = granite_header_label_new (_ ("All Day"));
			g_object_ref_sink (_tmp23_);
			allday_header = _tmp23_;
			_tmp24_ = allday_header;
			_tmp25_ = allday_header;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, 6);
			gtk_widget_set_margin_start ((GtkWidget*) _tmp24_, 6);
			_tmp26_ = row;
			_tmp27_ = allday_header;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp26_, (GtkWidget*) _tmp27_);
			_g_object_unref0 (allday_header);
		}
		_g_object_unref0 (row);
		return;
	}
	_g_object_unref0 (row);
}

static gint
date_time_indicator_sort_function (GtkListBoxRow* child1,
                                   GtkListBoxRow* child2,
                                   DateTimeIndicator* self)
{
	DateTimeComponentRow* e1 = NULL;
	DateTimeComponentRow* _tmp0_;
	DateTimeComponentRow* e2 = NULL;
	DateTimeComponentRow* _tmp1_;
	DateTimeComponentRow* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	DateTimeComponentRow* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	DateTimeComponentRow* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (child1 != NULL, 0);
	g_return_val_if_fail (child2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child1, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
	e1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child2, DATE_TIME_TYPE_COMPONENT_ROW, DateTimeComponentRow));
	e2 = _tmp1_;
	_tmp2_ = e1;
	_tmp3_ = date_time_component_row_get_start_time (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = e2;
	_tmp6_ = date_time_component_row_get_start_time (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_date_time_compare (_tmp4_, _tmp7_) != 0) {
		DateTimeComponentRow* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		DateTimeComponentRow* _tmp11_;
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		_tmp8_ = e1;
		_tmp9_ = date_time_component_row_get_start_time (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e2;
		_tmp12_ = date_time_component_row_get_start_time (_tmp11_);
		_tmp13_ = _tmp12_;
		result = g_date_time_compare (_tmp10_, _tmp13_);
		_g_object_unref0 (e2);
		_g_object_unref0 (e1);
		return result;
	}
	_tmp14_ = e1;
	_tmp15_ = date_time_component_row_get_is_allday (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		result = -1;
		_g_object_unref0 (e2);
		_g_object_unref0 (e1);
		return result;
	} else {
		DateTimeComponentRow* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp17_ = e2;
		_tmp18_ = date_time_component_row_get_is_allday (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			result = 1;
			_g_object_unref0 (e2);
			_g_object_unref0 (e1);
			return result;
		}
	}
	result = 0;
	_g_object_unref0 (e2);
	_g_object_unref0 (e1);
	return result;
}

static void
date_time_indicator_update_components_model (DateTimeIndicator* self,
                                             ESource* source,
                                             GeeCollection* events)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	date_time_indicator_idle_update_components (self);
}

static gboolean
_date_time_indicator_update_components_gsource_func (gpointer self)
{
	gboolean result;
	result = date_time_indicator_update_components ((DateTimeIndicator*) self);
	return result;
}

static void
date_time_indicator_idle_update_components (DateTimeIndicator* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_components_idle_source > ((guint) 0)) {
		g_source_remove (self->priv->update_components_idle_source);
	}
	self->priv->update_components_idle_source = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _date_time_indicator_update_components_gsource_func, g_object_ref (self), g_object_unref);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DateTimeIndicator* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->components_on_day);
		_g_date_time_unref0 (_data1_->date);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
__lambda34_ (Block1Data* _data1_,
             ESource* source,
             GeeTreeMultiMap* component_map)
{
	DateTimeIndicator* self;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (component_map != NULL);
	{
		GeeIterator* _comp_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get_values ((GeeMultiMap*) component_map);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_comp_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			ECalComponent* comp = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			ECalComponent* _tmp7_;
			GDateTime* _tmp8_;
			_tmp4_ = _comp_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _comp_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			comp = (ECalComponent*) _tmp6_;
			_tmp7_ = comp;
			_tmp8_ = _data1_->date;
			if (util_calcomp_is_on_day (_tmp7_, _tmp8_)) {
				ICalComponent* ical = NULL;
				ECalComponent* _tmp9_;
				ICalComponent* _tmp10_;
				gchar* component_uid = NULL;
				ICalComponent* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				GeeTreeMap* _tmp14_;
				const gchar* _tmp15_;
				_tmp9_ = comp;
				_tmp10_ = e_cal_component_get_icalcomponent (_tmp9_);
				ical = _tmp10_;
				_tmp11_ = ical;
				_tmp12_ = i_cal_component_get_uid (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				component_uid = _tmp13_;
				_tmp14_ = _data1_->components_on_day;
				_tmp15_ = component_uid;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp15_)) {
					GeeTreeMap* _tmp16_;
					const gchar* _tmp17_;
					GDateTime* _tmp18_;
					ICalComponent* _tmp19_;
					DateTimeComponentRow* _tmp20_;
					DateTimeComponentRow* _tmp21_;
					GtkListBox* _tmp22_;
					GeeTreeMap* _tmp23_;
					const gchar* _tmp24_;
					gpointer _tmp25_;
					DateTimeComponentRow* _tmp26_;
					_tmp16_ = _data1_->components_on_day;
					_tmp17_ = component_uid;
					_tmp18_ = _data1_->date;
					_tmp19_ = ical;
					_tmp20_ = date_time_component_row_new (_tmp18_, _tmp19_, source);
					g_object_ref_sink (_tmp20_);
					_tmp21_ = _tmp20_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp21_);
					_g_object_unref0 (_tmp21_);
					_tmp22_ = self->priv->component_listbox;
					_tmp23_ = _data1_->components_on_day;
					_tmp24_ = component_uid;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
					_tmp26_ = (DateTimeComponentRow*) _tmp25_;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp26_);
					_g_object_unref0 (_tmp26_);
				}
				_g_free0 (component_uid);
			}
			_g_object_unref0 (comp);
		}
		_g_object_unref0 (_comp_it);
	}
}

static void
___lambda34__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda34_ (self, (ESource*) key, (GeeTreeMultiMap*) value);
}

static void
__lambda35_ (Block1Data* _data1_,
             ESource* source,
             GeeTreeMultiMap* component_map)
{
	DateTimeIndicator* self;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (component_map != NULL);
	{
		GeeIterator* _comp_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get_values ((GeeMultiMap*) component_map);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_comp_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			ECalComponent* comp = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			ECalComponent* _tmp7_;
			GDateTime* _tmp8_;
			_tmp4_ = _comp_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _comp_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			comp = (ECalComponent*) _tmp6_;
			_tmp7_ = comp;
			_tmp8_ = _data1_->date;
			if (util_calcomp_is_on_day (_tmp7_, _tmp8_)) {
				ICalComponent* ical = NULL;
				ECalComponent* _tmp9_;
				ICalComponent* _tmp10_;
				gchar* component_uid = NULL;
				ICalComponent* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				GeeTreeMap* _tmp14_;
				const gchar* _tmp15_;
				_tmp9_ = comp;
				_tmp10_ = e_cal_component_get_icalcomponent (_tmp9_);
				ical = _tmp10_;
				_tmp11_ = ical;
				_tmp12_ = i_cal_component_get_uid (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				component_uid = _tmp13_;
				_tmp14_ = _data1_->components_on_day;
				_tmp15_ = component_uid;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp15_)) {
					GeeTreeMap* _tmp16_;
					const gchar* _tmp17_;
					GDateTime* _tmp18_;
					ICalComponent* _tmp19_;
					DateTimeComponentRow* _tmp20_;
					DateTimeComponentRow* _tmp21_;
					GtkListBox* _tmp22_;
					GeeTreeMap* _tmp23_;
					const gchar* _tmp24_;
					gpointer _tmp25_;
					DateTimeComponentRow* _tmp26_;
					_tmp16_ = _data1_->components_on_day;
					_tmp17_ = component_uid;
					_tmp18_ = _data1_->date;
					_tmp19_ = ical;
					_tmp20_ = date_time_component_row_new (_tmp18_, _tmp19_, source);
					g_object_ref_sink (_tmp20_);
					_tmp21_ = _tmp20_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp21_);
					_g_object_unref0 (_tmp21_);
					_tmp22_ = self->priv->component_listbox;
					_tmp23_ = _data1_->components_on_day;
					_tmp24_ = component_uid;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
					_tmp26_ = (DateTimeComponentRow*) _tmp25_;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp26_);
					_g_object_unref0 (_tmp26_);
				}
				_g_free0 (component_uid);
			}
			_g_object_unref0 (comp);
		}
		_g_object_unref0 (_comp_it);
	}
}

static void
___lambda35__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda35_ (self, (ESource*) key, (GeeTreeMultiMap*) value);
}

static gboolean
date_time_indicator_update_components (DateTimeIndicator* self)
{
	Block1Data* _data1_;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	DateTimeWidgetsCalendarView* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	DateTimeWidgetsCalendarView* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	DateTimeWidgetsCalendarModel* events_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp10_;
	DateTimeWidgetsCalendarModel* tasks_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp11_;
	GeeTreeMap* _tmp12_;
	DateTimeWidgetsCalendarModel* _tmp13_;
	GHashTable* _tmp14_;
	GHashTable* _tmp15_;
	DateTimeWidgetsCalendarModel* _tmp16_;
	GHashTable* _tmp17_;
	GHashTable* _tmp18_;
	GtkListBox* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->component_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp1_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* widget = NULL;
			widget = (GtkWidget*) widget_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = widget;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp3_ = self->priv->calendar;
	_tmp4_ = date_time_widgets_calendar_view_get_selected_date (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		self->priv->update_components_idle_source = (guint) 0;
		result = G_SOURCE_REMOVE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp6_ = self->priv->calendar;
	_tmp7_ = date_time_widgets_calendar_view_get_selected_date (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_date_time_ref0 (_tmp8_);
	_data1_->date = _tmp9_;
	_tmp10_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_EVENTS);
	events_model = _tmp10_;
	_tmp11_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_TASKS);
	tasks_model = _tmp11_;
	_tmp12_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, DATE_TIME_TYPE_COMPONENT_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data1_->components_on_day = _tmp12_;
	_tmp13_ = events_model;
	_tmp14_ = date_time_widgets_calendar_model_get_source_components (_tmp13_);
	_tmp15_ = _tmp14_;
	g_hash_table_foreach (_tmp15_, ___lambda34__gh_func, _data1_);
	_tmp16_ = tasks_model;
	_tmp17_ = date_time_widgets_calendar_model_get_source_components (_tmp16_);
	_tmp18_ = _tmp17_;
	g_hash_table_foreach (_tmp18_, ___lambda35__gh_func, _data1_);
	_tmp19_ = self->priv->component_listbox;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	self->priv->update_components_idle_source = (guint) 0;
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (tasks_model);
	_g_object_unref0 (events_model);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
_date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added (DateTimeWidgetsCalendarModel* _sender,
                                                                                                ESource* source,
                                                                                                GeeCollection* components,
                                                                                                gpointer self)
{
	date_time_indicator_update_components_model ((DateTimeIndicator*) self, source, components);
}

static void
_date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated (DateTimeWidgetsCalendarModel* _sender,
                                                                                                  ESource* source,
                                                                                                  GeeCollection* components,
                                                                                                  gpointer self)
{
	date_time_indicator_update_components_model ((DateTimeIndicator*) self, source, components);
}

static void
_date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed (DateTimeWidgetsCalendarModel* _sender,
                                                                                                  ESource* source,
                                                                                                  GeeCollection* components,
                                                                                                  gpointer self)
{
	date_time_indicator_update_components_model ((DateTimeIndicator*) self, source, components);
}

static void
date_time_indicator_real_opened (WingpanelIndicator* base)
{
	DateTimeIndicator * self;
	DateTimeWidgetsCalendarModel* events_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp0_;
	DateTimeWidgetsCalendarModel* tasks_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp1_;
	DateTimeWidgetsCalendarView* _tmp2_;
	self = (DateTimeIndicator*) base;
	_tmp0_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_EVENTS);
	events_model = _tmp0_;
	_tmp1_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_TASKS);
	tasks_model = _tmp1_;
	g_signal_connect_object (events_model, "components-added", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added, self, 0);
	g_signal_connect_object (tasks_model, "components-added", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added, self, 0);
	g_signal_connect_object (events_model, "components-updated", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated, self, 0);
	g_signal_connect_object (tasks_model, "components-updated", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated, self, 0);
	g_signal_connect_object (events_model, "components-removed", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed, self, 0);
	g_signal_connect_object (tasks_model, "components-removed", (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed, self, 0);
	_tmp2_ = self->priv->calendar;
	date_time_widgets_calendar_view_refresh (_tmp2_);
	_g_object_unref0 (tasks_model);
	_g_object_unref0 (events_model);
}

static void
date_time_indicator_real_closed (WingpanelIndicator* base)
{
	DateTimeIndicator * self;
	DateTimeWidgetsCalendarModel* events_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp0_;
	DateTimeWidgetsCalendarModel* tasks_model = NULL;
	DateTimeWidgetsCalendarModel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	self = (DateTimeIndicator*) base;
	_tmp0_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_EVENTS);
	events_model = _tmp0_;
	_tmp1_ = date_time_widgets_calendar_model_get_default (E_CAL_CLIENT_SOURCE_TYPE_TASKS);
	tasks_model = _tmp1_;
	g_signal_parse_name ("components-added", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (events_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added, self);
	g_signal_parse_name ("components-added", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tasks_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_added, self);
	g_signal_parse_name ("components-updated", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (events_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated, self);
	g_signal_parse_name ("components-updated", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tasks_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_updated, self);
	g_signal_parse_name ("components-removed", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (events_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed, self);
	g_signal_parse_name ("components-removed", DATE_TIME_WIDGETS_TYPE_CALENDAR_MODEL, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (tasks_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _date_time_indicator_update_components_model_date_time_widgets_calendar_model_components_removed, self);
	_g_object_unref0 (tasks_model);
	_g_object_unref0 (events_model);
}

static GObject *
date_time_indicator_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeIndicator * self;
	parent_class = G_OBJECT_CLASS (date_time_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_INDICATOR, DateTimeIndicator);
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, TRUE);
	return obj;
}

static void
date_time_indicator_class_init (DateTimeIndicatorClass * klass,
                                gpointer klass_data)
{
	GSettings* _tmp0_;
	date_time_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) date_time_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) date_time_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) date_time_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) date_time_indicator_real_closed;
	G_OBJECT_CLASS (klass)->constructor = date_time_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_indicator_finalize;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_settings_new ("io.elementary.desktop.wingpanel.datetime");
	_g_object_unref0 (date_time_indicator_settings);
	date_time_indicator_settings = _tmp0_;
}

static void
date_time_indicator_instance_init (DateTimeIndicator * self,
                                   gpointer klass)
{
	self->priv = date_time_indicator_get_instance_private (self);
	self->priv->update_components_idle_source = (guint) 0;
}

static void
date_time_indicator_finalize (GObject * obj)
{
	DateTimeIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_INDICATOR, DateTimeIndicator);
	i_cal_object_free_global_objects ();
	_g_object_unref0 (self->priv->panel_label);
	_g_object_unref0 (self->priv->main_grid);
	_g_object_unref0 (self->priv->calendar);
	_g_object_unref0 (self->priv->component_listbox);
	G_OBJECT_CLASS (date_time_indicator_parent_class)->finalize (obj);
}

static GType
date_time_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeIndicator), 0, (GInstanceInitFunc) date_time_indicator_instance_init, NULL };
	GType date_time_indicator_type_id;
	date_time_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "DateTimeIndicator", &g_define_type_info, 0);
	DateTimeIndicator_private_offset = g_type_add_instance_private (date_time_indicator_type_id, sizeof (DateTimeIndicatorPrivate));
	return date_time_indicator_type_id;
}

GType
date_time_indicator_get_type (void)
{
	static volatile gsize date_time_indicator_type_id__once = 0;
	if (g_once_init_enter (&date_time_indicator_type_id__once)) {
		GType date_time_indicator_type_id;
		date_time_indicator_type_id = date_time_indicator_get_type_once ();
		g_once_init_leave (&date_time_indicator_type_id__once, date_time_indicator_type_id);
	}
	return date_time_indicator_type_id__once;
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	DateTimeIndicator* indicator = NULL;
	DateTimeIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:319: Activating DateTime Indicator");
	if (server_type != WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		g_debug ("Indicator.vala:322: Wingpanel is not in session, not loading DateTime");
		result = NULL;
		return result;
	}
	_tmp0_ = date_time_indicator_new ();
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

