/* DateRange.c generated by valac 0.56.16, the Vala compiler
 * generated from DateRange.vala, do not modify */

/*
 * Copyright 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */
/* Represents date range from 'first' to 'last' inclusive */

#include "datetime.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	UTIL_DATE_RANGE_0_PROPERTY,
	UTIL_DATE_RANGE_FIRST_DT_PROPERTY,
	UTIL_DATE_RANGE_LAST_DT_PROPERTY,
	UTIL_DATE_RANGE_NUM_PROPERTIES
};
static GParamSpec* util_date_range_properties[UTIL_DATE_RANGE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UtilDateRangePrivate {
	GDateTime* _first_dt;
	GDateTime* _last_dt;
};

static gint UtilDateRange_private_offset;
static gpointer util_date_range_parent_class = NULL;
static GeeTraversableIface * util_date_range_gee_traversable_parent_iface = NULL;
static GeeIterableIface * util_date_range_gee_iterable_parent_iface = NULL;

static gboolean util_date_range_real_foreach (GeeTraversable* base,
                                       GeeForallFunc f,
                                       gpointer f_target);
static GeeIterator* util_date_range_real_iterator (GeeIterable* base);
static gboolean util_date_range_datetime_equal_func (UtilDateRange* self,
                                              GDateTime* a,
                                              GDateTime* b);
static void util_date_range_finalize (GObject * obj);
static GType util_date_range_get_type_once (void);
static void _vala_util_date_range_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_util_date_range_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
util_date_range_get_instance_private (UtilDateRange* self)
{
	return G_STRUCT_MEMBER_P (self, UtilDateRange_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
util_date_range_real_foreach (GeeTraversable* base,
                              GeeForallFunc f,
                              gpointer f_target)
{
	UtilDateRange * self;
	gboolean result;
	self = (UtilDateRange*) base;
	{
		GeeIterator* _date_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) self);
		_date_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GDateTime* date = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GDateTime* _tmp4_;
			GDateTime* _tmp5_;
			_tmp1_ = _date_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _date_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			date = (GDateTime*) _tmp3_;
			_tmp4_ = date;
			_tmp5_ = _g_date_time_ref0 (_tmp4_);
			if (f (_tmp5_, f_target) == FALSE) {
				result = FALSE;
				_g_date_time_unref0 (date);
				_g_object_unref0 (_date_it);
				return result;
			}
			_g_date_time_unref0 (date);
		}
		_g_object_unref0 (_date_it);
	}
	result = TRUE;
	return result;
}

UtilDateRange*
util_date_range_construct (GType object_type,
                           GDateTime* first,
                           GDateTime* last)
{
	UtilDateRange * self = NULL;
	g_return_val_if_fail (first != NULL, NULL);
	g_return_val_if_fail (last != NULL, NULL);
	self = (UtilDateRange*) g_object_new (object_type, "first-dt", first, "last-dt", last, NULL);
	return self;
}

UtilDateRange*
util_date_range_new (GDateTime* first,
                     GDateTime* last)
{
	return util_date_range_construct (UTIL_TYPE_DATE_RANGE, first, last);
}

gboolean
util_date_range_equals (UtilDateRange* self,
                        UtilDateRange* other)
{
	gboolean _tmp0_ = FALSE;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp1_ = self->priv->_first_dt;
	_tmp2_ = other->priv->_first_dt;
	if (_tmp1_ == _tmp2_) {
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp3_ = self->priv->_last_dt;
		_tmp4_ = other->priv->_last_dt;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static GeeIterator*
util_date_range_real_iterator (GeeIterable* base)
{
	UtilDateRange * self;
	UtilDateIterator* _tmp0_;
	GeeIterator* result;
	self = (UtilDateRange*) base;
	_tmp0_ = util_date_iterator_new (self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

GeeList*
util_date_range_to_list (UtilDateRange* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_DATE_TIME, (GBoxedCopyFunc) g_date_time_ref, (GDestroyNotify) g_date_time_unref, (GeeEqualDataFunc) util_date_range_datetime_equal_func, g_object_ref (self), g_object_unref);
	list = _tmp0_;
	{
		GeeIterator* _date_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) self);
		_date_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GDateTime* date = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			GDateTime* _tmp6_;
			_tmp2_ = _date_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _date_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			date = (GDateTime*) _tmp4_;
			_tmp5_ = list;
			_tmp6_ = date;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
			_g_date_time_unref0 (date);
		}
		_g_object_unref0 (_date_it);
	}
	result = (GeeList*) list;
	return result;
}

static gboolean
util_date_range_datetime_equal_func (UtilDateRange* self,
                                     GDateTime* a,
                                     GDateTime* b)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_date_time_equal (a, b);
	return result;
}

GDateTime*
util_date_range_get_first_dt (UtilDateRange* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_first_dt;
	result = _tmp0_;
	return result;
}

static void
util_date_range_set_first_dt (UtilDateRange* self,
                              GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = util_date_range_get_first_dt (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_first_dt);
		self->priv->_first_dt = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, util_date_range_properties[UTIL_DATE_RANGE_FIRST_DT_PROPERTY]);
	}
}

GDateTime*
util_date_range_get_last_dt (UtilDateRange* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_dt;
	result = _tmp0_;
	return result;
}

static void
util_date_range_set_last_dt (UtilDateRange* self,
                             GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = util_date_range_get_last_dt (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_last_dt);
		self->priv->_last_dt = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, util_date_range_properties[UTIL_DATE_RANGE_LAST_DT_PROPERTY]);
	}
}

static void
util_date_range_class_init (UtilDateRangeClass * klass,
                            gpointer klass_data)
{
	util_date_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UtilDateRange_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_util_date_range_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_util_date_range_set_property;
	G_OBJECT_CLASS (klass)->finalize = util_date_range_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_DATE_RANGE_FIRST_DT_PROPERTY, util_date_range_properties[UTIL_DATE_RANGE_FIRST_DT_PROPERTY] = g_param_spec_boxed ("first-dt", "first-dt", "first-dt", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_DATE_RANGE_LAST_DT_PROPERTY, util_date_range_properties[UTIL_DATE_RANGE_LAST_DT_PROPERTY] = g_param_spec_boxed ("last-dt", "last-dt", "last-dt", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static GType
util_date_range_gee_traversable_get_g_type (UtilDateRange* self)
{
	return (GType) G_TYPE_DATE_TIME;
}

static GBoxedCopyFunc
util_date_range_gee_traversable_get_g_dup_func (UtilDateRange* self)
{
	return (GBoxedCopyFunc) g_date_time_ref;
}

static GDestroyNotify
util_date_range_gee_traversable_get_g_destroy_func (UtilDateRange* self)
{
	return (GDestroyNotify) g_date_time_unref;
}

static void
util_date_range_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                gpointer iface_data)
{
	util_date_range_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) util_date_range_real_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) util_date_range_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) util_date_range_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) util_date_range_gee_traversable_get_g_destroy_func;
}

static GType
util_date_range_gee_iterable_get_g_type (UtilDateRange* self)
{
	return (GType) G_TYPE_DATE_TIME;
}

static GBoxedCopyFunc
util_date_range_gee_iterable_get_g_dup_func (UtilDateRange* self)
{
	return (GBoxedCopyFunc) g_date_time_ref;
}

static GDestroyNotify
util_date_range_gee_iterable_get_g_destroy_func (UtilDateRange* self)
{
	return (GDestroyNotify) g_date_time_unref;
}

static void
util_date_range_gee_iterable_interface_init (GeeIterableIface * iface,
                                             gpointer iface_data)
{
	util_date_range_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*) (GeeIterable*)) util_date_range_real_iterator;
	iface->get_g_type = (GType (*) (GeeIterable *)) util_date_range_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) util_date_range_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) util_date_range_gee_iterable_get_g_destroy_func;
}

static void
util_date_range_instance_init (UtilDateRange * self,
                               gpointer klass)
{
	self->priv = util_date_range_get_instance_private (self);
}

static void
util_date_range_finalize (GObject * obj)
{
	UtilDateRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_TYPE_DATE_RANGE, UtilDateRange);
	_g_date_time_unref0 (self->priv->_first_dt);
	_g_date_time_unref0 (self->priv->_last_dt);
	G_OBJECT_CLASS (util_date_range_parent_class)->finalize (obj);
}

static GType
util_date_range_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UtilDateRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_date_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilDateRange), 0, (GInstanceInitFunc) util_date_range_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) util_date_range_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) util_date_range_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType util_date_range_type_id;
	util_date_range_type_id = g_type_register_static (G_TYPE_OBJECT, "UtilDateRange", &g_define_type_info, 0);
	g_type_add_interface_static (util_date_range_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (util_date_range_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	UtilDateRange_private_offset = g_type_add_instance_private (util_date_range_type_id, sizeof (UtilDateRangePrivate));
	return util_date_range_type_id;
}

GType
util_date_range_get_type (void)
{
	static volatile gsize util_date_range_type_id__once = 0;
	if (g_once_init_enter (&util_date_range_type_id__once)) {
		GType util_date_range_type_id;
		util_date_range_type_id = util_date_range_get_type_once ();
		g_once_init_leave (&util_date_range_type_id__once, util_date_range_type_id);
	}
	return util_date_range_type_id__once;
}

static void
_vala_util_date_range_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	UtilDateRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_TYPE_DATE_RANGE, UtilDateRange);
	switch (property_id) {
		case UTIL_DATE_RANGE_FIRST_DT_PROPERTY:
		g_value_set_boxed (value, util_date_range_get_first_dt (self));
		break;
		case UTIL_DATE_RANGE_LAST_DT_PROPERTY:
		g_value_set_boxed (value, util_date_range_get_last_dt (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_util_date_range_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	UtilDateRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_TYPE_DATE_RANGE, UtilDateRange);
	switch (property_id) {
		case UTIL_DATE_RANGE_FIRST_DT_PROPERTY:
		util_date_range_set_first_dt (self, g_value_get_boxed (value));
		break;
		case UTIL_DATE_RANGE_LAST_DT_PROPERTY:
		util_date_range_set_last_dt (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

