/*
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* TextDecoderStream */
extern const char* const s_textDecoderStreamInitializeTextDecoderStreamCode;
extern const int s_textDecoderStreamInitializeTextDecoderStreamCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamInitializeTextDecoderStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamInitializeTextDecoderStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamInitializeTextDecoderStreamCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamInitializeTextDecoderStreamCodeInlineAttribute;
extern const char* const s_textDecoderStreamEncodingCode;
extern const int s_textDecoderStreamEncodingCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamEncodingCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamEncodingCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamEncodingCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamEncodingCodeInlineAttribute;
extern const char* const s_textDecoderStreamFatalCode;
extern const int s_textDecoderStreamFatalCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamFatalCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamFatalCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamFatalCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamFatalCodeInlineAttribute;
extern const char* const s_textDecoderStreamIgnoreBOMCode;
extern const int s_textDecoderStreamIgnoreBOMCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamIgnoreBOMCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamIgnoreBOMCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamIgnoreBOMCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamIgnoreBOMCodeInlineAttribute;
extern const char* const s_textDecoderStreamReadableCode;
extern const int s_textDecoderStreamReadableCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamReadableCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamReadableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamReadableCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamReadableCodeInlineAttribute;
extern const char* const s_textDecoderStreamWritableCode;
extern const int s_textDecoderStreamWritableCodeLength;
extern const JSC::ConstructAbility s_textDecoderStreamWritableCodeConstructAbility;
extern const JSC::ConstructorKind s_textDecoderStreamWritableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_textDecoderStreamWritableCodeImplementationVisibility;
extern const JSC::InlineAttribute s_textDecoderStreamWritableCodeInlineAttribute;

#define WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_DATA(macro) \
    macro(initializeTextDecoderStream, textDecoderStreamInitializeTextDecoderStream, 0) \
    macro(encoding, textDecoderStreamEncoding, 0) \
    macro(fatal, textDecoderStreamFatal, 0) \
    macro(ignoreBOM, textDecoderStreamIgnoreBOM, 0) \
    macro(readable, textDecoderStreamReadable, 0) \
    macro(writable, textDecoderStreamWritable, 0) \

#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_INITIALIZETEXTDECODERSTREAM 1
#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_ENCODING 1
#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_FATAL 1
#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_IGNOREBOM 1
#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_READABLE 1
#define WEBCORE_BUILTIN_TEXTDECODERSTREAM_WRITABLE 1

#define WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(macro) \
    macro(textDecoderStreamInitializeTextDecoderStreamCode, initializeTextDecoderStream, ASCIILiteral(), s_textDecoderStreamInitializeTextDecoderStreamCodeLength) \
    macro(textDecoderStreamEncodingCode, encoding, "get encoding"_s, s_textDecoderStreamEncodingCodeLength) \
    macro(textDecoderStreamFatalCode, fatal, "get fatal"_s, s_textDecoderStreamFatalCodeLength) \
    macro(textDecoderStreamIgnoreBOMCode, ignoreBOM, "get ignoreBOM"_s, s_textDecoderStreamIgnoreBOMCodeLength) \
    macro(textDecoderStreamReadableCode, readable, "get readable"_s, s_textDecoderStreamReadableCodeLength) \
    macro(textDecoderStreamWritableCode, writable, "get writable"_s, s_textDecoderStreamWritableCodeLength) \

#define WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_FUNCTION_NAME(macro) \
    macro(encoding) \
    macro(fatal) \
    macro(ignoreBOM) \
    macro(initializeTextDecoderStream) \
    macro(readable) \
    macro(writable) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class TextDecoderStreamBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit TextDecoderStreamBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }, JSC::SourceTaintedOrigin::Untainted))
        WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* TextDecoderStreamBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility, s_##name##InlineAttribute), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void TextDecoderStreamBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

} // namespace WebCore
