/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "TagName.h"

#include "HTMLNames.h"
#include "MathMLNames.h"
#include "SVGNames.h"
#include "XLinkNames.h"
#include "XMLNames.h"
#include "XMLNSNames.h"
#include <wtf/text/FastCharacterComparison.h>

namespace WebCore {

static constexpr void* tagQualifiedNamePointers[] = {
    &HTMLNames::abbrTag,
    &HTMLNames::acronymTag,
    &HTMLNames::addressTag,
    &HTMLNames::appletTag,
    &HTMLNames::areaTag,
    &HTMLNames::articleTag,
    &HTMLNames::asideTag,
    &HTMLNames::attachmentTag,
    &HTMLNames::audioTag,
    &HTMLNames::bTag,
    &HTMLNames::baseTag,
    &HTMLNames::basefontTag,
    &HTMLNames::bdiTag,
    &HTMLNames::bdoTag,
    &HTMLNames::bgsoundTag,
    &HTMLNames::bigTag,
    &HTMLNames::blockquoteTag,
    &HTMLNames::bodyTag,
    &HTMLNames::brTag,
    &HTMLNames::buttonTag,
    &HTMLNames::canvasTag,
    &HTMLNames::captionTag,
    &HTMLNames::centerTag,
    &HTMLNames::citeTag,
    &HTMLNames::codeTag,
    &HTMLNames::colTag,
    &HTMLNames::colgroupTag,
    &HTMLNames::color_profileTag,
    &HTMLNames::dataTag,
    &HTMLNames::datalistTag,
    &HTMLNames::ddTag,
    &HTMLNames::delTag,
    &HTMLNames::detailsTag,
    &HTMLNames::dfnTag,
    &HTMLNames::dialogTag,
    &HTMLNames::dirTag,
    &HTMLNames::divTag,
    &HTMLNames::dlTag,
    &HTMLNames::dtTag,
    &HTMLNames::emTag,
    &HTMLNames::embedTag,
    &HTMLNames::fieldsetTag,
    &HTMLNames::figcaptionTag,
    &HTMLNames::figureTag,
    &HTMLNames::footerTag,
    &HTMLNames::formTag,
    &HTMLNames::frameTag,
    &HTMLNames::framesetTag,
    &HTMLNames::h1Tag,
    &HTMLNames::h2Tag,
    &HTMLNames::h3Tag,
    &HTMLNames::h4Tag,
    &HTMLNames::h5Tag,
    &HTMLNames::h6Tag,
    &HTMLNames::headTag,
    &HTMLNames::headerTag,
    &HTMLNames::hgroupTag,
    &HTMLNames::hrTag,
    &HTMLNames::htmlTag,
    &HTMLNames::iTag,
    &HTMLNames::iframeTag,
    &HTMLNames::imgTag,
    &HTMLNames::inputTag,
    &HTMLNames::insTag,
    &HTMLNames::kbdTag,
    &HTMLNames::keygenTag,
    &HTMLNames::labelTag,
    &HTMLNames::legendTag,
    &HTMLNames::liTag,
    &HTMLNames::linkTag,
    &HTMLNames::listingTag,
    &HTMLNames::mainTag,
    &HTMLNames::mapTag,
    &HTMLNames::markTag,
    &HTMLNames::marqueeTag,
    &HTMLNames::menuTag,
    &HTMLNames::metaTag,
    &HTMLNames::meterTag,
    &HTMLNames::modelTag,
    &HTMLNames::navTag,
    &HTMLNames::nobrTag,
    &HTMLNames::noembedTag,
    &HTMLNames::noframesTag,
    &HTMLNames::noscriptTag,
    &HTMLNames::objectTag,
    &HTMLNames::olTag,
    &HTMLNames::optgroupTag,
    &HTMLNames::optionTag,
    &HTMLNames::outputTag,
    &HTMLNames::pTag,
    &HTMLNames::paramTag,
    &HTMLNames::pictureTag,
    &HTMLNames::plaintextTag,
    &HTMLNames::preTag,
    &HTMLNames::progressTag,
    &HTMLNames::qTag,
    &HTMLNames::rbTag,
    &HTMLNames::rpTag,
    &HTMLNames::rtTag,
    &HTMLNames::rtcTag,
    &HTMLNames::rubyTag,
    &HTMLNames::sTag,
    &HTMLNames::sampTag,
    &HTMLNames::searchTag,
    &HTMLNames::sectionTag,
    &HTMLNames::selectTag,
    &HTMLNames::slotTag,
    &HTMLNames::smallTag,
    &HTMLNames::sourceTag,
    &HTMLNames::spanTag,
    &HTMLNames::strikeTag,
    &HTMLNames::strongTag,
    &HTMLNames::subTag,
    &HTMLNames::summaryTag,
    &HTMLNames::supTag,
    &HTMLNames::tableTag,
    &HTMLNames::tbodyTag,
    &HTMLNames::tdTag,
    &HTMLNames::templateTag,
    &HTMLNames::textareaTag,
    &HTMLNames::tfootTag,
    &HTMLNames::thTag,
    &HTMLNames::theadTag,
    &HTMLNames::timeTag,
    &HTMLNames::trTag,
    &HTMLNames::trackTag,
    &HTMLNames::ttTag,
    &HTMLNames::uTag,
    &HTMLNames::ulTag,
    &HTMLNames::varTag,
    &HTMLNames::videoTag,
    &HTMLNames::wbrTag,
    &HTMLNames::xmpTag,
    &MathMLNames::annotationTag,
    &MathMLNames::mactionTag,
    &MathMLNames::maligngroupTag,
    &MathMLNames::malignmarkTag,
    &MathMLNames::mathTag,
    &MathMLNames::mencloseTag,
    &MathMLNames::merrorTag,
    &MathMLNames::mfencedTag,
    &MathMLNames::mfracTag,
    &MathMLNames::mglyphTag,
    &MathMLNames::miTag,
    &MathMLNames::mlabeledtrTag,
    &MathMLNames::mlongdivTag,
    &MathMLNames::mmultiscriptsTag,
    &MathMLNames::mnTag,
    &MathMLNames::moTag,
    &MathMLNames::moverTag,
    &MathMLNames::mpaddedTag,
    &MathMLNames::mphantomTag,
    &MathMLNames::mprescriptsTag,
    &MathMLNames::mrootTag,
    &MathMLNames::mrowTag,
    &MathMLNames::msTag,
    &MathMLNames::mscarriesTag,
    &MathMLNames::mscarryTag,
    &MathMLNames::msgroupTag,
    &MathMLNames::mslineTag,
    &MathMLNames::mspaceTag,
    &MathMLNames::msqrtTag,
    &MathMLNames::msrowTag,
    &MathMLNames::mstackTag,
    &MathMLNames::mstyleTag,
    &MathMLNames::msubTag,
    &MathMLNames::msubsupTag,
    &MathMLNames::msupTag,
    &MathMLNames::mtableTag,
    &MathMLNames::mtdTag,
    &MathMLNames::mtextTag,
    &MathMLNames::mtrTag,
    &MathMLNames::munderTag,
    &MathMLNames::munderoverTag,
    &MathMLNames::noneTag,
    &MathMLNames::semanticsTag,
    &SVGNames::altGlyphTag,
    &SVGNames::altGlyphDefTag,
    &SVGNames::altGlyphItemTag,
    &SVGNames::animateTag,
    &SVGNames::animateColorTag,
    &SVGNames::animateMotionTag,
    &SVGNames::animateTransformTag,
    &SVGNames::circleTag,
    &SVGNames::clipPathTag,
    &SVGNames::cursorTag,
    &SVGNames::defsTag,
    &SVGNames::descTag,
    &SVGNames::ellipseTag,
    &SVGNames::feBlendTag,
    &SVGNames::feColorMatrixTag,
    &SVGNames::feComponentTransferTag,
    &SVGNames::feCompositeTag,
    &SVGNames::feConvolveMatrixTag,
    &SVGNames::feDiffuseLightingTag,
    &SVGNames::feDisplacementMapTag,
    &SVGNames::feDistantLightTag,
    &SVGNames::feDropShadowTag,
    &SVGNames::feFloodTag,
    &SVGNames::feFuncATag,
    &SVGNames::feFuncBTag,
    &SVGNames::feFuncGTag,
    &SVGNames::feFuncRTag,
    &SVGNames::feGaussianBlurTag,
    &SVGNames::feImageTag,
    &SVGNames::feMergeTag,
    &SVGNames::feMergeNodeTag,
    &SVGNames::feMorphologyTag,
    &SVGNames::feOffsetTag,
    &SVGNames::fePointLightTag,
    &SVGNames::feSpecularLightingTag,
    &SVGNames::feSpotLightTag,
    &SVGNames::feTileTag,
    &SVGNames::feTurbulenceTag,
    &SVGNames::filterTag,
    &SVGNames::foreignObjectTag,
    &SVGNames::gTag,
    &SVGNames::glyphTag,
    &SVGNames::glyphRefTag,
    &SVGNames::hkernTag,
    &SVGNames::lineTag,
    &SVGNames::linearGradientTag,
    &SVGNames::markerTag,
    &SVGNames::maskTag,
    &SVGNames::metadataTag,
    &SVGNames::mpathTag,
    &SVGNames::pathTag,
    &SVGNames::patternTag,
    &SVGNames::polygonTag,
    &SVGNames::polylineTag,
    &SVGNames::radialGradientTag,
    &SVGNames::rectTag,
    &SVGNames::setTag,
    &SVGNames::stopTag,
    &SVGNames::svgTag,
    &SVGNames::switchTag,
    &SVGNames::symbolTag,
    &SVGNames::textTag,
    &SVGNames::textPathTag,
    &SVGNames::trefTag,
    &SVGNames::tspanTag,
    &SVGNames::useTag,
    &SVGNames::viewTag,
    &SVGNames::vkernTag,
    &HTMLNames::aTag,
    &HTMLNames::annotation_xmlTag,
    &HTMLNames::fontTag,
    &HTMLNames::font_faceTag,
    &HTMLNames::font_face_formatTag,
    &HTMLNames::font_face_nameTag,
    &HTMLNames::font_face_srcTag,
    &HTMLNames::font_face_uriTag,
    &HTMLNames::imageTag,
    &HTMLNames::missing_glyphTag,
    &HTMLNames::scriptTag,
    &HTMLNames::styleTag,
    &HTMLNames::titleTag,
};

static constexpr StringImpl::StaticStringImpl unadjustedTagNames[] = {
    StringImpl::StaticStringImpl { "altglyph" },
    StringImpl::StaticStringImpl { "altglyphdef" },
    StringImpl::StaticStringImpl { "altglyphitem" },
    StringImpl::StaticStringImpl { "animatecolor" },
    StringImpl::StaticStringImpl { "animatemotion" },
    StringImpl::StaticStringImpl { "animatetransform" },
    StringImpl::StaticStringImpl { "clippath" },
    StringImpl::StaticStringImpl { "feblend" },
    StringImpl::StaticStringImpl { "fecolormatrix" },
    StringImpl::StaticStringImpl { "fecomponenttransfer" },
    StringImpl::StaticStringImpl { "fecomposite" },
    StringImpl::StaticStringImpl { "feconvolvematrix" },
    StringImpl::StaticStringImpl { "fediffuselighting" },
    StringImpl::StaticStringImpl { "fedisplacementmap" },
    StringImpl::StaticStringImpl { "fedistantlight" },
    StringImpl::StaticStringImpl { "fedropshadow" },
    StringImpl::StaticStringImpl { "feflood" },
    StringImpl::StaticStringImpl { "fefunca" },
    StringImpl::StaticStringImpl { "fefuncb" },
    StringImpl::StaticStringImpl { "fefuncg" },
    StringImpl::StaticStringImpl { "fefuncr" },
    StringImpl::StaticStringImpl { "fegaussianblur" },
    StringImpl::StaticStringImpl { "feimage" },
    StringImpl::StaticStringImpl { "femerge" },
    StringImpl::StaticStringImpl { "femergenode" },
    StringImpl::StaticStringImpl { "femorphology" },
    StringImpl::StaticStringImpl { "feoffset" },
    StringImpl::StaticStringImpl { "fepointlight" },
    StringImpl::StaticStringImpl { "fespecularlighting" },
    StringImpl::StaticStringImpl { "fespotlight" },
    StringImpl::StaticStringImpl { "fetile" },
    StringImpl::StaticStringImpl { "feturbulence" },
    StringImpl::StaticStringImpl { "foreignobject" },
    StringImpl::StaticStringImpl { "glyphref" },
    StringImpl::StaticStringImpl { "lineargradient" },
    StringImpl::StaticStringImpl { "radialgradient" },
    StringImpl::StaticStringImpl { "textpath" },
};

void initializeTagNameStrings() {
    static bool initialized = false;
    if (std::exchange(initialized, true))
        return;

    tagNameStrings.construct();
    auto tagNamesEntry = tagNameStrings->begin();
    ++tagNamesEntry; // Skip TagName::Unknown
    for (auto* qualifiedName : tagQualifiedNamePointers)
        *(tagNamesEntry++) = reinterpret_cast<LazyNeverDestroyed<QualifiedName>*>(qualifiedName)->get().localName();
    for (auto& string : unadjustedTagNames) {
        reinterpret_cast<const StringImpl&>(string).assertHashIsCorrect();
        *(tagNamesEntry++) = AtomString(&string);
    }
    ASSERT(tagNamesEntry == tagNameStrings->end());
}

template <typename characterType>
static inline TagName findTagFromBuffer(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 1: {
        switch (buffer[0]) {
        case 'a': {
            return TagName::a;
        }
        case 'b': {
            return TagName::b;
        }
        case 'g': {
            return TagName::g;
        }
        case 'i': {
            return TagName::i;
        }
        case 'p': {
            return TagName::p;
        }
        case 'q': {
            return TagName::q;
        }
        case 's': {
            return TagName::s;
        }
        case 'u': {
            return TagName::u;
        }
        default:
            break;
        }
        break;
    }
    case 2: {
        switch (buffer[0]) {
        case 'b': {
            if (buffer[1] == 'r') {
                return TagName::br;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'd': {
                return TagName::dd;
            }
            case 'l': {
                return TagName::dl;
            }
            case 't': {
                return TagName::dt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'e': {
            if (buffer[1] == 'm') {
                return TagName::em;
            }
            break;
        }
        case 'h': {
            switch (buffer[1]) {
            case '1': {
                return TagName::h1;
            }
            case '2': {
                return TagName::h2;
            }
            case '3': {
                return TagName::h3;
            }
            case '4': {
                return TagName::h4;
            }
            case '5': {
                return TagName::h5;
            }
            case '6': {
                return TagName::h6;
            }
            case 'r': {
                return TagName::hr;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            if (buffer[1] == 'i') {
                return TagName::li;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'i': {
                return TagName::mi;
            }
            case 'n': {
                return TagName::mn;
            }
            case 'o': {
                return TagName::mo;
            }
            case 's': {
                return TagName::ms;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            if (buffer[1] == 'l') {
                return TagName::ol;
            }
            break;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'b': {
                return TagName::rb;
            }
            case 'p': {
                return TagName::rp;
            }
            case 't': {
                return TagName::rt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'd': {
                return TagName::td;
            }
            case 'h': {
                return TagName::th;
            }
            case 'r': {
                return TagName::tr;
            }
            case 't': {
                return TagName::tt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'u': {
            if (buffer[1] == 'l') {
                return TagName::ul;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 'b': {
            switch (buffer[1]) {
            case 'd': {
                switch (buffer[2]) {
                case 'i': {
                    return TagName::bdi;
                }
                case 'o': {
                    return TagName::bdo;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'i': {
                if (buffer[2] == 'g') {
                    return TagName::big;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'o', 'l')) {
                return TagName::col;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 'l') {
                    return TagName::del;
                }
                break;
            }
            case 'f': {
                if (buffer[2] == 'n') {
                    return TagName::dfn;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'r': {
                    return TagName::dir;
                }
                case 'v': {
                    return TagName::div;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (buffer[2] == 'g') {
                    return TagName::img;
                }
                break;
            }
            case 'n': {
                if (buffer[2] == 's') {
                    return TagName::ins;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'b', 'd')) {
                return TagName::kbd;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (buffer[2] == 'p') {
                    return TagName::map;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'd': {
                    return TagName::mtd;
                }
                case 'r': {
                    return TagName::mtr;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'a', 'v')) {
                return TagName::nav;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'r', 'e')) {
                return TagName::pre;
            }
            break;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 't', 'c')) {
                return TagName::rtc;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 't') {
                    return TagName::set;
                }
                break;
            }
            case 'u': {
                switch (buffer[2]) {
                case 'b': {
                    return TagName::sub;
                }
                case 'p': {
                    return TagName::sup;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'v': {
                if (buffer[2] == 'g') {
                    return TagName::svg;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'u': {
            if (compareCharacters(buffer.data() + 1, 's', 'e')) {
                return TagName::use;
            }
            break;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r')) {
                return TagName::var;
            }
            break;
        }
        case 'w': {
            if (compareCharacters(buffer.data() + 1, 'b', 'r')) {
                return TagName::wbr;
            }
            break;
        }
        case 'x': {
            if (compareCharacters(buffer.data() + 1, 'm', 'p')) {
                return TagName::xmp;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'b', 'r')) {
                    return TagName::abbr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'a')) {
                    return TagName::area;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 's', 'e')) {
                    return TagName::base;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'y')) {
                    return TagName::body;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'e')) {
                    return TagName::cite;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e')) {
                    return TagName::code;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 'a')) {
                    return TagName::data;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'f': {
                    if (buffer[3] == 's') {
                        return TagName::defs;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 'c') {
                        return TagName::desc;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 't') {
                        return TagName::font;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'm') {
                        return TagName::form;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd')) {
                    return TagName::head;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'm', 'l')) {
                    return TagName::html;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'i': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 'e': {
                        return TagName::line;
                    }
                    case 'k': {
                        return TagName::link;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'i': {
                    if (buffer[3] == 'n') {
                        return TagName::main;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'k') {
                        return TagName::mark;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 'k') {
                        return TagName::mask;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'h') {
                        return TagName::math;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 'u') {
                        return TagName::menu;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'a') {
                        return TagName::meta;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'w')) {
                    return TagName::mrow;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'u': {
                    switch (buffer[3]) {
                    case 'b': {
                        return TagName::msub;
                    }
                    case 'p': {
                        return TagName::msup;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'b': {
                    if (buffer[3] == 'r') {
                        return TagName::nobr;
                    }
                    break;
                }
                case 'n': {
                    if (buffer[3] == 'e') {
                        return TagName::none;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'h')) {
                return TagName::path;
            }
            break;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'c', 't')) {
                    return TagName::rect;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'b', 'y')) {
                    return TagName::ruby;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'm', 'p')) {
                    return TagName::samp;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 't')) {
                    return TagName::slot;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'n')) {
                    return TagName::span;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'o', 'p')) {
                    return TagName::stop;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'x', 't')) {
                    return TagName::text;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'm', 'e')) {
                    return TagName::time;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'f')) {
                    return TagName::tref;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'i', 'e', 'w')) {
                return TagName::view;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'i', 'd', 'e')) {
                    return TagName::aside;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 'o')) {
                    return TagName::audio;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'm', 'b', 'e', 'd')) {
                return TagName::embed;
            }
            break;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'r', 'a', 'm', 'e')) {
                return TagName::frame;
            }
            break;
        }
        case 'g': {
            if (compareCharacters(buffer.data() + 1, 'l', 'y', 'p', 'h')) {
                return TagName::glyph;
            }
            break;
        }
        case 'h': {
            if (compareCharacters(buffer.data() + 1, 'k', 'e', 'r', 'n')) {
                return TagName::hkern;
            }
            break;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (compareCharacters(buffer.data() + 2, 'a', 'g', 'e')) {
                    return TagName::image;
                }
                break;
            }
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'p', 'u', 't')) {
                    return TagName::input;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'a', 'b', 'e', 'l')) {
                return TagName::label;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 't', 'e', 'r')) {
                    return TagName::meter;
                }
                break;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'r', 'a', 'c')) {
                    return TagName::mfrac;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'd': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'l')) {
                        return TagName::model;
                    }
                    break;
                }
                case 'v': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r')) {
                        return TagName::mover;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 't', 'h')) {
                    return TagName::mpath;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'o', 't')) {
                    return TagName::mroot;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'q': {
                    if (compareCharacters(buffer.data() + 3, 'r', 't')) {
                        return TagName::msqrt;
                    }
                    break;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'w')) {
                        return TagName::msrow;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'e', 'x', 't')) {
                    return TagName::mtext;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r', 'a', 'm')) {
                return TagName::param;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'm': {
                if (compareCharacters(buffer.data() + 2, 'a', 'l', 'l')) {
                    return TagName::small_;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'y', 'l', 'e')) {
                    return TagName::style;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'b', 'l', 'e')) {
                    return TagName::table;
                }
                break;
            }
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'o', 'd', 'y')) {
                    return TagName::tbody;
                }
                break;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'o', 'o', 't')) {
                    return TagName::tfoot;
                }
                break;
            }
            case 'h': {
                if (compareCharacters(buffer.data() + 2, 'e', 'a', 'd')) {
                    return TagName::thead;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'l', 'e')) {
                    return TagName::title;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'c', 'k')) {
                    return TagName::track;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'n')) {
                    return TagName::tspan;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e', 'o')) {
                    return TagName::video;
                }
                break;
            }
            case 'k': {
                if (compareCharacters(buffer.data() + 2, 'e', 'r', 'n')) {
                    return TagName::vkern;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'p', 'p', 'l', 'e', 't')) {
                return TagName::applet;
            }
            break;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'u', 't', 't', 'o', 'n')) {
                return TagName::button;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'v', 'a', 's')) {
                    return TagName::canvas;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'n', 't', 'e', 'r')) {
                    return TagName::center;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'r', 'c', 'l', 'e')) {
                    return TagName::circle;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'r', 's', 'o', 'r')) {
                    return TagName::cursor;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'i', 'a', 'l', 'o', 'g')) {
                return TagName::dialog;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 't', 'i', 'l', 'e')) {
                    return TagName::fetileCaseUnadjusted;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'g': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'r', 'e')) {
                        return TagName::figure;
                    }
                    break;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 't', 'e', 'r')) {
                        return TagName::filter;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'o', 't', 'e', 'r')) {
                    return TagName::footer;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd', 'e', 'r')) {
                    return TagName::header;
                }
                break;
            }
            case 'g': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'u', 'p')) {
                    return TagName::hgroup;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'i': {
            if (compareCharacters(buffer.data() + 1, 'f', 'r', 'a', 'm', 'e')) {
                return TagName::iframe;
            }
            break;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'e', 'y', 'g', 'e', 'n')) {
                return TagName::keygen;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'e', 'g', 'e', 'n', 'd')) {
                return TagName::legend;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'r', 'k', 'e', 'r')) {
                    return TagName::marker;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'r', 'r', 'o', 'r')) {
                    return TagName::merror;
                }
                break;
            }
            case 'g': {
                if (compareCharacters(buffer.data() + 2, 'l', 'y', 'p', 'h')) {
                    return TagName::mglyph;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'n', 'e')) {
                        return TagName::msline;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'c', 'e')) {
                        return TagName::mspace;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (compareCharacters(buffer.data() + 4, 'c', 'k')) {
                            return TagName::mstack;
                        }
                        break;
                    }
                    case 'y': {
                        if (compareCharacters(buffer.data() + 4, 'l', 'e')) {
                            return TagName::mstyle;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'a', 'b', 'l', 'e')) {
                    return TagName::mtable;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'n', 'd', 'e', 'r')) {
                    return TagName::munder;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'j', 'e', 'c', 't')) {
                    return TagName::object;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 't', 'i', 'o', 'n')) {
                    return TagName::option;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 't', 'p', 'u', 't')) {
                    return TagName::output;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'i', 'p', 't')) {
                    return TagName::script;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'c', 'h')) {
                        return TagName::search;
                    }
                    break;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'c', 't')) {
                        return TagName::select;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'u', 'r', 'c', 'e')) {
                    return TagName::source;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'i': {
                        if (compareCharacters(buffer.data() + 4, 'k', 'e')) {
                            return TagName::strike;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'n', 'g')) {
                            return TagName::strong;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'w': {
                if (compareCharacters(buffer.data() + 2, 'i', 't', 'c', 'h')) {
                    return TagName::switch_;
                }
                break;
            }
            case 'y': {
                if (compareCharacters(buffer.data() + 2, 'm', 'b', 'o', 'l')) {
                    return TagName::symbol;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'n', 'y', 'm')) {
                    return TagName::acronym;
                }
                break;
            }
            case 'd': {
                if (compareCharacters(buffer.data() + 2, 'd', 'r', 'e', 's', 's')) {
                    return TagName::address;
                }
                break;
            }
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'i', 'm', 'a', 't', 'e')) {
                    return TagName::animate;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 't', 'i', 'c', 'l', 'e')) {
                    return TagName::article;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'g', 's', 'o', 'u', 'n', 'd')) {
                return TagName::bgsound;
            }
            break;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'a', 'p', 't', 'i', 'o', 'n')) {
                return TagName::caption;
            }
            break;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'e', 't', 'a', 'i', 'l', 's')) {
                return TagName::details;
            }
            break;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'l', 'l', 'i', 'p', 's', 'e')) {
                return TagName::ellipse;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'b': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'e', 'n', 'd')) {
                        return TagName::feblendCaseUnadjusted;
                    }
                    break;
                }
                case 'f': {
                    switch (buffer[3]) {
                    case 'l': {
                        if (compareCharacters(buffer.data() + 4, 'o', 'o', 'd')) {
                            return TagName::fefloodCaseUnadjusted;
                        }
                        break;
                    }
                    case 'u': {
                        switch (buffer[4]) {
                        case 'n': {
                            switch (buffer[5]) {
                            case 'c': {
                                switch (buffer[6]) {
                                case 'a': {
                                    return TagName::fefuncaCaseUnadjusted;
                                }
                                case 'b': {
                                    return TagName::fefuncbCaseUnadjusted;
                                }
                                case 'g': {
                                    return TagName::fefuncgCaseUnadjusted;
                                }
                                case 'r': {
                                    return TagName::fefuncrCaseUnadjusted;
                                }
                                default:
                                    break;
                                }
                                return TagName::Unknown;
                            }
                            default:
                                break;
                            }
                            return TagName::Unknown;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                case 'i': {
                    if (compareCharacters(buffer.data() + 3, 'm', 'a', 'g', 'e')) {
                        return TagName::feimageCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 'g', 'e')) {
                        return TagName::femergeCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'i', 's', 't', 'i', 'n', 'g')) {
                return TagName::listing;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 't', 'i', 'o', 'n')) {
                        return TagName::maction;
                    }
                    break;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'q', 'u', 'e', 'e')) {
                        return TagName::marquee;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'e', 'n', 'c', 'e', 'd')) {
                    return TagName::mfenced;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd', 'd', 'e', 'd')) {
                    return TagName::mpadded;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'r', 'r', 'y')) {
                        return TagName::mscarry;
                    }
                    break;
                }
                case 'g': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'o', 'u', 'p')) {
                        return TagName::msgroup;
                    }
                    break;
                }
                case 'u': {
                    if (compareCharacters(buffer.data() + 3, 'b', 's', 'u', 'p')) {
                        return TagName::msubsup;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 'e', 'm', 'b', 'e', 'd')) {
                return TagName::noembed;
            }
            break;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 't', 'e', 'r', 'n')) {
                    return TagName::pattern;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'c', 't', 'u', 'r', 'e')) {
                    return TagName::picture;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'l', 'y', 'g', 'o', 'n')) {
                    return TagName::polygon;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'c', 't', 'i', 'o', 'n')) {
                    return TagName::section;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'm', 'm', 'a', 'r', 'y')) {
                    return TagName::summary;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'l', 't', 'g', 'l', 'y', 'p', 'h')) {
                return TagName::altglyphCaseUnadjusted;
            }
            break;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'a', 's', 'e', 'f', 'o', 'n', 't')) {
                return TagName::basefont;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'i', 'p', 'p', 'a', 't', 'h')) {
                    return TagName::clippathCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'l', 'g', 'r', 'o', 'u', 'p')) {
                    return TagName::colgroup;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'a', 'l', 'i', 's', 't')) {
                return TagName::datalist;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'o', 'f', 'f', 's', 'e', 't')) {
                    return TagName::feoffsetCaseUnadjusted;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'e', 'l', 'd', 's', 'e', 't')) {
                    return TagName::fieldset;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'm', 'e', 's', 'e', 't')) {
                    return TagName::frameset;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'g': {
            if (compareCharacters(buffer.data() + 1, 'l', 'y', 'p', 'h', 'r', 'e', 'f')) {
                return TagName::glyphrefCaseUnadjusted;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'n': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'l', 'o', 's', 'e')) {
                        return TagName::menclose;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'd', 'a', 't', 'a')) {
                        return TagName::metadata;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 'n', 'g', 'd', 'i', 'v')) {
                    return TagName::mlongdiv;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'h', 'a', 'n', 't', 'o', 'm')) {
                    return TagName::mphantom;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'a', 'm', 'e', 's')) {
                        return TagName::noframes;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'r', 'i', 'p', 't')) {
                        return TagName::noscript;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            if (compareCharacters(buffer.data() + 1, 'p', 't', 'g', 'r', 'o', 'u', 'p')) {
                return TagName::optgroup;
            }
            break;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'l', 'y', 'l', 'i', 'n', 'e')) {
                    return TagName::polyline;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'g', 'r', 'e', 's', 's')) {
                    return TagName::progress;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'l', 'a', 't', 'e')) {
                        return TagName::template_;
                    }
                    break;
                }
                case 'x': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case 'a': {
                            if (compareCharacters(buffer.data() + 5, 'r', 'e', 'a')) {
                                return TagName::textarea;
                            }
                            break;
                        }
                        case 'p': {
                            if (compareCharacters(buffer.data() + 5, 'a', 't', 'h')) {
                                return TagName::textpathCaseUnadjusted;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        switch (buffer[0]) {
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'o', 'n', 't', '-', 'f', 'a', 'c', 'e')) {
                return TagName::font_face;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 's', 'c', 'a', 'r', 'r', 'i', 'e', 's')) {
                return TagName::mscarries;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'l', 'a', 'i', 'n', 't', 'e', 'x', 't')) {
                return TagName::plaintext;
            }
            break;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 'e', 'm', 'a', 'n', 't', 'i', 'c', 's')) {
                return TagName::semantics;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 10: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'n', 'o', 't', 'a', 't', 'i', 'o', 'n')) {
                    return TagName::annotation;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 't', 'a', 'c', 'h', 'm', 'e', 'n', 't')) {
                    return TagName::attachment;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            static constexpr characterType rest[] = { 'l', 'o', 'c', 'k', 'q', 'u', 'o', 't', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 9)) {
                return TagName::blockquote;
            }
            break;
        }
        case 'f': {
            static constexpr characterType rest[] = { 'i', 'g', 'c', 'a', 'p', 't', 'i', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 9)) {
                return TagName::figcaption;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'l', 'i', 'g', 'n', 'm', 'a', 'r', 'k')) {
                    return TagName::malignmark;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'a', 'b', 'e', 'l', 'e', 'd', 't', 'r')) {
                    return TagName::mlabeledtr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'n', 'd', 'e', 'r', 'o', 'v', 'e', 'r')) {
                    return TagName::munderover;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 11: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'l', 't', 'g', 'l', 'y', 'p', 'h', 'd', 'e', 'f', };
            if (WTF::equal(buffer.data() + 1, rest, 10)) {
                return TagName::altglyphdefCaseUnadjusted;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'm', 'p', 'o', 's', 'i', 't', 'e')) {
                        return TagName::fecompositeCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 'g', 'e', 'n', 'o', 'd', 'e')) {
                        return TagName::femergenodeCaseUnadjusted;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'o', 't', 'l', 'i', 'g', 'h', 't')) {
                        return TagName::fespotlightCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'l', 'i', 'g', 'n', 'g', 'r', 'o', 'u', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 9)) {
                    return TagName::maligngroup;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'r', 'e', 's', 'c', 'r', 'i', 'p', 't', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 9)) {
                    return TagName::mprescripts;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 12: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                static constexpr characterType rest[] = { 't', 'g', 'l', 'y', 'p', 'h', 'i', 't', 'e', 'm', };
                if (WTF::equal(buffer.data() + 2, rest, 10)) {
                    return TagName::altglyphitemCaseUnadjusted;
                }
                break;
            }
            case 'n': {
                static constexpr characterType rest[] = { 'i', 'm', 'a', 't', 'e', 'c', 'o', 'l', 'o', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 10)) {
                    return TagName::animatecolorCaseUnadjusted;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    static constexpr characterType rest[] = { 'r', 'o', 'p', 's', 'h', 'a', 'd', 'o', 'w', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::fedropshadowCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    static constexpr characterType rest[] = { 'o', 'r', 'p', 'h', 'o', 'l', 'o', 'g', 'y', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::femorphologyCaseUnadjusted;
                    }
                    break;
                }
                case 'p': {
                    static constexpr characterType rest[] = { 'o', 'i', 'n', 't', 'l', 'i', 'g', 'h', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::fepointlightCaseUnadjusted;
                    }
                    break;
                }
                case 't': {
                    static constexpr characterType rest[] = { 'u', 'r', 'b', 'u', 'l', 'e', 'n', 'c', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::feturbulenceCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'i', 'm', 'a', 't', 'e', 'm', 'o', 't', 'i', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 12)) {
                return TagName::animatemotionCaseUnadjusted;
            }
            break;
        }
        case 'c': {
            static constexpr characterType rest[] = { 'o', 'l', 'o', 'r', '-', 'p', 'r', 'o', 'f', 'i', 'l', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 12)) {
                return TagName::color_profile;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 'o', 'l', 'o', 'r', 'm', 'a', 't', 'r', 'i', 'x', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::fecolormatrixCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'f': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'c': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            switch (buffer[9]) {
                                            case '-': {
                                                switch (buffer[10]) {
                                                case 's': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'c')) {
                                                        return TagName::font_face_src;
                                                    }
                                                    break;
                                                }
                                                case 'u': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'i')) {
                                                        return TagName::font_face_uri;
                                                    }
                                                    break;
                                                }
                                                default:
                                                    break;
                                                }
                                                return TagName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return TagName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return TagName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return TagName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return TagName::Unknown;
                            }
                            default:
                                break;
                            }
                            return TagName::Unknown;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                case 'r': {
                    static constexpr characterType rest[] = { 'e', 'i', 'g', 'n', 'o', 'b', 'j', 'e', 'c', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 10)) {
                        return TagName::foreignobjectCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'i': {
                static constexpr characterType rest[] = { 's', 's', 'i', 'n', 'g', '-', 'g', 'l', 'y', 'p', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::missing_glyph;
                }
                break;
            }
            case 'm': {
                static constexpr characterType rest[] = { 'u', 'l', 't', 'i', 's', 'c', 'r', 'i', 'p', 't', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::mmultiscripts;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 14: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', '-', 'x', 'm', 'l', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::annotation_xml;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    static constexpr characterType rest[] = { 'i', 's', 't', 'a', 'n', 't', 'l', 'i', 'g', 'h', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 11)) {
                        return TagName::fedistantlightCaseUnadjusted;
                    }
                    break;
                }
                case 'g': {
                    static constexpr characterType rest[] = { 'a', 'u', 's', 's', 'i', 'a', 'n', 'b', 'l', 'u', 'r', };
                    if (WTF::equal(buffer.data() + 3, rest, 11)) {
                        return TagName::fegaussianblurCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'n', 't', '-', 'f', 'a', 'c', 'e', '-', 'n', 'a', 'm', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 12)) {
                    return TagName::font_face_name;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            static constexpr characterType rest[] = { 'i', 'n', 'e', 'a', 'r', 'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::lineargradientCaseUnadjusted;
            }
            break;
        }
        case 'r': {
            static constexpr characterType rest[] = { 'a', 'd', 'i', 'a', 'l', 'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::radialgradientCaseUnadjusted;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 16: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'i', 'm', 'a', 't', 'e', 't', 'r', 'a', 'n', 's', 'f', 'o', 'r', 'm', };
            if (WTF::equal(buffer.data() + 1, rest, 15)) {
                return TagName::animatetransformCaseUnadjusted;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 'o', 'n', 'v', 'o', 'l', 'v', 'e', 'm', 'a', 't', 'r', 'i', 'x', };
                if (WTF::equal(buffer.data() + 2, rest, 14)) {
                    return TagName::feconvolvematrixCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'n', 't', '-', 'f', 'a', 'c', 'e', '-', 'f', 'o', 'r', 'm', 'a', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 14)) {
                    return TagName::font_face_format;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 17: {
        switch (buffer[0]) {
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    switch (buffer[3]) {
                    case 'i': {
                        switch (buffer[4]) {
                        case 'f': {
                            static constexpr characterType rest[] = { 'f', 'u', 's', 'e', 'l', 'i', 'g', 'h', 't', 'i', 'n', 'g', };
                            if (WTF::equal(buffer.data() + 5, rest, 12)) {
                                return TagName::fediffuselightingCaseUnadjusted;
                            }
                            break;
                        }
                        case 's': {
                            static constexpr characterType rest[] = { 'p', 'l', 'a', 'c', 'e', 'm', 'e', 'n', 't', 'm', 'a', 'p', };
                            if (WTF::equal(buffer.data() + 5, rest, 12)) {
                                return TagName::fedisplacementmapCaseUnadjusted;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 18: {
        static constexpr characterType rest[] = { 'f', 'e', 's', 'p', 'e', 'c', 'u', 'l', 'a', 'r', 'l', 'i', 'g', 'h', 't', 'i', 'n', 'g', };
        if (WTF::equal(buffer.data(), rest, 18)) {
            return TagName::fespecularlightingCaseUnadjusted;
        }
        break;
    }
    case 19: {
        static constexpr characterType rest[] = { 'f', 'e', 'c', 'o', 'm', 'p', 'o', 'n', 'e', 'n', 't', 't', 'r', 'a', 'n', 's', 'f', 'e', 'r', };
        if (WTF::equal(buffer.data(), rest, 19)) {
            return TagName::fecomponenttransferCaseUnadjusted;
        }
        break;
    }
    default:
        break;
    };
    return TagName::Unknown;
}

TagName findTagName(std::span<const UChar> buffer)
{
    return findTagFromBuffer(buffer);
}

#if ASSERT_ENABLED
TagName findTagName(const String& name)
{
    if (name.is8Bit())
        return findTagFromBuffer(std::span(name.characters8(), name.length()));
    return findTagFromBuffer(std::span(name.characters16(), name.length()));
}
#endif

} // namespace WebCore
