/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestUpload.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestUploadConstructor);

class JSXMLHttpRequestUploadPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestUploadPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestUploadPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestUploadPrototype>(vm)) JSXMLHttpRequestUploadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestUploadPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestUploadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestUploadPrototype, JSXMLHttpRequestUploadPrototype::Base);

using JSXMLHttpRequestUploadDOMConstructor = JSDOMConstructorNotConstructable<JSXMLHttpRequestUpload>;

template<> const ClassInfo JSXMLHttpRequestUploadDOMConstructor::s_info = { "XMLHttpRequestUpload"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadDOMConstructor) };

template<> JSValue JSXMLHttpRequestUploadDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestUploadDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XMLHttpRequestUpload"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestUpload::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestUploadConstructor, 0 } },
};

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUpload"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadPrototype) };

void JSXMLHttpRequestUploadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestUpload::info(), JSXMLHttpRequestUploadPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUpload) };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestUpload>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<XMLHttpRequestUpload> JSXMLHttpRequestUpload::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, XMLHttpRequestUpload>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXMLHttpRequestUpload::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXMLHttpRequestUploadPrototype::createStructure(vm, &globalObject, JSXMLHttpRequestEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSXMLHttpRequestUploadPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXMLHttpRequestUpload::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(vm, globalObject);
}

JSValue JSXMLHttpRequestUpload::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestUploadDOMConstructor, DOMConstructorID::XMLHttpRequestUpload>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestUploadConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestUploadPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequestUpload::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSXMLHttpRequestUpload::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXMLHttpRequestUpload, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXMLHttpRequestUpload.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXMLHttpRequestUpload = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXMLHttpRequestUpload.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXMLHttpRequestUpload = std::forward<decltype(space)>(space); }
    );
}

void JSXMLHttpRequestUpload::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXMLHttpRequestUploadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    XMLHttpRequestUpload* owner = &jsXMLHttpRequestUpload->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from XMLHttpRequestUpload";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSXMLHttpRequestUploadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequestUpload = static_cast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequestUpload->wrapped(), jsXMLHttpRequestUpload);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequestUpload@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20XMLHttpRequestUploadE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XMLHttpRequestUpload>&& impl)
{

    if constexpr (std::is_polymorphic_v<XMLHttpRequestUpload>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XMLHttpRequestUpload@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20XMLHttpRequestUploadE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XMLHttpRequestUpload has subclasses. If XMLHttpRequestUpload has subclasses that get passed
        // to toJS() we currently require XMLHttpRequestUpload you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<XMLHttpRequestUpload>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
