/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequest.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSEventListener.h"
#include "JSURLSearchParams.h"
#include "JSXMLHttpRequestUpload.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(XMLHttpRequest::ResponseType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("arraybuffer"),
        MAKE_STATIC_STRING_IMPL("blob"),
        MAKE_STATIC_STRING_IMPL("document"),
        MAKE_STATIC_STRING_IMPL("json"),
        MAKE_STATIC_STRING_IMPL("text"),
    };
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::EmptyString) == 0, "XMLHttpRequest::ResponseType::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Arraybuffer) == 1, "XMLHttpRequest::ResponseType::Arraybuffer is not 1 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Blob) == 2, "XMLHttpRequest::ResponseType::Blob is not 2 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Document) == 3, "XMLHttpRequest::ResponseType::Document is not 3 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Json) == 4, "XMLHttpRequest::ResponseType::Json is not 4 as expected");
    static_assert(static_cast<size_t>(XMLHttpRequest::ResponseType::Text) == 5, "XMLHttpRequest::ResponseType::Text is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, XMLHttpRequest::ResponseType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<XMLHttpRequest::ResponseType> parseEnumerationFromString<XMLHttpRequest::ResponseType>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return XMLHttpRequest::ResponseType::EmptyString;
    static constexpr std::pair<ComparableASCIILiteral, XMLHttpRequest::ResponseType> mappings[] = {
        { "arraybuffer", XMLHttpRequest::ResponseType::Arraybuffer },
        { "blob", XMLHttpRequest::ResponseType::Blob },
        { "document", XMLHttpRequest::ResponseType::Document },
        { "json", XMLHttpRequest::ResponseType::Json },
        { "text", XMLHttpRequest::ResponseType::Text },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<XMLHttpRequest::ResponseType> parseEnumeration<XMLHttpRequest::ResponseType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<XMLHttpRequest::ResponseType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<XMLHttpRequest::ResponseType>()
{
    return "\"\", \"arraybuffer\", \"blob\", \"document\", \"json\", \"text\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_open);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_setRequestHeader);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_send);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_abort);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_getResponseHeader);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_getAllResponseHeaders);
static JSC_DECLARE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_overrideMimeType);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_onreadystatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequest_onreadystatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_timeout);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequest_timeout);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_withCredentials);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequest_withCredentials);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_upload);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_responseURL);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_status);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_statusText);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_responseType);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequest_responseType);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_response);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_responseText);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequest_responseXML);

class JSXMLHttpRequestPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestPrototype>(vm)) JSXMLHttpRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestPrototype, JSXMLHttpRequestPrototype::Base);

using JSXMLHttpRequestDOMConstructor = JSDOMConstructor<JSXMLHttpRequest>;

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestConstructorTableValues[] =
{
    { "UNSENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "OPENED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "HEADERS_RECEIVED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "DONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

static_assert(XMLHttpRequest::UNSENT == 0, "UNSENT in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::OPENED == 1, "OPENED in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::HEADERS_RECEIVED == 2, "HEADERS_RECEIVED in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::LOADING == 3, "LOADING in XMLHttpRequest does not match value from IDL");
static_assert(XMLHttpRequest::DONE == 4, "DONE in XMLHttpRequest does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSXMLHttpRequestDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSXMLHttpRequestDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "XMLHttpRequest");
    auto object = XMLHttpRequest::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<XMLHttpRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<XMLHttpRequest>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSXMLHttpRequestDOMConstructorConstruct, JSXMLHttpRequestDOMConstructor::construct);

template<> const ClassInfo JSXMLHttpRequestDOMConstructor::s_info = { "XMLHttpRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestDOMConstructor) };

template<> JSValue JSXMLHttpRequestDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XMLHttpRequest"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequest::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSXMLHttpRequest::info(), JSXMLHttpRequestConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestConstructor, 0 } },
    { "onreadystatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_onreadystatechange, setJSXMLHttpRequest_onreadystatechange } },
    { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_readyState, 0 } },
    { "timeout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_timeout, setJSXMLHttpRequest_timeout } },
    { "withCredentials"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_withCredentials, setJSXMLHttpRequest_withCredentials } },
    { "upload"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_upload, 0 } },
    { "responseURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_responseURL, 0 } },
    { "status"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_status, 0 } },
    { "statusText"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_statusText, 0 } },
    { "responseType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_responseType, setJSXMLHttpRequest_responseType } },
    { "response"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_response, 0 } },
    { "responseText"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_responseText, 0 } },
    { "responseXML"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequest_responseXML, 0 } },
    { "open"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_open, 2 } },
    { "setRequestHeader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_setRequestHeader, 2 } },
    { "send"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_send, 0 } },
    { "abort"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_abort, 0 } },
    { "getResponseHeader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_getResponseHeader, 1 } },
    { "getAllResponseHeaders"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_getAllResponseHeaders, 0 } },
    { "overrideMimeType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXMLHttpRequestPrototypeFunction_overrideMimeType, 1 } },
    { "UNSENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "OPENED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "HEADERS_RECEIVED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "DONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

const ClassInfo JSXMLHttpRequestPrototype::s_info = { "XMLHttpRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestPrototype) };

void JSXMLHttpRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequest::info(), JSXMLHttpRequestPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(globalObject())->inherits<JSDOMWindowBase>()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "responseXML"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXMLHttpRequest::s_info = { "XMLHttpRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequest) };

JSXMLHttpRequest::JSXMLHttpRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequest>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<XMLHttpRequest> JSXMLHttpRequest::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, XMLHttpRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

void JSXMLHttpRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSXMLHttpRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXMLHttpRequestPrototype::createStructure(vm, &globalObject, JSXMLHttpRequestEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSXMLHttpRequestPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXMLHttpRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequest>(vm, globalObject);
}

JSValue JSXMLHttpRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestDOMConstructor, DOMConstructorID::XMLHttpRequest>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsXMLHttpRequest_onreadystatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().readystatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_onreadystatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_onreadystatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequest_onreadystatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().readystatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequest_onreadystatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequest_onreadystatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_timeoutGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.timeout())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_timeout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_timeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequest_timeoutSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTimeout(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequest_timeout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequest_timeoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_withCredentialsGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.withCredentials())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_withCredentials, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_withCredentialsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequest_withCredentialsSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWithCredentials(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequest_withCredentials, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequest_withCredentialsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_uploadGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<XMLHttpRequestUpload>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upload())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_upload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_uploadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_responseURLGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.responseURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_responseURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_responseURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_statusGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.status())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_status, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_statusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_statusTextGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.statusText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_statusText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_statusTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_responseTypeGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<XMLHttpRequest::ResponseType>>(lexicalGlobalObject, throwScope, impl.responseType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_responseType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_responseTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequest_responseTypeSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<XMLHttpRequest::ResponseType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setResponseType(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequest_responseType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::set<setJSXMLHttpRequest_responseTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_responseGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.response(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_response, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_responseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_responseTextGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.responseText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_responseText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_responseTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequest_responseXMLGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequest& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Document>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.responseXML())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequest_responseXML, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequest>::get<jsXMLHttpRequest_responseXMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_open1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto method = convert<IDLByteString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.open(WTFMove(method), WTFMove(url)); })));
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_open2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto method = convert<IDLByteString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto async = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto user = argument3.value().isUndefined() ? String() : convert<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto password = argument4.value().isUndefined() ? String() : convert<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.open(WTFMove(method), WTFMove(url), WTFMove(async), WTFMove(user), WTFMove(password)); })));
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_openOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsXMLHttpRequestPrototypeFunction_open1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsXMLHttpRequestPrototypeFunction_open2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 4) {
        RELEASE_AND_RETURN(throwScope, (jsXMLHttpRequestPrototypeFunction_open2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsXMLHttpRequestPrototypeFunction_open2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_open, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_openOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_setRequestHeaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto header = convert<IDLByteString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto value = convert<IDLByteString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setRequestHeader(WTFMove(header), WTFMove(value)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_setRequestHeader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_setRequestHeaderBody>(*lexicalGlobalObject, *callFrame, "setRequestHeader");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_sendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto body = argument0.value().isUndefined() ? std::nullopt : convert<IDLNullable<IDLUnion<IDLInterface<Document>, IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLUSVString, IDLInterface<URLSearchParams>>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.send(WTFMove(body)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_send, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_sendBody>(*lexicalGlobalObject, *callFrame, "send");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_abortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.abort(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_abort, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_abortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_getResponseHeaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLByteString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLByteString>>(*lexicalGlobalObject, throwScope, impl.getResponseHeader(WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_getResponseHeader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_getResponseHeaderBody>(*lexicalGlobalObject, *callFrame, "getResponseHeader");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_getAllResponseHeadersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLByteString>(*lexicalGlobalObject, throwScope, impl.getAllResponseHeaders())));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_getAllResponseHeaders, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_getAllResponseHeadersBody>(*lexicalGlobalObject, *callFrame, "getAllResponseHeaders");
}

static inline JSC::EncodedJSValue jsXMLHttpRequestPrototypeFunction_overrideMimeTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXMLHttpRequest>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mime = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.overrideMimeType(WTFMove(mime)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXMLHttpRequestPrototypeFunction_overrideMimeType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXMLHttpRequest>::call<jsXMLHttpRequestPrototypeFunction_overrideMimeTypeBody>(*lexicalGlobalObject, *callFrame, "overrideMimeType");
}

JSC::GCClient::IsoSubspace* JSXMLHttpRequest::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXMLHttpRequest, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXMLHttpRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXMLHttpRequest = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXMLHttpRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXMLHttpRequest = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSXMLHttpRequest::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
    visitor.append(thisObject->m_response);
}

DEFINE_VISIT_CHILDREN(JSXMLHttpRequest);

template<typename Visitor>
void JSXMLHttpRequest::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSXMLHttpRequest::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSXMLHttpRequest::visitOutputConstraints(JSCell*, SlotVisitor&);
size_t JSXMLHttpRequest::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSXMLHttpRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXMLHttpRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsXMLHttpRequest = jsCast<JSXMLHttpRequest*>(handle.slot()->asCell());
    auto& wrapped = jsXMLHttpRequest->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXMLHttpRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequest = static_cast<JSXMLHttpRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequest->wrapped(), jsXMLHttpRequest);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14XMLHttpRequestE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XMLHttpRequest>&& impl)
{

    if constexpr (std::is_polymorphic_v<XMLHttpRequest>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XMLHttpRequest@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14XMLHttpRequestE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XMLHttpRequest has subclasses. If XMLHttpRequest has subclasses that get passed
        // to toJS() we currently require XMLHttpRequest you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<XMLHttpRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XMLHttpRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XMLHttpRequest* JSXMLHttpRequest::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
