/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> WheelEvent::Init convertDictionary<WheelEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WheelEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!altKeyValue.isUndefined()) {
        result.altKey = convert<IDLBoolean>(lexicalGlobalObject, altKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.altKey = false;
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ctrlKeyValue.isUndefined()) {
        result.ctrlKey = convert<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ctrlKey = false;
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!metaKeyValue.isUndefined()) {
        result.metaKey = convert<IDLBoolean>(lexicalGlobalObject, metaKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.metaKey = false;
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierAltGraphValue.isUndefined()) {
        result.modifierAltGraph = convert<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierAltGraph = false;
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierCapsLockValue.isUndefined()) {
        result.modifierCapsLock = convert<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierCapsLock = false;
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shiftKeyValue.isUndefined()) {
        result.shiftKey = convert<IDLBoolean>(lexicalGlobalObject, shiftKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shiftKey = false;
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonValue.isUndefined()) {
        result.button = convert<IDLShort>(lexicalGlobalObject, buttonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.button = 0;
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonsValue.isUndefined()) {
        result.buttons = convert<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.buttons = 0;
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientXValue.isUndefined()) {
        result.clientX = convert<IDLLong>(lexicalGlobalObject, clientXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientX = 0;
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientYValue.isUndefined()) {
        result.clientY = convert<IDLLong>(lexicalGlobalObject, clientYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientY = 0;
    JSValue movementXValue;
    if (isNullOrUndefined)
        movementXValue = jsUndefined();
    else {
        movementXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!movementXValue.isUndefined()) {
        result.movementX = convert<IDLDouble>(lexicalGlobalObject, movementXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.movementX = 0;
    JSValue movementYValue;
    if (isNullOrUndefined)
        movementYValue = jsUndefined();
    else {
        movementYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!movementYValue.isUndefined()) {
        result.movementY = convert<IDLDouble>(lexicalGlobalObject, movementYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.movementY = 0;
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!relatedTargetValue.isUndefined()) {
        result.relatedTarget = convert<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.relatedTarget = nullptr;
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenXValue.isUndefined()) {
        result.screenX = convert<IDLLong>(lexicalGlobalObject, screenXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenX = 0;
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenYValue.isUndefined()) {
        result.screenY = convert<IDLLong>(lexicalGlobalObject, screenYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenY = 0;
    JSValue deltaModeValue;
    if (isNullOrUndefined)
        deltaModeValue = jsUndefined();
    else {
        deltaModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaModeValue.isUndefined()) {
        result.deltaMode = convert<IDLUnsignedLong>(lexicalGlobalObject, deltaModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaMode = 0;
    JSValue deltaXValue;
    if (isNullOrUndefined)
        deltaXValue = jsUndefined();
    else {
        deltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaXValue.isUndefined()) {
        result.deltaX = convert<IDLDouble>(lexicalGlobalObject, deltaXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaX = 0.0;
    JSValue deltaYValue;
    if (isNullOrUndefined)
        deltaYValue = jsUndefined();
    else {
        deltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaYValue.isUndefined()) {
        result.deltaY = convert<IDLDouble>(lexicalGlobalObject, deltaYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaY = 0.0;
    JSValue deltaZValue;
    if (isNullOrUndefined)
        deltaZValue = jsUndefined();
    else {
        deltaZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaZ"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deltaZValue.isUndefined()) {
        result.deltaZ = convert<IDLDouble>(lexicalGlobalObject, deltaZValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deltaZ = 0.0;
    JSValue wheelDeltaXValue;
    if (isNullOrUndefined)
        wheelDeltaXValue = jsUndefined();
    else {
        wheelDeltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!wheelDeltaXValue.isUndefined()) {
        result.wheelDeltaX = convert<IDLLong>(lexicalGlobalObject, wheelDeltaXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.wheelDeltaX = 0;
    JSValue wheelDeltaYValue;
    if (isNullOrUndefined)
        wheelDeltaYValue = jsUndefined();
    else {
        wheelDeltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!wheelDeltaYValue.isUndefined()) {
        result.wheelDeltaY = convert<IDLLong>(lexicalGlobalObject, wheelDeltaYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.wheelDeltaY = 0;
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWheelEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaX);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaY);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaZ);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaMode);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaX);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaY);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDelta);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_webkitDirectionInvertedFromDevice);

class JSWheelEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWheelEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWheelEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWheelEventPrototype>(vm)) JSWheelEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWheelEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWheelEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWheelEventPrototype, JSWheelEventPrototype::Base);

using JSWheelEventDOMConstructor = JSDOMConstructor<JSWheelEvent>;

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[] =
{
    { "DOM_DELTA_PIXEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    { "DOM_DELTA_LINE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOM_DELTA_PAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
};

static_assert(WheelEvent::DOM_DELTA_PIXEL == 0x00, "DOM_DELTA_PIXEL in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_LINE == 0x01, "DOM_DELTA_LINE in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_PAGE == 0x02, "DOM_DELTA_PAGE in WheelEvent does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWheelEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWheelEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDict = convert<IDLDictionary<WheelEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WheelEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WheelEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WheelEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWheelEventDOMConstructorConstruct, JSWheelEventDOMConstructor::construct);

template<> const ClassInfo JSWheelEventDOMConstructor::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventDOMConstructor) };

template<> JSValue JSWheelEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSWheelEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WheelEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWheelEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEventConstructor, 0 } },
    { "deltaX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaX, 0 } },
    { "deltaY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaY, 0 } },
    { "deltaZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaZ, 0 } },
    { "deltaMode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaMode, 0 } },
    { "wheelDeltaX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDeltaX, 0 } },
    { "wheelDeltaY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDeltaY, 0 } },
    { "wheelDelta"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDelta, 0 } },
    { "webkitDirectionInvertedFromDevice"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_webkitDirectionInvertedFromDevice, 0 } },
    { "DOM_DELTA_PIXEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    { "DOM_DELTA_LINE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOM_DELTA_PAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
};

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

void JSWheelEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WheelEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<WheelEvent> JSWheelEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, WheelEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWheelEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWheelEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWheelEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWheelEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWheelEvent>(vm, globalObject);
}

JSValue JSWheelEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventDOMConstructor, DOMConstructorID::WheelEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWheelEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWheelEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWheelEvent_deltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaZGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaModeGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.deltaMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDelta())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDelta, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_webkitDirectionInvertedFromDeviceGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitDirectionInvertedFromDevice())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_webkitDirectionInvertedFromDevice, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_webkitDirectionInvertedFromDeviceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSWheelEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWheelEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWheelEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWheelEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWheelEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWheelEvent = std::forward<decltype(space)>(space); }
    );
}

void JSWheelEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWheelEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WheelEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10WheelEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WheelEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<WheelEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WheelEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10WheelEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WheelEvent has subclasses. If WheelEvent has subclasses that get passed
        // to toJS() we currently require WheelEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WheelEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WheelEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
