/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include "JSWebTransportCongestionControl.h"
#include "JSWebTransportHash.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> WebTransportOptions convertDictionary<WebTransportOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebTransportOptions result;
    JSValue allowPoolingValue;
    if (isNullOrUndefined)
        allowPoolingValue = jsUndefined();
    else {
        allowPoolingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "allowPooling"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!allowPoolingValue.isUndefined()) {
        result.allowPooling = convert<IDLBoolean>(lexicalGlobalObject, allowPoolingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.allowPooling = false;
    JSValue congestionControlValue;
    if (isNullOrUndefined)
        congestionControlValue = jsUndefined();
    else {
        congestionControlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "congestionControl"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!congestionControlValue.isUndefined()) {
        result.congestionControl = convert<IDLEnumeration<WebTransportCongestionControl>>(lexicalGlobalObject, congestionControlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.congestionControl = WebTransportCongestionControl::Default;
    JSValue requireUnreliableValue;
    if (isNullOrUndefined)
        requireUnreliableValue = jsUndefined();
    else {
        requireUnreliableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requireUnreliable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requireUnreliableValue.isUndefined()) {
        result.requireUnreliable = convert<IDLBoolean>(lexicalGlobalObject, requireUnreliableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requireUnreliable = false;
    JSValue serverCertificateHashesValue;
    if (isNullOrUndefined)
        serverCertificateHashesValue = jsUndefined();
    else {
        serverCertificateHashesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "serverCertificateHashes"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!serverCertificateHashesValue.isUndefined()) {
        result.serverCertificateHashes = convert<IDLSequence<IDLDictionary<WebTransportHash>>>(lexicalGlobalObject, serverCertificateHashesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
