/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportDatagramDuplexStream.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSReadableStream.h"
#include "JSWritableStream.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_readable);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_writable);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_maxDatagramSize);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_incomingMaxAge);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_incomingMaxAge);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_outgoingMaxAge);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_outgoingMaxAge);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_incomingHighWaterMark);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_incomingHighWaterMark);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_outgoingHighWaterMark);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_outgoingHighWaterMark);

class JSWebTransportDatagramDuplexStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportDatagramDuplexStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportDatagramDuplexStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportDatagramDuplexStreamPrototype>(vm)) JSWebTransportDatagramDuplexStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportDatagramDuplexStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportDatagramDuplexStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportDatagramDuplexStreamPrototype, JSWebTransportDatagramDuplexStreamPrototype::Base);

using JSWebTransportDatagramDuplexStreamDOMConstructor = JSDOMConstructorNotConstructable<JSWebTransportDatagramDuplexStream>;

template<> const ClassInfo JSWebTransportDatagramDuplexStreamDOMConstructor::s_info = { "WebTransportDatagramDuplexStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportDatagramDuplexStreamDOMConstructor) };

template<> JSValue JSWebTransportDatagramDuplexStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebTransportDatagramDuplexStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransportDatagramDuplexStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransportDatagramDuplexStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebTransportDatagramDuplexStreamPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStreamConstructor, 0 } },
    { "readable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_readable, 0 } },
    { "writable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_writable, 0 } },
    { "maxDatagramSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_maxDatagramSize, 0 } },
    { "incomingMaxAge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_incomingMaxAge, setJSWebTransportDatagramDuplexStream_incomingMaxAge } },
    { "outgoingMaxAge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_outgoingMaxAge, setJSWebTransportDatagramDuplexStream_outgoingMaxAge } },
    { "incomingHighWaterMark"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_incomingHighWaterMark, setJSWebTransportDatagramDuplexStream_incomingHighWaterMark } },
    { "outgoingHighWaterMark"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportDatagramDuplexStream_outgoingHighWaterMark, setJSWebTransportDatagramDuplexStream_outgoingHighWaterMark } },
};

const ClassInfo JSWebTransportDatagramDuplexStreamPrototype::s_info = { "WebTransportDatagramDuplexStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportDatagramDuplexStreamPrototype) };

void JSWebTransportDatagramDuplexStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransportDatagramDuplexStream::info(), JSWebTransportDatagramDuplexStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransportDatagramDuplexStream::s_info = { "WebTransportDatagramDuplexStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportDatagramDuplexStream) };

JSWebTransportDatagramDuplexStream::JSWebTransportDatagramDuplexStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransportDatagramDuplexStream>&& impl)
    : JSDOMWrapper<WebTransportDatagramDuplexStream>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebTransportDatagramDuplexStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebTransportDatagramDuplexStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportDatagramDuplexStreamPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebTransportDatagramDuplexStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransportDatagramDuplexStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransportDatagramDuplexStream>(vm, globalObject);
}

JSValue JSWebTransportDatagramDuplexStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportDatagramDuplexStreamDOMConstructor, DOMConstructorID::WebTransportDatagramDuplexStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebTransportDatagramDuplexStream::destroy(JSC::JSCell* cell)
{
    JSWebTransportDatagramDuplexStream* thisObject = static_cast<JSWebTransportDatagramDuplexStream*>(cell);
    thisObject->JSWebTransportDatagramDuplexStream::~JSWebTransportDatagramDuplexStream();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportDatagramDuplexStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransportDatagramDuplexStream::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebTransportDatagramDuplexStream_readableGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ReadableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_readable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_readableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_writableGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WritableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.writable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_writable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_writableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_maxDatagramSizeGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxDatagramSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_maxDatagramSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_maxDatagramSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_incomingMaxAgeGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.incomingMaxAge())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_incomingMaxAge, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_incomingMaxAgeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebTransportDatagramDuplexStream_incomingMaxAgeSetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setIncomingMaxAge(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_incomingMaxAge, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::set<setJSWebTransportDatagramDuplexStream_incomingMaxAgeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_outgoingMaxAgeGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.outgoingMaxAge())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_outgoingMaxAge, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_outgoingMaxAgeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebTransportDatagramDuplexStream_outgoingMaxAgeSetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setOutgoingMaxAge(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_outgoingMaxAge, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::set<setJSWebTransportDatagramDuplexStream_outgoingMaxAgeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_incomingHighWaterMarkGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.incomingHighWaterMark())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_incomingHighWaterMark, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_incomingHighWaterMarkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebTransportDatagramDuplexStream_incomingHighWaterMarkSetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setIncomingHighWaterMark(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_incomingHighWaterMark, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::set<setJSWebTransportDatagramDuplexStream_incomingHighWaterMarkSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebTransportDatagramDuplexStream_outgoingHighWaterMarkGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.outgoingHighWaterMark())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportDatagramDuplexStream_outgoingHighWaterMark, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::get<jsWebTransportDatagramDuplexStream_outgoingHighWaterMarkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebTransportDatagramDuplexStream_outgoingHighWaterMarkSetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportDatagramDuplexStream& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setOutgoingHighWaterMark(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebTransportDatagramDuplexStream_outgoingHighWaterMark, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportDatagramDuplexStream>::set<setJSWebTransportDatagramDuplexStream_outgoingHighWaterMarkSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSWebTransportDatagramDuplexStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransportDatagramDuplexStream, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransportDatagramDuplexStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransportDatagramDuplexStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransportDatagramDuplexStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransportDatagramDuplexStream = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransportDatagramDuplexStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransportDatagramDuplexStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebTransportDatagramDuplexStreamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebTransportDatagramDuplexStreamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebTransportDatagramDuplexStream = static_cast<JSWebTransportDatagramDuplexStream*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebTransportDatagramDuplexStream->wrapped(), jsWebTransportDatagramDuplexStream);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebTransportDatagramDuplexStream@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore32WebTransportDatagramDuplexStreamE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebTransportDatagramDuplexStream>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebTransportDatagramDuplexStream>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebTransportDatagramDuplexStream@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore32WebTransportDatagramDuplexStreamE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebTransportDatagramDuplexStream has subclasses. If WebTransportDatagramDuplexStream has subclasses that get passed
        // to toJS() we currently require WebTransportDatagramDuplexStream you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebTransportDatagramDuplexStream>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebTransportDatagramDuplexStream& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebTransportDatagramDuplexStream* JSWebTransportDatagramDuplexStream::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebTransportDatagramDuplexStream*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
