/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLRenderingContext.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "InspectorCanvasCallTracer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(WEBGL)
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertWebGL.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSWebCodecsVideoFrame.h"
#include "JSWebGLActiveInfo.h"
#include "JSWebGLBuffer.h"
#include "JSWebGLContextAttributes.h"
#include "JSWebGLFramebuffer.h"
#include "JSWebGLProgram.h"
#include "JSWebGLRenderbuffer.h"
#include "JSWebGLShader.h"
#include "JSWebGLShaderPrecisionFormat.h"
#include "JSWebGLTexture.h"
#include "JSWebGLUniformLocation.h"
#include <JavaScriptCore/JSArray.h>
#include <variant>
#endif

#if ENABLE(WEBGL) && ENABLE(WEBXR)
#include "DOMPromiseProxy.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMOperationReturningPromise.h"
#endif

#if ENABLE(WEBGL) || (ENABLE(WEBGL) && ENABLE(WEBXR))
#include "IDLTypes.h"
#include "JSDOMConvertBase.h"
#include "JSDOMGlobalObject.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_activeTexture);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_attachShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindAttribLocation);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindBuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindFramebuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindRenderbuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindTexture);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendColor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendEquation);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendEquationSeparate);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendFunc);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendFuncSeparate);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bufferData);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bufferSubData);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_checkFramebufferStatus);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clear);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearColor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearDepth);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearStencil);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_colorMask);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compileShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texSubImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compressedTexImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compressedTexSubImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_copyTexImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_copyTexSubImage2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createBuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createFramebuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createProgram);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createRenderbuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createTexture);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_cullFace);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteBuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteFramebuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteProgram);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteRenderbuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteTexture);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthFunc);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthMask);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthRange);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_detachShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_disable);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_disableVertexAttribArray);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_drawArrays);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_drawElements);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_enable);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_enableVertexAttribArray);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_finish);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_flush);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_framebufferRenderbuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_framebufferTexture2D);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_frontFace);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_generateMipmap);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getActiveAttrib);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getActiveUniform);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getAttachedShaders);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getAttribLocation);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getBufferParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getContextAttributes);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getError);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getSupportedExtensions);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getExtension);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getFramebufferAttachmentParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getProgramParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getProgramInfoLog);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getRenderbufferParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderInfoLog);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderPrecisionFormat);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderSource);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getTexParameter);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getUniform);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getUniformLocation);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getVertexAttrib);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getVertexAttribOffset);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_hint);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isBuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isContextLost);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isEnabled);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isFramebuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isProgram);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isRenderbuffer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isShader);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isTexture);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_lineWidth);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_linkProgram);
#endif
#if ENABLE(WEBGL) && ENABLE(WEBXR)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_makeXRCompatible);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_pixelStorei);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_polygonOffset);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_readPixels);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_renderbufferStorage);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_sampleCoverage);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_scissor);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_shaderSource);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilFunc);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilFuncSeparate);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilMask);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilMaskSeparate);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilOp);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilOpSeparate);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texParameterf);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texParameteri);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1i);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2i);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3i);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4i);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1iv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2iv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3iv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4iv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix2fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix3fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix4fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_useProgram);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_validateProgram);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib1f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib2f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib3f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib4f);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fv);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttribPointer);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_viewport);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLRenderingContextConstructor);
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLRenderingContext_canvas);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLRenderingContext_drawingBufferWidth);
#endif
#if ENABLE(WEBGL)
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLRenderingContext_drawingBufferHeight);
#endif

class JSWebGLRenderingContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLRenderingContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLRenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLRenderingContextPrototype>(vm)) JSWebGLRenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLRenderingContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLRenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLRenderingContextPrototype, JSWebGLRenderingContextPrototype::Base);

using JSWebGLRenderingContextDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLRenderingContext>;

/* Hash table for constructor */

static const HashTableValue JSWebGLRenderingContextConstructorTableValues[] =
{
#if ENABLE(WEBGL)
    { "DEPTH_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000100 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000400 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00004000 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POINTS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0000 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_LOOP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_STRIP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0003 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0004 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_STRIP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0005 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_FAN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0006 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ZERO"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0300 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0301 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0302 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0303 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0304 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0305 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DST_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0306 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0307 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA_SATURATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0308 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_ADD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8006 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8009 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8009 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x883D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_SUBTRACT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x800A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_REVERSE_SUBTRACT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x800B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80C8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80C9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80CA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80CB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8001 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8002 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8003 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8004 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8005 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8892 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8893 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8894 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8895 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STREAM_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STATIC_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DYNAMIC_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8764 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_USAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8765 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_VERTEX_ATTRIB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8626 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0404 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BACK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0405 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_AND_BACK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0408 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0DE1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B44 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BE2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DITHER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BD0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B90 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B71 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C11 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FILL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8037 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_ALPHA_TO_COVERAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x809E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NO_ERROR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_ENUM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0500 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0501 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_OPERATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0502 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "OUT_OF_MEMORY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0505 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0900 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CCW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0901 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_WIDTH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B21 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_POINT_SIZE_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x846D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_LINE_WIDTH_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x846E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE_MODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B45 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B46 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B70 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B72 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B73 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B74 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B91 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B92 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B94 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B95 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_PASS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B96 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_REF"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B97 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_VALUE_MASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B93 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B98 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8800 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8801 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8802 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_PASS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8803 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_REF"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_VALUE_MASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VIEWPORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BA2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_BOX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C10 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C22 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C23 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_ALIGNMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0CF5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "PACK_ALIGNMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D05 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D33 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VIEWPORT_DIMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D3A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SUBPIXEL_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RED_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GREEN_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLUE_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D56 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D57 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2A00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FACTOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8038 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8069 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_BUFFERS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80AA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_INVERT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80AB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COMPRESSED_TEXTURE_FORMATS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x86A3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DONT_CARE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1100 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FASTEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1101 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NICEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1102 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GENERATE_MIPMAP_HINT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8192 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BYTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1400 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_BYTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1401 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1402 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1403 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1404 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1405 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1406 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1902 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1906 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1907 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGBA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1908 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1909 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x190A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_4_4_4_4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8033 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_5_5_1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8034 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_6_5"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8363 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAGMENT_SHADER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B30 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_SHADER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B31 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_ATTRIBS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8869 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_UNIFORM_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VARYING_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_COMBINED_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8872 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_FRAGMENT_UNIFORM_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHADER_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DELETE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B80 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINK_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B82 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VALIDATE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B83 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ATTACHED_SHADERS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B85 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_UNIFORMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B86 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_ATTRIBUTES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B89 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHADING_LANGUAGE_VERSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B8C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_PROGRAM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B8D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEVER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0200 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LESS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0201 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "EQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0202 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0203 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GREATER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0204 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NOTEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0205 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0206 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALWAYS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0207 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "KEEP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "REPLACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E01 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INCR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E02 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DECR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E03 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVERT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x150A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INCR_WRAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8507 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DECR_WRAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8508 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VENDOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F01 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F02 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2600 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2601 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2700 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2701 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2702 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2703 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MAG_FILTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2800 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MIN_FILTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2801 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2802 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_T"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2803 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1702 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8513 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_CUBE_MAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8514 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_X"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8515 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_X"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8516 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Y"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8517 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Y"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8518 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Z"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8519 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Z"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x851A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_CUBE_MAP_TEXTURE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x851C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE0"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE5"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE6"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE7"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE8"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE9"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE10"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE11"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE12"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE13"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE14"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CE } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE15"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CF } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE16"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE17"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE18"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE19"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE20"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE21"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE22"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE23"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE24"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE25"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE26"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE27"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE28"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE29"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE30"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DE } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE31"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DF } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_TEXTURE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84E0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "REPEAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2901 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CLAMP_TO_EDGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x812F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MIRRORED_REPEAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8370 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B51 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B56 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B57 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B58 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B59 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_CUBE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B60 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_ENABLED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8622 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8623 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_STRIDE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8624 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8625 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_NORMALIZED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x886A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_POINTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8645 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x889F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B9A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_FORMAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B9B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COMPILE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B81 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LOW_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LOW_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D40 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D41 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGBA4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8056 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB5_A1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8057 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB565"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D62 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT16"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x81A5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX8"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D48 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84F9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_WIDTH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D42 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_HEIGHT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D43 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_INTERNAL_FORMAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D44 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_RED_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_GREEN_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D51 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BLUE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_ALPHA_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_DEPTH_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_STENCIL_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_NAME"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_ATTACHMENT0"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CE0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D20 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x821A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_COMPLETE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_DIMENSIONS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_UNSUPPORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CDD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_RENDERBUFFER_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84E8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_FRAMEBUFFER_OPERATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0506 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_FLIP_Y_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9240 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_PREMULTIPLY_ALPHA_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9241 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONTEXT_LOST_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9242 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_COLORSPACE_CONVERSION_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9243 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BROWSER_DEFAULT_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9244 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

template<> const ClassInfo JSWebGLRenderingContextDOMConstructor::s_info = { "WebGLRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLRenderingContextDOMConstructor) };

template<> JSValue JSWebGLRenderingContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLRenderingContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLRenderingContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLRenderingContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWebGLRenderingContext::info(), JSWebGLRenderingContextConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLRenderingContextPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLRenderingContextConstructor, 0 } },
#if ENABLE(WEBGL)
    { "canvas"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLRenderingContext_canvas, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "drawingBufferWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLRenderingContext_drawingBufferWidth, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "drawingBufferHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLRenderingContext_drawingBufferHeight, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "activeTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_activeTexture, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "attachShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_attachShader, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bindAttribLocation"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bindAttribLocation, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bindBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bindBuffer, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bindFramebuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bindFramebuffer, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bindRenderbuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bindRenderbuffer, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bindTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bindTexture, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "blendColor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_blendColor, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "blendEquation"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_blendEquation, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "blendEquationSeparate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_blendEquationSeparate, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "blendFunc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_blendFunc, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "blendFuncSeparate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_blendFuncSeparate, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bufferData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bufferData, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "bufferSubData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_bufferSubData, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "checkFramebufferStatus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_checkFramebufferStatus, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_clear, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "clearColor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_clearColor, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "clearDepth"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_clearDepth, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "clearStencil"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_clearStencil, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "colorMask"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_colorMask, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "compileShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_compileShader, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "texImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_texImage2D, 6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "texSubImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_texSubImage2D, 7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "compressedTexImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_compressedTexImage2D, 7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "compressedTexSubImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_compressedTexSubImage2D, 8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "copyTexImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_copyTexImage2D, 8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "copyTexSubImage2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_copyTexSubImage2D, 8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createBuffer, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createFramebuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createFramebuffer, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createProgram, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createRenderbuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createRenderbuffer, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createShader, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "createTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_createTexture, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "cullFace"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_cullFace, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteBuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteFramebuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteFramebuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteProgram, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteRenderbuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteRenderbuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteShader, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "deleteTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_deleteTexture, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "depthFunc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_depthFunc, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "depthMask"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_depthMask, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "depthRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_depthRange, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "detachShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_detachShader, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "disable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_disable, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "disableVertexAttribArray"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_disableVertexAttribArray, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "drawArrays"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_drawArrays, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "drawElements"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_drawElements, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "enable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_enable, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "enableVertexAttribArray"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_enableVertexAttribArray, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "finish"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_finish, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "flush"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_flush, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "framebufferRenderbuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_framebufferRenderbuffer, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "framebufferTexture2D"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_framebufferTexture2D, 5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "frontFace"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_frontFace, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "generateMipmap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_generateMipmap, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getActiveAttrib"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getActiveAttrib, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getActiveUniform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getActiveUniform, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getAttachedShaders"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getAttachedShaders, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getAttribLocation"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getAttribLocation, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getBufferParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getBufferParameter, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getContextAttributes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getContextAttributes, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getError"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getError, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getSupportedExtensions"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getSupportedExtensions, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getExtension"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getExtension, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getFramebufferAttachmentParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getFramebufferAttachmentParameter, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getParameter, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getProgramParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getProgramParameter, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getProgramInfoLog"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getProgramInfoLog, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getRenderbufferParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getRenderbufferParameter, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getShaderParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getShaderParameter, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getShaderInfoLog"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getShaderInfoLog, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getShaderPrecisionFormat"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getShaderPrecisionFormat, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getShaderSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getShaderSource, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getTexParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getTexParameter, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getUniform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getUniform, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getUniformLocation"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getUniformLocation, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getVertexAttrib"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getVertexAttrib, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "getVertexAttribOffset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_getVertexAttribOffset, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "hint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_hint, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isBuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isContextLost"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isContextLost, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isEnabled"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isEnabled, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isFramebuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isFramebuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isProgram, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isRenderbuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isRenderbuffer, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isShader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isShader, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "isTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_isTexture, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "lineWidth"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_lineWidth, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "linkProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_linkProgram, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL) && ENABLE(WEBXR)
    { "makeXRCompatible"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_makeXRCompatible, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "pixelStorei"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_pixelStorei, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "polygonOffset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_polygonOffset, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "readPixels"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_readPixels, 7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "renderbufferStorage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_renderbufferStorage, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "sampleCoverage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_sampleCoverage, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "scissor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_scissor, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "shaderSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_shaderSource, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilFunc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilFunc, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilFuncSeparate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilFuncSeparate, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilMask"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilMask, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilMaskSeparate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilMaskSeparate, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilOp"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilOp, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "stencilOpSeparate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_stencilOpSeparate, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "texParameterf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_texParameterf, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "texParameteri"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_texParameteri, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform1f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform1f, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform2f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform2f, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform3f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform3f, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform4f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform4f, 5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform1i"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform1i, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform2i"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform2i, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform3i"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform3i, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform4i"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform4i, 5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform1fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform1fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform2fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform2fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform3fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform3fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform4fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform4fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform1iv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform1iv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform2iv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform2iv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform3iv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform3iv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniform4iv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniform4iv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniformMatrix2fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniformMatrix2fv, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniformMatrix3fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniformMatrix3fv, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "uniformMatrix4fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_uniformMatrix4fv, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "useProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_useProgram, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "validateProgram"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_validateProgram, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib1f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib1f, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib2f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib2f, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib3f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib3f, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib4f"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib4f, 5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib1fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib2fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib3fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib4fv"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fv, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttribPointer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_vertexAttribPointer, 6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "viewport"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLRenderingContextPrototypeFunction_viewport, 4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000100 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000400 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_BUFFER_BIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00004000 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POINTS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0000 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_LOOP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_STRIP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0003 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0004 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_STRIP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0005 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_FAN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0006 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ZERO"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0300 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0301 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0302 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0303 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0304 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0305 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DST_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0306 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0307 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA_SATURATE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0308 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_ADD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8006 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8009 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8009 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x883D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_SUBTRACT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x800A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_REVERSE_SUBTRACT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x800B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80C8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80C9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80CA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80CB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8001 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8002 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8003 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8004 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_COLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8005 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8892 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8893 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8894 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8895 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STREAM_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STATIC_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DYNAMIC_DRAW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88E8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8764 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_USAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8765 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_VERTEX_ATTRIB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8626 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0404 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BACK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0405 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_AND_BACK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0408 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0DE1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B44 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLEND"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BE2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DITHER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BD0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B90 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B71 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_TEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C11 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FILL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8037 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_ALPHA_TO_COVERAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x809E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NO_ERROR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_ENUM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0500 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0501 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_OPERATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0502 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "OUT_OF_MEMORY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0505 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0900 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CCW"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0901 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINE_WIDTH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B21 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_POINT_SIZE_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x846D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_LINE_WIDTH_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x846E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE_MODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B45 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B46 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_RANGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B70 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B72 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B73 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B74 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B91 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B92 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B94 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B95 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_PASS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B96 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_REF"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B97 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_VALUE_MASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B93 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0B98 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FUNC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8800 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8801 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_FAIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8802 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_PASS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8803 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_REF"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_VALUE_MASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VIEWPORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0BA2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_BOX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C10 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_CLEAR_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C22 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_WRITEMASK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0C23 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_ALIGNMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0CF5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "PACK_ALIGNMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D05 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D33 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VIEWPORT_DIMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D3A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SUBPIXEL_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RED_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GREEN_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BLUE_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D56 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D57 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2A00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FACTOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8038 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8069 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_BUFFERS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80A9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80AA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_INVERT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x80AB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COMPRESSED_TEXTURE_FORMATS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x86A3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DONT_CARE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1100 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FASTEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1101 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NICEST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1102 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GENERATE_MIPMAP_HINT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8192 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BYTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1400 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_BYTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1401 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1402 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1403 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1404 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1405 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1406 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1902 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1906 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1907 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGBA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1908 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1909 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE_ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x190A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_4_4_4_4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8033 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_5_5_1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8034 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_6_5"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8363 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAGMENT_SHADER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B30 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_SHADER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B31 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_ATTRIBS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8869 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_UNIFORM_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VARYING_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_COMBINED_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_IMAGE_UNITS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8872 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_FRAGMENT_UNIFORM_VECTORS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DFD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHADER_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B4F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DELETE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B80 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINK_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B82 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VALIDATE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B83 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ATTACHED_SHADERS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B85 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_UNIFORMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B86 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_ATTRIBUTES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B89 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SHADING_LANGUAGE_VERSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B8C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_PROGRAM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B8D } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEVER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0200 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LESS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0201 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "EQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0202 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0203 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GREATER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0204 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NOTEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0205 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "GEQUAL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0206 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ALWAYS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0207 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "KEEP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "REPLACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E01 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INCR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E02 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DECR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1E03 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVERT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x150A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INCR_WRAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8507 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DECR_WRAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8508 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VENDOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F01 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1F02 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2600 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2601 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2700 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_NEAREST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2701 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2702 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_LINEAR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2703 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MAG_FILTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2800 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MIN_FILTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2801 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2802 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_T"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2803 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1702 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8513 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_CUBE_MAP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8514 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_X"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8515 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_X"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8516 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Y"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8517 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Y"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8518 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Z"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8519 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Z"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x851A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_CUBE_MAP_TEXTURE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x851C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE0"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE5"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE6"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE7"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE8"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE9"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84C9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE10"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE11"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE12"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE13"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE14"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CE } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE15"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84CF } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE16"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE17"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE18"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE19"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE20"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE21"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE22"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE23"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE24"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE25"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84D9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE26"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DA } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE27"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DB } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE28"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DC } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE29"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE30"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DE } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE31"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84DF } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_TEXTURE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84E0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "REPEAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2901 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CLAMP_TO_EDGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x812F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MIRRORED_REPEAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8370 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B51 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B56 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B57 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B58 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B59 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT2"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT3"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5C } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_2D"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B5E } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_CUBE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B60 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_ENABLED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8622 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8623 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_STRIDE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8624 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8625 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_NORMALIZED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x886A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_POINTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8645 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_BUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x889F } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B9A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_FORMAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B9B } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COMPILE_STATUS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B81 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LOW_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_FLOAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "LOW_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF4 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_INT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DF5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D40 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D41 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGBA4"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8056 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB5_A1"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8057 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RGB565"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D62 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT16"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x81A5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX8"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D48 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84F9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_WIDTH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D42 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_HEIGHT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D43 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_INTERNAL_FORMAT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D44 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_RED_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D50 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_GREEN_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D51 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BLUE_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D52 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_ALPHA_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D53 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_DEPTH_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D54 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_STENCIL_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D55 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_NAME"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_ATTACHMENT0"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CE0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D00 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D20 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x821A } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "NONE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_COMPLETE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD5 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_DIMENSIONS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CD9 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_UNSUPPORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CDD } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA6 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA7 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "MAX_RENDERBUFFER_SIZE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x84E8 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_FRAMEBUFFER_OPERATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0506 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_FLIP_Y_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9240 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_PREMULTIPLY_ALPHA_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9241 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "CONTEXT_LOST_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9242 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_COLORSPACE_CONVERSION_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9243 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(WEBGL)
    { "BROWSER_DEFAULT_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9244 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSWebGLRenderingContextPrototype::s_info = { "WebGLRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLRenderingContextPrototype) };

void JSWebGLRenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLRenderingContext::info(), JSWebGLRenderingContextPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(WEBGL) && ENABLE(WEBXR)
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webXREnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "makeXRCompatible"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLRenderingContext::s_info = { "WebGLRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLRenderingContext) };

JSWebGLRenderingContext::JSWebGLRenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLRenderingContext>&& impl)
    : JSDOMWrapper<WebGLRenderingContext>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, WebGLRenderingContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebGLRenderingContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLRenderingContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLRenderingContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLRenderingContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLRenderingContext>(vm, globalObject);
}

JSValue JSWebGLRenderingContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLRenderingContextDOMConstructor, DOMConstructorID::WebGLRenderingContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLRenderingContext::destroy(JSC::JSCell* cell)
{
    JSWebGLRenderingContext* thisObject = static_cast<JSWebGLRenderingContext*>(cell);
    thisObject->JSWebGLRenderingContext::~JSWebGLRenderingContext();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLRenderingContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLRenderingContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLRenderingContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

#if ENABLE(WEBGL)
static inline JSValue jsWebGLRenderingContext_canvasGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLRenderingContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLInterface<HTMLCanvasElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLRenderingContext_canvas, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLRenderingContext>::get<jsWebGLRenderingContext_canvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWebGLRenderingContext_drawingBufferWidthGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLRenderingContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.drawingBufferWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLRenderingContext_drawingBufferWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLRenderingContext>::get<jsWebGLRenderingContext_drawingBufferWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWebGLRenderingContext_drawingBufferHeightGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLRenderingContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.drawingBufferHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLRenderingContext_drawingBufferHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLRenderingContext>::get<jsWebGLRenderingContext_drawingBufferHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_activeTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto texture = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "activeTexture"_s, { InspectorCanvasCallTracer::processArgument(impl, texture) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.activeTexture(WTFMove(texture)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_activeTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_activeTextureBody>(*lexicalGlobalObject, *callFrame, "activeTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_attachShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "attachShader", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "shader", "WebGLRenderingContext", "attachShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "attachShader"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.attachShader(*program, *shader); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_attachShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_attachShaderBody>(*lexicalGlobalObject, *callFrame, "attachShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bindAttribLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "bindAttribLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bindAttribLocation"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, name) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindAttribLocation(*program, WTFMove(index), WTFMove(name)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindAttribLocation, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bindAttribLocationBody>(*lexicalGlobalObject, *callFrame, "bindAttribLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bindBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "buffer", "WebGLRenderingContext", "bindBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bindBuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, buffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindBuffer(WTFMove(target), WTFMove(buffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bindBufferBody>(*lexicalGlobalObject, *callFrame, "bindBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bindFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "framebuffer", "WebGLRenderingContext", "bindFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bindFramebuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, framebuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindFramebuffer(WTFMove(target), WTFMove(framebuffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindFramebuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bindFramebufferBody>(*lexicalGlobalObject, *callFrame, "bindFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bindRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "renderbuffer", "WebGLRenderingContext", "bindRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bindRenderbuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, renderbuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindRenderbuffer(WTFMove(target), WTFMove(renderbuffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindRenderbuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bindRenderbufferBody>(*lexicalGlobalObject, *callFrame, "bindRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bindTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "texture", "WebGLRenderingContext", "bindTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bindTexture"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, texture) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindTexture(WTFMove(target), WTFMove(texture)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bindTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bindTextureBody>(*lexicalGlobalObject, *callFrame, "bindTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_blendColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto red = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto green = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto blue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto alpha = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "blendColor"_s, { InspectorCanvasCallTracer::processArgument(impl, red), InspectorCanvasCallTracer::processArgument(impl, green), InspectorCanvasCallTracer::processArgument(impl, blue), InspectorCanvasCallTracer::processArgument(impl, alpha) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendColor(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendColor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_blendColorBody>(*lexicalGlobalObject, *callFrame, "blendColor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_blendEquationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "blendEquation"_s, { InspectorCanvasCallTracer::processArgument(impl, mode) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquation(WTFMove(mode)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendEquation, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_blendEquationBody>(*lexicalGlobalObject, *callFrame, "blendEquation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_blendEquationSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto modeAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "blendEquationSeparate"_s, { InspectorCanvasCallTracer::processArgument(impl, modeRGB), InspectorCanvasCallTracer::processArgument(impl, modeAlpha) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquationSeparate(WTFMove(modeRGB), WTFMove(modeAlpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendEquationSeparate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_blendEquationSeparateBody>(*lexicalGlobalObject, *callFrame, "blendEquationSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_blendFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sfactor = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dfactor = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "blendFunc"_s, { InspectorCanvasCallTracer::processArgument(impl, sfactor), InspectorCanvasCallTracer::processArgument(impl, dfactor) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFunc(WTFMove(sfactor), WTFMove(dfactor)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendFunc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_blendFuncBody>(*lexicalGlobalObject, *callFrame, "blendFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_blendFuncSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto srcRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dstRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto srcAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dstAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "blendFuncSeparate"_s, { InspectorCanvasCallTracer::processArgument(impl, srcRGB), InspectorCanvasCallTracer::processArgument(impl, dstRGB), InspectorCanvasCallTracer::processArgument(impl, srcAlpha), InspectorCanvasCallTracer::processArgument(impl, dstAlpha) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFuncSeparate(WTFMove(srcRGB), WTFMove(dstRGB), WTFMove(srcAlpha), WTFMove(dstAlpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_blendFuncSeparate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_blendFuncSeparateBody>(*lexicalGlobalObject, *callFrame, "blendFuncSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bufferData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto data = convert<IDLNullable<IDLUnion<IDLAllowSharedAdaptor<IDLArrayBuffer>, IDLAllowSharedAdaptor<IDLArrayBufferView>>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto usage = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bufferData"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, data), InspectorCanvasCallTracer::processArgument(impl, usage) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bufferData(WTFMove(target), WTFMove(data), WTFMove(usage)); })));
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bufferData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto size = convert<IDLLongLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto usage = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bufferData"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, size), InspectorCanvasCallTracer::processArgument(impl, usage) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bufferData(WTFMove(target), WTFMove(size), WTFMove(usage)); })));
}

#endif

#if ENABLE(WEBGL)

static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bufferDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
#if ENABLE(WEBGL)
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_bufferData1Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBuffer>())
            RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_bufferData1Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>())
            RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_bufferData1Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_bufferData2Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
#if ENABLE(WEBGL)
        RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_bufferData2Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bufferData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bufferDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "bufferData");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_bufferSubDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto data = convert<IDLUnion<IDLAllowSharedAdaptor<IDLArrayBuffer>, IDLAllowSharedAdaptor<IDLArrayBufferView>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "bufferSubData"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, offset), InspectorCanvasCallTracer::processArgument(impl, data) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bufferSubData(WTFMove(target), WTFMove(offset), WTFMove(data)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_bufferSubData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_bufferSubDataBody>(*lexicalGlobalObject, *callFrame, "bufferSubData");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_checkFramebufferStatusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "checkFramebufferStatus"_s, { InspectorCanvasCallTracer::processArgument(impl, target) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.checkFramebufferStatus(WTFMove(target)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_checkFramebufferStatus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_checkFramebufferStatusBody>(*lexicalGlobalObject, *callFrame, "checkFramebufferStatus");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "clear"_s, { InspectorCanvasCallTracer::processArgument(impl, mask) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clear(WTFMove(mask)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_clearColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto red = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto green = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto blue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto alpha = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "clearColor"_s, { InspectorCanvasCallTracer::processArgument(impl, red), InspectorCanvasCallTracer::processArgument(impl, green), InspectorCanvasCallTracer::processArgument(impl, blue), InspectorCanvasCallTracer::processArgument(impl, alpha) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearColor(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearColor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_clearColorBody>(*lexicalGlobalObject, *callFrame, "clearColor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_clearDepthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto depth = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "clearDepth"_s, { InspectorCanvasCallTracer::processArgument(impl, depth) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearDepth(WTFMove(depth)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearDepth, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_clearDepthBody>(*lexicalGlobalObject, *callFrame, "clearDepth");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_clearStencilBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto s = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "clearStencil"_s, { InspectorCanvasCallTracer::processArgument(impl, s) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearStencil(WTFMove(s)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_clearStencil, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_clearStencilBody>(*lexicalGlobalObject, *callFrame, "clearStencil");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_colorMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto red = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto green = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto blue = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto alpha = convert<IDLBoolean>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "colorMask"_s, { InspectorCanvasCallTracer::processArgument(impl, red), InspectorCanvasCallTracer::processArgument(impl, green), InspectorCanvasCallTracer::processArgument(impl, blue), InspectorCanvasCallTracer::processArgument(impl, alpha) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.colorMask(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_colorMask, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_colorMaskBody>(*lexicalGlobalObject, *callFrame, "colorMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_compileShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "compileShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "compileShader"_s, { InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.compileShader(*shader); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compileShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_compileShaderBody>(*lexicalGlobalObject, *callFrame, "compileShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto border = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto pixels = convert<IDLNullable<IDLAllowSharedAdaptor<IDLArrayBufferView>>>(*lexicalGlobalObject, argument8.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "pixels", "WebGLRenderingContext", "texImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, internalformat), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, border), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, pixels) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(pixels)); })));
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, internalformat), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, source) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(format), WTFMove(type), WTFMove(source)); })));
}

#endif

#if ENABLE(WEBGL)

static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 6) {
#if ENABLE(WEBGL)
        RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_texImage2D2Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
    }
    if (argsCount == 9) {
#if ENABLE(WEBGL)
        RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_texImage2D1Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
    }
    return argsCount < 6 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_texImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texSubImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto pixels = convert<IDLNullable<IDLAllowSharedAdaptor<IDLArrayBufferView>>>(*lexicalGlobalObject, argument8.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "pixels", "WebGLRenderingContext", "texSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texSubImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, xoffset), InspectorCanvasCallTracer::processArgument(impl, yoffset), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, pixels) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(pixels)); })));
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texSubImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texSubImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, xoffset), InspectorCanvasCallTracer::processArgument(impl, yoffset), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, source) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(format), WTFMove(type), WTFMove(source)); })));
}

#endif

#if ENABLE(WEBGL)

static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texSubImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 7) {
#if ENABLE(WEBGL)
        RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_texSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
    }
    if (argsCount == 9) {
#if ENABLE(WEBGL)
        RELEASE_AND_RETURN(throwScope, (jsWebGLRenderingContextPrototypeFunction_texSubImage2D1Body(lexicalGlobalObject, callFrame, castedThis)));
#endif
    }
    return argsCount < 7 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texSubImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_texSubImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texSubImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_compressedTexImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto border = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto data = convert<IDLAllowSharedAdaptor<IDLArrayBufferView>>(*lexicalGlobalObject, argument6.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "data", "WebGLRenderingContext", "compressedTexImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "compressedTexImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, internalformat), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, border), InspectorCanvasCallTracer::processArgument(impl, data) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.compressedTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), data.releaseNonNull()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compressedTexImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_compressedTexImage2DBody>(*lexicalGlobalObject, *callFrame, "compressedTexImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_compressedTexSubImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto data = convert<IDLAllowSharedAdaptor<IDLArrayBufferView>>(*lexicalGlobalObject, argument7.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "data", "WebGLRenderingContext", "compressedTexSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "compressedTexSubImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, xoffset), InspectorCanvasCallTracer::processArgument(impl, yoffset), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, data) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.compressedTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), data.releaseNonNull()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_compressedTexSubImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_compressedTexSubImage2DBody>(*lexicalGlobalObject, *callFrame, "compressedTexSubImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_copyTexImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto border = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "copyTexImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, internalformat), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, border) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(border)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_copyTexImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_copyTexImage2DBody>(*lexicalGlobalObject, *callFrame, "copyTexImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_copyTexSubImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "copyTexSubImage2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, level), InspectorCanvasCallTracer::processArgument(impl, xoffset), InspectorCanvasCallTracer::processArgument(impl, yoffset), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_copyTexSubImage2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_copyTexSubImage2DBody>(*lexicalGlobalObject, *callFrame, "copyTexSubImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createBuffer"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createFramebuffer"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLFramebuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createFramebuffer())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createFramebuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createFramebufferBody>(*lexicalGlobalObject, *callFrame, "createFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createProgram"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createProgram())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createProgramBody>(*lexicalGlobalObject, *callFrame, "createProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createRenderbuffer"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLRenderbuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRenderbuffer())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createRenderbuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createRenderbufferBody>(*lexicalGlobalObject, *callFrame, "createRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createShader"_s, { InspectorCanvasCallTracer::processArgument(impl, type) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLShader>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createShader(WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createShaderBody>(*lexicalGlobalObject, *callFrame, "createShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_createTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "createTexture"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createTexture())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_createTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_createTextureBody>(*lexicalGlobalObject, *callFrame, "createTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_cullFaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "cullFace"_s, { InspectorCanvasCallTracer::processArgument(impl, mode) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.cullFace(WTFMove(mode)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_cullFace, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_cullFaceBody>(*lexicalGlobalObject, *callFrame, "cullFace");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "WebGLRenderingContext", "deleteBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteBuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, buffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteBuffer(WTFMove(buffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteBufferBody>(*lexicalGlobalObject, *callFrame, "deleteBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "framebuffer", "WebGLRenderingContext", "deleteFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteFramebuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, framebuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteFramebuffer(WTFMove(framebuffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteFramebuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteFramebufferBody>(*lexicalGlobalObject, *callFrame, "deleteFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "deleteProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteProgram"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteProgram(WTFMove(program)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteProgramBody>(*lexicalGlobalObject, *callFrame, "deleteProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "renderbuffer", "WebGLRenderingContext", "deleteRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteRenderbuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, renderbuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteRenderbuffer(WTFMove(renderbuffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteRenderbuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteRenderbufferBody>(*lexicalGlobalObject, *callFrame, "deleteRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "deleteShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteShader"_s, { InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteShader(WTFMove(shader)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteShaderBody>(*lexicalGlobalObject, *callFrame, "deleteShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_deleteTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "texture", "WebGLRenderingContext", "deleteTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "deleteTexture"_s, { InspectorCanvasCallTracer::processArgument(impl, texture) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteTexture(WTFMove(texture)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_deleteTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_deleteTextureBody>(*lexicalGlobalObject, *callFrame, "deleteTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_depthFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "depthFunc"_s, { InspectorCanvasCallTracer::processArgument(impl, func) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.depthFunc(WTFMove(func)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthFunc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_depthFuncBody>(*lexicalGlobalObject, *callFrame, "depthFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_depthMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto flag = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "depthMask"_s, { InspectorCanvasCallTracer::processArgument(impl, flag) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.depthMask(WTFMove(flag)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthMask, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_depthMaskBody>(*lexicalGlobalObject, *callFrame, "depthMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_depthRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto zNear = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto zFar = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "depthRange"_s, { InspectorCanvasCallTracer::processArgument(impl, zNear), InspectorCanvasCallTracer::processArgument(impl, zFar) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.depthRange(WTFMove(zNear), WTFMove(zFar)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_depthRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_depthRangeBody>(*lexicalGlobalObject, *callFrame, "depthRange");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_detachShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "detachShader", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "shader", "WebGLRenderingContext", "detachShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "detachShader"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.detachShader(*program, *shader); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_detachShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_detachShaderBody>(*lexicalGlobalObject, *callFrame, "detachShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_disableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "disable"_s, { InspectorCanvasCallTracer::processArgument(impl, cap) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disable(WTFMove(cap)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_disable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_disableBody>(*lexicalGlobalObject, *callFrame, "disable");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_disableVertexAttribArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "disableVertexAttribArray"_s, { InspectorCanvasCallTracer::processArgument(impl, index) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disableVertexAttribArray(WTFMove(index)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_disableVertexAttribArray, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_disableVertexAttribArrayBody>(*lexicalGlobalObject, *callFrame, "disableVertexAttribArray");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_drawArraysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto first = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto count = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "drawArrays"_s, { InspectorCanvasCallTracer::processArgument(impl, mode), InspectorCanvasCallTracer::processArgument(impl, first), InspectorCanvasCallTracer::processArgument(impl, count) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawArrays(WTFMove(mode), WTFMove(first), WTFMove(count)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_drawArrays, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_drawArraysBody>(*lexicalGlobalObject, *callFrame, "drawArrays");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_drawElementsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto count = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "drawElements"_s, { InspectorCanvasCallTracer::processArgument(impl, mode), InspectorCanvasCallTracer::processArgument(impl, count), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, offset) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawElements(WTFMove(mode), WTFMove(count), WTFMove(type), WTFMove(offset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_drawElements, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_drawElementsBody>(*lexicalGlobalObject, *callFrame, "drawElements");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_enableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "enable"_s, { InspectorCanvasCallTracer::processArgument(impl, cap) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.enable(WTFMove(cap)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_enable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_enableBody>(*lexicalGlobalObject, *callFrame, "enable");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_enableVertexAttribArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "enableVertexAttribArray"_s, { InspectorCanvasCallTracer::processArgument(impl, index) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.enableVertexAttribArray(WTFMove(index)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_enableVertexAttribArray, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_enableVertexAttribArrayBody>(*lexicalGlobalObject, *callFrame, "enableVertexAttribArray");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_finishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "finish"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.finish(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_finish, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_finishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "flush"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.flush(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_flushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_framebufferRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto renderbuffertarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, argument3.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "renderbuffer", "WebGLRenderingContext", "framebufferRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "framebufferRenderbuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, attachment), InspectorCanvasCallTracer::processArgument(impl, renderbuffertarget), InspectorCanvasCallTracer::processArgument(impl, renderbuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.framebufferRenderbuffer(WTFMove(target), WTFMove(attachment), WTFMove(renderbuffertarget), WTFMove(renderbuffer)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_framebufferRenderbuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_framebufferRenderbufferBody>(*lexicalGlobalObject, *callFrame, "framebufferRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_framebufferTexture2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto textarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, argument3.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "texture", "WebGLRenderingContext", "framebufferTexture2D", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto level = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "framebufferTexture2D"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, attachment), InspectorCanvasCallTracer::processArgument(impl, textarget), InspectorCanvasCallTracer::processArgument(impl, texture), InspectorCanvasCallTracer::processArgument(impl, level) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.framebufferTexture2D(WTFMove(target), WTFMove(attachment), WTFMove(textarget), WTFMove(texture), WTFMove(level)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_framebufferTexture2D, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_framebufferTexture2DBody>(*lexicalGlobalObject, *callFrame, "framebufferTexture2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_frontFaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "frontFace"_s, { InspectorCanvasCallTracer::processArgument(impl, mode) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.frontFace(WTFMove(mode)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_frontFace, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_frontFaceBody>(*lexicalGlobalObject, *callFrame, "frontFace");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_generateMipmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "generateMipmap"_s, { InspectorCanvasCallTracer::processArgument(impl, target) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.generateMipmap(WTFMove(target)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_generateMipmap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_generateMipmapBody>(*lexicalGlobalObject, *callFrame, "generateMipmap");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getActiveAttribBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getActiveAttrib", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getActiveAttrib"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, index) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLActiveInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getActiveAttrib(*program, WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getActiveAttrib, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getActiveAttribBody>(*lexicalGlobalObject, *callFrame, "getActiveAttrib");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getActiveUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getActiveUniform", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getActiveUniform"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, index) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLActiveInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getActiveUniform(*program, WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getActiveUniform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getActiveUniformBody>(*lexicalGlobalObject, *callFrame, "getActiveUniform");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getAttachedShadersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getAttachedShaders", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getAttachedShaders"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<WebGLShader>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAttachedShaders(*program))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getAttachedShaders, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getAttachedShadersBody>(*lexicalGlobalObject, *callFrame, "getAttachedShaders");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getAttribLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getAttribLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getAttribLocation"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, name) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.getAttribLocation(*program, WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getAttribLocation, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getAttribLocationBody>(*lexicalGlobalObject, *callFrame, "getAttribLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getBufferParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getBufferParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBufferParameter(WTFMove(target), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getBufferParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getBufferParameterBody>(*lexicalGlobalObject, *callFrame, "getBufferParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getContextAttributesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getContextAttributes"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDictionary<WebGLContextAttributes>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getContextAttributes())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getContextAttributes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getContextAttributesBody>(*lexicalGlobalObject, *callFrame, "getContextAttributes");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getError"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.getError())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getError, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getErrorBody>(*lexicalGlobalObject, *callFrame, "getError");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getSupportedExtensionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getSupportedExtensions"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSupportedExtensions())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getSupportedExtensions, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getSupportedExtensionsBody>(*lexicalGlobalObject, *callFrame, "getSupportedExtensions");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getExtensionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getExtension"_s, { InspectorCanvasCallTracer::processArgument(impl, name) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLWebGLExtensionAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getExtension(WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getExtension, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getExtensionBody>(*lexicalGlobalObject, *callFrame, "getExtension");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getFramebufferAttachmentParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getFramebufferAttachmentParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, attachment), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getFramebufferAttachmentParameter(WTFMove(target), WTFMove(attachment), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getFramebufferAttachmentParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getFramebufferAttachmentParameterBody>(*lexicalGlobalObject, *callFrame, "getFramebufferAttachmentParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getParameter(WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getParameterBody>(*lexicalGlobalObject, *callFrame, "getParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getProgramParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getProgramParameter", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getProgramParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getProgramParameter(*program, WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getProgramParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getProgramParameterBody>(*lexicalGlobalObject, *callFrame, "getProgramParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getProgramInfoLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getProgramInfoLog", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getProgramInfoLog"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getProgramInfoLog(*program))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getProgramInfoLog, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getProgramInfoLogBody>(*lexicalGlobalObject, *callFrame, "getProgramInfoLog");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getRenderbufferParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getRenderbufferParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRenderbufferParameter(WTFMove(target), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getRenderbufferParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getRenderbufferParameterBody>(*lexicalGlobalObject, *callFrame, "getRenderbufferParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getShaderParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "getShaderParameter", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getShaderParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, shader), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getShaderParameter(*shader, WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getShaderParameterBody>(*lexicalGlobalObject, *callFrame, "getShaderParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getShaderInfoLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "getShaderInfoLog", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getShaderInfoLog"_s, { InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getShaderInfoLog(*shader))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderInfoLog, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getShaderInfoLogBody>(*lexicalGlobalObject, *callFrame, "getShaderInfoLog");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getShaderPrecisionFormatBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shadertype = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto precisiontype = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getShaderPrecisionFormat"_s, { InspectorCanvasCallTracer::processArgument(impl, shadertype), InspectorCanvasCallTracer::processArgument(impl, precisiontype) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLShaderPrecisionFormat>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getShaderPrecisionFormat(WTFMove(shadertype), WTFMove(precisiontype)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderPrecisionFormat, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getShaderPrecisionFormatBody>(*lexicalGlobalObject, *callFrame, "getShaderPrecisionFormat");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getShaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "getShaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getShaderSource"_s, { InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getShaderSource(*shader))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getShaderSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getShaderSourceBody>(*lexicalGlobalObject, *callFrame, "getShaderSource");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getTexParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getTexParameter"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getTexParameter(WTFMove(target), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getTexParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getTexParameterBody>(*lexicalGlobalObject, *callFrame, "getTexParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getUniform", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto location = convert<IDLInterface<WebGLUniformLocation>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "location", "WebGLRenderingContext", "getUniform", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getUniform"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, location) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getUniform(*program, *location))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getUniform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getUniformBody>(*lexicalGlobalObject, *callFrame, "getUniform");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getUniformLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "getUniformLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getUniformLocation"_s, { InspectorCanvasCallTracer::processArgument(impl, program), InspectorCanvasCallTracer::processArgument(impl, name) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLUniformLocation>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getUniformLocation(*program, WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getUniformLocation, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getUniformLocationBody>(*lexicalGlobalObject, *callFrame, "getUniformLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getVertexAttribBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getVertexAttrib"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getVertexAttrib(WTFMove(index), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getVertexAttrib, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getVertexAttribBody>(*lexicalGlobalObject, *callFrame, "getVertexAttrib");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_getVertexAttribOffsetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "getVertexAttribOffset"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, pname) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLongLong>(*lexicalGlobalObject, throwScope, impl.getVertexAttribOffset(WTFMove(index), WTFMove(pname)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_getVertexAttribOffset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_getVertexAttribOffsetBody>(*lexicalGlobalObject, *callFrame, "getVertexAttribOffset");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_hintBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "hint"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, mode) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.hint(WTFMove(target), WTFMove(mode)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_hint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_hintBody>(*lexicalGlobalObject, *callFrame, "hint");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "WebGLRenderingContext", "isBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isBuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, buffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isBuffer(WTFMove(buffer)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isBufferBody>(*lexicalGlobalObject, *callFrame, "isBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isContextLostBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isContextLost"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isContextLost())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isContextLost, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isContextLostBody>(*lexicalGlobalObject, *callFrame, "isContextLost");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isEnabled"_s, { InspectorCanvasCallTracer::processArgument(impl, cap) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isEnabled(WTFMove(cap)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isEnabled, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isEnabledBody>(*lexicalGlobalObject, *callFrame, "isEnabled");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "framebuffer", "WebGLRenderingContext", "isFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isFramebuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, framebuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isFramebuffer(WTFMove(framebuffer)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isFramebuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isFramebufferBody>(*lexicalGlobalObject, *callFrame, "isFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "isProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isProgram"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isProgram(WTFMove(program)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isProgramBody>(*lexicalGlobalObject, *callFrame, "isProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "renderbuffer", "WebGLRenderingContext", "isRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isRenderbuffer"_s, { InspectorCanvasCallTracer::processArgument(impl, renderbuffer) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isRenderbuffer(WTFMove(renderbuffer)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isRenderbuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isRenderbufferBody>(*lexicalGlobalObject, *callFrame, "isRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "isShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isShader"_s, { InspectorCanvasCallTracer::processArgument(impl, shader) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isShader(WTFMove(shader)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isShader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isShaderBody>(*lexicalGlobalObject, *callFrame, "isShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_isTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "texture", "WebGLRenderingContext", "isTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "isTexture"_s, { InspectorCanvasCallTracer::processArgument(impl, texture) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isTexture(WTFMove(texture)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_isTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_isTextureBody>(*lexicalGlobalObject, *callFrame, "isTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_lineWidthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "lineWidth"_s, { InspectorCanvasCallTracer::processArgument(impl, width) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.lineWidth(WTFMove(width)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_lineWidth, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_lineWidthBody>(*lexicalGlobalObject, *callFrame, "lineWidth");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_linkProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "linkProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "linkProgram"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.linkProgram(*program); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_linkProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_linkProgramBody>(*lexicalGlobalObject, *callFrame, "linkProgram");
}

#endif

#if ENABLE(WEBGL) && ENABLE(WEBXR)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_makeXRCompatibleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebGLRenderingContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "makeXRCompatible"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.makeXRCompatible(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_makeXRCompatible, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_makeXRCompatibleBody>(*lexicalGlobalObject, *callFrame, "makeXRCompatible");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_pixelStoreiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto param = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "pixelStorei"_s, { InspectorCanvasCallTracer::processArgument(impl, pname), InspectorCanvasCallTracer::processArgument(impl, param) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pixelStorei(WTFMove(pname), WTFMove(param)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_pixelStorei, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_pixelStoreiBody>(*lexicalGlobalObject, *callFrame, "pixelStorei");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_polygonOffsetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto factor = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto units = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "polygonOffset"_s, { InspectorCanvasCallTracer::processArgument(impl, factor), InspectorCanvasCallTracer::processArgument(impl, units) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.polygonOffset(WTFMove(factor), WTFMove(units)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_polygonOffset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_polygonOffsetBody>(*lexicalGlobalObject, *callFrame, "polygonOffset");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_readPixelsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto pixels = convert<IDLNullable<IDLAllowSharedAdaptor<IDLArrayBufferView>>>(*lexicalGlobalObject, argument6.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "pixels", "WebGLRenderingContext", "readPixels", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "readPixels"_s, { InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height), InspectorCanvasCallTracer::processArgument(impl, format), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, pixels) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.readPixels(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(pixels)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_readPixels, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_readPixelsBody>(*lexicalGlobalObject, *callFrame, "readPixels");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_renderbufferStorageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "renderbufferStorage"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, internalformat), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.renderbufferStorage(WTFMove(target), WTFMove(internalformat), WTFMove(width), WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_renderbufferStorage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_renderbufferStorageBody>(*lexicalGlobalObject, *callFrame, "renderbufferStorage");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_sampleCoverageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto invert = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "sampleCoverage"_s, { InspectorCanvasCallTracer::processArgument(impl, value), InspectorCanvasCallTracer::processArgument(impl, invert) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.sampleCoverage(WTFMove(value), WTFMove(invert)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_sampleCoverage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_sampleCoverageBody>(*lexicalGlobalObject, *callFrame, "sampleCoverage");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_scissorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "scissor"_s, { InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.scissor(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_scissor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_scissorBody>(*lexicalGlobalObject, *callFrame, "scissor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_shaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLRenderingContext", "shaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto string = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "shaderSource"_s, { InspectorCanvasCallTracer::processArgument(impl, shader), InspectorCanvasCallTracer::processArgument(impl, string) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.shaderSource(*shader, WTFMove(string)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_shaderSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_shaderSourceBody>(*lexicalGlobalObject, *callFrame, "shaderSource");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto ref = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilFunc"_s, { InspectorCanvasCallTracer::processArgument(impl, func), InspectorCanvasCallTracer::processArgument(impl, ref), InspectorCanvasCallTracer::processArgument(impl, mask) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilFunc(WTFMove(func), WTFMove(ref), WTFMove(mask)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilFunc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilFuncBody>(*lexicalGlobalObject, *callFrame, "stencilFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilFuncSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto ref = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilFuncSeparate"_s, { InspectorCanvasCallTracer::processArgument(impl, face), InspectorCanvasCallTracer::processArgument(impl, func), InspectorCanvasCallTracer::processArgument(impl, ref), InspectorCanvasCallTracer::processArgument(impl, mask) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilFuncSeparate(WTFMove(face), WTFMove(func), WTFMove(ref), WTFMove(mask)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilFuncSeparate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilFuncSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilFuncSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilMask"_s, { InspectorCanvasCallTracer::processArgument(impl, mask) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilMask(WTFMove(mask)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilMask, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilMaskBody>(*lexicalGlobalObject, *callFrame, "stencilMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilMaskSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilMaskSeparate"_s, { InspectorCanvasCallTracer::processArgument(impl, face), InspectorCanvasCallTracer::processArgument(impl, mask) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilMaskSeparate(WTFMove(face), WTFMove(mask)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilMaskSeparate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilMaskSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilMaskSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilOpBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fail = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto zfail = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto zpass = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilOp"_s, { InspectorCanvasCallTracer::processArgument(impl, fail), InspectorCanvasCallTracer::processArgument(impl, zfail), InspectorCanvasCallTracer::processArgument(impl, zpass) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilOp(WTFMove(fail), WTFMove(zfail), WTFMove(zpass)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilOp, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilOpBody>(*lexicalGlobalObject, *callFrame, "stencilOp");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_stencilOpSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto fail = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto zfail = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto zpass = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "stencilOpSeparate"_s, { InspectorCanvasCallTracer::processArgument(impl, face), InspectorCanvasCallTracer::processArgument(impl, fail), InspectorCanvasCallTracer::processArgument(impl, zfail), InspectorCanvasCallTracer::processArgument(impl, zpass) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stencilOpSeparate(WTFMove(face), WTFMove(fail), WTFMove(zfail), WTFMove(zpass)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_stencilOpSeparate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_stencilOpSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilOpSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texParameterfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto param = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texParameterf"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, pname), InspectorCanvasCallTracer::processArgument(impl, param) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texParameterf(WTFMove(target), WTFMove(pname), WTFMove(param)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texParameterf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_texParameterfBody>(*lexicalGlobalObject, *callFrame, "texParameterf");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_texParameteriBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto param = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "texParameteri"_s, { InspectorCanvasCallTracer::processArgument(impl, target), InspectorCanvasCallTracer::processArgument(impl, pname), InspectorCanvasCallTracer::processArgument(impl, param) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.texParameteri(WTFMove(target), WTFMove(pname), WTFMove(param)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_texParameteri, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_texParameteriBody>(*lexicalGlobalObject, *callFrame, "texParameteri");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform1fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform1f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform1f"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform1f(WTFMove(location), WTFMove(x)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform1fBody>(*lexicalGlobalObject, *callFrame, "uniform1f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform2fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform2f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform2f"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform2f(WTFMove(location), WTFMove(x), WTFMove(y)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform2fBody>(*lexicalGlobalObject, *callFrame, "uniform2f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform3fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform3f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform3f"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform3f(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform3fBody>(*lexicalGlobalObject, *callFrame, "uniform3f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform4fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform4f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform4f"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z), InspectorCanvasCallTracer::processArgument(impl, w) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform4f(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform4fBody>(*lexicalGlobalObject, *callFrame, "uniform4f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform1iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform1i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform1i"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform1i(WTFMove(location), WTFMove(x)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1i, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform1iBody>(*lexicalGlobalObject, *callFrame, "uniform1i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform2iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform2i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform2i"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform2i(WTFMove(location), WTFMove(x), WTFMove(y)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2i, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform2iBody>(*lexicalGlobalObject, *callFrame, "uniform2i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform3iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform3i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform3i"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform3i(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3i, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform3iBody>(*lexicalGlobalObject, *callFrame, "uniform3i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform4iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform4i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto w = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform4i"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z), InspectorCanvasCallTracer::processArgument(impl, w) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform4i(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4i, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform4iBody>(*lexicalGlobalObject, *callFrame, "uniform4i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform1fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform1fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform1fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform1fv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform1fvBody>(*lexicalGlobalObject, *callFrame, "uniform1fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform2fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform2fv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform2fvBody>(*lexicalGlobalObject, *callFrame, "uniform2fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform3fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform3fv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform3fvBody>(*lexicalGlobalObject, *callFrame, "uniform3fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform4fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform4fv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform4fvBody>(*lexicalGlobalObject, *callFrame, "uniform4fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform1ivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform1iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLInt32Array>, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform1iv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform1iv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform1iv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform1ivBody>(*lexicalGlobalObject, *callFrame, "uniform1iv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform2ivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform2iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLInt32Array>, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform2iv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform2iv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform2iv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform2ivBody>(*lexicalGlobalObject, *callFrame, "uniform2iv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform3ivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform3iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLInt32Array>, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform3iv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform3iv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform3iv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform3ivBody>(*lexicalGlobalObject, *callFrame, "uniform3iv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniform4ivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniform4iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto v = convert<IDLUnion<IDLAllowSharedAdaptor<IDLInt32Array>, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniform4iv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, v) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniform4iv(WTFMove(location), WTFMove(v)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniform4iv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniform4ivBody>(*lexicalGlobalObject, *callFrame, "uniform4iv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniformMatrix2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniformMatrix2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto array = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniformMatrix2fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, transpose), InspectorCanvasCallTracer::processArgument(impl, array) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniformMatrix2fv(WTFMove(location), WTFMove(transpose), WTFMove(array)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix2fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniformMatrix2fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix2fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniformMatrix3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniformMatrix3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto array = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniformMatrix3fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, transpose), InspectorCanvasCallTracer::processArgument(impl, array) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniformMatrix3fv(WTFMove(location), WTFMove(transpose), WTFMove(array)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix3fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniformMatrix3fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix3fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_uniformMatrix4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGLRenderingContext", "uniformMatrix4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto array = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "uniformMatrix4fv"_s, { InspectorCanvasCallTracer::processArgument(impl, location), InspectorCanvasCallTracer::processArgument(impl, transpose), InspectorCanvasCallTracer::processArgument(impl, array) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.uniformMatrix4fv(WTFMove(location), WTFMove(transpose), WTFMove(array)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_uniformMatrix4fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_uniformMatrix4fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix4fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_useProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "useProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "useProgram"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.useProgram(WTFMove(program)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_useProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_useProgramBody>(*lexicalGlobalObject, *callFrame, "useProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_validateProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGLRenderingContext", "validateProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "validateProgram"_s, { InspectorCanvasCallTracer::processArgument(impl, program) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.validateProgram(*program); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_validateProgram, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_validateProgramBody>(*lexicalGlobalObject, *callFrame, "validateProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib1f"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, x) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib1f(WTFMove(index), WTFMove(x)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib1f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib1f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib2f"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib2f(WTFMove(index), WTFMove(x), WTFMove(y)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib2f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib2f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib3f"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib3f(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib3f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib3f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib4f"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, z), InspectorCanvasCallTracer::processArgument(impl, w) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib4f(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib4f, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib4f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto values = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib1fv"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, values) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib1fv(WTFMove(index), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib1fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib1fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto values = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib2fv"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, values) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib2fv(WTFMove(index), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib2fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib2fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto values = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib3fv"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, values) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib3fv(WTFMove(index), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib3fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib3fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto values = convert<IDLUnion<IDLAllowSharedAdaptor<IDLFloat32Array>, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttrib4fv"_s, { InspectorCanvasCallTracer::processArgument(impl, index), InspectorCanvasCallTracer::processArgument(impl, values) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttrib4fv(WTFMove(index), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fv, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttrib4fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib4fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_vertexAttribPointerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indx = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto size = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto normalized = convert<IDLBoolean>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto stride = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "vertexAttribPointer"_s, { InspectorCanvasCallTracer::processArgument(impl, indx), InspectorCanvasCallTracer::processArgument(impl, size), InspectorCanvasCallTracer::processArgument(impl, type), InspectorCanvasCallTracer::processArgument(impl, normalized), InspectorCanvasCallTracer::processArgument(impl, stride), InspectorCanvasCallTracer::processArgument(impl, offset) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttribPointer(WTFMove(indx), WTFMove(size), WTFMove(type), WTFMove(normalized), WTFMove(stride), WTFMove(offset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_vertexAttribPointer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_vertexAttribPointerBody>(*lexicalGlobalObject, *callFrame, "vertexAttribPointer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGLRenderingContextPrototypeFunction_viewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLRenderingContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto width = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto height = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.hasActiveInspectorCanvasCallTracer()))
        InspectorCanvasCallTracer::recordAction(impl, "viewport"_s, { InspectorCanvasCallTracer::processArgument(impl, x), InspectorCanvasCallTracer::processArgument(impl, y), InspectorCanvasCallTracer::processArgument(impl, width), InspectorCanvasCallTracer::processArgument(impl, height) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.viewport(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLRenderingContextPrototypeFunction_viewport, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLRenderingContext>::call<jsWebGLRenderingContextPrototypeFunction_viewportBody>(*lexicalGlobalObject, *callFrame, "viewport");
}

#endif

JSC::GCClient::IsoSubspace* JSWebGLRenderingContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLRenderingContext, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLRenderingContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLRenderingContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLRenderingContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLRenderingContext = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebGLRenderingContext::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebGLRenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWebGLRenderingContext);

template<typename Visitor>
void JSWebGLRenderingContext::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebGLRenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWebGLRenderingContext::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWebGLRenderingContext::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWebGLRenderingContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLRenderingContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLRenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLRenderingContext = jsCast<JSWebGLRenderingContext*>(handle.slot()->asCell());
    auto& wrapped = jsWebGLRenderingContext->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    auto& owner = jsWebGLRenderingContext->wrapped().canvasBase();
    if (UNLIKELY(reason))
        *reason = "Reachable from CanvasBase";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLRenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLRenderingContext = static_cast<JSWebGLRenderingContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLRenderingContext->wrapped(), jsWebGLRenderingContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLRenderingContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebGLRenderingContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLRenderingContext>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLRenderingContext>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLRenderingContext@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebGLRenderingContextE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLRenderingContext has subclasses. If WebGLRenderingContext has subclasses that get passed
        // to toJS() we currently require WebGLRenderingContext you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLRenderingContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLRenderingContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLRenderingContext* JSWebGLRenderingContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLRenderingContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
