/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLMultiDraw.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawArraysWEBGL);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawArraysInstancedWEBGL);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawElementsWEBGL);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawElementsInstancedWEBGL);

class JSWebGLMultiDrawPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLMultiDrawPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLMultiDrawPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLMultiDrawPrototype>(vm)) JSWebGLMultiDrawPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLMultiDrawPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLMultiDrawPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLMultiDrawPrototype, JSWebGLMultiDrawPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLMultiDrawPrototypeTableValues[] =
{
    { "multiDrawArraysWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawPrototypeFunction_multiDrawArraysWEBGL, 6 } },
    { "multiDrawArraysInstancedWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawPrototypeFunction_multiDrawArraysInstancedWEBGL, 8 } },
    { "multiDrawElementsWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawPrototypeFunction_multiDrawElementsWEBGL, 7 } },
    { "multiDrawElementsInstancedWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLMultiDrawPrototypeFunction_multiDrawElementsInstancedWEBGL, 9 } },
};

const ClassInfo JSWebGLMultiDrawPrototype::s_info = { "WebGLMultiDraw"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLMultiDrawPrototype) };

void JSWebGLMultiDrawPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLMultiDraw::info(), JSWebGLMultiDrawPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLMultiDraw::s_info = { "WebGLMultiDraw"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLMultiDraw) };

JSWebGLMultiDraw::JSWebGLMultiDraw(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLMultiDraw>&& impl)
    : JSDOMWrapper<WebGLMultiDraw>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLMultiDraw>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLMultiDraw::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLMultiDrawPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLMultiDrawPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLMultiDraw::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLMultiDraw>(vm, globalObject);
}

void JSWebGLMultiDraw::destroy(JSC::JSCell* cell)
{
    JSWebGLMultiDraw* thisObject = static_cast<JSWebGLMultiDraw*>(cell);
    thisObject->JSWebGLMultiDraw::~JSWebGLMultiDraw();
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawPrototypeFunction_multiDrawArraysWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDraw>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto firstsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto firstsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto countsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto countsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto drawcount = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawArraysWEBGL(WTFMove(mode), WTFMove(firstsList), WTFMove(firstsOffset), WTFMove(countsList), WTFMove(countsOffset), WTFMove(drawcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawArraysWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDraw>::call<jsWebGLMultiDrawPrototypeFunction_multiDrawArraysWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawArraysWEBGL");
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawPrototypeFunction_multiDrawArraysInstancedWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDraw>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto firstsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto firstsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto countsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto countsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto instanceCountsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto instanceCountsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto drawcount = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawArraysInstancedWEBGL(WTFMove(mode), WTFMove(firstsList), WTFMove(firstsOffset), WTFMove(countsList), WTFMove(countsOffset), WTFMove(instanceCountsList), WTFMove(instanceCountsOffset), WTFMove(drawcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawArraysInstancedWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDraw>::call<jsWebGLMultiDrawPrototypeFunction_multiDrawArraysInstancedWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawArraysInstancedWEBGL");
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawPrototypeFunction_multiDrawElementsWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDraw>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto countsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto offsetsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto offsetsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto drawcount = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawElementsWEBGL(WTFMove(mode), WTFMove(countsList), WTFMove(countsOffset), WTFMove(type), WTFMove(offsetsList), WTFMove(offsetsOffset), WTFMove(drawcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawElementsWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDraw>::call<jsWebGLMultiDrawPrototypeFunction_multiDrawElementsWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawElementsWEBGL");
}

static inline JSC::EncodedJSValue jsWebGLMultiDrawPrototypeFunction_multiDrawElementsInstancedWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLMultiDraw>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 9))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto countsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto offsetsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto offsetsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto instanceCountsList = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto instanceCountsOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto drawcount = convert<IDLLong>(*lexicalGlobalObject, argument8.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.multiDrawElementsInstancedWEBGL(WTFMove(mode), WTFMove(countsList), WTFMove(countsOffset), WTFMove(type), WTFMove(offsetsList), WTFMove(offsetsOffset), WTFMove(instanceCountsList), WTFMove(instanceCountsOffset), WTFMove(drawcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLMultiDrawPrototypeFunction_multiDrawElementsInstancedWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLMultiDraw>::call<jsWebGLMultiDrawPrototypeFunction_multiDrawElementsInstancedWEBGLBody>(*lexicalGlobalObject, *callFrame, "multiDrawElementsInstancedWEBGL");
}

JSC::GCClient::IsoSubspace* JSWebGLMultiDraw::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLMultiDraw, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLMultiDraw.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLMultiDraw = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLMultiDraw.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLMultiDraw = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLMultiDraw::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLMultiDraw*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLMultiDrawOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLMultiDraw = jsCast<JSWebGLMultiDraw*>(handle.slot()->asCell());
    auto& owner = jsWebGLMultiDraw->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLMultiDraw";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLMultiDrawOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLMultiDraw = static_cast<JSWebGLMultiDraw*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLMultiDraw->wrapped(), jsWebGLMultiDraw);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLMultiDraw@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14WebGLMultiDrawE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLMultiDraw>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLMultiDraw>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLMultiDraw@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14WebGLMultiDrawE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLMultiDraw has subclasses. If WebGLMultiDraw has subclasses that get passed
        // to toJS() we currently require WebGLMultiDraw you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLMultiDraw>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLMultiDraw& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLMultiDraw* JSWebGLMultiDraw::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLMultiDraw*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
