/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugShaders.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLShader.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLDebugShadersPrototypeFunction_getTranslatedShaderSource);

class JSWebGLDebugShadersPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDebugShadersPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDebugShadersPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDebugShadersPrototype>(vm)) JSWebGLDebugShadersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDebugShadersPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDebugShadersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDebugShadersPrototype, JSWebGLDebugShadersPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugShadersPrototypeTableValues[] =
{
    { "getTranslatedShaderSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLDebugShadersPrototypeFunction_getTranslatedShaderSource, 1 } },
};

const ClassInfo JSWebGLDebugShadersPrototype::s_info = { "WebGLDebugShaders"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugShadersPrototype) };

void JSWebGLDebugShadersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDebugShaders::info(), JSWebGLDebugShadersPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLDebugShaders::s_info = { "WebGLDebugShaders"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugShaders) };

JSWebGLDebugShaders::JSWebGLDebugShaders(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDebugShaders>&& impl)
    : JSDOMWrapper<WebGLDebugShaders>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLDebugShaders>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLDebugShaders::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLDebugShadersPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLDebugShadersPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLDebugShaders::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDebugShaders>(vm, globalObject);
}

void JSWebGLDebugShaders::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugShaders* thisObject = static_cast<JSWebGLDebugShaders*>(cell);
    thisObject->JSWebGLDebugShaders::~JSWebGLDebugShaders();
}

static inline JSC::EncodedJSValue jsWebGLDebugShadersPrototypeFunction_getTranslatedShaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLDebugShaders>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLDebugShaders", "getTranslatedShaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getTranslatedShaderSource(*shader))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLDebugShadersPrototypeFunction_getTranslatedShaderSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLDebugShaders>::call<jsWebGLDebugShadersPrototypeFunction_getTranslatedShaderSourceBody>(*lexicalGlobalObject, *callFrame, "getTranslatedShaderSource");
}

JSC::GCClient::IsoSubspace* JSWebGLDebugShaders::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLDebugShaders, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLDebugShaders.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLDebugShaders = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLDebugShaders.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLDebugShaders = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLDebugShaders::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDebugShaders*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDebugShadersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    auto& owner = jsWebGLDebugShaders->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLDebugShaders";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLDebugShadersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDebugShaders = static_cast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDebugShaders->wrapped(), jsWebGLDebugShaders);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugShaders@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17WebGLDebugShadersE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDebugShaders>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLDebugShaders>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLDebugShaders@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17WebGLDebugShadersE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLDebugShaders has subclasses. If WebGLDebugShaders has subclasses that get passed
        // to toJS() we currently require WebGLDebugShaders you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLDebugShaders>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDebugShaders& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDebugShaders* JSWebGLDebugShaders::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDebugShaders*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
