/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureS3TCsRGB.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureS3TCsRGBPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureS3TCsRGBPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureS3TCsRGBPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureS3TCsRGBPrototype>(vm)) JSWebGLCompressedTextureS3TCsRGBPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureS3TCsRGBPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureS3TCsRGBPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureS3TCsRGBPrototype, JSWebGLCompressedTextureS3TCsRGBPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureS3TCsRGBPrototypeTableValues[] =
{
    { "COMPRESSED_SRGB_S3TC_DXT1_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C4C } },
    { "COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C4D } },
    { "COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C4E } },
    { "COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C4F } },
};

const ClassInfo JSWebGLCompressedTextureS3TCsRGBPrototype::s_info = { "WebGLCompressedTextureS3TCsRGB"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureS3TCsRGBPrototype) };

void JSWebGLCompressedTextureS3TCsRGBPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureS3TCsRGB::info(), JSWebGLCompressedTextureS3TCsRGBPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLCompressedTextureS3TCsRGB::s_info = { "WebGLCompressedTextureS3TCsRGB"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureS3TCsRGB) };

JSWebGLCompressedTextureS3TCsRGB::JSWebGLCompressedTextureS3TCsRGB(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureS3TCsRGB>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureS3TCsRGB>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureS3TCsRGB>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLCompressedTextureS3TCsRGB::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLCompressedTextureS3TCsRGBPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLCompressedTextureS3TCsRGBPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLCompressedTextureS3TCsRGB::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureS3TCsRGB>(vm, globalObject);
}

void JSWebGLCompressedTextureS3TCsRGB::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureS3TCsRGB* thisObject = static_cast<JSWebGLCompressedTextureS3TCsRGB*>(cell);
    thisObject->JSWebGLCompressedTextureS3TCsRGB::~JSWebGLCompressedTextureS3TCsRGB();
}

JSC::GCClient::IsoSubspace* JSWebGLCompressedTextureS3TCsRGB::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLCompressedTextureS3TCsRGB, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLCompressedTextureS3TCsRGB.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLCompressedTextureS3TCsRGB = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLCompressedTextureS3TCsRGB.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLCompressedTextureS3TCsRGB = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLCompressedTextureS3TCsRGB::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureS3TCsRGB*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureS3TCsRGBOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureS3TCsRGB = jsCast<JSWebGLCompressedTextureS3TCsRGB*>(handle.slot()->asCell());
    auto& owner = jsWebGLCompressedTextureS3TCsRGB->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLCompressedTextureS3TCsRGB";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLCompressedTextureS3TCsRGBOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureS3TCsRGB = static_cast<JSWebGLCompressedTextureS3TCsRGB*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureS3TCsRGB->wrapped(), jsWebGLCompressedTextureS3TCsRGB);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureS3TCsRGB@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore30WebGLCompressedTextureS3TCsRGBE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureS3TCsRGB>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLCompressedTextureS3TCsRGB>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureS3TCsRGB@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore30WebGLCompressedTextureS3TCsRGBE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLCompressedTextureS3TCsRGB has subclasses. If WebGLCompressedTextureS3TCsRGB has subclasses that get passed
        // to toJS() we currently require WebGLCompressedTextureS3TCsRGB you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLCompressedTextureS3TCsRGB>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureS3TCsRGB& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureS3TCsRGB* JSWebGLCompressedTextureS3TCsRGB::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureS3TCsRGB*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
