/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLColorBufferFloat.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLColorBufferFloatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLColorBufferFloatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLColorBufferFloatPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLColorBufferFloatPrototype>(vm)) JSWebGLColorBufferFloatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLColorBufferFloatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLColorBufferFloatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLColorBufferFloatPrototype, JSWebGLColorBufferFloatPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLColorBufferFloatPrototypeTableValues[] =
{
    { "RGBA32F_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8814 } },
    { "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8211 } },
    { "UNSIGNED_NORMALIZED_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8C17 } },
};

const ClassInfo JSWebGLColorBufferFloatPrototype::s_info = { "WebGLColorBufferFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLColorBufferFloatPrototype) };

void JSWebGLColorBufferFloatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLColorBufferFloat::info(), JSWebGLColorBufferFloatPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLColorBufferFloat::s_info = { "WebGLColorBufferFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLColorBufferFloat) };

JSWebGLColorBufferFloat::JSWebGLColorBufferFloat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLColorBufferFloat>&& impl)
    : JSDOMWrapper<WebGLColorBufferFloat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLColorBufferFloat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLColorBufferFloat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLColorBufferFloatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLColorBufferFloatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLColorBufferFloat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLColorBufferFloat>(vm, globalObject);
}

void JSWebGLColorBufferFloat::destroy(JSC::JSCell* cell)
{
    JSWebGLColorBufferFloat* thisObject = static_cast<JSWebGLColorBufferFloat*>(cell);
    thisObject->JSWebGLColorBufferFloat::~JSWebGLColorBufferFloat();
}

JSC::GCClient::IsoSubspace* JSWebGLColorBufferFloat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLColorBufferFloat, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLColorBufferFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLColorBufferFloat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLColorBufferFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLColorBufferFloat = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLColorBufferFloat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLColorBufferFloat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLColorBufferFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLColorBufferFloat = jsCast<JSWebGLColorBufferFloat*>(handle.slot()->asCell());
    auto& owner = jsWebGLColorBufferFloat->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLColorBufferFloat";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLColorBufferFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLColorBufferFloat = static_cast<JSWebGLColorBufferFloat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLColorBufferFloat->wrapped(), jsWebGLColorBufferFloat);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLColorBufferFloat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebGLColorBufferFloatE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLColorBufferFloat>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLColorBufferFloat>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLColorBufferFloat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebGLColorBufferFloatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLColorBufferFloat has subclasses. If WebGLColorBufferFloat has subclasses that get passed
        // to toJS() we currently require WebGLColorBufferFloat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLColorBufferFloat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLColorBufferFloat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLColorBufferFloat* JSWebGLColorBufferFloat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLColorBufferFloat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
