/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsVideoEncoderConfig.h"

#include "JSAvcEncoderConfig.h"
#include "JSBitrateMode.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSHardwareAcceleration.h"
#include "JSLatencyMode.h"
#include "JSWebCodecsAlphaOption.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsVideoEncoderConfig convertDictionary<WebCodecsVideoEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsVideoEncoderConfig result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaValue.isUndefined()) {
        result.alpha = convert<IDLEnumeration<WebCodecsAlphaOption>>(lexicalGlobalObject, alphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.alpha = WebCodecsAlphaOption::Discard;
    JSValue avcValue;
    if (isNullOrUndefined)
        avcValue = jsUndefined();
    else {
        avcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "avc"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!avcValue.isUndefined()) {
        result.avc = convert<IDLDictionary<AvcEncoderConfig>>(lexicalGlobalObject, avcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitrateValue;
    if (isNullOrUndefined)
        bitrateValue = jsUndefined();
    else {
        bitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateValue.isUndefined()) {
        result.bitrate = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, bitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitrateModeValue;
    if (isNullOrUndefined)
        bitrateModeValue = jsUndefined();
    else {
        bitrateModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrateMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateModeValue.isUndefined()) {
        result.bitrateMode = convert<IDLEnumeration<BitrateMode>>(lexicalGlobalObject, bitrateModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bitrateMode = BitrateMode::Variable;
    JSValue codecValue;
    if (isNullOrUndefined)
        codecValue = jsUndefined();
    else {
        codecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codec"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecValue.isUndefined()) {
        result.codec = convert<IDLDOMString>(lexicalGlobalObject, codecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codec", "WebCodecsVideoEncoderConfig", "DOMString");
        return { };
    }
    JSValue displayHeightValue;
    if (isNullOrUndefined)
        displayHeightValue = jsUndefined();
    else {
        displayHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayHeightValue.isUndefined()) {
        result.displayHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayWidthValue;
    if (isNullOrUndefined)
        displayWidthValue = jsUndefined();
    else {
        displayWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayWidthValue.isUndefined()) {
        result.displayWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framerateValue;
    if (isNullOrUndefined)
        framerateValue = jsUndefined();
    else {
        framerateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framerate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framerateValue.isUndefined()) {
        result.framerate = convert<IDLDouble>(lexicalGlobalObject, framerateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hardwareAccelerationValue;
    if (isNullOrUndefined)
        hardwareAccelerationValue = jsUndefined();
    else {
        hardwareAccelerationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hardwareAcceleration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hardwareAccelerationValue.isUndefined()) {
        result.hardwareAcceleration = convert<IDLEnumeration<HardwareAcceleration>>(lexicalGlobalObject, hardwareAccelerationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.hardwareAcceleration = HardwareAcceleration::NoPreference;
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "height", "WebCodecsVideoEncoderConfig", "unsigned long");
        return { };
    }
    JSValue latencyModeValue;
    if (isNullOrUndefined)
        latencyModeValue = jsUndefined();
    else {
        latencyModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "latencyMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!latencyModeValue.isUndefined()) {
        result.latencyMode = convert<IDLEnumeration<LatencyMode>>(lexicalGlobalObject, latencyModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.latencyMode = LatencyMode::Quality;
    JSValue scalabilityModeValue;
    if (isNullOrUndefined)
        scalabilityModeValue = jsUndefined();
    else {
        scalabilityModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scalabilityMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!scalabilityModeValue.isUndefined()) {
        result.scalabilityMode = convert<IDLDOMString>(lexicalGlobalObject, scalabilityModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "width", "WebCodecsVideoEncoderConfig", "unsigned long");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebCodecsVideoEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto alphaValue = toJS<IDLEnumeration<WebCodecsAlphaOption>>(lexicalGlobalObject, throwScope, dictionary.alpha);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "alpha"_s), alphaValue);
    if (!IDLDictionary<AvcEncoderConfig>::isNullValue(dictionary.avc)) {
        auto avcValue = toJS<IDLDictionary<AvcEncoderConfig>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AvcEncoderConfig>::extractValueFromNullable(dictionary.avc));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "avc"_s), avcValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.bitrate)) {
        auto bitrateValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.bitrate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrate"_s), bitrateValue);
    }
    auto bitrateModeValue = toJS<IDLEnumeration<BitrateMode>>(lexicalGlobalObject, throwScope, dictionary.bitrateMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrateMode"_s), bitrateModeValue);
    auto codecValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.codec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "codec"_s), codecValue);
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.displayHeight)) {
        auto displayHeightValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.displayHeight));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displayHeight"_s), displayHeightValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.displayWidth)) {
        auto displayWidthValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.displayWidth));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displayWidth"_s), displayWidthValue);
    }
    if (!IDLDouble::isNullValue(dictionary.framerate)) {
        auto framerateValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.framerate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framerate"_s), framerateValue);
    }
    auto hardwareAccelerationValue = toJS<IDLEnumeration<HardwareAcceleration>>(lexicalGlobalObject, throwScope, dictionary.hardwareAcceleration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "hardwareAcceleration"_s), hardwareAccelerationValue);
    auto heightValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    auto latencyModeValue = toJS<IDLEnumeration<LatencyMode>>(lexicalGlobalObject, throwScope, dictionary.latencyMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "latencyMode"_s), latencyModeValue);
    if (!IDLDOMString::isNullValue(dictionary.scalabilityMode)) {
        auto scalabilityModeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.scalabilityMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "scalabilityMode"_s), scalabilityModeValue);
    }
    auto widthValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
