/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsVideoDecoderConfig.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include "JSHardwareAcceleration.h"
#include "JSVideoColorSpaceInit.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsVideoDecoderConfig convertDictionary<WebCodecsVideoDecoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsVideoDecoderConfig result;
    JSValue codecValue;
    if (isNullOrUndefined)
        codecValue = jsUndefined();
    else {
        codecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codec"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecValue.isUndefined()) {
        result.codec = convert<IDLDOMString>(lexicalGlobalObject, codecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codec", "WebCodecsVideoDecoderConfig", "DOMString");
        return { };
    }
    JSValue codedHeightValue;
    if (isNullOrUndefined)
        codedHeightValue = jsUndefined();
    else {
        codedHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codedHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codedHeightValue.isUndefined()) {
        result.codedHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, codedHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codedWidthValue;
    if (isNullOrUndefined)
        codedWidthValue = jsUndefined();
    else {
        codedWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codedWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codedWidthValue.isUndefined()) {
        result.codedWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, codedWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue colorSpaceValue;
    if (isNullOrUndefined)
        colorSpaceValue = jsUndefined();
    else {
        colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorSpaceValue.isUndefined()) {
        result.colorSpace = convert<IDLDictionary<VideoColorSpaceInit>>(lexicalGlobalObject, colorSpaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue descriptionValue;
    if (isNullOrUndefined)
        descriptionValue = jsUndefined();
    else {
        descriptionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "description"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!descriptionValue.isUndefined()) {
        result.description = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(lexicalGlobalObject, descriptionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayAspectHeightValue;
    if (isNullOrUndefined)
        displayAspectHeightValue = jsUndefined();
    else {
        displayAspectHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayAspectHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayAspectHeightValue.isUndefined()) {
        result.displayAspectHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, displayAspectHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayAspectWidthValue;
    if (isNullOrUndefined)
        displayAspectWidthValue = jsUndefined();
    else {
        displayAspectWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayAspectWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayAspectWidthValue.isUndefined()) {
        result.displayAspectWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, displayAspectWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hardwareAccelerationValue;
    if (isNullOrUndefined)
        hardwareAccelerationValue = jsUndefined();
    else {
        hardwareAccelerationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hardwareAcceleration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hardwareAccelerationValue.isUndefined()) {
        result.hardwareAcceleration = convert<IDLEnumeration<HardwareAcceleration>>(lexicalGlobalObject, hardwareAccelerationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.hardwareAcceleration = HardwareAcceleration::NoPreference;
    JSValue optimizeForLatencyValue;
    if (isNullOrUndefined)
        optimizeForLatencyValue = jsUndefined();
    else {
        optimizeForLatencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "optimizeForLatency"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!optimizeForLatencyValue.isUndefined()) {
        result.optimizeForLatency = convert<IDLBoolean>(lexicalGlobalObject, optimizeForLatencyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebCodecsVideoDecoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto codecValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.codec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "codec"_s), codecValue);
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.codedHeight)) {
        auto codedHeightValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.codedHeight));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codedHeight"_s), codedHeightValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.codedWidth)) {
        auto codedWidthValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.codedWidth));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codedWidth"_s), codedWidthValue);
    }
    if (!IDLDictionary<VideoColorSpaceInit>::isNullValue(dictionary.colorSpace)) {
        auto colorSpaceValue = toJS<IDLDictionary<VideoColorSpaceInit>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<VideoColorSpaceInit>::extractValueFromNullable(dictionary.colorSpace));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "colorSpace"_s), colorSpaceValue);
    }
    if (!IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>::isNullValue(dictionary.description)) {
        auto descriptionValue = toJS<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(lexicalGlobalObject, globalObject, throwScope, IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>::extractValueFromNullable(dictionary.description));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "description"_s), descriptionValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.displayAspectHeight)) {
        auto displayAspectHeightValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.displayAspectHeight));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displayAspectHeight"_s), displayAspectHeightValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.displayAspectWidth)) {
        auto displayAspectWidthValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.displayAspectWidth));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displayAspectWidth"_s), displayAspectWidthValue);
    }
    auto hardwareAccelerationValue = toJS<IDLEnumeration<HardwareAcceleration>>(lexicalGlobalObject, throwScope, dictionary.hardwareAcceleration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "hardwareAcceleration"_s), hardwareAccelerationValue);
    if (!IDLBoolean::isNullValue(dictionary.optimizeForLatency)) {
        auto optimizeForLatencyValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.optimizeForLatency));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "optimizeForLatency"_s), optimizeForLatencyValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
