/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsEncodedVideoChunkMetadata.h"

#include "JSDOMGlobalObject.h"
#include "JSWebCodecsSvcOutputMetadata.h"
#include "JSWebCodecsVideoDecoderConfig.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsEncodedVideoChunkMetadata convertDictionary<WebCodecsEncodedVideoChunkMetadata>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsEncodedVideoChunkMetadata result;
    JSValue decoderConfigValue;
    if (isNullOrUndefined)
        decoderConfigValue = jsUndefined();
    else {
        decoderConfigValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "decoderConfig"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!decoderConfigValue.isUndefined()) {
        result.decoderConfig = convert<IDLDictionary<WebCodecsVideoDecoderConfig>>(lexicalGlobalObject, decoderConfigValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue svcValue;
    if (isNullOrUndefined)
        svcValue = jsUndefined();
    else {
        svcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "svc"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!svcValue.isUndefined()) {
        result.svc = convert<IDLDictionary<WebCodecsSvcOutputMetadata>>(lexicalGlobalObject, svcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebCodecsEncodedVideoChunkMetadata& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<WebCodecsVideoDecoderConfig>::isNullValue(dictionary.decoderConfig)) {
        auto decoderConfigValue = toJS<IDLDictionary<WebCodecsVideoDecoderConfig>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<WebCodecsVideoDecoderConfig>::extractValueFromNullable(dictionary.decoderConfig));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "decoderConfig"_s), decoderConfigValue);
    }
    if (!IDLDictionary<WebCodecsSvcOutputMetadata>::isNullValue(dictionary.svc)) {
        auto svcValue = toJS<IDLDictionary<WebCodecsSvcOutputMetadata>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<WebCodecsSvcOutputMetadata>::extractValueFromNullable(dictionary.svc));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "svc"_s), svcValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
