/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsEncodedAudioChunk.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebCodecsEncodedAudioChunkType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsEncodedAudioChunk::Init convertDictionary<WebCodecsEncodedAudioChunk::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsEncodedAudioChunk::Init result;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "data", "WebCodecsEncodedAudioChunkInit", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<WebCodecsEncodedAudioChunkType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type", "WebCodecsEncodedAudioChunkInit", "WebCodecsEncodedAudioChunkType");
        return { };
    }
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsEncodedAudioChunkPrototypeFunction_copyTo);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_type);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_timestamp);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_byteLength);

class JSWebCodecsEncodedAudioChunkPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsEncodedAudioChunkPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsEncodedAudioChunkPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsEncodedAudioChunkPrototype>(vm)) JSWebCodecsEncodedAudioChunkPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsEncodedAudioChunkPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsEncodedAudioChunkPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsEncodedAudioChunkPrototype, JSWebCodecsEncodedAudioChunkPrototype::Base);

using JSWebCodecsEncodedAudioChunkDOMConstructor = JSDOMConstructor<JSWebCodecsEncodedAudioChunk>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsEncodedAudioChunkDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsEncodedAudioChunkDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto init = convert<IDLDictionary<WebCodecsEncodedAudioChunk::Init>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebCodecsEncodedAudioChunk::create(WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsEncodedAudioChunk>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsEncodedAudioChunk>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsEncodedAudioChunkDOMConstructorConstruct, JSWebCodecsEncodedAudioChunkDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsEncodedAudioChunkDOMConstructor::s_info = { "EncodedAudioChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedAudioChunkDOMConstructor) };

template<> JSValue JSWebCodecsEncodedAudioChunkDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebCodecsEncodedAudioChunkDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "EncodedAudioChunk"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsEncodedAudioChunk::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebCodecsEncodedAudioChunkPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedAudioChunkConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedAudioChunk_type, 0 } },
    { "timestamp"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedAudioChunk_timestamp, 0 } },
    { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedAudioChunk_duration, 0 } },
    { "byteLength"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedAudioChunk_byteLength, 0 } },
    { "copyTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsEncodedAudioChunkPrototypeFunction_copyTo, 1 } },
};

const ClassInfo JSWebCodecsEncodedAudioChunkPrototype::s_info = { "EncodedAudioChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedAudioChunkPrototype) };

void JSWebCodecsEncodedAudioChunkPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsEncodedAudioChunk::info(), JSWebCodecsEncodedAudioChunkPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsEncodedAudioChunk::s_info = { "EncodedAudioChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedAudioChunk) };

JSWebCodecsEncodedAudioChunk::JSWebCodecsEncodedAudioChunk(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsEncodedAudioChunk>&& impl)
    : JSDOMWrapper<WebCodecsEncodedAudioChunk>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebCodecsEncodedAudioChunk>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebCodecsEncodedAudioChunk::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsEncodedAudioChunkPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebCodecsEncodedAudioChunkPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsEncodedAudioChunk::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsEncodedAudioChunk>(vm, globalObject);
}

JSValue JSWebCodecsEncodedAudioChunk::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsEncodedAudioChunkDOMConstructor, DOMConstructorID::WebCodecsEncodedAudioChunk>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebCodecsEncodedAudioChunk::destroy(JSC::JSCell* cell)
{
    JSWebCodecsEncodedAudioChunk* thisObject = static_cast<JSWebCodecsEncodedAudioChunk*>(cell);
    thisObject->JSWebCodecsEncodedAudioChunk::~JSWebCodecsEncodedAudioChunk();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsEncodedAudioChunkPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsEncodedAudioChunk::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebCodecsEncodedAudioChunk_typeGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedAudioChunk& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebCodecsEncodedAudioChunkType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedAudioChunk>::get<jsWebCodecsEncodedAudioChunk_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedAudioChunk_timestampGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedAudioChunk& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.timestamp())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_timestamp, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedAudioChunk>::get<jsWebCodecsEncodedAudioChunk_timestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedAudioChunk_durationGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedAudioChunk& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedAudioChunk>::get<jsWebCodecsEncodedAudioChunk_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedAudioChunk_byteLengthGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedAudioChunk& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.byteLength())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedAudioChunk_byteLength, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedAudioChunk>::get<jsWebCodecsEncodedAudioChunk_byteLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsEncodedAudioChunkPrototypeFunction_copyToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsEncodedAudioChunk>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destination = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTo(WTFMove(destination)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsEncodedAudioChunkPrototypeFunction_copyTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsEncodedAudioChunk>::call<jsWebCodecsEncodedAudioChunkPrototypeFunction_copyToBody>(*lexicalGlobalObject, *callFrame, "copyTo");
}

JSC::GCClient::IsoSubspace* JSWebCodecsEncodedAudioChunk::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsEncodedAudioChunk, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsEncodedAudioChunk.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsEncodedAudioChunk = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsEncodedAudioChunk.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsEncodedAudioChunk = std::forward<decltype(space)>(space); }
    );
}

void JSWebCodecsEncodedAudioChunk::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsEncodedAudioChunk*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsEncodedAudioChunkOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsEncodedAudioChunkOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsEncodedAudioChunk = static_cast<JSWebCodecsEncodedAudioChunk*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebCodecsEncodedAudioChunk->wrapped(), jsWebCodecsEncodedAudioChunk);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsEncodedAudioChunk@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebCodecsEncodedAudioChunkE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsEncodedAudioChunk>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebCodecsEncodedAudioChunk>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsEncodedAudioChunk@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26WebCodecsEncodedAudioChunkE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsEncodedAudioChunk has subclasses. If WebCodecsEncodedAudioChunk has subclasses that get passed
        // to toJS() we currently require WebCodecsEncodedAudioChunk you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebCodecsEncodedAudioChunk>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsEncodedAudioChunk& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsEncodedAudioChunk* JSWebCodecsEncodedAudioChunk::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsEncodedAudioChunk*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
