/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioEncoderConfig.h"

#include "JSAacEncoderConfig.h"
#include "JSBitrateMode.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSFlacEncoderConfig.h"
#include "JSOpusEncoderConfig.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsAudioEncoderConfig convertDictionary<WebCodecsAudioEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsAudioEncoderConfig result;
    JSValue aacValue;
    if (isNullOrUndefined)
        aacValue = jsUndefined();
    else {
        aacValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aac"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aacValue.isUndefined()) {
        result.aac = convert<IDLDictionary<AacEncoderConfig>>(lexicalGlobalObject, aacValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitrateValue;
    if (isNullOrUndefined)
        bitrateValue = jsUndefined();
    else {
        bitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateValue.isUndefined()) {
        result.bitrate = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, bitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitrateModeValue;
    if (isNullOrUndefined)
        bitrateModeValue = jsUndefined();
    else {
        bitrateModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrateMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateModeValue.isUndefined()) {
        result.bitrateMode = convert<IDLEnumeration<BitrateMode>>(lexicalGlobalObject, bitrateModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bitrateMode = BitrateMode::Variable;
    JSValue codecValue;
    if (isNullOrUndefined)
        codecValue = jsUndefined();
    else {
        codecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codec"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecValue.isUndefined()) {
        result.codec = convert<IDLDOMString>(lexicalGlobalObject, codecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codec", "WebCodecsAudioEncoderConfig", "DOMString");
        return { };
    }
    JSValue flacValue;
    if (isNullOrUndefined)
        flacValue = jsUndefined();
    else {
        flacValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "flac"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!flacValue.isUndefined()) {
        result.flac = convert<IDLDictionary<FlacEncoderConfig>>(lexicalGlobalObject, flacValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue numberOfChannelsValue;
    if (isNullOrUndefined)
        numberOfChannelsValue = jsUndefined();
    else {
        numberOfChannelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfChannels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfChannelsValue.isUndefined()) {
        result.numberOfChannels = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, numberOfChannelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue opusValue;
    if (isNullOrUndefined)
        opusValue = jsUndefined();
    else {
        opusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "opus"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!opusValue.isUndefined()) {
        result.opus = convert<IDLDictionary<OpusEncoderConfig>>(lexicalGlobalObject, opusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebCodecsAudioEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<AacEncoderConfig>::isNullValue(dictionary.aac)) {
        auto aacValue = toJS<IDLDictionary<AacEncoderConfig>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AacEncoderConfig>::extractValueFromNullable(dictionary.aac));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aac"_s), aacValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::isNullValue(dictionary.bitrate)) {
        auto bitrateValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.bitrate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrate"_s), bitrateValue);
    }
    auto bitrateModeValue = toJS<IDLEnumeration<BitrateMode>>(lexicalGlobalObject, throwScope, dictionary.bitrateMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrateMode"_s), bitrateModeValue);
    auto codecValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.codec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "codec"_s), codecValue);
    if (!IDLDictionary<FlacEncoderConfig>::isNullValue(dictionary.flac)) {
        auto flacValue = toJS<IDLDictionary<FlacEncoderConfig>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<FlacEncoderConfig>::extractValueFromNullable(dictionary.flac));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "flac"_s), flacValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.numberOfChannels)) {
        auto numberOfChannelsValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.numberOfChannels));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "numberOfChannels"_s), numberOfChannelsValue);
    }
    if (!IDLDictionary<OpusEncoderConfig>::isNullValue(dictionary.opus)) {
        auto opusValue = toJS<IDLDictionary<OpusEncoderConfig>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<OpusEncoderConfig>::extractValueFromNullable(dictionary.opus));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "opus"_s), opusValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
