/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)

#include "JSVideoTrackGenerator.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStreamTrack.h"
#include "JSWritableStream.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackGeneratorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackGenerator_writable);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackGenerator_muted);
static JSC_DECLARE_CUSTOM_SETTER(setJSVideoTrackGenerator_muted);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackGenerator_track);

class JSVideoTrackGeneratorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoTrackGeneratorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackGeneratorPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackGeneratorPrototype>(vm)) JSVideoTrackGeneratorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackGeneratorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoTrackGeneratorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackGeneratorPrototype, JSVideoTrackGeneratorPrototype::Base);

using JSVideoTrackGeneratorDOMConstructor = JSDOMConstructor<JSVideoTrackGenerator>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSVideoTrackGeneratorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSVideoTrackGeneratorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VideoTrackGenerator");
    auto object = VideoTrackGenerator::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<VideoTrackGenerator>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<VideoTrackGenerator>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSVideoTrackGeneratorDOMConstructorConstruct, JSVideoTrackGeneratorDOMConstructor::construct);

template<> const ClassInfo JSVideoTrackGeneratorDOMConstructor::s_info = { "VideoTrackGenerator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackGeneratorDOMConstructor) };

template<> JSValue JSVideoTrackGeneratorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoTrackGeneratorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoTrackGenerator"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVideoTrackGenerator::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSVideoTrackGeneratorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackGeneratorConstructor, 0 } },
    { "writable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackGenerator_writable, 0 } },
    { "muted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackGenerator_muted, setJSVideoTrackGenerator_muted } },
    { "track"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackGenerator_track, 0 } },
};

const ClassInfo JSVideoTrackGeneratorPrototype::s_info = { "VideoTrackGenerator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackGeneratorPrototype) };

void JSVideoTrackGeneratorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoTrackGenerator::info(), JSVideoTrackGeneratorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVideoTrackGenerator::s_info = { "VideoTrackGenerator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackGenerator) };

JSVideoTrackGenerator::JSVideoTrackGenerator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoTrackGenerator>&& impl)
    : JSDOMWrapper<VideoTrackGenerator>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, VideoTrackGenerator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVideoTrackGenerator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVideoTrackGeneratorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSVideoTrackGeneratorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSVideoTrackGenerator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoTrackGenerator>(vm, globalObject);
}

JSValue JSVideoTrackGenerator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoTrackGeneratorDOMConstructor, DOMConstructorID::VideoTrackGenerator>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoTrackGenerator::destroy(JSC::JSCell* cell)
{
    JSVideoTrackGenerator* thisObject = static_cast<JSVideoTrackGenerator*>(cell);
    thisObject->JSVideoTrackGenerator::~JSVideoTrackGenerator();
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackGeneratorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoTrackGeneratorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVideoTrackGenerator::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsVideoTrackGenerator_writableGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackGenerator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WritableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.writable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackGenerator_writable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackGenerator>::get<jsVideoTrackGenerator_writableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackGenerator_mutedGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackGenerator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.muted(*context))));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackGenerator_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackGenerator>::get<jsVideoTrackGenerator_mutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVideoTrackGenerator_mutedSetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackGenerator& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMuted(*context, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVideoTrackGenerator_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackGenerator>::set<setJSVideoTrackGenerator_mutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVideoTrackGenerator_trackGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackGenerator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackGenerator_track, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackGenerator>::get<jsVideoTrackGenerator_trackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSVideoTrackGenerator::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVideoTrackGenerator, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVideoTrackGenerator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVideoTrackGenerator = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVideoTrackGenerator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVideoTrackGenerator = std::forward<decltype(space)>(space); }
    );
}

void JSVideoTrackGenerator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoTrackGenerator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoTrackGeneratorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVideoTrackGeneratorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoTrackGenerator = static_cast<JSVideoTrackGenerator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoTrackGenerator->wrapped(), jsVideoTrackGenerator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrackGenerator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19VideoTrackGeneratorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoTrackGenerator>&& impl)
{

    if constexpr (std::is_polymorphic_v<VideoTrackGenerator>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VideoTrackGenerator@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19VideoTrackGeneratorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VideoTrackGenerator has subclasses. If VideoTrackGenerator has subclasses that get passed
        // to toJS() we currently require VideoTrackGenerator you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<VideoTrackGenerator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoTrackGenerator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoTrackGenerator* JSVideoTrackGenerator::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoTrackGenerator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
