/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO)

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "VTTRegion.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSVTTRegion : public JSDOMWrapper<VTTRegion> {
public:
    using Base = JSDOMWrapper<VTTRegion>;
    static JSVTTRegion* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<VTTRegion>&& impl)
    {
        JSVTTRegion* ptr = new (NotNull, JSC::allocateCell<JSVTTRegion>(globalObject->vm())) JSVTTRegion(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static VTTRegion* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSVTTRegion(JSC::Structure*, JSDOMGlobalObject&, Ref<VTTRegion>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSVTTRegionOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, const char**) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, VTTRegion*)
{
    static NeverDestroyed<JSVTTRegionOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(VTTRegion* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, VTTRegion&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VTTRegion* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<VTTRegion>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<VTTRegion>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<VTTRegion> {
    using WrapperClass = JSVTTRegion;
    using ToWrappedReturnType = VTTRegion*;
};
String convertEnumerationToString(VTTRegion::ScrollSetting);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, VTTRegion::ScrollSetting);

template<> std::optional<VTTRegion::ScrollSetting> parseEnumerationFromString<VTTRegion::ScrollSetting>(const String&);
template<> std::optional<VTTRegion::ScrollSetting> parseEnumeration<VTTRegion::ScrollSetting>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<VTTRegion::ScrollSetting>();


} // namespace WebCore

#endif // ENABLE(VIDEO)
