/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTrustedTypePolicyOptions.h"

#include "JSCreateHTMLCallback.h"
#include "JSCreateScriptCallback.h"
#include "JSCreateScriptURLCallback.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> TrustedTypePolicyOptions convertDictionary<TrustedTypePolicyOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TrustedTypePolicyOptions result;
    JSValue createHTMLValue;
    if (isNullOrUndefined)
        createHTMLValue = jsUndefined();
    else {
        createHTMLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createHTML"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createHTMLValue.isUndefined()) {
        result.createHTML = convert<IDLCallbackFunction<JSCreateHTMLCallback>>(lexicalGlobalObject, createHTMLValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue createScriptValue;
    if (isNullOrUndefined)
        createScriptValue = jsUndefined();
    else {
        createScriptValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createScript"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createScriptValue.isUndefined()) {
        result.createScript = convert<IDLCallbackFunction<JSCreateScriptCallback>>(lexicalGlobalObject, createScriptValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue createScriptURLValue;
    if (isNullOrUndefined)
        createScriptURLValue = jsUndefined();
    else {
        createScriptURLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createScriptURL"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createScriptURLValue.isUndefined()) {
        result.createScriptURL = convert<IDLCallbackFunction<JSCreateScriptURLCallback>>(lexicalGlobalObject, createScriptURLValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
