/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> StorageEvent::Init convertDictionary<StorageEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    StorageEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue keyValue;
    if (isNullOrUndefined)
        keyValue = jsUndefined();
    else {
        keyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "key"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyValue.isUndefined()) {
        result.key = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, keyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.key = String();
    JSValue newValueValue;
    if (isNullOrUndefined)
        newValueValue = jsUndefined();
    else {
        newValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "newValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!newValueValue.isUndefined()) {
        result.newValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, newValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.newValue = String();
    JSValue oldValueValue;
    if (isNullOrUndefined)
        oldValueValue = jsUndefined();
    else {
        oldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "oldValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!oldValueValue.isUndefined()) {
        result.oldValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, oldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.oldValue = String();
    JSValue storageAreaValue;
    if (isNullOrUndefined)
        storageAreaValue = jsUndefined();
    else {
        storageAreaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageArea"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!storageAreaValue.isUndefined()) {
        result.storageArea = convert<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, storageAreaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.storageArea = nullptr;
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLUSVString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.url = emptyString();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsStorageEventPrototypeFunction_initStorageEvent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStorageEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_key);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_oldValue);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_newValue);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_url);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_storageArea);

class JSStorageEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStorageEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStorageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSStorageEventPrototype>(vm)) JSStorageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStorageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageEventPrototype, JSStorageEventPrototype::Base);

using JSStorageEventDOMConstructor = JSDOMConstructor<JSStorageEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSStorageEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSStorageEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDict = convert<IDLDictionary<StorageEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = StorageEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<StorageEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<StorageEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSStorageEventDOMConstructorConstruct, JSStorageEventDOMConstructor::construct);

template<> const ClassInfo JSStorageEventDOMConstructor::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventDOMConstructor) };

template<> JSValue JSStorageEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSStorageEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StorageEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStorageEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEventConstructor, 0 } },
    { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_key, 0 } },
    { "oldValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_oldValue, 0 } },
    { "newValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_newValue, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_url, 0 } },
    { "storageArea"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_storageArea, 0 } },
    { "initStorageEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageEventPrototypeFunction_initStorageEvent, 1 } },
};

const ClassInfo JSStorageEventPrototype::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventPrototype) };

void JSStorageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStorageEvent::info(), JSStorageEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEvent) };

JSStorageEvent::JSStorageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StorageEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<StorageEvent> JSStorageEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, StorageEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStorageEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStorageEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSStorageEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStorageEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStorageEvent>(vm, globalObject);
}

JSValue JSStorageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageEventDOMConstructor, DOMConstructorID::StorageEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStorageEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStorageEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsStorageEvent_keyGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.key())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_oldValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.oldValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_oldValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_oldValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_newValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.newValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_newValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_newValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_urlGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_storageAreaGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.storageArea())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_storageArea, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_storageAreaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsStorageEventPrototypeFunction_initStorageEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStorageEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto bubbles = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto cancelable = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto key = argument3.value().isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto oldValue = argument4.value().isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto newValue = argument5.value().isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto url = argument6.value().isUndefined() ? emptyString() : convert<IDLUSVString>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto storageArea = convert<IDLNullable<IDLInterface<Storage>>>(*lexicalGlobalObject, argument7.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "storageArea", "StorageEvent", "initStorageEvent", "Storage"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initStorageEvent(WTFMove(type), WTFMove(bubbles), WTFMove(cancelable), WTFMove(key), WTFMove(oldValue), WTFMove(newValue), WTFMove(url), WTFMove(storageArea)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageEventPrototypeFunction_initStorageEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStorageEvent>::call<jsStorageEventPrototypeFunction_initStorageEventBody>(*lexicalGlobalObject, *callFrame, "initStorageEvent");
}

JSC::GCClient::IsoSubspace* JSStorageEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStorageEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStorageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStorageEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStorageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStorageEvent = std::forward<decltype(space)>(space); }
    );
}

void JSStorageEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStorageEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7StorageEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12StorageEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StorageEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<StorageEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7StorageEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12StorageEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // StorageEvent has subclasses. If StorageEvent has subclasses that get passed
        // to toJS() we currently require StorageEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<StorageEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StorageEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
