/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRoot.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSShadowRootMode.h"
#include "JSSlotAssignmentMode.h"
#include "JSStyleSheetList.h"
#include "JSWebAnimation.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(FULLSCREEN_API)
#include "DocumentOrShadowRootFullscreen.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsShadowRootPrototypeFunction_elementFromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsShadowRootPrototypeFunction_elementsFromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsShadowRootPrototypeFunction_getAnimations);
static JSC_DECLARE_HOST_FUNCTION(jsShadowRootPrototypeFunction_setHTMLUnsafe);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsShadowRootConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_mode);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_delegatesFocus);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_slotAssignment);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_clonable);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_host);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_onslotchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSShadowRoot_onslotchange);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_activeElement);
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_pictureInPictureElement);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_styleSheets);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_adoptedStyleSheets);
static JSC_DECLARE_CUSTOM_SETTER(setJSShadowRoot_adoptedStyleSheets);
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_fullscreenElement);
static JSC_DECLARE_CUSTOM_SETTER(setJSShadowRoot_fullscreenElement);
#endif
#if ENABLE(POINTER_LOCK)
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_pointerLockElement);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRoot_innerHTML);
static JSC_DECLARE_CUSTOM_SETTER(setJSShadowRoot_innerHTML);

class JSShadowRootPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSShadowRootPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSShadowRootPrototype* ptr = new (NotNull, JSC::allocateCell<JSShadowRootPrototype>(vm)) JSShadowRootPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSShadowRootPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSShadowRootPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSShadowRootPrototype, JSShadowRootPrototype::Base);

using JSShadowRootDOMConstructor = JSDOMConstructorNotConstructable<JSShadowRoot>;

template<> const ClassInfo JSShadowRootDOMConstructor::s_info = { "ShadowRoot"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRootDOMConstructor) };

template<> JSValue JSShadowRootDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDocumentFragment::getConstructor(vm, &globalObject);
}

template<> void JSShadowRootDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ShadowRoot"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSShadowRoot::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSShadowRootPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRootConstructor, 0 } },
    { "mode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_mode, 0 } },
    { "delegatesFocus"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_delegatesFocus, 0 } },
    { "slotAssignment"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_slotAssignment, 0 } },
    { "clonable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_clonable, 0 } },
    { "host"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_host, 0 } },
    { "onslotchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_onslotchange, setJSShadowRoot_onslotchange } },
    { "activeElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_activeElement, 0 } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_pictureInPictureElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "styleSheets"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_styleSheets, 0 } },
    { "adoptedStyleSheets"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_adoptedStyleSheets, setJSShadowRoot_adoptedStyleSheets } },
#if ENABLE(FULLSCREEN_API)
    { "fullscreenElement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_fullscreenElement, setJSShadowRoot_fullscreenElement } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(POINTER_LOCK)
    { "pointerLockElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_pointerLockElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "innerHTML"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRoot_innerHTML, setJSShadowRoot_innerHTML } },
    { "elementFromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsShadowRootPrototypeFunction_elementFromPoint, 2 } },
    { "elementsFromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsShadowRootPrototypeFunction_elementsFromPoint, 2 } },
    { "getAnimations"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsShadowRootPrototypeFunction_getAnimations, 0 } },
    { "setHTMLUnsafe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsShadowRootPrototypeFunction_setHTMLUnsafe, 1 } },
};

const ClassInfo JSShadowRootPrototype::s_info = { "ShadowRoot"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRootPrototype) };

void JSShadowRootPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSShadowRoot::info(), JSShadowRootPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().declarativeShadowRootsParserAPIsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setHTMLUnsafe"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().imperativeSlotAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "slotAssignment"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().declarativeShadowRootsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "clonable"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pictureInPictureElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().constructableStylesheetsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "adoptedStyleSheets"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().unprefixedFullscreenAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fullscreenElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSShadowRoot::s_info = { "ShadowRoot"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSShadowRoot) };

JSShadowRoot::JSShadowRoot(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ShadowRoot>&& impl)
    : JSDocumentFragment(structure, globalObject, WTFMove(impl))
{
}

Ref<ShadowRoot> JSShadowRoot::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSShadowRoot::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSShadowRootPrototype::createStructure(vm, &globalObject, JSDocumentFragment::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSShadowRootPrototype::create(vm, &globalObject, structure);
}

JSObject* JSShadowRoot::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSShadowRoot>(vm, globalObject);
}

JSValue JSShadowRoot::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSShadowRootDOMConstructor, DOMConstructorID::ShadowRoot>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRootConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSShadowRootPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSShadowRoot::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsShadowRoot_modeGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ShadowRootMode>>(lexicalGlobalObject, throwScope, impl.mode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_mode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_modeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_delegatesFocusGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.delegatesFocus())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_delegatesFocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_delegatesFocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_slotAssignmentGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SlotAssignmentMode>>(lexicalGlobalObject, throwScope, impl.slotAssignmentMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_slotAssignment, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_slotAssignmentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_clonableGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isClonable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_clonable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_clonableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_hostGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.host())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_host, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_hostGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_onslotchangeGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().slotchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_onslotchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSShadowRoot_onslotchangeSetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().slotchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSShadowRoot_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::set<setJSShadowRoot_onslotchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsShadowRoot_activeElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_activeElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_activeElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsShadowRoot_pictureInPictureElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pictureInPictureElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_pictureInPictureElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_pictureInPictureElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsShadowRoot_styleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<StyleSheetList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleSheets())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_styleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_styleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRoot_adoptedStyleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_adoptedStyleSheets.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.adoptedStyleSheetWrapper(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)));
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_adoptedStyleSheets.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_adoptedStyleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_adoptedStyleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSShadowRoot_adoptedStyleSheetsSetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    thisObject.setAdoptedStyleSheets(lexicalGlobalObject, value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSShadowRoot_adoptedStyleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::set<setJSShadowRoot_adoptedStyleSheetsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsShadowRoot_fullscreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentOrShadowRootFullscreen::fullscreenElement(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_fullscreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_fullscreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSShadowRoot_fullscreenElementSetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(thisObject);
    UNUSED_PARAM(value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSShadowRoot_fullscreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::set<setJSShadowRoot_fullscreenElementSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSValue jsShadowRoot_pointerLockElementGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pointerLockElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_pointerLockElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_pointerLockElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsShadowRoot_innerHTMLGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.innerHTML())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRoot_innerHTML, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::get<jsShadowRoot_innerHTMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSShadowRoot_innerHTMLSetter(JSGlobalObject& lexicalGlobalObject, JSShadowRoot& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInnerHTML(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSShadowRoot_innerHTML, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRoot>::set<setJSShadowRoot_innerHTMLSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunction_elementFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.elementFromPoint(WTFMove(x), WTFMove(y)))));
}

JSC_DEFINE_HOST_FUNCTION(jsShadowRootPrototypeFunction_elementFromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunction_elementFromPointBody>(*lexicalGlobalObject, *callFrame, "elementFromPoint");
}

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunction_elementsFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.elementsFromPoint(WTFMove(x), WTFMove(y)))));
}

JSC_DEFINE_HOST_FUNCTION(jsShadowRootPrototypeFunction_elementsFromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunction_elementsFromPointBody>(*lexicalGlobalObject, *callFrame, "elementsFromPoint");
}

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunction_getAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<WebAnimation>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAnimations())));
}

JSC_DEFINE_HOST_FUNCTION(jsShadowRootPrototypeFunction_getAnimations, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunction_getAnimationsBody>(*lexicalGlobalObject, *callFrame, "getAnimations");
}

static inline JSC::EncodedJSValue jsShadowRootPrototypeFunction_setHTMLUnsafeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSShadowRoot>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto html = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setHTMLUnsafe(WTFMove(html)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsShadowRootPrototypeFunction_setHTMLUnsafe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSShadowRoot>::call<jsShadowRootPrototypeFunction_setHTMLUnsafeBody>(*lexicalGlobalObject, *callFrame, "setHTMLUnsafe");
}

JSC::GCClient::IsoSubspace* JSShadowRoot::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSShadowRoot, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForShadowRoot.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForShadowRoot = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForShadowRoot.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForShadowRoot = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSShadowRoot::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSShadowRoot*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_adoptedStyleSheets);
}

DEFINE_VISIT_CHILDREN(JSShadowRoot);

void JSShadowRoot::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSShadowRoot*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ShadowRoot@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10ShadowRootE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ShadowRoot>&& impl)
{

    if constexpr (std::is_polymorphic_v<ShadowRoot>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ShadowRoot@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10ShadowRootE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ShadowRoot has subclasses. If ShadowRoot has subclasses that get passed
        // to toJS() we currently require ShadowRoot you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ShadowRoot>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ShadowRoot& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ShadowRoot* JSShadowRoot::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSShadowRoot*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
