/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScreenOrientation.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ScreenOrientationLockType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("any"),
        MAKE_STATIC_STRING_IMPL("natural"),
        MAKE_STATIC_STRING_IMPL("landscape"),
        MAKE_STATIC_STRING_IMPL("portrait"),
        MAKE_STATIC_STRING_IMPL("portrait-primary"),
        MAKE_STATIC_STRING_IMPL("portrait-secondary"),
        MAKE_STATIC_STRING_IMPL("landscape-primary"),
        MAKE_STATIC_STRING_IMPL("landscape-secondary"),
    };
    static_assert(static_cast<size_t>(ScreenOrientationLockType::Any) == 0, "ScreenOrientationLockType::Any is not 0 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::Natural) == 1, "ScreenOrientationLockType::Natural is not 1 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::Landscape) == 2, "ScreenOrientationLockType::Landscape is not 2 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::Portrait) == 3, "ScreenOrientationLockType::Portrait is not 3 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::PortraitPrimary) == 4, "ScreenOrientationLockType::PortraitPrimary is not 4 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::PortraitSecondary) == 5, "ScreenOrientationLockType::PortraitSecondary is not 5 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::LandscapePrimary) == 6, "ScreenOrientationLockType::LandscapePrimary is not 6 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationLockType::LandscapeSecondary) == 7, "ScreenOrientationLockType::LandscapeSecondary is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ScreenOrientationLockType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ScreenOrientationLockType> parseEnumerationFromString<ScreenOrientationLockType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ScreenOrientationLockType> mappings[] = {
        { "any", ScreenOrientationLockType::Any },
        { "landscape", ScreenOrientationLockType::Landscape },
        { "landscape-primary", ScreenOrientationLockType::LandscapePrimary },
        { "landscape-secondary", ScreenOrientationLockType::LandscapeSecondary },
        { "natural", ScreenOrientationLockType::Natural },
        { "portrait", ScreenOrientationLockType::Portrait },
        { "portrait-primary", ScreenOrientationLockType::PortraitPrimary },
        { "portrait-secondary", ScreenOrientationLockType::PortraitSecondary },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ScreenOrientationLockType> parseEnumeration<ScreenOrientationLockType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ScreenOrientationLockType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ScreenOrientationLockType>()
{
    return "\"any\", \"natural\", \"landscape\", \"portrait\", \"portrait-primary\", \"portrait-secondary\", \"landscape-primary\", \"landscape-secondary\"";
}

String convertEnumerationToString(ScreenOrientationType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("portrait-primary"),
        MAKE_STATIC_STRING_IMPL("portrait-secondary"),
        MAKE_STATIC_STRING_IMPL("landscape-primary"),
        MAKE_STATIC_STRING_IMPL("landscape-secondary"),
    };
    static_assert(static_cast<size_t>(ScreenOrientationType::PortraitPrimary) == 0, "ScreenOrientationType::PortraitPrimary is not 0 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationType::PortraitSecondary) == 1, "ScreenOrientationType::PortraitSecondary is not 1 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationType::LandscapePrimary) == 2, "ScreenOrientationType::LandscapePrimary is not 2 as expected");
    static_assert(static_cast<size_t>(ScreenOrientationType::LandscapeSecondary) == 3, "ScreenOrientationType::LandscapeSecondary is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ScreenOrientationType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ScreenOrientationType> parseEnumerationFromString<ScreenOrientationType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ScreenOrientationType> mappings[] = {
        { "landscape-primary", ScreenOrientationType::LandscapePrimary },
        { "landscape-secondary", ScreenOrientationType::LandscapeSecondary },
        { "portrait-primary", ScreenOrientationType::PortraitPrimary },
        { "portrait-secondary", ScreenOrientationType::PortraitSecondary },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ScreenOrientationType> parseEnumeration<ScreenOrientationType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ScreenOrientationType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ScreenOrientationType>()
{
    return "\"portrait-primary\", \"portrait-secondary\", \"landscape-primary\", \"landscape-secondary\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsScreenOrientationPrototypeFunction_lock);
static JSC_DECLARE_HOST_FUNCTION(jsScreenOrientationPrototypeFunction_unlock);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsScreenOrientationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsScreenOrientation_type);
static JSC_DECLARE_CUSTOM_GETTER(jsScreenOrientation_angle);
static JSC_DECLARE_CUSTOM_GETTER(jsScreenOrientation_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSScreenOrientation_onchange);

class JSScreenOrientationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSScreenOrientationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScreenOrientationPrototype* ptr = new (NotNull, JSC::allocateCell<JSScreenOrientationPrototype>(vm)) JSScreenOrientationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScreenOrientationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSScreenOrientationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScreenOrientationPrototype, JSScreenOrientationPrototype::Base);

using JSScreenOrientationDOMConstructor = JSDOMConstructorNotConstructable<JSScreenOrientation>;

template<> const ClassInfo JSScreenOrientationDOMConstructor::s_info = { "ScreenOrientation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreenOrientationDOMConstructor) };

template<> JSValue JSScreenOrientationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSScreenOrientationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ScreenOrientation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSScreenOrientation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSScreenOrientationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsScreenOrientationConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreenOrientation_type, 0 } },
    { "angle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreenOrientation_angle, 0 } },
    { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreenOrientation_onchange, setJSScreenOrientation_onchange } },
    { "lock"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsScreenOrientationPrototypeFunction_lock, 1 } },
    { "unlock"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsScreenOrientationPrototypeFunction_unlock, 0 } },
};

const ClassInfo JSScreenOrientationPrototype::s_info = { "ScreenOrientation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreenOrientationPrototype) };

void JSScreenOrientationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSScreenOrientation::info(), JSScreenOrientationPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().screenOrientationLockingAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "lock"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().screenOrientationLockingAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "unlock"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSScreenOrientation::s_info = { "ScreenOrientation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreenOrientation) };

JSScreenOrientation::JSScreenOrientation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ScreenOrientation>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<ScreenOrientation> JSScreenOrientation::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, ScreenOrientation>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSScreenOrientation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSScreenOrientationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSScreenOrientationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSScreenOrientation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSScreenOrientation>(vm, globalObject);
}

JSValue JSScreenOrientation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSScreenOrientationDOMConstructor, DOMConstructorID::ScreenOrientation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreenOrientationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSScreenOrientationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSScreenOrientation::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsScreenOrientation_typeGetter(JSGlobalObject& lexicalGlobalObject, JSScreenOrientation& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ScreenOrientationType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreenOrientation_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreenOrientation>::get<jsScreenOrientation_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreenOrientation_angleGetter(JSGlobalObject& lexicalGlobalObject, JSScreenOrientation& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.angle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreenOrientation_angle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreenOrientation>::get<jsScreenOrientation_angleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreenOrientation_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSScreenOrientation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreenOrientation_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreenOrientation>::get<jsScreenOrientation_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSScreenOrientation_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSScreenOrientation& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSScreenOrientation_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreenOrientation>::set<setJSScreenOrientation_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsScreenOrientationPrototypeFunction_lockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSScreenOrientation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto orientation = convert<IDLEnumeration<ScreenOrientationLockType>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "orientation", "ScreenOrientation", "lock", expectedEnumerationValues<ScreenOrientationLockType>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.lock(WTFMove(orientation), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsScreenOrientationPrototypeFunction_lock, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSScreenOrientation>::call<jsScreenOrientationPrototypeFunction_lockBody>(*lexicalGlobalObject, *callFrame, "lock");
}

static inline JSC::EncodedJSValue jsScreenOrientationPrototypeFunction_unlockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSScreenOrientation>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unlock(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsScreenOrientationPrototypeFunction_unlock, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSScreenOrientation>::call<jsScreenOrientationPrototypeFunction_unlockBody>(*lexicalGlobalObject, *callFrame, "unlock");
}

JSC::GCClient::IsoSubspace* JSScreenOrientation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSScreenOrientation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForScreenOrientation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForScreenOrientation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForScreenOrientation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForScreenOrientation = std::forward<decltype(space)>(space); }
    );
}

void JSScreenOrientation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSScreenOrientation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSScreenOrientationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsScreenOrientation = jsCast<JSScreenOrientation*>(handle.slot()->asCell());
    auto& wrapped = jsScreenOrientation->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSScreenOrientationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsScreenOrientation = static_cast<JSScreenOrientation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsScreenOrientation->wrapped(), jsScreenOrientation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ScreenOrientation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17ScreenOrientationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ScreenOrientation>&& impl)
{

    if constexpr (std::is_polymorphic_v<ScreenOrientation>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ScreenOrientation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17ScreenOrientationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ScreenOrientation has subclasses. If ScreenOrientation has subclasses that get passed
        // to toJS() we currently require ScreenOrientation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ScreenOrientation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ScreenOrientation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ScreenOrientation* JSScreenOrientation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSScreenOrientation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
