/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbs_x);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticSmoothAbs_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbs_y);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticSmoothAbs_y);

class JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype>(vm)) JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype, JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype::Base);

using JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegCurvetoQuadraticSmoothAbs>;

template<> const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor::s_info = { "SVGPathSegCurvetoQuadraticSmoothAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor) };

template<> JSValue JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathSegCurvetoQuadraticSmoothAbs"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegCurvetoQuadraticSmoothAbs::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegCurvetoQuadraticSmoothAbsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticSmoothAbsConstructor, 0 } },
    { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticSmoothAbs_x, setJSSVGPathSegCurvetoQuadraticSmoothAbs_x } },
    { "y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoQuadraticSmoothAbs_y, setJSSVGPathSegCurvetoQuadraticSmoothAbs_y } },
};

const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype::s_info = { "SVGPathSegCurvetoQuadraticSmoothAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype) };

void JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegCurvetoQuadraticSmoothAbs::info(), JSSVGPathSegCurvetoQuadraticSmoothAbsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothAbs::s_info = { "SVGPathSegCurvetoQuadraticSmoothAbs"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothAbs) };

JSSVGPathSegCurvetoQuadraticSmoothAbs::JSSVGPathSegCurvetoQuadraticSmoothAbs(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegCurvetoQuadraticSmoothAbs>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGPathSegCurvetoQuadraticSmoothAbs> JSSVGPathSegCurvetoQuadraticSmoothAbs::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegCurvetoQuadraticSmoothAbs>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPathSegCurvetoQuadraticSmoothAbs::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathSegCurvetoQuadraticSmoothAbs::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegCurvetoQuadraticSmoothAbs>(vm, globalObject);
}

JSValue JSSVGPathSegCurvetoQuadraticSmoothAbs::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegCurvetoQuadraticSmoothAbsDOMConstructor, DOMConstructorID::SVGPathSegCurvetoQuadraticSmoothAbs>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegCurvetoQuadraticSmoothAbsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegCurvetoQuadraticSmoothAbs::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGPathSegCurvetoQuadraticSmoothAbs_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbs_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothAbs>::get<jsSVGPathSegCurvetoQuadraticSmoothAbs_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticSmoothAbs_xSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticSmoothAbs_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothAbs>::set<setJSSVGPathSegCurvetoQuadraticSmoothAbs_xSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoQuadraticSmoothAbs_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothAbs& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoQuadraticSmoothAbs_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothAbs>::get<jsSVGPathSegCurvetoQuadraticSmoothAbs_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoQuadraticSmoothAbs_ySetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothAbs& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoQuadraticSmoothAbs_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothAbs>::set<setJSSVGPathSegCurvetoQuadraticSmoothAbs_ySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPathSegCurvetoQuadraticSmoothAbs::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathSegCurvetoQuadraticSmoothAbs, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathSegCurvetoQuadraticSmoothAbs.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathSegCurvetoQuadraticSmoothAbs = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathSegCurvetoQuadraticSmoothAbs.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathSegCurvetoQuadraticSmoothAbs = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathSegCurvetoQuadraticSmoothAbs::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegCurvetoQuadraticSmoothAbs*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
