/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRemoteDOMWindow.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSLocation.h"
#include "JSWindowPostMessageOptions.h"
#include "LocalDOMWindow.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_focus);
static JSC_DECLARE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_blur);
static JSC_DECLARE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_postMessage);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_closed);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_location);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_location);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_window);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_self);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_self);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_opener);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_opener);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_frames);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_frames);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_length);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_length);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_top);
static JSC_DECLARE_CUSTOM_GETTER(jsRemoteDOMWindow_parent);
static JSC_DECLARE_CUSTOM_SETTER(setJSRemoteDOMWindow_parent);

/* Hash table */

static const struct CompactHashIndex JSRemoteDOMWindowTableIndex[34] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { 0, 32 },
    { 3, -1 },
    { 7, -1 },
    { 4, 33 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, -1 },
    { 6, -1 },
    { -1, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 2, -1 },
    { 5, -1 },
};


static const HashTableValue JSRemoteDOMWindowTableValues[] =
{
    { "closed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_closed, 0 } },
    { "location"_s, JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_location, setJSRemoteDOMWindow_location } },
    { "window"_s, JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_window, 0 } },
    { "self"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_self, setJSRemoteDOMWindow_self } },
    { "opener"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_opener, setJSRemoteDOMWindow_opener } },
    { "frames"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_frames, setJSRemoteDOMWindow_frames } },
    { "length"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_length, setJSRemoteDOMWindow_length } },
    { "top"_s, JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_top, 0 } },
    { "parent"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsRemoteDOMWindow_parent, setJSRemoteDOMWindow_parent } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsRemoteDOMWindowInstanceFunction_close, 0 } },
    { "focus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsRemoteDOMWindowInstanceFunction_focus, 0 } },
    { "blur"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsRemoteDOMWindowInstanceFunction_blur, 0 } },
    { "postMessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsRemoteDOMWindowInstanceFunction_postMessage, 1 } },
};

static const HashTable JSRemoteDOMWindowTable = { 13, 31, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::Function | JSC::PropertyAttribute::ReadOnly), JSRemoteDOMWindow::info(), JSRemoteDOMWindowTableValues, JSRemoteDOMWindowTableIndex };
/* Hash table for prototype */

static const struct CompactHashIndex JSRemoteDOMWindowPrototypeTableIndex[1] = {
    { -1, -1 },
};


static const HashTableValue JSRemoteDOMWindowPrototypeTableValues[] =
{
    { { }, 0, NoIntrinsic, { HashTableValue::End } }
};

static const HashTable JSRemoteDOMWindowPrototypeTable = { 0, 0, static_cast<uint8_t>(0), JSRemoteDOMWindow::info(), JSRemoteDOMWindowPrototypeTableValues, JSRemoteDOMWindowPrototypeTableIndex };
const ClassInfo JSRemoteDOMWindowPrototype::s_info = { "Window"_s, &Base::s_info, &JSRemoteDOMWindowPrototypeTable, nullptr, CREATE_METHOD_TABLE(JSRemoteDOMWindowPrototype) };

void JSRemoteDOMWindowPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSRemoteDOMWindow::s_info = { "Window"_s, &Base::s_info, &JSRemoteDOMWindowTable, nullptr, CREATE_METHOD_TABLE(JSRemoteDOMWindow) };

JSRemoteDOMWindow::JSRemoteDOMWindow(VM& vm, Structure* structure, Ref<RemoteDOMWindow>&& impl, JSWindowProxy* proxy)
    : JSRemoteDOMWindowBase(vm, structure, WTFMove(impl), proxy)
{
}

Ref<RemoteDOMWindow> JSRemoteDOMWindow::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, RemoteDOMWindow>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

#if ASSERT_ENABLED
void JSRemoteDOMWindow::finishCreation(VM& vm, JSWindowProxy* proxy)
{
    Base::finishCreation(vm, proxy);

}
#endif

static inline JSValue jsRemoteDOMWindow_closedGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.closed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_closed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_closedGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_locationGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Location>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_locationGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_locationSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "location"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "href"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindow_locationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_windowGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.window(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_window, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_windowGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_selfGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.self(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_selfGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_selfSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::setPassingPropertyName<setJSRemoteDOMWindow_selfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_openerGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.opener())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_opener, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_openerGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_openerSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    thisObject.setOpener(lexicalGlobalObject, value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_opener, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindow_openerSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_framesGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.frames(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_frames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_framesGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_framesSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_frames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::setPassingPropertyName<setJSRemoteDOMWindow_framesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_lengthGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_lengthSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::setPassingPropertyName<setJSRemoteDOMWindow_lengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_topGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.top())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_topGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsRemoteDOMWindow_parentGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsRemoteDOMWindow_parent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindow_parentGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSRemoteDOMWindow_parentSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSRemoteDOMWindow_parent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSRemoteDOMWindow>::setPassingPropertyName<setJSRemoteDOMWindow_parentSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* incumbentDocument = incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame).document();
    if (!incumbentDocument)
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(*incumbentDocument); })));
}

JSC_DEFINE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_focusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.focus(incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_focus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunction_focusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_blurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blur(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_blur, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunction_blurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_postMessage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto targetOrigin = convert<IDLUSVString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto transfer = argument2.value().isUndefined() ? Converter<IDLSequence<IDLObject>>::ReturnType{ } : convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame), WTFMove(message), WTFMove(targetOrigin), WTFMove(transfer)); })));
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_postMessage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<WindowPostMessageOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame), WTFMove(message), WTFMove(options)); })));
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunction_postMessageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsRemoteDOMWindowInstanceFunction_postMessage1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsRemoteDOMWindowInstanceFunction_postMessage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunction_postMessageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "postMessage");
}

JSC::GCClient::IsoSubspace* JSRemoteDOMWindow::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSRemoteDOMWindow, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForRemoteDOMWindow.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForRemoteDOMWindow = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForRemoteDOMWindow.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForRemoteDOMWindow = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSRemoteDOMWindow; }
    );
}

void JSRemoteDOMWindow::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRemoteDOMWindow*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
