/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushSubscription.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSPushEncryptionKeyName.h"
#include "JSPushSubscriptionJSON.h"
#include "JSPushSubscriptionOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_getKey);
static JSC_DECLARE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_unsubscribe);
static JSC_DECLARE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscription_endpoint);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscription_expirationTime);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscription_options);

class JSPushSubscriptionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPushSubscriptionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPushSubscriptionPrototype* ptr = new (NotNull, JSC::allocateCell<JSPushSubscriptionPrototype>(vm)) JSPushSubscriptionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPushSubscriptionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionPrototype, JSPushSubscriptionPrototype::Base);

using JSPushSubscriptionDOMConstructor = JSDOMConstructorNotConstructable<JSPushSubscription>;

template<> const ClassInfo JSPushSubscriptionDOMConstructor::s_info = { "PushSubscription"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionDOMConstructor) };

template<> JSValue JSPushSubscriptionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPushSubscriptionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PushSubscription"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPushSubscription::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPushSubscriptionPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionConstructor, 0 } },
    { "endpoint"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscription_endpoint, 0 } },
    { "expirationTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscription_expirationTime, 0 } },
    { "options"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscription_options, 0 } },
    { "getKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushSubscriptionPrototypeFunction_getKey, 1 } },
    { "unsubscribe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushSubscriptionPrototypeFunction_unsubscribe, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushSubscriptionPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSPushSubscriptionPrototype::s_info = { "PushSubscription"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionPrototype) };

void JSPushSubscriptionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPushSubscription::info(), JSPushSubscriptionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPushSubscription::s_info = { "PushSubscription"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscription) };

JSPushSubscription::JSPushSubscription(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PushSubscription>&& impl)
    : JSDOMWrapper<PushSubscription>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PushSubscription>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPushSubscription::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPushSubscriptionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPushSubscriptionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPushSubscription::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPushSubscription>(vm, globalObject);
}

JSValue JSPushSubscription::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPushSubscriptionDOMConstructor, DOMConstructorID::PushSubscription>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPushSubscription::destroy(JSC::JSCell* cell)
{
    JSPushSubscription* thisObject = static_cast<JSPushSubscription*>(cell);
    thisObject->JSPushSubscription::~JSPushSubscription();
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPushSubscriptionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPushSubscription::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsPushSubscription_endpointGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscription& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.endpoint())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscription_endpoint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscription>::get<jsPushSubscription_endpointGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPushSubscription_expirationTimeGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscription& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.expirationTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscription_expirationTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscription>::get<jsPushSubscription_expirationTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPushSubscription_optionsGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscription& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<PushSubscriptionOptions>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.options())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscription_options, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscription>::get<jsPushSubscription_optionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsPushSubscriptionPrototypeFunction_getKeyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushSubscription>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLEnumeration<PushEncryptionKeyName>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "name", "PushSubscription", "getKey", expectedEnumerationValues<PushEncryptionKeyName>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLArrayBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_getKey, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushSubscription>::call<jsPushSubscriptionPrototypeFunction_getKeyBody>(*lexicalGlobalObject, *callFrame, "getKey");
}

static inline JSC::EncodedJSValue jsPushSubscriptionPrototypeFunction_unsubscribeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPushSubscription>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.unsubscribe(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_unsubscribe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSPushSubscription>::call<jsPushSubscriptionPrototypeFunction_unsubscribeBody>(*lexicalGlobalObject, *callFrame, "unsubscribe");
}

static inline JSC::EncodedJSValue jsPushSubscriptionPrototypeFunction_toJSONBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushSubscription>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<PushSubscriptionJSON>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toJSON())));
}

JSC_DEFINE_HOST_FUNCTION(jsPushSubscriptionPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushSubscription>::call<jsPushSubscriptionPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSPushSubscription::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPushSubscription, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPushSubscription.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPushSubscription = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPushSubscription.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPushSubscription = std::forward<decltype(space)>(space); }
    );
}

void JSPushSubscription::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPushSubscription*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPushSubscriptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPushSubscriptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPushSubscription = static_cast<JSPushSubscription*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPushSubscription->wrapped(), jsPushSubscription);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PushSubscription@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16PushSubscriptionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PushSubscription>&& impl)
{

    if constexpr (std::is_polymorphic_v<PushSubscription>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PushSubscription@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16PushSubscriptionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PushSubscription has subclasses. If PushSubscription has subclasses that get passed
        // to toJS() we currently require PushSubscription you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<PushSubscription>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PushSubscription& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PushSubscription* JSPushSubscription::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPushSubscription*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
