/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSPlaneLayout.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> PlaneLayout convertDictionary<PlaneLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PlaneLayout result;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "offset", "PlaneLayout", "unsigned long");
        return { };
    }
    JSValue strideValue;
    if (isNullOrUndefined)
        strideValue = jsUndefined();
    else {
        strideValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stride"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!strideValue.isUndefined()) {
        result.stride = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, strideValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "stride", "PlaneLayout", "unsigned long");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PlaneLayout& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto offsetValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.offset);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "offset"_s), offsetValue);
    auto strideValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.stride);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "stride"_s), strideValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
