/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceNavigationTiming.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPerformanceServerTiming.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PerformanceNavigationTiming::NavigationType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("navigate"),
        MAKE_STATIC_STRING_IMPL("reload"),
        MAKE_STATIC_STRING_IMPL("back_forward"),
        MAKE_STATIC_STRING_IMPL("prerender"),
    };
    static_assert(static_cast<size_t>(PerformanceNavigationTiming::NavigationType::Navigate) == 0, "PerformanceNavigationTiming::NavigationType::Navigate is not 0 as expected");
    static_assert(static_cast<size_t>(PerformanceNavigationTiming::NavigationType::Reload) == 1, "PerformanceNavigationTiming::NavigationType::Reload is not 1 as expected");
    static_assert(static_cast<size_t>(PerformanceNavigationTiming::NavigationType::Back_forward) == 2, "PerformanceNavigationTiming::NavigationType::Back_forward is not 2 as expected");
    static_assert(static_cast<size_t>(PerformanceNavigationTiming::NavigationType::Prerender) == 3, "PerformanceNavigationTiming::NavigationType::Prerender is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, PerformanceNavigationTiming::NavigationType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<PerformanceNavigationTiming::NavigationType> parseEnumerationFromString<PerformanceNavigationTiming::NavigationType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, PerformanceNavigationTiming::NavigationType> mappings[] = {
        { "back_forward", PerformanceNavigationTiming::NavigationType::Back_forward },
        { "navigate", PerformanceNavigationTiming::NavigationType::Navigate },
        { "prerender", PerformanceNavigationTiming::NavigationType::Prerender },
        { "reload", PerformanceNavigationTiming::NavigationType::Reload },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<PerformanceNavigationTiming::NavigationType> parseEnumeration<PerformanceNavigationTiming::NavigationType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<PerformanceNavigationTiming::NavigationType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<PerformanceNavigationTiming::NavigationType>()
{
    return "\"navigate\", \"reload\", \"back_forward\", \"prerender\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPerformanceNavigationTimingPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_unloadEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_unloadEventEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domInteractive);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domContentLoadedEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domContentLoadedEventEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domComplete);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_loadEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_loadEventEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_type);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceNavigationTiming_redirectCount);

class JSPerformanceNavigationTimingPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceNavigationTimingPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceNavigationTimingPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceNavigationTimingPrototype>(vm)) JSPerformanceNavigationTimingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceNavigationTimingPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceNavigationTimingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceNavigationTimingPrototype, JSPerformanceNavigationTimingPrototype::Base);

using JSPerformanceNavigationTimingDOMConstructor = JSDOMConstructorNotConstructable<JSPerformanceNavigationTiming>;

template<> const ClassInfo JSPerformanceNavigationTimingDOMConstructor::s_info = { "PerformanceNavigationTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceNavigationTimingDOMConstructor) };

template<> JSValue JSPerformanceNavigationTimingDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSPerformanceResourceTiming::getConstructor(vm, &globalObject);
}

template<> void JSPerformanceNavigationTimingDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PerformanceNavigationTiming"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceNavigationTiming::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPerformanceNavigationTimingPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTimingConstructor, 0 } },
    { "unloadEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_unloadEventStart, 0 } },
    { "unloadEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_unloadEventEnd, 0 } },
    { "domInteractive"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_domInteractive, 0 } },
    { "domContentLoadedEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_domContentLoadedEventStart, 0 } },
    { "domContentLoadedEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_domContentLoadedEventEnd, 0 } },
    { "domComplete"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_domComplete, 0 } },
    { "loadEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_loadEventStart, 0 } },
    { "loadEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_loadEventEnd, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_type, 0 } },
    { "redirectCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceNavigationTiming_redirectCount, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPerformanceNavigationTimingPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSPerformanceNavigationTimingPrototype::s_info = { "PerformanceNavigationTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceNavigationTimingPrototype) };

void JSPerformanceNavigationTimingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceNavigationTiming::info(), JSPerformanceNavigationTimingPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPerformanceNavigationTiming::s_info = { "PerformanceNavigationTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceNavigationTiming) };

JSPerformanceNavigationTiming::JSPerformanceNavigationTiming(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceNavigationTiming>&& impl)
    : JSPerformanceResourceTiming(structure, globalObject, WTFMove(impl))
{
}

Ref<PerformanceNavigationTiming> JSPerformanceNavigationTiming::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PerformanceNavigationTiming>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPerformanceNavigationTiming::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPerformanceNavigationTimingPrototype::createStructure(vm, &globalObject, JSPerformanceResourceTiming::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPerformanceNavigationTimingPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPerformanceNavigationTiming::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceNavigationTiming>(vm, globalObject);
}

JSValue JSPerformanceNavigationTiming::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceNavigationTimingDOMConstructor, DOMConstructorID::PerformanceNavigationTiming>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceNavigationTimingPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceNavigationTiming::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsPerformanceNavigationTiming_unloadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.unloadEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_unloadEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_unloadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_unloadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.unloadEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_unloadEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_unloadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_domInteractiveGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domInteractive())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domInteractive, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_domInteractiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_domContentLoadedEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domContentLoadedEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_domContentLoadedEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_domContentLoadedEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domContentLoadedEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_domContentLoadedEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_domCompleteGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domComplete())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_domComplete, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_domCompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_loadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.loadEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_loadEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_loadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_loadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.loadEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_loadEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_loadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_typeGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<PerformanceNavigationTiming::NavigationType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceNavigationTiming_redirectCountGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceNavigationTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.redirectCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceNavigationTiming_redirectCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceNavigationTiming>::get<jsPerformanceNavigationTiming_redirectCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsPerformanceNavigationTimingPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPerformanceNavigationTiming* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto nameValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.name());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "name"_s), nameValue);
    auto entryTypeValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.entryType());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "entryType"_s), entryTypeValue);
    auto startTimeValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.startTime());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "startTime"_s), startTimeValue);
    auto durationValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.duration());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "duration"_s), durationValue);
    auto initiatorTypeValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.initiatorType());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "initiatorType"_s), initiatorTypeValue);
    auto nextHopProtocolValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.nextHopProtocol());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "nextHopProtocol"_s), nextHopProtocolValue);
    auto workerStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.workerStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "workerStart"_s), workerStartValue);
    auto redirectStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.redirectStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "redirectStart"_s), redirectStartValue);
    auto redirectEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.redirectEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "redirectEnd"_s), redirectEndValue);
    auto fetchStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.fetchStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "fetchStart"_s), fetchStartValue);
    auto domainLookupStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domainLookupStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupStart"_s), domainLookupStartValue);
    auto domainLookupEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domainLookupEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupEnd"_s), domainLookupEndValue);
    auto connectStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.connectStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "connectStart"_s), connectStartValue);
    auto connectEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.connectEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "connectEnd"_s), connectEndValue);
    auto secureConnectionStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.secureConnectionStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "secureConnectionStart"_s), secureConnectionStartValue);
    auto requestStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.requestStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "requestStart"_s), requestStartValue);
    auto responseStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.responseStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "responseStart"_s), responseStartValue);
    auto responseEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.responseEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "responseEnd"_s), responseEndValue);
    auto transferSizeValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.transferSize());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "transferSize"_s), transferSizeValue);
    auto encodedBodySizeValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.encodedBodySize());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "encodedBodySize"_s), encodedBodySizeValue);
    auto decodedBodySizeValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.decodedBodySize());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "decodedBodySize"_s), decodedBodySizeValue);
    auto serverTimingValue = toJS<IDLFrozenArray<IDLInterface<PerformanceServerTiming>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.serverTiming());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "serverTiming"_s), serverTimingValue);
    auto unloadEventStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.unloadEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventStart"_s), unloadEventStartValue);
    auto unloadEventEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.unloadEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventEnd"_s), unloadEventEndValue);
    auto domInteractiveValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domInteractive());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domInteractive"_s), domInteractiveValue);
    auto domContentLoadedEventStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domContentLoadedEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventStart"_s), domContentLoadedEventStartValue);
    auto domContentLoadedEventEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domContentLoadedEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventEnd"_s), domContentLoadedEventEndValue);
    auto domCompleteValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.domComplete());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domComplete"_s), domCompleteValue);
    auto loadEventStartValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.loadEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "loadEventStart"_s), loadEventStartValue);
    auto loadEventEndValue = toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.loadEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "loadEventEnd"_s), loadEventEndValue);
    auto typeValue = toJS<IDLEnumeration<PerformanceNavigationTiming::NavigationType>>(*lexicalGlobalObject, throwScope, impl.type());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "type"_s), typeValue);
    auto redirectCountValue = toJS<IDLUnsignedShort>(*lexicalGlobalObject, throwScope, impl.redirectCount());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "redirectCount"_s), redirectCountValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsPerformanceNavigationTimingPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPerformanceNavigationTiming>::call<jsPerformanceNavigationTimingPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSPerformanceNavigationTiming::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPerformanceNavigationTiming, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPerformanceNavigationTiming.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPerformanceNavigationTiming = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPerformanceNavigationTiming.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPerformanceNavigationTiming = std::forward<decltype(space)>(space); }
    );
}

void JSPerformanceNavigationTiming::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceNavigationTiming*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
