/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSOpusEncoderConfig.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> OpusEncoderConfig convertDictionary<OpusEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    OpusEncoderConfig result;
    JSValue complexityValue;
    if (isNullOrUndefined)
        complexityValue = jsUndefined();
    else {
        complexityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "complexity"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!complexityValue.isUndefined()) {
        result.complexity = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, complexityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.format = OpusEncoderConfig::BitstreamFormat::Opus;
    JSValue frameDurationValue;
    if (isNullOrUndefined)
        frameDurationValue = jsUndefined();
    else {
        frameDurationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameDuration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameDurationValue.isUndefined()) {
        result.frameDuration = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, frameDurationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.frameDuration = 20000;
    JSValue packetlosspercValue;
    if (isNullOrUndefined)
        packetlosspercValue = jsUndefined();
    else {
        packetlosspercValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetlossperc"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetlosspercValue.isUndefined()) {
        result.packetlossperc = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, packetlosspercValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.packetlossperc = 0;
    JSValue usedtxValue;
    if (isNullOrUndefined)
        usedtxValue = jsUndefined();
    else {
        usedtxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usedtx"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usedtxValue.isUndefined()) {
        result.usedtx = convert<IDLBoolean>(lexicalGlobalObject, usedtxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.usedtx = false;
    JSValue useinbandfecValue;
    if (isNullOrUndefined)
        useinbandfecValue = jsUndefined();
    else {
        useinbandfecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "useinbandfec"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!useinbandfecValue.isUndefined()) {
        result.useinbandfec = convert<IDLBoolean>(lexicalGlobalObject, useinbandfecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.useinbandfec = false;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const OpusEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.complexity)) {
        auto complexityValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.complexity));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "complexity"_s), complexityValue);
    }
    auto formatValue = toJS<IDLEnumeration<OpusEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, throwScope, dictionary.format);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "format"_s), formatValue);
    auto frameDurationValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, dictionary.frameDuration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "frameDuration"_s), frameDurationValue);
    auto packetlosspercValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.packetlossperc);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "packetlossperc"_s), packetlosspercValue);
    auto usedtxValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.usedtx);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "usedtx"_s), usedtxValue);
    auto useinbandfecValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.useinbandfec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useinbandfec"_s), useinbandfecValue);
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

String convertEnumerationToString(OpusEncoderConfig::BitstreamFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("opus"),
        MAKE_STATIC_STRING_IMPL("ogg"),
    };
    static_assert(static_cast<size_t>(OpusEncoderConfig::BitstreamFormat::Opus) == 0, "OpusEncoderConfig::BitstreamFormat::Opus is not 0 as expected");
    static_assert(static_cast<size_t>(OpusEncoderConfig::BitstreamFormat::Ogg) == 1, "OpusEncoderConfig::BitstreamFormat::Ogg is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, OpusEncoderConfig::BitstreamFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<OpusEncoderConfig::BitstreamFormat> parseEnumerationFromString<OpusEncoderConfig::BitstreamFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, OpusEncoderConfig::BitstreamFormat> mappings[] = {
        { "ogg", OpusEncoderConfig::BitstreamFormat::Ogg },
        { "opus", OpusEncoderConfig::BitstreamFormat::Opus },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<OpusEncoderConfig::BitstreamFormat> parseEnumeration<OpusEncoderConfig::BitstreamFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<OpusEncoderConfig::BitstreamFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<OpusEncoderConfig::BitstreamFormat>()
{
    return "\"opus\", \"ogg\"";
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
